/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.views.dnd;

import com.blixx.boom.engine.Repository;
import com.blixx.boom.gui.views.ActionTab;
import com.blixx.boom.gui.views.ActionView;
import com.blixx.log.RTLogger;
import com.blixx.shared.Action;
import com.blixx.shared.utils.GroupTreeObject;
import com.blixx.shared.utils.GroupTreeObjectLast;
import java.util.ArrayList;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.widgets.Shell;

public class DNDSourceActionsList
implements DragSourceListener {
    private TreeViewer m_treeViewer = null;
    private ArrayList<Object> m_elements = null;

    public DNDSourceActionsList(TreeViewer tv) {
        this.m_treeViewer = tv;
    }

    public void dragFinished(DragSourceEvent event) {
        RTLogger.print(5, "DND dragFinished Source Action Tree ");
    }

    public void dragSetData(DragSourceEvent event) {
        event.data = this.m_elements;
    }

    public void dragStart(DragSourceEvent event) {
        if (Repository.getInstance().getRights(1007) < 3) {
            RTLogger.print(5, "no rights for DND Action Tree ");
            event.doit = false;
            return;
        }
        RTLogger.print(5, "DND dragStart Action Tree " + event);
        TreeSelection sel = (TreeSelection)this.m_treeViewer.getSelection();
        if (sel.isEmpty()) {
            event.doit = false;
            RTLogger.print(5, "dnd Action Tree no selection.");
        } else if (!this.m_treeViewer.getTree().isFocusControl()) {
            event.doit = false;
            RTLogger.print(5, "dnd Action Tree no focus.");
        } else {
            boolean isDirty = false;
            this.m_elements = new ArrayList();
            for (Object o : sel) {
                if (o instanceof GroupTreeObject && !(o instanceof GroupTreeObjectLast)) continue;
                if (o instanceof GroupTreeObjectLast) {
                    GroupTreeObjectLast gtol = (GroupTreeObjectLast)o;
                    Action action = (Action)gtol.getTreeObject().getObject();
                    CTabItem cti = ActionView.getCTabItem(action.m_ID);
                    if (cti != null && ((Boolean)cti.getData(ActionTab.DIRTY_STATUS)).booleanValue()) {
                        isDirty = true;
                        break;
                    }
                    this.m_elements.add(o);
                    continue;
                }
                event.doit = false;
                break;
            }
            if (!isDirty && this.m_elements.size() > 0) {
                event.data = this.m_elements;
            } else if (isDirty) {
                MessageDialog.openWarning((Shell)this.m_treeViewer.getControl().getShell(), (String)"Moving Action", (String)"Cannot move unsaved action!");
                event.doit = false;
            } else {
                event.doit = false;
            }
        }
    }
}

