/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.views.dnd;

import com.blixx.boom.engine.BMUI;
import com.blixx.boom.engine.Repository;
import com.blixx.log.RTLogger;
import com.blixx.shared.utils.GroupTreeObject;
import com.blixx.shared.utils.GroupTreeObjectLast;
import java.util.ArrayList;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;

public class DNDSourceAssignTreeProcessor
implements DragSourceListener {
    private TreeViewer m_tree = null;
    private ArrayList<Object> m_elements = null;

    public DNDSourceAssignTreeProcessor(TreeViewer tv) {
        this.m_tree = tv;
    }

    public void dragFinished(DragSourceEvent event) {
        RTLogger.print(5, "DND source dragFinished AsnTree");
    }

    public void dragSetData(DragSourceEvent event) {
        event.data = this.m_elements;
    }

    public void dragStart(DragSourceEvent event) {
        if (Repository.getInstance().getRights(1008) < 3) {
            RTLogger.print(5, "DND source dragStart AsnTree - not enough rights");
            event.doit = false;
            return;
        }
        RTLogger.print(5, "DND source dragStart AsnTree ...");
        TreeSelection sel = (TreeSelection)this.m_tree.getSelection();
        if (sel.isEmpty()) {
            event.doit = false;
            RTLogger.print(5, "DND source dragStart AsnTree - no selection");
        } else if (!this.m_tree.getTree().isFocusControl()) {
            event.doit = false;
            RTLogger.print(5, "DND source dragStart AsnTree - no focus");
        } else {
            this.m_elements = new ArrayList();
            GroupTreeObject assignGroup = null;
            for (Object te : sel) {
                GroupTreeObject assignGto = ((GroupTreeObject)te).reverseFind(BMUI.type_assignment_pol);
                if (assignGroup == null) {
                    assignGroup = assignGto;
                } else if (assignGroup != assignGto) {
                    event.doit = false;
                    break;
                }
                if (te instanceof GroupTreeObject && !(te instanceof GroupTreeObjectLast)) {
                    GroupTreeObject gto = (GroupTreeObject)te;
                    if (gto.getTreeObject().getType().equals(BMUI.type_toplevel) || gto.getTreeObject().getType().equals(BMUI.type_assignment_pol)) {
                        event.doit = false;
                        break;
                    }
                    this.m_elements.add(te);
                    continue;
                }
                if (te instanceof GroupTreeObjectLast) {
                    this.m_elements.add(te);
                    continue;
                }
                event.doit = false;
                break;
            }
            if (this.m_elements.size() > 0) {
                event.data = this.m_elements;
            } else {
                event.doit = false;
            }
            RTLogger.print(5, "DND source dragStart AsnTree " + this.m_elements.size() + " elements");
        }
    }
}

