/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.views.dnd;

import com.blixx.boom.engine.BMUI;
import com.blixx.boom.engine.Repository;
import com.blixx.boom.gui.views.dnd.DNDShare;
import com.blixx.log.RTLogger;
import com.blixx.shared.utils.GroupTreeObject;
import com.blixx.shared.utils.GroupTreeObjectLast;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;

public class DNDSourceBinariesTreeProcessor
implements DragSourceListener {
    private TreeViewer m_tree = null;
    private ArrayList<Object> m_elements = null;

    public DNDSourceBinariesTreeProcessor(TreeViewer tv) {
        this.m_tree = tv;
    }

    public void dragFinished(DragSourceEvent event) {
        RTLogger.print(5, "DND dragFinished Source Binary Tree ");
        DNDShare.getInstance().setTreeSelection(null);
    }

    public void dragSetData(DragSourceEvent event) {
        event.data = this.m_elements;
    }

    public void dragStart(DragSourceEvent event) {
        if (Repository.getInstance().getRights(1006) < 3) {
            RTLogger.print(5, "no rights for DND Binary Tree ");
            event.doit = false;
            return;
        }
        RTLogger.print(5, "DND dragStart Binary Tree ");
        TreeSelection sel = (TreeSelection)this.m_tree.getSelection();
        if (sel.isEmpty()) {
            event.doit = false;
            RTLogger.print(5, "DND Binaries Tree no selection.");
        } else if (!this.m_tree.getTree().isFocusControl()) {
            event.doit = false;
            RTLogger.print(5, "DND Binaries Tree no focus.");
        } else {
            Iterator it = sel.iterator();
            this.m_elements = new ArrayList();
            while (it.hasNext()) {
                Object te = it.next();
                if (te instanceof GroupTreeObjectLast) {
                    event.doit = false;
                    break;
                }
                if (te instanceof GroupTreeObject) {
                    GroupTreeObject gto = (GroupTreeObject)te;
                    if (gto.getTreeObject().getType().equals(BMUI.type_assignment_bin)) {
                        this.m_elements.add(te);
                        continue;
                    }
                    event.doit = false;
                    break;
                }
                event.doit = false;
                break;
            }
            if (this.m_elements.size() > 0) {
                event.data = this.m_elements;
                DNDShare.getInstance().setTreeSelection(this.m_elements);
                DNDShare.getInstance().setTreeType(BMUI.type_tree_binaries);
                RTLogger.print(5, "DND Binaries Tree selection>0");
            } else {
                event.doit = false;
            }
        }
    }
}

