/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.views.dnd;

import com.blixx.boom.engine.Repository;
import com.blixx.boom.engine.ServerClient;
import com.blixx.boom.gui.views.ActionView;
import com.blixx.log.RTLogger;
import com.blixx.shared.Action;
import com.blixx.shared.utils.GroupTreeObject;
import com.blixx.shared.utils.GroupTreeObjectLast;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.widgets.Shell;

public class DNDTargetActionsList
implements DropTargetListener {
    private TreeViewer m_treeViewer = null;
    private ArrayList<Object> m_elements = null;

    public DNDTargetActionsList(TreeViewer tv) {
        this.m_treeViewer = tv;
    }

    public void dragEnter(DropTargetEvent event) {
        this.m_elements = new ArrayList();
        TreeSelection sel = (TreeSelection)this.m_treeViewer.getSelection();
        for (Object te : sel) {
            this.m_elements.add(te);
        }
    }

    public void dragLeave(DropTargetEvent event) {
    }

    public void dragOperationChanged(DropTargetEvent event) {
    }

    public void dragOver(DropTargetEvent event) {
        event.feedback = 24;
        if (Repository.getInstance().getRights(1007) < 3) {
            RTLogger.print(5, "no rights to paste element into Action Tree ");
            event.detail = 0;
            return;
        }
        if (event.item != null) {
            Object data = event.item.getData();
            event.detail = 0;
            if (data instanceof GroupTreeObject && !(data instanceof GroupTreeObjectLast)) {
                event.detail = 2;
            }
        } else {
            event.detail = 0;
        }
    }

    public void drop(DropTargetEvent event) {
        Object data = event.item.getData();
        GroupTreeObject target = (GroupTreeObject)data;
        for (Object o : this.m_elements) {
            if (!(o instanceof GroupTreeObjectLast)) continue;
            GroupTreeObjectLast gtol = (GroupTreeObjectLast)o;
            Action action = (Action)gtol.getTreeObject().getObject();
            ServerClient sc = ServerClient.moveAction(action.m_ID, target.getName());
            sc.runInUIThread(null);
            if (sc.isSuccess()) {
                ActionView.reOpenActionTab(action, target.getName());
                continue;
            }
            RTLogger.print(5, "DND Move Action: Error moving action");
            MessageDialog.openError((Shell)this.m_treeViewer.getControl().getShell(), (String)"Error moving action", (String)"Cannot move action!");
        }
    }

    public void dropAccept(DropTargetEvent event) {
        RTLogger.print(5, "DND dropAccept target Action Tree " + event.item);
        try {
            Object data = event.item.getData();
            GroupTreeObject target = null;
            if (data instanceof GroupTreeObject && !(data instanceof GroupTreeObjectLast)) {
                target = (GroupTreeObject)data;
            }
            Iterator<Object> it = this.m_elements.iterator();
            while (it.hasNext()) {
                GroupTreeObjectLast gtol;
                Object o = it.next();
                if (!(o instanceof GroupTreeObjectLast) || target.getChild((gtol = (GroupTreeObjectLast)o).getName(), gtol.getType()) == null) continue;
                it.remove();
            }
            if (this.m_elements.size() == 0) {
                event.detail = 0;
            }
        }
        catch (RuntimeException e) {
            RTLogger.print(5, "Error DND dropAccept target Action Tree " + e);
        }
    }
}

