/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.views.dnd;

import com.blixx.boom.engine.AgentCard;
import com.blixx.boom.engine.BMUI;
import com.blixx.boom.engine.JobManager;
import com.blixx.boom.engine.Repository;
import com.blixx.boom.engine.ServerClientBatch;
import com.blixx.boom.gui.Activator;
import com.blixx.boom.gui.dialogs.ProgressDialog;
import com.blixx.boom.gui.dialogs.ShowMessageDialog;
import com.blixx.boom.gui.policies.PolicyManager;
import com.blixx.boom.gui.views.AssignmentsSummaryView;
import com.blixx.boom.gui.views.actions.UpdateServer;
import com.blixx.boom.gui.views.dnd.DNDShare;
import com.blixx.ctrl.sc.in.ScDeploy;
import com.blixx.log.RTLogger;
import com.blixx.shared.BM;
import com.blixx.shared.sc.CMDS;
import com.blixx.shared.utils.GroupTreeObject;
import com.blixx.shared.utils.GroupTreeObjectLast;
import com.blixx.shared.utils.ITreeObject;
import com.blixx.shared.utils.TreeObject;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;

public class DNDTargetAssignTreeProcessor
implements DropTargetListener {
    private TreeViewer m_treeViewer = null;
    private List<Object> m_elements = null;
    private boolean m_isAddLink = false;
    private int m_dndDropType = 0;
    private String m_treeType = null;
    private GroupTreeObject m_sourceAssignGroup = null;
    private static String MOVE = "move";
    private static String COPY = "copy";
    private String m_action = COPY;

    public DNDTargetAssignTreeProcessor(TreeViewer tv) {
        this.m_treeViewer = tv;
    }

    public void dragEnter(DropTargetEvent event) {
        RTLogger.print(5, "DND target dragEnter AsnTree ...");
        this.m_elements = new ArrayList<Object>();
        List<Object> treeSelection = DNDShare.getInstance().getTreeSelection();
        if (treeSelection != null) {
            this.m_elements = treeSelection;
            this.m_isAddLink = true;
            this.m_dndDropType = 4;
            this.m_treeType = DNDShare.getInstance().getTreeType();
            RTLogger.print(5, "DND target dragEnter source=" + this.m_treeType);
        } else {
            this.m_dndDropType = 2;
            this.m_isAddLink = false;
            this.m_treeType = BMUI.type_tree_assignment;
            TreeSelection sel = (TreeSelection)this.m_treeViewer.getSelection();
            for (Object te : sel) {
                this.m_elements.add(te);
            }
            this.m_sourceAssignGroup = ((GroupTreeObject)this.m_elements.get(0)).reverseFind(BMUI.type_assignment_pol);
            if (RTLogger.getCurrentLevel() >= 5) {
                RTLogger.print(5, "DND target dragEnter source=" + this.m_treeType + " path=" + this.m_sourceAssignGroup.getPath() + " | " + this.m_elements.size() + " elements");
            }
        }
    }

    public void dragLeave(DropTargetEvent event) {
    }

    public void dragOperationChanged(DropTargetEvent event) {
    }

    public void dragOver(DropTargetEvent event) {
        Object data;
        event.feedback = 24;
        event.detail = 0;
        if (Repository.getInstance().getRights(1008) < 3) {
            RTLogger.print(5, "DND target dragOver . Not enough rights to paste element into AsnTree");
            return;
        }
        if (event.item != null && (data = event.item.getData()) instanceof GroupTreeObject && !(data instanceof GroupTreeObjectLast)) {
            GroupTreeObject gto = (GroupTreeObject)data;
            if (this.m_treeType != null && this.m_treeType.equals(BMUI.type_tree_policy)) {
                if (!gto.getTreeObject().getType().equals(BMUI.type_toplevel)) {
                    event.detail = this.m_dndDropType;
                }
            } else if (this.m_treeType != null && this.m_treeType.equals(BMUI.type_tree_binaries)) {
                if (!gto.getTreeObject().getType().equals(BMUI.type_toplevel)) {
                    event.detail = this.m_dndDropType;
                }
            } else if (this.m_treeType != null && this.m_treeType.equals(BMUI.type_tree_assignment) && !gto.getTreeObject().getType().equals(BMUI.type_toplevel)) {
                event.detail = this.m_dndDropType;
                GroupTreeObject targetAssignGroup = null;
                targetAssignGroup = gto.getTreeObject().getType().equals(BMUI.type_assignment_pol) ? gto : gto.reverseFind(BMUI.type_assignment_pol);
                if (!PolicyManager.getInstance().isPermittedPGAModify(targetAssignGroup)) {
                    event.detail = 0;
                    return;
                }
                this.m_action = this.m_sourceAssignGroup.equals(targetAssignGroup) ? MOVE : COPY;
            }
        }
    }

    public void drop(DropTargetEvent event) {
        Map<AgentCard, String> related;
        GroupTreeObject pga;
        RTLogger.print(5, "DND target drop AsnTree ...");
        Object data = event.item.getData();
        GroupTreeObject target = (GroupTreeObject)data;
        RTLogger.print(5, "DND target drop AsnTree targetPath=" + target.getPath() + " type='" + target.getType() + "' | " + this.m_elements.size() + " elements");
        if (this.m_elements.size() == 0) {
            return;
        }
        if (!PolicyManager.getInstance().isPermittedPGAModify(target)) {
            event.detail = 0;
            return;
        }
        String title = "";
        if (this.m_isAddLink) {
            title = "  Add Links";
        } else if (this.m_action.equals(COPY)) {
            title = "  Copy Links";
        } else if (this.m_action.equals(MOVE)) {
            title = "  Move Links";
        }
        ProgressDialog pd = new ProgressDialog(title, "", 0, this.m_elements.size());
        pd.setBlockOnOpen(false);
        pd.open();
        int progressNumber = 0;
        LinkedList<ScDeploy.NameType> toDeploy = new LinkedList<ScDeploy.NameType>();
        ServerClientBatch scBatch = new ServerClientBatch("BATCH");
        try {
            scBatch.openSocket();
            UpdateServer usrv = new UpdateServer();
            boolean isSuccess = false;
            for (Object o : this.m_elements) {
                GroupTreeObject gto;
                block39: {
                    block41: {
                        String sourcePath;
                        ITreeObject to;
                        block40: {
                            gto = null;
                            to = null;
                            if (!this.m_isAddLink) break block39;
                            sourcePath = null;
                            if (!(o instanceof GroupTreeObjectLast)) break block40;
                            if (!this.m_treeType.equals(BMUI.type_tree_policy)) break block41;
                            GroupTreeObjectLast gtol = (GroupTreeObjectLast)o;
                            to = gtol.getTreeObject();
                            sourcePath = gtol.getPath();
                            pd.setProgress("Add Policy Link '" + gtol.getName() + "'", ++progressNumber);
                            isSuccess = usrv.syncAsnWithServer(scBatch, sourcePath, target.getPath(), CMDS.ACTION_ADDLINK, gtol.getType());
                            if (!isSuccess) break block41;
                            target.addElement(new GroupTreeObjectLast(to, sourcePath, this.getIconType(gtol)));
                            ScDeploy.NameType nt = new ScDeploy.NameType(gtol.getName(), gtol.getType());
                            toDeploy.add(nt);
                            break block41;
                        }
                        if (o instanceof GroupTreeObject) {
                            gto = (GroupTreeObject)o;
                            to = gto.getTreeObject();
                            sourcePath = gto.getPath();
                            isSuccess = usrv.syncAsnWithServer(scBatch, sourcePath, target.getPath(), CMDS.ACTION_ADDLINK, gto.getType());
                            if (isSuccess) {
                                if (this.m_treeType.equals(BMUI.type_tree_binaries)) {
                                    pd.setProgress("Add Binary Link  '" + gto.getName() + "'", ++progressNumber);
                                    target.addElement(new GroupTreeObjectLast(to, sourcePath, "IMAGE_PKG_LNK"));
                                    ScDeploy.NameType nt = new ScDeploy.NameType(gto.getName(), gto.getType());
                                    toDeploy.add(nt);
                                } else if (this.m_treeType.equals(BMUI.type_tree_policy)) {
                                    pd.setProgress("Add Folder " + gto.getName(), ++progressNumber);
                                    GroupTreeObject newFolder = new GroupTreeObject(new TreeObject(gto.getName(), gto.getTreeObject().getType(), null));
                                    newFolder = this.proccessObject(newFolder, gto);
                                    target.addElement(newFolder);
                                    List<GroupTreeObjectLast> policies = newFolder.getAllGTOLs();
                                    for (GroupTreeObjectLast gtol : policies) {
                                        ScDeploy.NameType nt = new ScDeploy.NameType(gtol.getName(), gtol.getType());
                                        toDeploy.add(nt);
                                    }
                                }
                            }
                        }
                    }
                    if (isSuccess) continue;
                    MessageDialog.openError((Shell)this.m_treeViewer.getControl().getShell(), (String)"Error updating server", (String)usrv.m_resultString);
                    continue;
                }
                if (o instanceof GroupTreeObjectLast) {
                    GroupTreeObjectLast source = (GroupTreeObjectLast)o;
                    if (this.m_action.equals(COPY)) {
                        pd.setProgress("Copy Link  '" + source.getName() + "'", ++progressNumber);
                        isSuccess = usrv.syncAsnWithServer(scBatch, source.getPath(), target.getPath(), CMDS.ACTION_COPY, source.getType());
                    } else if (this.m_action.equals(MOVE)) {
                        if (source.getPath().equals(target.getPath()) && source.getType().equals(target.getType())) continue;
                        pd.setProgress("Move Link  '" + source.getName() + "'", ++progressNumber);
                        isSuccess = usrv.syncAsnWithServer(scBatch, source.getPath(), target.getPath(), CMDS.ACTION_MOVE, source.getType());
                        if (isSuccess) {
                            GroupTreeObject parentOld = source.getParent();
                            target.addElement(source);
                            parentOld.removeElement(source);
                        }
                    }
                } else if (o instanceof GroupTreeObject) {
                    gto = (GroupTreeObject)o;
                    if (this.m_action.equals(COPY)) {
                        pd.setProgress("Copy Folder  '" + gto.getName() + "'", ++progressNumber);
                        isSuccess = usrv.syncAsnWithServer(scBatch, gto.getPath(), target.getPath(), CMDS.ACTION_COPY, gto.getType());
                    } else if (this.m_action.equals(MOVE)) {
                        if (gto.getPath().equals(target.getPath()) && gto.getType().equals(target.getType()) || target.getPath().startsWith(String.valueOf(gto.getPath()) + BM.GTO_PATH_SEPARATOR)) continue;
                        pd.setProgress("Move Folder  '" + gto.getName() + "'", ++progressNumber);
                        isSuccess = usrv.syncAsnWithServer(scBatch, gto.getPath(), target.getPath(), CMDS.ACTION_MOVE, gto.getType());
                        if (isSuccess) {
                            GroupTreeObject parentOld = gto.getParent();
                            target.addElement(gto);
                            parentOld.removeElement(gto);
                        }
                    }
                }
                if (isSuccess) continue;
                MessageDialog.openError((Shell)this.m_treeViewer.getControl().getShell(), (String)"Error updating server", (String)usrv.m_resultString);
            }
        }
        catch (Throwable throwable) {
            try {
                scBatch.close();
            }
            catch (Throwable throwable2) {}
            try {
                pd.close();
            }
            catch (Throwable throwable3) {}
            throw throwable;
        }
        try {
            scBatch.close();
        }
        catch (Throwable throwable) {}
        try {
            pd.close();
        }
        catch (Throwable throwable) {}
        this.m_treeViewer.refresh();
        this.m_treeViewer.setExpandedState((Object)target, true);
        if (toDeploy.size() > 0 && BMUI.type_assignment_pol.equals((pga = target.findFirstParent(BMUI.type_assignment_pol)).getType()) && (related = Repository.getInstance().getAllAssignments().getAgentID2AssignmentGroupID(pga.getName())) != null && related.size() > 0) {
            String title1 = toDeploy.size() > 1 ? "Trigger Deployments" : "Trigger Deployment";
            String header = toDeploy.size() > 1 ? "Trigger Deployments now?\n\nRelated Agents:" : "Trigger Deployment now?\n\nRelated Agent:";
            String footer = related.size() > 1 ? "Total: " + related.size() + " Agents" : "Total: " + related.size() + " Agent";
            ShowMessageDialog smd = new ShowMessageDialog(this.m_treeViewer.getControl().getShell(), title1, header, footer, true, "OK", new ArrayList<AgentCard>(related.keySet()), "No related Agents found");
            smd.setBlockOnOpen(true);
            int res = smd.open();
            if (res == 0) {
                StringBuilder agentIDs = new StringBuilder();
                Iterator<AgentCard> it = related.keySet().iterator();
                while (it.hasNext()) {
                    agentIDs.append(it.next().getAgentID());
                    if (!it.hasNext()) continue;
                    agentIDs.append(',');
                }
                ScDeploy sd = new ScDeploy(Repository.getInstance(), agentIDs.toString(), toDeploy.toArray(new ScDeploy.NameType[0]));
                JobManager.getInstance().schedule(sd);
            } else {
                Activator.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage().activate((IWorkbenchPart)AssignmentsSummaryView.getInstance());
            }
        }
    }

    public GroupTreeObject proccessObject(GroupTreeObject newFolder, Object obj) {
        GroupTreeObject gtoNew = null;
        if (obj instanceof GroupTreeObject && !(obj instanceof GroupTreeObjectLast)) {
            GroupTreeObject gto = (GroupTreeObject)obj;
            gtoNew = new GroupTreeObject(new TreeObject(gto.getName(), gto.getTreeObject().getType(), null));
            List<GroupTreeObject> list = gto.getElements();
            for (GroupTreeObject o : list) {
                if (o instanceof GroupTreeObject && !(o instanceof GroupTreeObjectLast)) {
                    GroupTreeObject folder = this.proccessObject(gtoNew, o);
                    gtoNew.addElement(folder);
                    continue;
                }
                if (!(o instanceof GroupTreeObjectLast)) continue;
                GroupTreeObjectLast gtol = (GroupTreeObjectLast)o;
                String iconType = null;
                if (gtol.getTreeObject().getType().equals(BMUI.type_mon)) {
                    iconType = "IMAGE_MON_LNK";
                } else if (gtol.getTreeObject().getType().equals(BMUI.type_msg)) {
                    iconType = "IMAGE_MSG_LNK";
                }
                gtoNew.addElement(new GroupTreeObjectLast(gtol.getTreeObject(), gtol.getLinkedPath(), iconType));
            }
        } else if (obj instanceof GroupTreeObjectLast) {
            GroupTreeObjectLast gtol = (GroupTreeObjectLast)obj;
            newFolder.addElement(new GroupTreeObjectLast(gtol.getTreeObject(), gtol.getLinkedPath(), null));
            return newFolder;
        }
        return gtoNew;
    }

    public String getIconType(GroupTreeObject gtol) {
        String iconType = null;
        if (gtol.getTreeObject().getType().equals(BMUI.type_mon)) {
            iconType = "IMAGE_MON_LNK";
        } else if (gtol.getTreeObject().getType().equals(BMUI.type_msg)) {
            iconType = "IMAGE_MSG_LNK";
        }
        return iconType;
    }

    public void dropAccept(DropTargetEvent event) {
        RTLogger.print(5, "DND target dropAccept AsnTree ...");
        try {
            Object data = event.item.getData();
            GroupTreeObject target = null;
            if (data instanceof GroupTreeObject && !(data instanceof GroupTreeObjectLast)) {
                target = (GroupTreeObject)data;
            } else if (data instanceof GroupTreeObjectLast) {
                GroupTreeObjectLast gtol = (GroupTreeObjectLast)data;
                target = gtol.getParent();
            }
            if (!PolicyManager.getInstance().isPermittedPGAModify(target)) {
                event.detail = 0;
                return;
            }
            Iterator<Object> it = this.m_elements.iterator();
            while (it.hasNext()) {
                GroupTreeObjectLast gtol;
                GroupTreeObject existing;
                Object o = it.next();
                if (o instanceof GroupTreeObject && !(o instanceof GroupTreeObjectLast)) {
                    GroupTreeObject gto = (GroupTreeObject)o;
                    existing = target.getChild(gto.getName(), gto.getType());
                    if (existing != null) {
                        RTLogger.print(5, "DND target dropAccept AsnTree - folder does already exist path=" + existing.getPath() + " | type=" + existing.getType());
                        it.remove();
                    }
                    if (!target.getPath().startsWith(String.valueOf(gto.getPath()) + BM.GTO_PATH_SEPARATOR)) continue;
                    RTLogger.print(5, "DND target dropAccept AsnTree - target is subfolder of source: source=" + gto.getPath() + " | target=" + target.getPath());
                    it.remove();
                    continue;
                }
                if (!(o instanceof GroupTreeObjectLast) || (existing = target.getChild((gtol = (GroupTreeObjectLast)o).getName(), gtol.getType())) == null) continue;
                RTLogger.print(5, "DND target dropAccept AsnTree - link does already exist: " + existing.getPath() + " | " + existing.getType());
                it.remove();
            }
            if (this.m_elements.size() == 0) {
                event.detail = 0;
            }
            RTLogger.print(5, "DND target dropAccept AsnTree " + this.m_elements.size() + " elements");
        }
        catch (RuntimeException e) {
            RTLogger.print(5, "Error DND target dropAccept AsnTree " + e);
        }
    }
}

