/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.views.dnd;

import com.blixx.boom.engine.Repository;
import com.blixx.boom.engine.ServerClientBatch;
import com.blixx.boom.gui.dialogs.ProgressDialog;
import com.blixx.boom.gui.policies.PolicyManager;
import com.blixx.boom.gui.views.AssignmentListView;
import com.blixx.boom.gui.views.actions.UpdateServer;
import com.blixx.log.RTLogger;
import com.blixx.shared.sc.CMDS;
import com.blixx.shared.utils.GroupTreeObject;
import com.blixx.shared.utils.GroupTreeObjectLast;
import com.blixx.shared.utils.GroupTreeObjectUnsubmitted;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.widgets.Shell;

public class DNDTargetTreeProcessor
implements DropTargetListener {
    private TreeViewer m_tree = null;
    private ArrayList<GroupTreeObject> m_elements = new ArrayList();

    public DNDTargetTreeProcessor(TreeViewer tv) {
        this.m_tree = tv;
    }

    public void dragEnter(DropTargetEvent event) {
        TreeSelection sel = (TreeSelection)this.m_tree.getSelection();
        Iterator it = sel.iterator();
        this.m_elements = new ArrayList();
        while (it.hasNext()) {
            Object te = it.next();
            if (!(te instanceof GroupTreeObject)) continue;
            this.m_elements.add((GroupTreeObject)te);
        }
    }

    public void dragLeave(DropTargetEvent event) {
    }

    public void dragOperationChanged(DropTargetEvent event) {
    }

    /*
     * Unable to fully structure code
     */
    public void dragOver(DropTargetEvent event) {
        block5: {
            block6: {
                block7: {
                    event.feedback = 24;
                    if (Repository.getInstance().getRights(1001) < 3) {
                        RTLogger.print(5, "no rights to paste element into Policy Tree ");
                        event.detail = 0;
                        return;
                    }
                    if (event.item == null) break block6;
                    target = event.item.getData();
                    if (!(target instanceof GroupTreeObject) || target instanceof GroupTreeObjectLast) break block7;
                    event.detail = 2;
                    targetGTO = (GroupTreeObject)target;
                    for (GroupTreeObject o : this.m_elements) {
                        block8: {
                            if (!(o instanceof GroupTreeObjectLast)) break block8;
                            sourceGTOL = (GroupTreeObjectLast)o;
                            elem = targetGTO.getChild(sourceGTOL.getName(), sourceGTOL.getType());
                            if (elem != null) {
                                RTLogger.print(1, "policies with the same name/type detected: " + sourceGTOL.getPath() + ", " + elem.getPath());
                                event.detail = 0;
                                break block5;
                            }
                            ** GOTO lbl-1000
                        }
                        sourceGTO = o;
                        source_path = String.valueOf(sourceGTO.getPath()) + "/";
                        target_path = String.valueOf(targetGTO.getPath()) + "/";
                        if (targetGTO.getChild(sourceGTO.getName(), sourceGTO.getType()) != null || target_path.startsWith(source_path)) {
                            event.detail = 0;
                        } else lbl-1000:
                        // 2 sources

                        {
                            if (PolicyManager.getInstance().isPermittedPolicyModify(targetGTO)) continue;
                            event.detail = 0;
                        }
                        break block5;
                    }
                    break block5;
                }
                event.detail = 0;
                break block5;
            }
            event.detail = 0;
        }
    }

    public void drop(DropTargetEvent event) {
        RTLogger.print(5, "DND drop target Policy Tree " + event.item);
        Object data = event.item.getData();
        GroupTreeObject target = (GroupTreeObject)data;
        ProgressDialog pd = new ProgressDialog("  Move Policies", "", 0, this.m_elements.size());
        pd.setBlockOnOpen(false);
        pd.open();
        int pdNumber = 0;
        ServerClientBatch scBatch = new ServerClientBatch("BATCH");
        scBatch.openSocket();
        try {
            UpdateServer usrv = new UpdateServer();
            for (GroupTreeObject o : this.m_elements) {
                GroupTreeObject parentOld;
                boolean isSuccess;
                if (o instanceof GroupTreeObjectLast) {
                    GroupTreeObjectLast gtl = (GroupTreeObjectLast)o;
                    pd.setProgress("   Move " + gtl.getName(), ++pdNumber);
                    if (gtl instanceof GroupTreeObjectUnsubmitted) continue;
                    isSuccess = usrv.syncWithServer(scBatch, gtl.getPath(), target.getPath(), CMDS.ACTION_MOVE, gtl.getType());
                    if (isSuccess) {
                        parentOld = gtl.getParent();
                        target.addElement(gtl);
                        parentOld.removeElement(gtl);
                        continue;
                    }
                    MessageDialog.openError((Shell)this.m_tree.getControl().getShell(), (String)"Error", (String)usrv.m_resultString);
                    continue;
                }
                if (!(o instanceof GroupTreeObject)) continue;
                GroupTreeObject gto = o;
                pd.setProgress("   Move " + gto.getName(), ++pdNumber);
                isSuccess = usrv.syncWithServer(scBatch, gto.getPath(), target.getPath(), CMDS.ACTION_MOVE, gto.getType());
                if (isSuccess) {
                    parentOld = gto.getParent();
                    target.addElement(gto);
                    parentOld.removeElement(gto);
                    continue;
                }
                MessageDialog.openError((Shell)this.m_tree.getControl().getShell(), (String)"Error", (String)usrv.m_resultString);
            }
        }
        catch (Throwable throwable) {
            try {
                scBatch.close();
            }
            catch (Throwable throwable2) {}
            try {
                pd.close();
            }
            catch (Throwable throwable3) {}
            throw throwable;
        }
        try {
            scBatch.close();
        }
        catch (Throwable throwable) {}
        try {
            pd.close();
        }
        catch (Throwable throwable) {}
        this.m_tree.refresh();
        AssignmentListView.getInstance().getTreeViewer().refresh();
        this.m_tree.setExpandedState((Object)target, true);
    }

    public void dropAccept(DropTargetEvent event) {
        RTLogger.print(5, "DND dropAccept target Policy Tree " + event.item);
        Object data = event.item.getData();
        GroupTreeObject targetGTO = (GroupTreeObject)data;
        Iterator<GroupTreeObject> it = this.m_elements.iterator();
        while (it.hasNext()) {
            GroupTreeObject o = it.next();
            if (o instanceof GroupTreeObjectLast) {
                GroupTreeObjectLast sourceGTOL = (GroupTreeObjectLast)o;
                if (targetGTO.getChild(sourceGTOL.getName(), sourceGTOL.getType()) == null) continue;
                it.remove();
                continue;
            }
            if (!(o instanceof GroupTreeObject)) continue;
            GroupTreeObject sourceGTO = o;
            String source_path = String.valueOf(sourceGTO.getPath()) + "/";
            String target_path = String.valueOf(targetGTO.getPath()) + "/";
            if (targetGTO.getChild(sourceGTO.getName(), sourceGTO.getType()) != null || target_path.startsWith(source_path)) {
                it.remove();
            }
            if (PolicyManager.getInstance().isPermittedPolicyModify(targetGTO)) continue;
            it.remove();
        }
        if (this.m_elements.size() == 0) {
            event.detail = 0;
        }
    }
}

