/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.views.outages;

import com.blixx.boom.engine.BMUI;
import com.blixx.boom.engine.Repository;
import com.blixx.boom.gui.Activator;
import com.blixx.boom.gui.utils.GUIDisplayElements;
import com.blixx.boom.gui.utils.TableComparator;
import com.blixx.boom.gui.views.FilterProvider;
import com.blixx.boom.gui.views.outages.MaintenanceFilterDialog;
import com.blixx.boom.gui.views.outages.NodeGroupFilterDialog;
import com.blixx.shared.ext.ForwardFilter;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.ISharedImages;

public abstract class AbstractMaintenanceDetailsComposite
extends Composite
implements IDoubleClickListener,
SelectionListener,
ModifyListener {
    public static final String FILTER_DELETE = "FILTER_DELETE";
    public static final String FILTER_NEW = "FILTER_NEW";
    public static final String FILTER_EDIT = "FILTER_EDIT";
    public static final String INFINITY = "\u221e";
    public static final String SAVE_BTN = "SAVE_BTN";
    public static final String UNDO_BTN = "UNDO_BTN";
    public static final String SP_INTERVAL = "SP_INTERVAL";
    public static final String SP_POST_ACTION = "SPPostAction";
    public static final String SP_ACTION = "SPAction";
    public static final String SP_DESCR = "SPDescr";
    public static final String SP_NAME = "SPName";
    public static final String ID = "ID";
    protected ScrolledComposite m_sc = null;
    protected Composite m_comp_main = null;
    protected GUIDisplayElements m_gui = new GUIDisplayElements();
    protected Text m_mSpID = null;
    protected Text m_mSpName = null;
    protected Text m_mSpDescr = null;
    protected Text m_mSpOwner = null;
    protected Text m_mSpReadOnly = null;
    protected TableViewer m_table_filters = null;
    protected FilterProvider m_fp = new FilterProvider(null);
    protected AtomicBoolean m_dirty = new AtomicBoolean(false);
    protected boolean m_isValid = true;
    protected boolean m_isReadOnly = false;
    protected CTabItem m_cTab = null;
    protected Composite m_parent = null;
    protected Button m_editF = null;
    protected Button m_newF = null;
    protected Button m_delF = null;
    protected Button m_save = null;
    protected Button m_undo = null;
    private Text m_statusFilters;

    public AbstractMaintenanceDetailsComposite(CTabItem cTab, Composite parent, int style) {
        super(parent, style);
        this.m_cTab = cTab;
        this.m_parent = parent;
        this.init();
    }

    public abstract void init();

    public void checkButtons() {
        if (this.isReadOnly()) {
            this.m_mSpReadOnly.setVisible(true);
            return;
        }
        boolean isSpNameValid = false;
        if (this.m_mSpName != null && this.m_mSpName.getText().trim().length() > 0) {
            isSpNameValid = true;
        }
        this.m_gui.enableField(this.m_save, this.isDirty() && this.m_isValid && isSpNameValid);
        this.m_gui.enableField(this.m_undo, this.isDirty());
        int selCount = this.m_table_filters.getTable().getSelectionCount();
        if (selCount == 1) {
            this.m_gui.enableField(this.m_editF, true);
            this.m_gui.enableField(this.m_delF, true);
        } else if (selCount > 1) {
            this.m_gui.enableField(this.m_editF, false);
            this.m_gui.enableField(this.m_delF, true);
        } else {
            this.m_gui.enableField(this.m_editF, false);
            this.m_gui.enableField(this.m_delF, false);
        }
    }

    public void setDirty(boolean dirty) {
        if (this.isReadOnly()) {
            return;
        }
        if (this.m_dirty.compareAndSet(!dirty, dirty)) {
            if (this.isDirty()) {
                if (!this.m_cTab.getText().startsWith("* ")) {
                    this.m_cTab.setText("* " + this.m_cTab.getText());
                }
                this.validate();
            } else if (this.m_cTab.getText().startsWith("* ")) {
                this.m_cTab.setText(this.m_cTab.getText().substring(2));
            }
        }
        this.checkButtons();
    }

    public Composite createFilterTable(Composite parent) {
        Group filter_grp = new Group(parent, 0);
        filter_grp.setText(" Filters ");
        filter_grp.setLayout((Layout)new GridLayout(2, false));
        filter_grp.setLayoutData((Object)new GridData(4, 4, true, false, 4, 1));
        Table m_fFilterTable = new Table((Composite)filter_grp, 68354);
        GridData gd = new GridData(4, 4, true, true, 2, 1);
        gd.heightHint = 80;
        m_fFilterTable.setLayoutData((Object)gd);
        m_fFilterTable.setHeaderVisible(true);
        m_fFilterTable.setLinesVisible(true);
        TableColumn col2 = new TableColumn(m_fFilterTable, 16384);
        col2.setText("Name");
        col2.setWidth(100);
        TableColumn col3 = new TableColumn(m_fFilterTable, 16384);
        col3.setText("Attribute");
        col3.setWidth(100);
        TableColumn col4 = new TableColumn(m_fFilterTable, 16384);
        col4.setText("Pattern");
        col4.setWidth(230);
        this.m_table_filters = new TableViewer(m_fFilterTable);
        this.m_table_filters.setContentProvider((IContentProvider)this.m_fp);
        this.m_table_filters.setLabelProvider((IBaseLabelProvider)this.m_fp);
        this.m_table_filters.setInput(null);
        this.m_table_filters.setComparator((ViewerComparator)new TableComparator(m_fFilterTable));
        this.m_table_filters.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                AbstractMaintenanceDetailsComposite.this.checkButtons();
            }
        });
        this.m_table_filters.addDoubleClickListener((IDoubleClickListener)this);
        this.m_table_filters.getTable().select(0);
        ISharedImages sharedImages = Activator.getDefault().getWorkbench().getActiveWorkbenchWindow().getWorkbench().getSharedImages();
        Composite btn_comp = new Composite((Composite)filter_grp, 0);
        GridLayout gl = new GridLayout(3, true);
        gl.verticalSpacing = 0;
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        btn_comp.setLayout((Layout)gl);
        btn_comp.setLayoutData((Object)new GridData(16384, 4, false, false));
        this.m_editF = this.m_gui.addButton(btn_comp, FILTER_EDIT, "Edit", false, 60, 10, 0, 8, this);
        ((GridData)this.m_editF.getLayoutData()).horizontalAlignment = 4;
        this.m_editF.setImage(BMUI.IMAGE_EDIT);
        this.m_newF = this.m_gui.addButton(btn_comp, FILTER_NEW, "Add", !this.isReadOnly(), 10, 60, 0, 8, this);
        ((GridData)this.m_newF.getLayoutData()).horizontalAlignment = 4;
        this.m_newF.setImage(sharedImages.getImage("IMG_OBJ_ADD"));
        this.m_delF = this.m_gui.addButton(btn_comp, FILTER_DELETE, "Delete", false, 60, 10, 0, 8, this);
        ((GridData)this.m_delF.getLayoutData()).horizontalAlignment = 4;
        this.m_delF.setImage(sharedImages.getImage("IMG_TOOL_DELETE"));
        this.m_statusFilters = this.m_gui.addTextReadOnlyNoBorder((Composite)filter_grp, null, "Filter on Agent ID or NodeGroup is required!", 1, 1, 0, 0, null);
        this.m_statusFilters.setForeground(BMUI.color_critical);
        this.m_statusFilters.setVisible(false);
        return filter_grp;
    }

    public boolean isDirty() {
        return this.m_dirty.get();
    }

    public boolean isReadOnly() {
        return this.m_isReadOnly;
    }

    public void setReadOnly(boolean readOnly) {
        this.m_isReadOnly = readOnly;
    }

    public void refreshFilterTable(ForwardFilter selectedFilter, TableViewer tableViewer, FilterProvider provider) {
        int selIndex = tableViewer.getTable().getSelectionIndex();
        tableViewer.setInput((Object)provider.getElements(null));
        if (selectedFilter != null) {
            TableItem[] items = tableViewer.getTable().getItems();
            int i = 0;
            while (items != null && i < items.length) {
                ForwardFilter f = (ForwardFilter)items[i].getData();
                if (selectedFilter.getNumber().equals(f.getNumber())) {
                    selIndex = i;
                    break;
                }
                ++i;
            }
        }
        if (selIndex == -1 || selIndex >= tableViewer.getTable().getItemCount()) {
            tableViewer.getTable().setSelection(0);
        } else {
            tableViewer.getTable().setSelection(selIndex);
        }
        tableViewer.refresh();
    }

    public abstract boolean saveServerPolicy(String var1);

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void validate() {
        try {
            if (!Repository.getInstance().isUserFiltered()) {
                this.m_statusFilters.setVisible(false);
            } else {
                boolean isAgentFilterDefined = false;
                for (ForwardFilter filter : this.m_fp.getFilters()) {
                    if (filter.getType() != 26 && filter.getType() != 21) continue;
                    isAgentFilterDefined = true;
                    break;
                }
                if (!isAgentFilterDefined) {
                    this.m_statusFilters.setVisible(true);
                    this.m_isValid = false;
                } else {
                    this.m_statusFilters.setVisible(false);
                }
            }
        }
        catch (Throwable throwable) {}
    }

    public class FilterAction
    extends Action {
        protected Shell m_shell;
        protected ForwardFilter m_ff;
        protected List<ForwardFilter> m_ff2Del;
        protected TableViewer m_tv;
        protected FilterProvider m_filterProvider;
        protected String m_action;

        public FilterAction(Shell shell, TableViewer tv, FilterProvider filterProvider, String action) {
            super("FilterAction");
            this.m_shell = null;
            this.m_ff = null;
            this.m_ff2Del = null;
            this.m_tv = null;
            this.m_filterProvider = null;
            this.m_action = null;
            this.setId("FilterAction");
            this.setText("FilterAction");
            this.m_shell = shell;
            this.m_tv = tv;
            this.m_filterProvider = filterProvider;
            this.m_action = action;
            if (this.m_shell == null || this.m_tv == null || this.m_filterProvider == null || this.m_action == null || AbstractMaintenanceDetailsComposite.this.isReadOnly()) {
                this.setEnabled(false);
            }
            if (this.m_action.equals(AbstractMaintenanceDetailsComposite.FILTER_NEW)) {
                this.setText("Add Filter");
            } else if (this.m_action.equals(AbstractMaintenanceDetailsComposite.FILTER_EDIT)) {
                this.setText("Edit Filter");
                StructuredSelection sel = (StructuredSelection)this.m_tv.getSelection();
                if (sel.size() == 1) {
                    this.m_ff = (ForwardFilter)sel.getFirstElement();
                } else {
                    this.setEnabled(false);
                }
            } else if (this.m_action.equals(AbstractMaintenanceDetailsComposite.FILTER_DELETE)) {
                this.setText("Delete Filter");
                StructuredSelection ssel = (StructuredSelection)this.m_tv.getSelection();
                if (!ssel.isEmpty()) {
                    this.m_ff2Del = new ArrayList<ForwardFilter>();
                    for (ForwardFilter ff : ssel) {
                        this.m_ff2Del.add(ff);
                    }
                } else {
                    this.setEnabled(false);
                }
            }
        }

        public void run() {
            if (!this.isEnabled()) {
                return;
            }
            if (this.m_action.equals(AbstractMaintenanceDetailsComposite.FILTER_DELETE)) {
                if (this.m_ff2Del != null && this.m_ff2Del.size() > 0) {
                    this.m_filterProvider.removeFFilters(this.m_ff2Del);
                    AbstractMaintenanceDetailsComposite.this.setDirty(true);
                    AbstractMaintenanceDetailsComposite.this.refreshFilterTable(null, this.m_tv, this.m_filterProvider);
                    AbstractMaintenanceDetailsComposite.this.checkButtons();
                }
            } else if (this.m_action.equals(AbstractMaintenanceDetailsComposite.FILTER_EDIT) || this.m_action.equals(AbstractMaintenanceDetailsComposite.FILTER_NEW)) {
                MaintenanceFilterDialog dialog = this.getDialog();
                dialog.setBlockOnOpen(true);
                dialog.open();
                if (dialog.getReturnCode() == 0) {
                    Properties p = new Properties();
                    p.setProperty("NAME", dialog.m_name);
                    p.setProperty("ATTRIBUTE", dialog.m_attribute);
                    p.setProperty("PATTERN", dialog.m_pattern);
                    if (this.m_action.equals(AbstractMaintenanceDetailsComposite.FILTER_NEW)) {
                        p.setProperty("FILTER_NUMBER", "" + (this.m_filterProvider.getHighestNumber() + 1));
                    } else {
                        p.setProperty("FILTER_NUMBER", "" + this.m_ff.getNumber());
                    }
                    ForwardFilter ff = ForwardFilter.getInstance(p);
                    ArrayList<ForwardFilter> fList = new ArrayList<ForwardFilter>();
                    fList.add(ff);
                    this.m_filterProvider.addFFilters(fList);
                    AbstractMaintenanceDetailsComposite.this.setDirty(true);
                    AbstractMaintenanceDetailsComposite.this.refreshFilterTable(ff, this.m_tv, this.m_filterProvider);
                    AbstractMaintenanceDetailsComposite.this.checkButtons();
                }
            }
        }

        public MaintenanceFilterDialog getDialog() {
            return new MaintenanceFilterDialog(this.m_shell, this.m_ff);
        }
    }

    public class NodeGroupFilterAction
    extends FilterAction {
        public NodeGroupFilterAction(Shell shell, TableViewer tv, FilterProvider filterProvider, String action) {
            super(shell, tv, filterProvider, action);
        }

        @Override
        public MaintenanceFilterDialog getDialog() {
            return new NodeGroupFilterDialog(this.m_shell, this.m_ff);
        }
    }
}

