/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.views.outages;

import com.blixx.boom.engine.AgentCard;
import com.blixx.boom.engine.BMUI;
import com.blixx.boom.engine.Repository;
import com.blixx.boom.engine.UIJob;
import com.blixx.boom.engine.UIJobManager;
import com.blixx.boom.gui.dialogs.ShowMessageBox;
import com.blixx.boom.gui.views.outages.IServerPolicyStatusProvider;
import com.blixx.ctrl.sc.ICmdPostProcess;
import com.blixx.ctrl.sc.ServerClient;
import com.blixx.ctrl.sc.in.ScDeleteAgentOutagePolicy;
import com.blixx.ctrl.sc.in.ScEnableAgentOutagePolicy;
import com.blixx.ctrl.sc.in.ScGetAgentServerPolicies;
import com.blixx.shared.Interval;
import com.blixx.shared.ext.AgentOutagePolicy;
import com.blixx.shared.ext.ServerPolicyStatus;
import com.blixx.shared.ext.ServerPolicyTemplate;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.IElementComparer;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.graphics.Image;

public class AgentAdHocMaintenanceTableProvider
extends CellLabelProvider
implements IElementComparer,
IStructuredContentProvider,
ICmdPostProcess,
IServerPolicyStatusProvider {
    public static final String COL_POLICY_ID = "ID";
    public static final String COL_AGENT = "Agent";
    public static final String COL_ENABLED = "Enabled";
    public static final String COL_ENABLEDBY = "Enabled by";
    public static final String COL_DISABLEDBY = "Disabled by";
    public static final String COL_ACTIVE = "Active";
    public static final String COL_ACTION = "Action";
    public static final String COL_POSTACTION = "PostAction";
    public static final String COL_START = "Start Time";
    public static final String COL_INTERVAL = "Interval";
    public static final String COL_EXPEXTED_END = "Expected End";
    public static final String COL_IS_END_TIME = "End Time";
    public static final String COL_FILTERS = "Filters";
    public static final int COL_POLICY_ID_INT = 0;
    public static final int COL_AGENT_INT = 1;
    public static final int COL_ENABLED_INT = 2;
    public static final int COL_ENABLEDBY_INT = 3;
    public static final int COL_DISABLEDBY_INT = 4;
    public static final int COL_ACTIVE_INT = 5;
    public static final int COL_ACTION_INT = 6;
    public static final int COL_POSTACTION_INT = 7;
    public static final int COL_START_INT = 8;
    public static final int COL_INTERVAL_INT = 9;
    public static final int COL_EXPEXTED_END_INT = 10;
    public static final int COL_IS_END_TIME_INT = 11;
    public static final int COL_FILTERS_INT = 12;
    List<AgentOutagePolicy> m_serverPolicies = new LinkedList<AgentOutagePolicy>();
    Map<String, ServerPolicyStatus> m_serverPoliciesStatus = new HashMap<String, ServerPolicyStatus>();
    TableViewer m_table = null;

    public AgentAdHocMaintenanceTableProvider(TableViewer table) {
        this.m_table = table;
    }

    public boolean equals(Object a, Object b) {
        return a == null ? b == null : a.equals(b);
    }

    public int hashCode(Object element) {
        return element.hashCode();
    }

    public Object[] getElements(Object inputElement) {
        return this.m_serverPolicies.toArray();
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public void update(ViewerCell cell) {
        AgentOutagePolicy sp = (AgentOutagePolicy)cell.getElement();
        cell.setText(this.getText(cell.getColumnIndex(), sp));
        cell.setImage(this.getImage(cell.getColumnIndex(), this.m_serverPoliciesStatus.get(sp.getID())));
    }

    public Image getImage(int colindex, ServerPolicyStatus sps) {
        Image image = null;
        if (sps != null) {
            switch (colindex) {
                case 2: {
                    image = sps.m_enabled ? BMUI.IMAGE_ACCEPT_GREEN : BMUI.IMAGE_CANCEL_ROUND;
                    break;
                }
                case 5: {
                    image = sps.m_active ? BMUI.IMAGE_ACCEPT_GREEN : BMUI.IMAGE_CANCEL_ROUND;
                    break;
                }
            }
        }
        return image;
    }

    public String getText(int colindex, AgentOutagePolicy sp) {
        ServerPolicyStatus sps = this.m_serverPoliciesStatus.get(sp.getID());
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String label = "";
        switch (colindex) {
            case 0: {
                label = sp.getID();
                break;
            }
            case 1: {
                String agentID = sp.getAgentID();
                AgentCard ac = Repository.getInstance().getAgentCard(agentID);
                if (ac == null) {
                    label = agentID;
                    break;
                }
                label = ac.toString();
                break;
            }
            case 2: {
                label = sps.m_enabled ? "enabled" : "disabled";
                break;
            }
            case 5: {
                label = sps.m_active ? "active" : "inactive";
                break;
            }
            case 3: {
                label = sps.m_enabledBy;
                break;
            }
            case 4: {
                label = sps.m_disabledBy;
                break;
            }
            case 6: {
                label = ServerPolicyTemplate.getActionLabel(sp.getAction());
                break;
            }
            case 7: {
                label = ServerPolicyTemplate.getActionLabel(sp.getPostAction());
                break;
            }
            case 8: {
                if (sp.getTimeInterval().getFirstStart() > 0L) {
                    label = sdf.format(new Date(sp.getTimeInterval().getFirstStart()));
                    break;
                }
                label = "-";
                break;
            }
            case 9: {
                if (sp.getTimeInterval().getInterval() > 0L && sp.getTimeInterval().getInterval() < Long.MAX_VALUE) {
                    Interval ivl = Interval.getSimpleInterval((int)(sp.getTimeInterval().getInterval() / 1000L));
                    label = ivl.toString();
                    break;
                }
                if (sp.getTimeInterval().getInterval() == Long.MAX_VALUE) {
                    label = "\u221e";
                    break;
                }
                label = "-";
                break;
            }
            case 10: {
                if (sp.getExpectedDuration() <= 0L || sp.getExpectedDuration() == Long.MAX_VALUE) {
                    label = "-";
                    break;
                }
                long end = sp.getTimeInterval().getFirstStart() + sp.getExpectedDuration();
                label = sdf.format(new Date(end));
                break;
            }
            case 11: {
                if (sp.getIsEndTime() > 0L) {
                    label = sdf.format(new Date(sp.getIsEndTime()));
                    break;
                }
                label = "-";
                break;
            }
            case 12: {
                String fstr = sp.getFiltersAsString();
                if (fstr.endsWith("\n")) {
                    fstr = fstr.substring(0, fstr.length() - 1);
                }
                label = fstr.replace("\n", " & ");
                break;
            }
        }
        return label;
    }

    public void reloadData() {
        ScGetAgentServerPolicies sc = new ScGetAgentServerPolicies(Repository.getInstance());
        sc.addCmdPostProcess(this);
        sc.start();
    }

    public void postProcess(ServerClient client) {
        if (client instanceof ScGetAgentServerPolicies) {
            ScGetAgentServerPolicies sc = (ScGetAgentServerPolicies)client;
            if (sc.isSuccess()) {
                this.m_serverPolicies.clear();
                this.m_serverPoliciesStatus.clear();
                for (AgentOutagePolicy ap : sc.getServerPolicies()) {
                    if (Repository.getInstance().getAgentCard(ap.getAgentID()) == null) continue;
                    ServerPolicyStatus status = sc.getStatuses().get(ap.getID());
                    this.m_serverPolicies.add(ap);
                    this.m_serverPoliciesStatus.put(ap.getID(), status);
                }
                UIJob uj = new UIJob("SePolRefresh"){

                    @Override
                    public IStatus runInUIThread(IProgressMonitor monitor) {
                        AgentAdHocMaintenanceTableProvider.this.m_table.setInput((Object)AgentAdHocMaintenanceTableProvider.this.getElements(null));
                        return null;
                    }
                };
                UIJobManager.getInstance().schedule(uj);
            }
        } else {
            this.reloadData();
            if (!client.isSuccess()) {
                new ShowMessageBox("Error", client.getLastException().getMessage(), 1);
            }
        }
    }

    public void enablePolicies(List<String> ids) {
        ScEnableAgentOutagePolicy sc = new ScEnableAgentOutagePolicy(Repository.getInstance(), ids, true, "");
        sc.addCmdPostProcess(this);
        sc.start();
    }

    public void disablePolicies(List<String> ids, int overridePostAction) {
        ScEnableAgentOutagePolicy sc = new ScEnableAgentOutagePolicy(Repository.getInstance(), ids, false, "", overridePostAction);
        sc.addCmdPostProcess(this);
        sc.start();
    }

    public void deletePolicy(List<String> ids) {
        ScDeleteAgentOutagePolicy sc = new ScDeleteAgentOutagePolicy(Repository.getInstance(), ids, null);
        sc.addCmdPostProcess(this);
        sc.start();
    }

    @Override
    public ServerPolicyStatus getServerPolicyStatus(String id) {
        return this.m_serverPoliciesStatus.get(id);
    }
}

