/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.views.outages;

import com.blixx.boom.engine.BMUI;
import com.blixx.boom.engine.ICommandListener;
import com.blixx.boom.engine.Repository;
import com.blixx.boom.gui.Activator;
import com.blixx.boom.gui.utils.FilterComposite;
import com.blixx.boom.gui.utils.GUIDisplayElements;
import com.blixx.boom.gui.views.MaintenanceView;
import com.blixx.boom.gui.views.outages.AgentAdHocMaintenanceTableProvider;
import com.blixx.boom.gui.views.outages.StatusViewFilter;
import com.blixx.log.RTLogger;
import com.blixx.shared.ext.AgentOutagePolicy;
import com.blixx.shared.ext.ServerPolicyStatus;
import com.blixx.shared.ext.ServerPolicyTemplate;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IElementComparer;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.ISharedImages;

public class AgentAdhocMaintenanceOverviewTab
extends CTabItem
implements SelectionListener,
IDoubleClickListener,
ICommandListener {
    public static final String SHOWDISABLED = "SHOWDISABLED";
    public static final String SHOWENABLED = "SHOWENABLED";
    public static final String SHOWALL = "SHOWALL";
    private static String REFRESH_BTN = "REFRESH_BTN";
    public static String VIEWER_TYPE_OVERVIEW = "OVERVIEW";
    public static String VIEWER_TYPE_NONE = "NONE";
    public static String VIEWER_TYPE = "VIEWER_TYPE";
    CTabFolder m_folder = null;
    private Composite m_compositeInView = null;
    private Composite m_compMain = null;
    private Composite m_compTable = null;
    private GUIDisplayElements m_gui = null;
    private Composite m_sc = null;
    private Table m_table = null;
    private TableViewer m_tableViewer = null;
    private Button m_refresh_btn = null;
    public static HashMap<String, Integer> m_colIndices = null;
    public static HashMap<Integer, String> m_colNames = null;
    public static HashMap<String, Integer> m_columnWidth = new HashMap();
    public AgentAdHocMaintenanceTableProvider m_provider = null;
    SelectionListener m_sorter = new SelectionListener(){

        public void widgetSelected(SelectionEvent e) {
            TableColumn sortColumn = AgentAdhocMaintenanceOverviewTab.this.m_table.getSortColumn();
            TableColumn currentColumn = (TableColumn)e.widget;
            int dir = AgentAdhocMaintenanceOverviewTab.this.m_table.getSortDirection();
            if (sortColumn == currentColumn) {
                dir = dir == 128 ? 1024 : 128;
            } else {
                AgentAdhocMaintenanceOverviewTab.this.m_table.setSortColumn(currentColumn);
                dir = 128;
            }
            AgentAdhocMaintenanceOverviewTab.this.m_table.setSortDirection(dir);
            AgentAdhocMaintenanceOverviewTab.this.m_tableViewer.refresh(true, false);
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }
    };

    static {
        m_columnWidth.put("ID", 36);
        m_columnWidth.put("Agent", 140);
        m_columnWidth.put("Enabled", 25);
        m_columnWidth.put("Enabled by", 80);
        m_columnWidth.put("Disabled by", 80);
        m_columnWidth.put("Active", 25);
        m_columnWidth.put("Action", 50);
        m_columnWidth.put("PostAction", 50);
        m_columnWidth.put("Start Time", 140);
        m_columnWidth.put("Interval", 40);
        m_columnWidth.put("Expected End", 140);
        m_columnWidth.put("End Time", 80);
        m_columnWidth.put("Filters", 200);
    }

    public AgentAdhocMaintenanceOverviewTab(CTabFolder parent, int style) {
        super(parent, style, 0);
        this.m_folder = parent;
        this.setText("Overview");
        this.setImage(BMUI.IMAGE_AGENTOUTAGE);
        this.createMainArea();
        if (Repository.getInstance().getRights(2011) > 1) {
            Repository.getInstance().getCmdRouter().addCmdListener("GET_SERVER_POLICIES_STATUS_AOP", this);
        }
    }

    @Override
    public void onCommand(String command, String action) {
        this.m_provider.reloadData();
    }

    public void createMainArea() {
        this.m_gui = new GUIDisplayElements();
        this.m_compositeInView = new Composite((Composite)this.m_folder, 0);
        GridLayout gl = new GridLayout(1, false);
        gl.verticalSpacing = 0;
        gl.horizontalSpacing = 0;
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        this.m_compositeInView.setLayout((Layout)gl);
        this.m_sc = new Composite(this.m_compositeInView, 0);
        this.m_sc.setLayout((Layout)gl);
        this.m_sc.setLayoutData((Object)new GridData(4, 4, true, true));
        this.m_compMain = new Composite(this.m_sc, 2048);
        gl = new GridLayout(4, false);
        gl.verticalSpacing = 0;
        this.m_compMain.setLayout((Layout)gl);
        this.m_compMain.setLayoutData((Object)new GridData(4, 4, true, true));
        Group filterGroupOnStatus = new Group(this.m_compMain, 0);
        filterGroupOnStatus.setText("Filter on Status");
        filterGroupOnStatus.setLayout((Layout)new GridLayout(3, false));
        GridData gdb = new GridData(4, 4, false, false);
        gdb.minimumWidth = 100;
        filterGroupOnStatus.setLayoutData((Object)gdb);
        Button showAll = this.m_gui.addRadioButton((Composite)filterGroupOnStatus, SHOWALL, "All", true, 1, 1, 0, 0, this);
        showAll.setLayoutData((Object)new GridData(1, 0x1000000, false, true));
        Button showEnabled = this.m_gui.addRadioButton((Composite)filterGroupOnStatus, SHOWENABLED, "Enabled", false, 1, 1, 0, 0, this);
        showEnabled.setLayoutData((Object)new GridData(1, 0x1000000, false, true));
        Button showDisabled = this.m_gui.addRadioButton((Composite)filterGroupOnStatus, SHOWDISABLED, "Disabled", false, 1, 1, 0, 0, this);
        showDisabled.setLayoutData((Object)new GridData(1, 0x1000000, false, true));
        Group filterGroup = new Group(this.m_compMain, 0);
        filterGroup.setText("Filter on Name or ID");
        gl = new GridLayout(3, false);
        gl.horizontalSpacing = 0;
        gl.marginWidth = 0;
        filterGroup.setLayout((Layout)gl);
        GridData gd = new GridData(4, 4, true, false);
        gd.minimumWidth = 100;
        filterGroup.setLayoutData((Object)gd);
        FilterComposite filterComp = new FilterComposite((Composite)filterGroup, this);
        filterComp.setCompositeLayoutData(new GridData(4, 0x1000000, true, true));
        Composite compBtn_refresh = new Composite(this.m_compMain, 0);
        compBtn_refresh.setLayout((Layout)new GridLayout(1, false));
        compBtn_refresh.setLayoutData((Object)new GridData(4, 4, false, false));
        this.m_refresh_btn = this.m_gui.addButton(compBtn_refresh, REFRESH_BTN, "Refresh ", true, 35, 20, 0, this);
        this.m_refresh_btn.setImage(BMUI.IMAGE_REFRESH_14x14);
        ((GridData)this.m_refresh_btn.getLayoutData()).verticalAlignment = 0x1000000;
        ((GridData)this.m_refresh_btn.getLayoutData()).verticalIndent = 7;
        this.m_compTable = new Composite(this.m_compMain, 0);
        gl = new GridLayout(1, false);
        gl.verticalSpacing = 0;
        gl.horizontalSpacing = 0;
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        this.m_compTable.setLayout((Layout)gl);
        this.m_compTable.setLayoutData((Object)new GridData(4, 4, true, true, 3, 1));
        this.createTable();
        this.setControl((Control)this.m_compositeInView);
    }

    protected void createTable() {
        GridData gd = null;
        GridLayout gl = null;
        this.m_table = new Table(this.m_compTable, 68354);
        this.m_table.setHeaderVisible(true);
        this.m_table.setLinesVisible(true);
        gl = new GridLayout();
        gl.verticalSpacing = 0;
        this.m_table.setLayout((Layout)gl);
        gd = new GridData(4, 4, true, true, 4, 1);
        gd.verticalIndent = 5;
        gd.heightHint = 50;
        this.m_table.setLayoutData((Object)gd);
        this.m_tableViewer = new TableViewer(this.m_table);
        this.m_tableViewer.setData(VIEWER_TYPE, (Object)VIEWER_TYPE_OVERVIEW);
        this.m_provider = new AgentAdHocMaintenanceTableProvider(this.m_tableViewer);
        TableViewerColumn col0 = new TableViewerColumn(this.m_tableViewer, 16384);
        col0.getColumn().setText("ID");
        col0.getColumn().setWidth(m_columnWidth.get("ID").intValue());
        col0.setLabelProvider((CellLabelProvider)this.m_provider);
        col0.getColumn().addSelectionListener(this.m_sorter);
        TableViewerColumn col1 = new TableViewerColumn(this.m_tableViewer, 16384);
        col1.getColumn().setText("Agent");
        col1.getColumn().setWidth(m_columnWidth.get("Agent").intValue());
        col1.setLabelProvider((CellLabelProvider)this.m_provider);
        col1.getColumn().addSelectionListener(this.m_sorter);
        TableViewerColumn col2 = new TableViewerColumn(this.m_tableViewer, 0x1000000);
        col2.getColumn().setText("Enabled");
        col2.getColumn().setWidth(m_columnWidth.get("Enabled").intValue());
        col2.setLabelProvider((CellLabelProvider)this.m_provider);
        col2.getColumn().addSelectionListener(this.m_sorter);
        TableViewerColumn col3 = new TableViewerColumn(this.m_tableViewer, 16384);
        col3.getColumn().setText("Enabled by");
        col3.getColumn().setWidth(m_columnWidth.get("Enabled by").intValue());
        col3.setLabelProvider((CellLabelProvider)this.m_provider);
        col3.getColumn().addSelectionListener(this.m_sorter);
        TableViewerColumn col4 = new TableViewerColumn(this.m_tableViewer, 16384);
        col4.getColumn().setText("Disabled by");
        col4.getColumn().setWidth(m_columnWidth.get("Disabled by").intValue());
        col4.setLabelProvider((CellLabelProvider)this.m_provider);
        col4.getColumn().addSelectionListener(this.m_sorter);
        TableViewerColumn col5 = new TableViewerColumn(this.m_tableViewer, 16384);
        col5.getColumn().setText("Active");
        col5.getColumn().setWidth(m_columnWidth.get("Active").intValue());
        col5.setLabelProvider((CellLabelProvider)this.m_provider);
        col5.getColumn().addSelectionListener(this.m_sorter);
        TableViewerColumn col6 = new TableViewerColumn(this.m_tableViewer, 16384);
        col6.getColumn().setText("Action");
        col6.getColumn().setWidth(m_columnWidth.get("Action").intValue());
        col6.setLabelProvider((CellLabelProvider)this.m_provider);
        col6.getColumn().addSelectionListener(this.m_sorter);
        TableViewerColumn col7 = new TableViewerColumn(this.m_tableViewer, 16384);
        col7.getColumn().setText("PostAction");
        col7.getColumn().setWidth(m_columnWidth.get("PostAction").intValue());
        col7.setLabelProvider((CellLabelProvider)this.m_provider);
        col7.getColumn().addSelectionListener(this.m_sorter);
        TableViewerColumn col8 = new TableViewerColumn(this.m_tableViewer, 16384);
        col8.getColumn().setText("Start Time");
        col8.getColumn().setWidth(m_columnWidth.get("Start Time").intValue());
        col8.setLabelProvider((CellLabelProvider)this.m_provider);
        col8.getColumn().addSelectionListener(this.m_sorter);
        TableViewerColumn col9 = new TableViewerColumn(this.m_tableViewer, 16384);
        col9.getColumn().setText("Interval");
        col9.getColumn().setWidth(m_columnWidth.get("Interval").intValue());
        col9.setLabelProvider((CellLabelProvider)this.m_provider);
        col9.getColumn().addSelectionListener(this.m_sorter);
        TableViewerColumn col10 = new TableViewerColumn(this.m_tableViewer, 16384);
        col10.getColumn().setText("Expected End");
        col10.getColumn().setWidth(m_columnWidth.get("Expected End").intValue());
        col10.setLabelProvider((CellLabelProvider)this.m_provider);
        col10.getColumn().addSelectionListener(this.m_sorter);
        TableViewerColumn col11 = new TableViewerColumn(this.m_tableViewer, 16384);
        col11.getColumn().setText("End Time");
        col11.getColumn().setWidth(m_columnWidth.get("End Time").intValue());
        col11.setLabelProvider((CellLabelProvider)this.m_provider);
        col11.getColumn().addSelectionListener(this.m_sorter);
        TableViewerColumn col12 = new TableViewerColumn(this.m_tableViewer, 16384);
        col12.getColumn().setText("Filters");
        col12.getColumn().setWidth(m_columnWidth.get("Filters").intValue());
        col12.setLabelProvider((CellLabelProvider)this.m_provider);
        col12.getColumn().addSelectionListener(this.m_sorter);
        m_colIndices = new HashMap();
        m_colNames = new HashMap();
        TableColumn[] cols = this.m_table.getColumns();
        int i = 0;
        while (i < cols.length) {
            TableColumn col = cols[i];
            m_colIndices.put(col.getText(), i);
            m_colNames.put(i, col.getText());
            ++i;
        }
        int[] nArray = new int[13];
        nArray[1] = 1;
        nArray[2] = 2;
        nArray[3] = 5;
        nArray[4] = 3;
        nArray[5] = 4;
        nArray[6] = 6;
        nArray[7] = 7;
        nArray[8] = 8;
        nArray[9] = 9;
        nArray[10] = 10;
        nArray[11] = 11;
        nArray[12] = 12;
        this.m_tableViewer.getTable().setColumnOrder(nArray);
        this.m_tableViewer.setContentProvider((IContentProvider)this.m_provider);
        this.m_tableViewer.setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                int result;
                block7: {
                    result = 0;
                    if (e1 != null && e2 != null) break block7;
                    return 0;
                }
                try {
                    TableColumn sortColumn = AgentAdhocMaintenanceOverviewTab.this.m_table.getSortColumn();
                    AgentOutagePolicy ap1 = (AgentOutagePolicy)e1;
                    AgentOutagePolicy ap2 = (AgentOutagePolicy)e2;
                    if (sortColumn == null) {
                        String str1 = "" + ap1.getTimeInterval().getFirstStart();
                        String str2 = "" + ap2.getTimeInterval().getFirstStart();
                        result = str1.compareTo(str2) * -1;
                    } else {
                        int pos = 0;
                        TableColumn[] tableColumnArray = AgentAdhocMaintenanceOverviewTab.this.m_table.getColumns();
                        int n = tableColumnArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            TableColumn tc = tableColumnArray[n2];
                            if (tc.equals(sortColumn)) break;
                            ++pos;
                            ++n2;
                        }
                        String str1 = AgentAdhocMaintenanceOverviewTab.this.m_provider.getText(pos, ap1) + ap1.getTimeInterval().getFirstStart();
                        String str2 = AgentAdhocMaintenanceOverviewTab.this.m_provider.getText(pos, ap2) + ap2.getTimeInterval().getFirstStart();
                        result = str1.compareTo(str2);
                        if (AgentAdhocMaintenanceOverviewTab.this.m_table.getSortDirection() == 1024) {
                            result *= -1;
                        }
                    }
                    return result;
                }
                catch (Throwable e) {
                    e.printStackTrace();
                    return 0;
                }
            }
        });
        this.m_tableViewer.setComparer((IElementComparer)this.m_provider);
        this.m_tableViewer.setInput((Object)this.m_provider.getElements(null));
        this.m_table.setToolTipText("");
        this.m_provider.reloadData();
        this.m_tableViewer.addDoubleClickListener((IDoubleClickListener)this);
        this.createPolicyTable_CM();
    }

    public void createPolicyTable_CM() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(false);
        Menu menu = menuMgr.createContextMenu(this.m_tableViewer.getControl());
        this.m_tableViewer.getControl().setMenu(menu);
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                try {
                    IStructuredSelection ssel = (IStructuredSelection)AgentAdhocMaintenanceOverviewTab.this.m_tableViewer.getSelection();
                    manager.add((IAction)new RefreshTableAction(AgentAdhocMaintenanceOverviewTab.this.m_provider));
                    manager.add((IContributionItem)new Separator());
                    manager.add((IAction)new DisableSPAction(AgentAdhocMaintenanceOverviewTab.this.m_tableViewer, AgentAdhocMaintenanceOverviewTab.this.m_provider, 0));
                    manager.add((IAction)new DisableSPAction(AgentAdhocMaintenanceOverviewTab.this.m_tableViewer, AgentAdhocMaintenanceOverviewTab.this.m_provider, 5));
                    manager.add((IAction)new DisableSPAction(AgentAdhocMaintenanceOverviewTab.this.m_tableViewer, AgentAdhocMaintenanceOverviewTab.this.m_provider, 1));
                    manager.add((IAction)new DeleteSPAction(AgentAdhocMaintenanceOverviewTab.this.m_tableViewer));
                    manager.add((IContributionItem)new Separator());
                    manager.add((IAction)new ShowIndicationAction(ssel));
                }
                catch (RuntimeException e) {
                    RTLogger.print(5, "Error creating context menu", e);
                }
            }
        });
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
        String name = "";
        if (!(e.getSource() instanceof Table) && e.getSource() instanceof Button) {
            Button b = (Button)e.getSource();
            name = (String)b.getData();
            if (name.equals(REFRESH_BTN)) {
                this.m_provider.reloadData();
            } else if (name.equals(SHOWALL)) {
                LinkedList<ViewerFilter> toAdd = new LinkedList<ViewerFilter>();
                ViewerFilter[] viewerFilterArray = this.m_tableViewer.getFilters();
                int n = viewerFilterArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ViewerFilter vf = viewerFilterArray[n2];
                    if (!(vf instanceof StatusViewFilter)) {
                        toAdd.add(vf);
                    }
                    ++n2;
                }
                this.m_tableViewer.setFilters(toAdd.toArray(new ViewerFilter[0]));
            } else if (name.equals(SHOWENABLED)) {
                LinkedList<ViewerFilter> toAdd = new LinkedList<ViewerFilter>();
                ViewerFilter[] viewerFilterArray = this.m_tableViewer.getFilters();
                int n = viewerFilterArray.length;
                int n3 = 0;
                while (n3 < n) {
                    ViewerFilter vf = viewerFilterArray[n3];
                    if (!(vf instanceof StatusViewFilter)) {
                        toAdd.add(vf);
                    }
                    ++n3;
                }
                StatusViewFilter svf = new StatusViewFilter(this.m_provider, true);
                toAdd.add(svf);
                this.m_tableViewer.setFilters(toAdd.toArray(new ViewerFilter[0]));
            } else if (name.equals(SHOWDISABLED)) {
                LinkedList<ViewerFilter> toAdd = new LinkedList<ViewerFilter>();
                ViewerFilter[] viewerFilterArray = this.m_tableViewer.getFilters();
                int n = viewerFilterArray.length;
                int n4 = 0;
                while (n4 < n) {
                    ViewerFilter vf = viewerFilterArray[n4];
                    if (!(vf instanceof StatusViewFilter)) {
                        toAdd.add(vf);
                    }
                    ++n4;
                }
                StatusViewFilter svf = new StatusViewFilter(this.m_provider, false);
                toAdd.add(svf);
                this.m_tableViewer.setFilters(toAdd.toArray(new ViewerFilter[0]));
            }
        }
    }

    public void doubleClick(DoubleClickEvent event) {
        IStructuredSelection ssel = (IStructuredSelection)this.m_tableViewer.getSelection();
        if (!ssel.isEmpty()) {
            ssel.size();
        }
    }

    public void dispose() {
        Repository.getInstance().getCmdRouter().removeCmdListener("GET_SERVER_POLICIES_STATUS_AOP", this);
        super.dispose();
    }

    public TableViewer getTableViewer() {
        return this.m_tableViewer;
    }

    private class DeleteSPAction
    extends Action {
        private List<String> m_spIDs;
        private List<String> m_agentIDs;

        public DeleteSPAction(TableViewer tv) {
            super("deleteSP");
            this.m_spIDs = new LinkedList<String>();
            this.m_agentIDs = new LinkedList<String>();
            this.setId("deleteSP");
            this.setText("Delete");
            ISharedImages sharedImages = Activator.getDefault().getWorkbench().getActiveWorkbenchWindow().getWorkbench().getSharedImages();
            this.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_DELETE"));
            this.setDisabledImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_DELETE_DISABLED"));
            if (tv == null) {
                this.setEnabled(false);
                return;
            }
            IStructuredSelection ssel = (IStructuredSelection)tv.getSelection();
            if (ssel != null && !ssel.isEmpty()) {
                for (AgentOutagePolicy object : ssel) {
                    if (!Repository.getInstance().isPermittedAgentModify(object.getAgentID())) continue;
                    this.m_spIDs.add(object.getID());
                    this.m_agentIDs.add(object.getAgentID());
                }
            }
            if (this.m_spIDs == null || this.m_spIDs.isEmpty()) {
                this.setEnabled(false);
            }
        }

        public void run() {
            if (!this.isEnabled()) {
                return;
            }
            AgentAdhocMaintenanceOverviewTab.this.m_provider.deletePolicy(this.m_spIDs);
        }
    }

    private class DisableSPAction
    extends Action {
        private int m_overridePostAction;
        private AgentAdHocMaintenanceTableProvider m_tableProvider;
        private List<String> m_spIDs;

        public DisableSPAction(TableViewer tv, AgentAdHocMaintenanceTableProvider provider, int overridePostAction) {
            super("disableSP" + overridePostAction);
            this.m_overridePostAction = 0;
            this.m_tableProvider = null;
            this.m_spIDs = new LinkedList<String>();
            this.m_tableProvider = provider;
            this.m_overridePostAction = overridePostAction;
            this.setId("disableSP" + overridePostAction);
            switch (this.m_overridePostAction) {
                case 1: {
                    this.setText("Disable + Drop Indications");
                    break;
                }
                case 5: {
                    this.setText("Disable + Publish Indications");
                    break;
                }
                default: {
                    this.setText("Disable");
                }
            }
            if (this.m_tableProvider == null || tv == null) {
                this.setEnabled(false);
                return;
            }
            IStructuredSelection ssel = (IStructuredSelection)tv.getSelection();
            if (ssel != null && !ssel.isEmpty()) {
                for (AgentOutagePolicy object : ssel) {
                    ServerPolicyStatus status = AgentAdhocMaintenanceOverviewTab.this.m_provider.getServerPolicyStatus(object.getID());
                    if (status == null || !status.m_enabled || !Repository.getInstance().isPermittedAgentModify(object.getAgentID())) continue;
                    this.m_spIDs.add(object.getID());
                }
            }
            if (this.m_spIDs.size() == 0) {
                this.setEnabled(false);
            }
        }

        public void run() {
            if (!this.isEnabled()) {
                return;
            }
            this.m_tableProvider.disablePolicies(this.m_spIDs, this.m_overridePostAction);
        }
    }

    private class RefreshTableAction
    extends Action {
        private AgentAdHocMaintenanceTableProvider m_prov;

        public RefreshTableAction(AgentAdHocMaintenanceTableProvider provider) {
            super("refreshtableSP");
            this.m_prov = null;
            this.setId("refreshtableSP");
            this.setText("Refresh");
            this.setImageDescriptor(BMUI.IMAGE_DESCR_REFRESH);
            this.m_prov = provider;
            if (this.m_prov == null) {
                this.setEnabled(false);
                return;
            }
        }

        public void run() {
            if (!this.isEnabled()) {
                return;
            }
            this.m_prov.reloadData();
        }
    }

    private class ShowIndicationAction
    extends Action {
        private List<String> m_spIDs;

        public ShowIndicationAction(IStructuredSelection ssel) {
            super("showindication");
            this.m_spIDs = null;
            this.setId("showindication");
            this.setText("Show Indications");
            this.setImageDescriptor(BMUI.IMAGE_DESC_INDICATIONS);
            if (ssel == null || ssel.isEmpty()) {
                this.setEnabled(false);
                return;
            }
            this.m_spIDs = new LinkedList<String>();
            for (ServerPolicyTemplate object : ssel) {
                this.m_spIDs.add(object.getID());
            }
            if (this.m_spIDs.size() == 0) {
                this.setEnabled(false);
                return;
            }
        }

        public void run() {
            if (!this.isEnabled()) {
                return;
            }
            int i = 0;
            while (i < this.m_spIDs.size()) {
                String id = this.m_spIDs.get(i);
                MaintenanceView.showMaintenanceTab(id, "AdHoc " + id, "AdHoc " + id);
                ++i;
            }
        }
    }
}

