/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.views.outages;

import com.blixx.boom.engine.BMUI;
import com.blixx.boom.engine.Repository;
import com.blixx.boom.engine.UIJob;
import com.blixx.boom.engine.UIJobManager;
import com.blixx.boom.gui.dialogs.ShowMessageBox;
import com.blixx.boom.gui.views.outages.AbstractMaintenanceOverviewTab;
import com.blixx.boom.gui.views.outages.IServerPolicyStatusProvider;
import com.blixx.boom.gui.views.outages.OutagePoliciesManager;
import com.blixx.ctrl.sc.ICmdPostProcess;
import com.blixx.ctrl.sc.ServerClient;
import com.blixx.ctrl.sc.in.ScDeleteServerPolicy;
import com.blixx.ctrl.sc.in.ScEnableServerPolicy;
import com.blixx.ctrl.sc.in.ScGetServerPolicies;
import com.blixx.ctrl.sc.in.ScSetServerPoliciesOrder;
import com.blixx.ctrl.sc.in.ScSetServerPoliciesOrderSlave;
import com.blixx.shared.Interval;
import com.blixx.shared.ext.OutagePolicy;
import com.blixx.shared.ext.ServerPolicyStatus;
import com.blixx.shared.ext.ServerPolicyTemplate;
import com.blixx.shared.ext.TimeMask;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.IElementComparer;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.graphics.Image;

public class AgentMaintenanceTableProvider
extends CellLabelProvider
implements IElementComparer,
IStructuredContentProvider,
ICmdPostProcess,
IServerPolicyStatusProvider {
    public static final String COL_POLICY_ID = "ID";
    public static final String COL_POLICY_NAME = "Name";
    public static final String COL_ENABLED = "Enabled";
    public static final String COL_ENABLEDBY = "Enabled by";
    public static final String COL_DISABLEDBY = "Disabled by";
    public static final String COL_ACTIVE = "Active";
    public static final String COL_ACTION = "Action";
    public static final String COL_POSTACTION = "PostAction";
    public static final String COL_FILTERS = "Filters";
    public static final String COL_START = "Start Time";
    public static final String COL_IS_ENABLE_TIME = "Enabled Time";
    public static final String COL_INTERVAL = "Interval";
    public static final String COL_EXPEXTED_END = "Expected End";
    public static final String COL_IS_END_TIME = "End Time";
    public static final String COL_SCHEDULE = "Schedule";
    public static final String COL_DESCRIPTION = "Description";
    public static final int COL_POLICY_ID_INT = 0;
    public static final int COL_POLICY_NAME_INT = 1;
    public static final int COL_ENABLED_INT = 2;
    public static final int COL_ENABLEDBY_INT = 3;
    public static final int COL_DISABLEDBY_INT = 4;
    public static final int COL_ACTIVE_INT = 5;
    public static final int COL_ACTION_INT = 6;
    public static final int COL_POSTACTION_INT = 7;
    public static final int COL_START_INT = 8;
    public static final int COL_INTERVAL_INT = 9;
    public static final int COL_EXPEXTED_END_INT = 10;
    public static final int COL_IS_END_TIME_INT = 11;
    public static final int COL_SCHEDULE_INT = 12;
    public static final int COL_DESCRIPTION_INT = 13;
    public static final int COL_FILTERS_INT = 14;
    public static final int COL_IS_ENABLE_TIME_INT = 15;
    List<String> m_newOrder = new ArrayList<String>();
    AbstractMaintenanceOverviewTab m_ctab = null;
    TableViewer m_table = null;
    String m_server = "";

    public AgentMaintenanceTableProvider(TableViewer table, AbstractMaintenanceOverviewTab ctab) {
        this.m_table = table;
        this.m_ctab = ctab;
    }

    public AgentMaintenanceTableProvider(TableViewer table, AbstractMaintenanceOverviewTab ctab, String slaveServer) {
        this(table, ctab);
        this.m_server = slaveServer;
    }

    public boolean equals(Object a, Object b) {
        return a == null ? b == null : a.equals(b);
    }

    public int hashCode(Object element) {
        return element.hashCode();
    }

    public Object[] getElements(Object inputElement) {
        if (this.m_newOrder.size() > 0) {
            LinkedList<OutagePolicy> list = new LinkedList<OutagePolicy>();
            int i = 0;
            while (i < this.m_newOrder.size()) {
                list.add(this.getOutagePolicy(this.m_newOrder.get(i)));
                ++i;
            }
            if (this.checkAndMergeServerUpdate(list)) {
                list = new LinkedList();
                i = 0;
                while (i < this.m_newOrder.size()) {
                    list.add(this.getOutagePolicy(this.m_newOrder.get(i)));
                    ++i;
                }
            }
            return list.toArray();
        }
        return OutagePoliciesManager.getInstance().getServerPolicies(this.m_server).toArray();
    }

    private boolean checkAndMergeServerUpdate(List<OutagePolicy> list) {
        boolean isNewOrderListChanged = false;
        List<OutagePolicy> m_serverPolicies = OutagePoliciesManager.getInstance().getServerPolicies(this.m_server);
        if (!list.containsAll(m_serverPolicies) || !m_serverPolicies.containsAll(list)) {
            isNewOrderListChanged = true;
            LinkedList<String> actualIDs = new LinkedList<String>();
            for (OutagePolicy op : m_serverPolicies) {
                actualIDs.add(op.getID());
            }
            this.m_newOrder.retainAll(actualIDs);
            int i = 0;
            while (i < m_serverPolicies.size()) {
                OutagePolicy op = m_serverPolicies.get(i);
                if (!this.m_newOrder.contains(op.getID())) {
                    if (i < this.m_newOrder.size()) {
                        this.m_newOrder.add(i, op.getID());
                    } else {
                        this.m_newOrder.add(op.getID());
                    }
                }
                ++i;
            }
        }
        return isNewOrderListChanged;
    }

    public OutagePolicy getOutagePolicy(String id) {
        if (id != null) {
            for (OutagePolicy op : OutagePoliciesManager.getInstance().getServerPolicies(this.m_server)) {
                if (!op.getID().equals(id)) continue;
                return op;
            }
        }
        return null;
    }

    @Override
    public ServerPolicyStatus getServerPolicyStatus(String id) {
        return OutagePoliciesManager.getInstance().getServerPolicyStatus(this.m_server, id);
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public void update(ViewerCell cell) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        OutagePolicy sp = (OutagePolicy)cell.getElement();
        String label = "";
        Image image = null;
        ServerPolicyStatus sps = this.getServerPolicyStatus(sp.getID());
        if (sps != null && sps.m_access < ServerPolicyStatus.ACCESS_EDIT_DELETE) {
            cell.setForeground(BMUI.color_darkGrey2);
        }
        int colindex = cell.getColumnIndex();
        switch (colindex) {
            case 0: {
                label = sp.getID();
                break;
            }
            case 1: {
                label = sp.getName();
                break;
            }
            case 2: {
                boolean enabled = sps.m_enabled;
                label = null;
                image = enabled ? BMUI.IMAGE_ACCEPT_GREEN : BMUI.IMAGE_CANCEL_ROUND;
                break;
            }
            case 5: {
                boolean active = sps.m_active;
                label = null;
                image = active ? BMUI.IMAGE_ACCEPT_GREEN : BMUI.IMAGE_CANCEL_ROUND;
                break;
            }
            case 3: {
                label = sps.m_enabledBy;
                break;
            }
            case 4: {
                label = sps.m_disabledBy;
                break;
            }
            case 6: {
                label = ServerPolicyTemplate.getActionLabel(sp.getAction());
                break;
            }
            case 7: {
                label = ServerPolicyTemplate.getActionLabel(sp.getPostAction());
                break;
            }
            case 8: {
                if (sp.getTimeInterval().getFirstStart() > 0L) {
                    label = sdf.format(new Date(sp.getTimeInterval().getFirstStart()));
                    break;
                }
                label = "-";
                break;
            }
            case 9: {
                if (sp.getTimeInterval().getInterval() > 0L && sp.getTimeInterval().getInterval() < Long.MAX_VALUE) {
                    Interval ivl = Interval.getSimpleInterval((int)(sp.getTimeInterval().getInterval() / 1000L));
                    label = ivl.toString();
                    break;
                }
                if (sp.getTimeInterval().getInterval() == Long.MAX_VALUE) {
                    label = "\u221e";
                    break;
                }
                label = "-";
                break;
            }
            case 10: {
                if (sp.getTimeInterval().getInterval() != Long.MAX_VALUE && sp.getTimeInterval().getTimeMask() == null) {
                    long end = sp.getTimeInterval().getFirstStart() + sp.getTimeInterval().getInterval();
                    label = sdf.format(new Date(end));
                    break;
                }
                if (sp.getTimeInterval().getTimeMask() != null) break;
                label = "-";
                break;
            }
            case 11: {
                if (sp.getIsEndTime() > 0L) {
                    label = sdf.format(new Date(sp.getIsEndTime()));
                    break;
                }
                label = "-";
                break;
            }
            case 15: {
                if (sp.getIsEnableTime() > 0L) {
                    label = sdf.format(new Date(sp.getIsEnableTime()));
                    break;
                }
                label = "-";
                break;
            }
            case 12: {
                TimeMask timeMask = sp.getTimeInterval().getTimeMask();
                if (timeMask != null) {
                    label = timeMask.getMask();
                    break;
                }
                label = "-";
                break;
            }
            case 13: {
                label = sp.getDescription();
                break;
            }
            case 14: {
                label = sp.getFilters().toString();
                break;
            }
        }
        cell.setText(label);
        cell.setImage(image);
    }

    public void reloadData() {
        ScGetServerPolicies sc = new ScGetServerPolicies(Repository.getInstance());
        sc.addCmdPostProcess(this);
        OutagePoliciesManager.getInstance().reloadData(sc);
    }

    public void postProcess(ServerClient client) {
        if (client instanceof ScGetServerPolicies) {
            ScGetServerPolicies sc = (ScGetServerPolicies)client;
            if (sc.isSuccess()) {
                UIJob uj = new UIJob("SePolRefresh"){

                    @Override
                    public IStatus runInUIThread(IProgressMonitor monitor) {
                        AgentMaintenanceTableProvider.this.m_table.setInput((Object)AgentMaintenanceTableProvider.this.getElements(null));
                        return null;
                    }
                };
                UIJobManager.getInstance().schedule(uj);
            }
        } else if (client instanceof ScSetServerPoliciesOrder) {
            ScSetServerPoliciesOrder sc = (ScSetServerPoliciesOrder)client;
            if (sc.isSuccess()) {
                this.m_newOrder.clear();
                UIJob uj = new UIJob("Bchk"){

                    @Override
                    public IStatus runInUIThread(IProgressMonitor monitor) {
                        AgentMaintenanceTableProvider.this.m_ctab.checkButtons();
                        return Status.OK_STATUS;
                    }
                };
                UIJobManager.getInstance().schedule(uj);
            } else {
                new ShowMessageBox("Error", client.getLastException().getMessage(), 1);
            }
        } else if (client instanceof ScSetServerPoliciesOrderSlave) {
            ScSetServerPoliciesOrderSlave sc = (ScSetServerPoliciesOrderSlave)client;
            if (sc.isSuccess()) {
                this.m_newOrder.clear();
                UIJob uj = new UIJob("Bchk"){

                    @Override
                    public IStatus runInUIThread(IProgressMonitor monitor) {
                        AgentMaintenanceTableProvider.this.m_ctab.checkButtons();
                        return Status.OK_STATUS;
                    }
                };
                UIJobManager.getInstance().schedule(uj);
            } else {
                new ShowMessageBox("Error", client.getLastException().getMessage(), 1);
            }
        } else {
            this.reloadData();
            if (!client.isSuccess()) {
                new ShowMessageBox("Error", client.getLastException().getMessage(), 1);
            }
        }
    }

    public void enablePolicies(List<String> ids) {
        ScEnableServerPolicy sc = new ScEnableServerPolicy(Repository.getInstance(), ids, true, "");
        sc.addCmdPostProcess(this);
        sc.start();
    }

    public void disablePolicies(List<String> ids, int overridePostAction) {
        ScEnableServerPolicy sc = new ScEnableServerPolicy(Repository.getInstance(), ids, false, "", overridePostAction);
        sc.addCmdPostProcess(this);
        sc.start();
    }

    public void deletePolicy(List<String> ids) {
        ScDeleteServerPolicy sc = new ScDeleteServerPolicy(Repository.getInstance(), ids, null);
        sc.addCmdPostProcess(this);
        sc.start();
    }

    public void saveOrder(List<String> ids) {
        if (this.m_server == null || this.m_server.length() == 0) {
            ScSetServerPoliciesOrder sc = new ScSetServerPoliciesOrder(Repository.getInstance(), ids);
            sc.addCmdPostProcess(this);
            sc.start();
        } else {
            ScSetServerPoliciesOrderSlave sc = new ScSetServerPoliciesOrderSlave(Repository.getInstance(), ids, this.m_server);
            sc.addCmdPostProcess(this);
            sc.start();
        }
    }

    public void order(String id, int step) {
        int n;
        if (this.m_newOrder.size() == 0) {
            for (ServerPolicyTemplate serverPolicyTemplate : OutagePoliciesManager.getInstance().getServerPolicies(this.m_server)) {
                this.m_newOrder.add(serverPolicyTemplate.getID());
            }
        }
        if ((n = this.m_newOrder.indexOf(id)) >= 0) {
            String IDbkp = this.m_newOrder.remove(n);
            try {
                if (step == Integer.MAX_VALUE) {
                    this.m_newOrder.add(id);
                } else if (step == Integer.MIN_VALUE) {
                    if (this.m_newOrder.size() == 0) {
                        this.m_newOrder.add(id);
                    } else {
                        this.m_newOrder.add(0, id);
                    }
                } else {
                    this.m_newOrder.add(n + step, id);
                }
            }
            catch (Throwable throwable) {
                this.m_newOrder.add(n, IDbkp);
            }
            this.m_table.setInput((Object)this.getElements(null));
        }
    }

    public boolean isNewOrderSaved() {
        return this.m_newOrder.size() == 0;
    }

    public void saveOrder() {
        this.saveOrder(this.m_newOrder);
    }

    public int getOutagePoliciesCount() {
        return OutagePoliciesManager.getInstance().getServerPolicies(this.m_server).size();
    }
}

