/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.views.outages;

import com.blixx.boom.engine.AgentCard;
import com.blixx.boom.engine.BMUI;
import com.blixx.boom.engine.Repository;
import com.blixx.boom.gui.policies.FFilterManager;
import com.blixx.boom.gui.policies.ViewContentProvider;
import com.blixx.boom.gui.utils.GUIDisplayElements;
import com.blixx.boom.gui.utils.PatternValidator;
import com.blixx.boom.gui.utils.STreeViewer;
import com.blixx.boom.gui.views.AgentOverviewTableProvider;
import com.blixx.boom.gui.views.actions.SelectNodeGroupsAction;
import com.blixx.boom.gui.views.outages.StyledTreeLabelProvider_S;
import com.blixx.shared.ext.ForwardFilter;
import com.blixx.shared.utils.GroupTreeObject;
import com.blixx.shared.utils.TreeObject;
import java.util.Properties;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;

public class MaintenanceFilterDialog
extends StatusDialog
implements ModifyListener,
SelectionListener,
DisposeListener {
    public static final String SELECT_AGENT_IDS = "SELECT_AGENT_IDS";
    protected Shell m_parentShell = null;
    protected ForwardFilter m_fFilter = null;
    protected GUIDisplayElements m_gui;
    protected Composite m_comp = null;
    protected Text m_name_field = null;
    protected CCombo m_attribute_combo = null;
    protected Label m_label = null;
    protected StyledText m_pattern_field = null;
    protected Button m_selectNodeGroup_btn = null;
    protected Composite m_agentsOrNodegroups = null;
    public String m_name = null;
    public String m_attribute = null;
    public String m_description = null;
    public String m_pattern = ".*";
    public String m_pattern_bkp = ".*";
    protected static String FFILTER_NAME = "FFILTER_NAME";
    protected static String ATTRIBUTES = "ATTRIBUTES";
    protected static String SELECT_NODE_GROUPS = "SELECT_NODE_GROUPS";
    protected static String PATTERN = "PATTERN";
    protected static String SOMPLIFIED_PATTERN = "Simplified Pattern: ";
    protected static String GROUP_PATHS = "Group Paths: ";
    protected static String AGENT_IDS = "Agent IDs: ";
    protected String m_type = PatternValidator.SIMPLIFIED;
    protected PatternValidator m_patternValidator = null;
    protected boolean m_isPatternValid = true;

    public MaintenanceFilterDialog(Shell parentShell, ForwardFilter ff) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.setTitle(" Filter");
        this.m_parentShell = parentShell;
        this.m_fFilter = ff;
        this.m_patternValidator = new PatternValidator();
    }

    protected Control createDialogArea(Composite parent) {
        this.setImage(BMUI.IMAGE_FILTERED);
        this.m_gui = new GUIDisplayElements();
        this.m_comp = new Composite(parent, 0);
        GridLayout gl = new GridLayout(3, false);
        gl.marginHeight = 0;
        gl.marginTop = 15;
        gl.marginWidth = 15;
        this.m_comp.setLayout((Layout)gl);
        this.m_comp.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.m_comp.addDisposeListener((DisposeListener)this);
        this.m_name_field = this.m_gui.addInputFieldSingle(this.m_comp, FFILTER_NAME, "Name: ", "", 2, 1, 1, 1, 450, this);
        ((GridData)this.m_name_field.getLayoutData()).horizontalAlignment = 4;
        this.m_attribute_combo = this.m_gui.addDropDown(this.m_comp, ATTRIBUTES, "Attribute: ", this.getAllowedTypes(), this.getAllowedTypes()[0], null, 1, 1, 1, 1, this);
        ((GridData)this.m_attribute_combo.getLayoutData()).horizontalAlignment = 1;
        this.m_selectNodeGroup_btn = this.m_gui.addButton(this.m_comp, SELECT_NODE_GROUPS, "Select", false, this);
        this.m_selectNodeGroup_btn.setVisible(false);
        this.m_label = new Label(this.m_comp, 0);
        this.m_label.setText(SOMPLIFIED_PATTERN);
        this.m_pattern_field = new StyledText(this.m_comp, 2052);
        this.m_pattern_field.setData((Object)PATTERN);
        this.m_pattern_field.setEditable(true);
        GridData gd = new GridData(4, 128, true, false, 2, 1);
        gd.widthHint = 450;
        this.m_pattern_field.setLayoutData((Object)gd);
        this.m_pattern_field.addModifyListener((ModifyListener)this);
        if (this.m_fFilter == null) {
            this.m_name_field.setBackground(BMUI.color_critical);
            this.m_pattern_field.setText("<*>");
            this.m_pattern_field.setBackground(BMUI.color_light_green);
        } else {
            Properties p = this.m_fFilter.getProperties();
            this.m_name_field.setText(p.getProperty("NAME"));
            String pattern = p.getProperty("PATTERN");
            if (pattern.toLowerCase().startsWith("java=")) {
                pattern = p.getProperty("PATTERN").substring(5);
            }
            int pos = 0;
            String ATTRIBUTE = p.getProperty("ATTRIBUTE");
            int i = 0;
            while (i < ForwardFilter.TYPES.length) {
                if (ATTRIBUTE.equalsIgnoreCase(ForwardFilter.TYPES[i])) {
                    pos = i;
                    break;
                }
                ++i;
            }
            this.m_attribute_combo.select(pos);
            if (this.m_attribute_combo.getText().equals("NODEGROUP")) {
                this.m_label.setText(GROUP_PATHS);
            } else if (this.m_attribute_combo.getText().equals("AGENTID")) {
                this.m_label.setText(AGENT_IDS);
            }
            this.m_pattern_field.setText(pattern);
        }
        return this.m_comp;
    }

    public String[] getAllowedTypes() {
        return ForwardFilter.TYPES;
    }

    public void create() {
        super.create();
        this.resetLayout();
    }

    public Composite createAgentsComposite() {
        try {
            if (this.m_agentsOrNodegroups != null) {
                this.disposeAgentOrNGComposite();
                this.resetLayout();
            }
            this.m_agentsOrNodegroups = new AgentTableComposite(this.m_comp, 0);
            GridData layoutData = new GridData(4, 4, true, true);
            layoutData.horizontalSpan = 3;
            this.m_agentsOrNodegroups.setLayoutData((Object)layoutData);
        }
        catch (Throwable throwable) {}
        return this.m_agentsOrNodegroups;
    }

    public Composite createNodeGroupComposite() {
        try {
            if (this.m_agentsOrNodegroups != null) {
                this.disposeAgentOrNGComposite();
                this.resetLayout();
            }
            this.m_agentsOrNodegroups = new NodeGroupsComposite(this.m_comp, 0);
            GridData layoutData = new GridData(4, 4, true, true);
            layoutData.horizontalSpan = 3;
            this.m_agentsOrNodegroups.setLayoutData((Object)layoutData);
        }
        catch (Throwable throwable) {}
        return this.m_agentsOrNodegroups;
    }

    public void disposeAgentOrNGComposite() {
        try {
            if (this.m_agentsOrNodegroups != null && !this.m_agentsOrNodegroups.isDisposed()) {
                this.m_agentsOrNodegroups.dispose();
            }
        }
        catch (Throwable throwable) {}
    }

    private void resetLayout() {
        this.m_comp.computeSize(-1, -1, true);
        this.m_comp.layout(true);
        this.m_comp.pack();
        this.getShell().computeSize(-1, -1, true);
        this.getShell().layout(true);
        this.getShell().pack();
    }

    public void updateAgentsComposite() {
        ((AgentTableComposite)this.m_agentsOrNodegroups).m_tv.setInput((Object)this.m_pattern_field.getText());
    }

    public void updateNodeGroupComposite() {
        ((NodeGroupsComposite)this.m_agentsOrNodegroups).initSelectionNG();
    }

    public void validatePattern() {
        this.m_isPatternValid = this.m_patternValidator.validatePattern(this.m_type, this.m_pattern_field);
        if (this.m_isPatternValid) {
            this.m_pattern = this.m_patternValidator.getPatternStr();
        }
    }

    public void checkButtons() {
        if (this.m_name_field.getText().trim().length() <= 0 || this.m_pattern_field.getText().length() <= 0 || !this.m_isPatternValid) {
            this.m_gui.enableField(this.getButton(0), false);
        } else {
            this.m_gui.enableField(this.getButton(0), true);
        }
    }

    protected void okPressed() {
        this.m_name = this.m_name_field.getText().trim();
        this.m_attribute = this.m_attribute_combo.getText();
        this.m_pattern = this.m_pattern_field.getText().trim();
        if ((this.m_attribute.equals("NODEGROUP") || this.m_attribute.equals("AGENTID")) && this.m_pattern.toLowerCase().startsWith("java=")) {
            this.m_pattern = this.m_pattern.substring(5);
        }
        super.okPressed();
    }

    protected Button getButton(int id) {
        return super.getButton(id);
    }

    public void modifyText(ModifyEvent e) {
        StyledText field;
        String fieldName = null;
        Object obj = e.getSource();
        if (obj instanceof Text) {
            Text field2 = (Text)obj;
            fieldName = (String)field2.getData();
            if (fieldName.equals(FFILTER_NAME)) {
                boolean isValid = true;
                String value = field2.getText().trim();
                if ("".equals(value)) {
                    isValid = false;
                } else if (this.m_fFilter != null) {
                    String currName = this.m_fFilter.getName();
                    if (!value.equals(currName) && FFilterManager.getInstance().getFilter(value) != null) {
                        isValid = false;
                    }
                } else if (FFilterManager.getInstance().getFilter(value) != null) {
                    isValid = false;
                }
                if (isValid) {
                    field2.setBackground(BMUI.color_white);
                } else {
                    field2.setBackground(BMUI.color_critical);
                }
            }
        } else if (obj instanceof StyledText && (fieldName = (String)(field = (StyledText)obj).getData()).equals(PATTERN)) {
            try {
                if (this.m_fFilter != null) {
                    Properties p = this.m_fFilter.getProperties();
                    String attribute = p.getProperty("ATTRIBUTE");
                    if (!attribute.equals("NODEGROUP") && !attribute.equals("AGENTID")) {
                        this.validatePattern();
                    } else if (attribute.equals("AGENTID")) {
                        this.updateAgentsComposite();
                    } else if (attribute.equals("NODEGROUP")) {
                        this.updateNodeGroupComposite();
                    }
                } else if (!this.m_attribute_combo.getText().equals("NODEGROUP") && !this.m_attribute_combo.getText().equals("AGENTID")) {
                    this.validatePattern();
                }
            }
            catch (Throwable throwable) {}
        }
        this.checkButtons();
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
        CCombo combo;
        String data;
        Object obj = e.getSource();
        if (obj instanceof Button) {
            Button b = (Button)obj;
            String name = (String)b.getData();
            if (name.equals(SELECT_NODE_GROUPS) || name.equals(SELECT_AGENT_IDS)) {
                try {
                    SelectNodeGroupsAction selectNodeGroupsAction = new SelectNodeGroupsAction(this.m_parentShell, this.m_pattern_field.getText().trim(), name.equals(SELECT_AGENT_IDS));
                    selectNodeGroupsAction.run();
                    String selectedNodeGroups = selectNodeGroupsAction.getSelectedNodeGroups();
                    if (selectedNodeGroups != null) {
                        this.m_pattern_field.removeModifyListener((ModifyListener)this);
                        this.m_pattern_field.setText(selectedNodeGroups);
                        if (name.equals(SELECT_AGENT_IDS)) {
                            this.updateAgentsComposite();
                        } else if (name.equals(SELECT_NODE_GROUPS)) {
                            this.updateNodeGroupComposite();
                        }
                        this.m_pattern_field.addModifyListener((ModifyListener)this);
                        if (selectedNodeGroups.length() > 0) {
                            this.m_pattern_field.setBackground(BMUI.defaultBackground);
                            this.m_isPatternValid = true;
                        } else {
                            this.m_pattern_field.setBackground(BMUI.color_critical);
                            this.m_isPatternValid = false;
                        }
                        this.checkButtons();
                    }
                }
                catch (Throwable e1) {
                    e1.printStackTrace();
                }
            }
        } else if (obj instanceof CCombo && (data = (String)(combo = (CCombo)obj).getData()).equals(ATTRIBUTES)) {
            String value = combo.getText();
            if (value.equals("NODEGROUP")) {
                this.m_gui.enableField(this.m_selectNodeGroup_btn, true);
                this.m_selectNodeGroup_btn.setVisible(true);
                this.m_selectNodeGroup_btn.setData((Object)SELECT_NODE_GROUPS);
                this.m_label.setText(GROUP_PATHS);
                this.m_gui.setEditable(this.m_pattern_field, false);
                this.m_pattern_field.setText("");
                this.createNodeGroupComposite();
                this.resetLayout();
            } else if (value.equals("AGENTID")) {
                this.m_gui.enableField(this.m_selectNodeGroup_btn, true);
                this.m_selectNodeGroup_btn.setVisible(true);
                this.m_selectNodeGroup_btn.setData((Object)SELECT_AGENT_IDS);
                this.m_label.setText(AGENT_IDS);
                this.m_gui.setEditable(this.m_pattern_field, false);
                this.m_pattern_field.setText("");
                this.createAgentsComposite();
                this.resetLayout();
            } else {
                this.disposeAgentOrNGComposite();
                this.m_gui.enableField(this.m_selectNodeGroup_btn, false);
                this.m_selectNodeGroup_btn.setVisible(false);
                this.m_label.setText(SOMPLIFIED_PATTERN);
                this.resetLayout();
                if (!this.m_pattern_field.getEditable()) {
                    this.m_gui.setEditable(this.m_pattern_field, true);
                    this.m_pattern_field.setText(this.m_pattern);
                    this.validatePattern();
                }
            }
        }
    }

    public void widgetDisposed(DisposeEvent e) {
        try {
            this.m_name_field.dispose();
        }
        catch (Throwable throwable) {}
        try {
            this.m_attribute_combo.dispose();
        }
        catch (Throwable throwable) {}
        try {
            this.m_label.dispose();
        }
        catch (Throwable throwable) {}
        try {
            this.m_pattern_field.dispose();
        }
        catch (Throwable throwable) {}
        try {
            this.m_comp.dispose();
        }
        catch (Throwable throwable) {}
    }

    public class AgentTableComposite
    extends Composite {
        public Table m_table;
        public TableViewer m_tv;

        public AgentTableComposite(Composite parent, int style) {
            super(parent, style);
            this.m_table = null;
            this.m_tv = null;
            GridLayout gl = new GridLayout(1, false);
            gl.verticalSpacing = 0;
            gl.horizontalSpacing = 0;
            gl.marginWidth = 0;
            gl.marginHeight = 0;
            this.setLayout((Layout)gl);
            this.createTable();
        }

        public void createTable() {
            this.m_table = new Table((Composite)this, 268503812);
            this.m_table.setHeaderVisible(true);
            this.m_table.setLinesVisible(true);
            GridLayout gl = new GridLayout();
            gl.verticalSpacing = 0;
            this.m_table.setLayout((Layout)gl);
            GridData layoutData = new GridData(4, 4, true, true, 1, 1);
            layoutData.minimumHeight = 50;
            layoutData.heightHint = 100;
            this.m_table.setLayoutData((Object)layoutData);
            this.m_tv = new TableViewer(this.m_table);
            LightAgentLabelProvider lp = new LightAgentLabelProvider();
            TableViewerColumn col0 = new TableViewerColumn(this.m_tv, 16384);
            col0.getColumn().setText("Status");
            col0.getColumn().setWidth(25);
            col0.setLabelProvider((CellLabelProvider)lp);
            TableViewerColumn col1 = new TableViewerColumn(this.m_tv, 16384);
            col1.getColumn().setText("Name");
            col1.getColumn().setWidth(200);
            col1.setLabelProvider((CellLabelProvider)lp);
            TableViewerColumn col2 = new TableViewerColumn(this.m_tv, 16384);
            col2.getColumn().setText("Id");
            col2.getColumn().setWidth(250);
            col2.setLabelProvider((CellLabelProvider)lp);
            this.m_tv.setContentProvider((IContentProvider)lp);
            this.m_tv.setInput((Object)MaintenanceFilterDialog.this.m_pattern_field.getText());
        }
    }

    public class LightAgentLabelProvider
    extends CellLabelProvider
    implements IStructuredContentProvider {
        public static final String COL_STATUS = "Status";
        public static final String COL_NAME = "Name";
        public static final String COL_ID = "Id";
        public String m_objectsSeparatedByPipe = "";

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            return MaintenanceFilterDialog.this.m_pattern_field.getText().split("\\|");
        }

        public void update(ViewerCell cell) {
            AgentCard ac;
            Object element = cell.getElement();
            String id = "";
            String label = "";
            Image status = null;
            if (element instanceof String) {
                id = (String)element;
                AgentCard ac2 = Repository.getInstance().getAgentCard(id);
                if (ac2 != null) {
                    label = ac2.getLabel();
                    status = AgentOverviewTableProvider.getStatusIcon(ac2.getIconnameForAgent());
                }
            } else if (element instanceof AgentCard && (ac = (AgentCard)element) != null) {
                label = ac.getLabel();
                status = AgentOverviewTableProvider.getStatusIcon(ac.getIconnameForAgent());
            }
            switch (cell.getColumnIndex()) {
                case 0: {
                    cell.setImage(status);
                    break;
                }
                case 1: {
                    cell.setText(label);
                    break;
                }
                case 2: {
                    cell.setText(id);
                    break;
                }
            }
        }
    }

    public class NodeGroupsComposite
    extends Composite {
        GroupTreeObject m_root;
        TreeViewer m_tv;

        public NodeGroupsComposite(Composite parent, int style) {
            super(parent, style);
            this.m_root = new GroupTreeObject(new TreeObject("root", BMUI.type_folder, null));
            this.m_tv = null;
            GridLayout gl = new GridLayout(1, false);
            gl.verticalSpacing = 0;
            gl.horizontalSpacing = 0;
            gl.marginWidth = 0;
            gl.marginHeight = 0;
            this.setLayout((Layout)gl);
            this.m_tv = new STreeViewer(this, 268438274);
            GridData gd = new GridData(4, 4, true, true);
            gd.heightHint = 150;
            this.m_tv.getTree().setLayoutData((Object)gd);
            this.m_tv.setContentProvider((IContentProvider)new ViewContentProvider());
            this.m_tv.setLabelProvider((IBaseLabelProvider)new StyledTreeLabelProvider_S());
            this.m_tv.setInput((Object)this.m_root);
            this.initSelectionNG();
        }

        public void initSelectionNG() {
            String[] pathes;
            this.m_root.clean();
            String[] stringArray = pathes = MaintenanceFilterDialog.this.m_pattern_field.getText().split("\\|");
            int n = pathes.length;
            int n2 = 0;
            while (n2 < n) {
                String path = stringArray[n2];
                GroupTreeObject gto = Repository.getInstance().getNodeGroupTree().getRoot().searchPath(path, BMUI.type_folder);
                if (gto != null) {
                    String gtoPath = gto.getPath();
                    gtoPath = gtoPath.replace("/root/_Groups", "/root");
                    GroupTreeObject leftObject = GroupTreeObject.createPath(gtoPath, this.m_root);
                    leftObject.getTreeObject().setObject("SELECTED");
                    for (GroupTreeObject gtoChild : gto.getElements()) {
                        if (!(gtoChild instanceof GroupTreeObject)) continue;
                        try {
                            GroupTreeObject leftGtoChild = gtoChild.clone();
                            leftObject.addElement(leftGtoChild);
                        }
                        catch (Throwable throwable) {}
                    }
                }
                ++n2;
            }
            this.m_tv.refresh();
            this.m_tv.expandAll();
        }
    }
}

