/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.views.outages;

import com.blixx.boom.gui.dialogs.ShowMessageBox;
import com.blixx.ctrl.sc.ICmdPostProcess;
import com.blixx.ctrl.sc.ServerClient;
import com.blixx.ctrl.sc.in.ScGetServerPolicies;
import com.blixx.shared.ext.OutagePolicy;
import com.blixx.shared.ext.ServerPolicyStatus;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class OutagePoliciesManager
implements ICmdPostProcess {
    public Map<String, List<OutagePolicy>> m_slaveOutagePolicies = new ConcurrentHashMap<String, List<OutagePolicy>>();
    public Map<String, Map<String, ServerPolicyStatus>> m_slaveOutagePoliciesStatuses = new ConcurrentHashMap<String, Map<String, ServerPolicyStatus>>();
    private ReentrantReadWriteLock m_lock = new ReentrantReadWriteLock();
    private static OutagePoliciesManager m_instance = null;

    public static synchronized OutagePoliciesManager getInstance() {
        if (m_instance == null) {
            m_instance = new OutagePoliciesManager();
        }
        return m_instance;
    }

    public void reloadData(ServerClient sc) {
        sc.addCmdPostProcess(this);
        sc.start();
    }

    public void postProcess(ServerClient client) {
        if (client instanceof ScGetServerPolicies) {
            ScGetServerPolicies sc = (ScGetServerPolicies)client;
            if (sc.isSuccess()) {
                try {
                    this.m_lock.writeLock().lock();
                    this.m_slaveOutagePolicies.clear();
                    this.m_slaveOutagePoliciesStatuses.clear();
                    List<OutagePolicy> listOP = sc.getServerPolicies();
                    Map<String, ServerPolicyStatus> listSP = sc.getStatuses();
                    for (OutagePolicy op : listOP) {
                        List<OutagePolicy> plist;
                        ServerPolicyStatus sps = listSP.get(op.getID());
                        if (sps == null) continue;
                        String slaveServer = sps.getOption("BOOMSERVER");
                        if (slaveServer == null) {
                            slaveServer = "";
                        }
                        if ((plist = this.m_slaveOutagePolicies.get(slaveServer)) == null) {
                            plist = new LinkedList<OutagePolicy>();
                            this.m_slaveOutagePolicies.put(slaveServer, plist);
                        }
                        plist.add(op);
                        Map<String, ServerPolicyStatus> s = this.m_slaveOutagePoliciesStatuses.get(slaveServer);
                        if (s == null) {
                            s = new LinkedHashMap<String, ServerPolicyStatus>();
                            this.m_slaveOutagePoliciesStatuses.put(slaveServer, s);
                        }
                        s.put(op.getID(), sps);
                    }
                }
                finally {
                    this.m_lock.writeLock().unlock();
                }
            } else {
                new ShowMessageBox("Error", client.getLastException().getMessage(), 1);
            }
        }
    }

    public List<OutagePolicy> getServerPolicies(String server) {
        List<OutagePolicy> list;
        block7: {
            if (server == null) {
                server = "";
            }
            list = null;
            try {
                this.m_lock.readLock().lock();
                list = this.m_slaveOutagePolicies.get(server);
                if (list != null) break block7;
                this.m_lock.readLock().unlock();
                this.m_lock.writeLock().lock();
                try {
                    list = new LinkedList<OutagePolicy>();
                    this.m_slaveOutagePolicies.put(server, list);
                }
                finally {
                    this.m_lock.writeLock().unlock();
                    this.m_lock.readLock().lock();
                }
            }
            finally {
                this.m_lock.readLock().unlock();
            }
        }
        return list;
    }

    public ServerPolicyStatus getServerPolicyStatus(String server, String id) {
        ServerPolicyStatus sps = null;
        try {
            this.m_lock.readLock().lock();
            Map<String, ServerPolicyStatus> map = this.m_slaveOutagePoliciesStatuses.get(server);
            if (map != null) {
                sps = map.get(id);
            }
        }
        finally {
            this.m_lock.readLock().unlock();
        }
        return sps;
    }

    public ServerPolicyStatus getServerPolicyStatus(String id) {
        ServerPolicyStatus sps = null;
        try {
            this.m_lock.readLock().lock();
            for (Map<String, ServerPolicyStatus> map : this.m_slaveOutagePoliciesStatuses.values()) {
                if (map == null || (sps = map.get(id)) == null) continue;
                break;
            }
        }
        finally {
            this.m_lock.readLock().unlock();
        }
        return sps;
    }
}

