/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.views.outages;

import com.blixx.boom.engine.BMUI;
import com.blixx.boom.engine.Repository;
import com.blixx.boom.engine.UIJob;
import com.blixx.boom.engine.UIJobManager;
import com.blixx.boom.gui.dialogs.ShowMessageBox;
import com.blixx.boom.gui.views.DateTimeGroup;
import com.blixx.boom.gui.views.outages.AbstractMaintenanceDetailsComposite;
import com.blixx.boom.gui.views.outages.AgentScheduledMaintenanceView;
import com.blixx.ctrl.sc.ServerClient;
import com.blixx.ctrl.sc.in.ScSaveServerPolicies;
import com.blixx.ctrl.sc.in.ScSaveServerPoliciesSlave;
import com.blixx.log.RTLogger;
import com.blixx.shared.Interval;
import com.blixx.shared.ext.OutagePolicy;
import com.blixx.shared.ext.ServerPolicyTemplate;
import com.blixx.shared.ext.TimeInterval;
import com.blixx.shared.ext.TimeMask;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Timer;
import java.util.TimerTask;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.PopupList;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;

public class ScheduledMaintenanceDetailsComposite
extends AbstractMaintenanceDetailsComposite {
    public static final String SP_MASK = "SP_MASK";
    protected CCombo m_mSpAction;
    protected CCombo m_mSpPostAction;
    protected DateTimeGroup m_startDate;
    protected DateTimeGroup m_ExpectedEndDate;
    protected Text m_interval;
    protected Text m_mask;
    protected OutagePolicy m_sp = null;
    protected boolean m_ignoreModifyTextEvents = false;
    public String m_server = null;
    Timer m_serverTimeTimer;

    public ScheduledMaintenanceDetailsComposite(CTabItem cTab, Composite parent, int style) {
        super(cTab, parent, style);
    }

    public void setServerPolicy(OutagePolicy sp, boolean isReadOnly, String server) {
        this.m_sp = sp;
        this.m_server = server;
        this.setReadOnly(isReadOnly);
        this.update();
        this.setDirty(false);
        this.m_save.setEnabled(false);
        if (this.isReadOnly()) {
            this.setTabReadOnly();
        }
    }

    @Override
    public void init() {
        GridLayout gl = new GridLayout(1, false);
        gl.verticalSpacing = 0;
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        gl.marginTop = 10;
        this.setLayout((Layout)gl);
        this.setLayoutData(new GridData(4, 4, true, true));
        this.m_sc = new ScrolledComposite((Composite)this, 768);
        this.m_sc.setAlwaysShowScrollBars(false);
        this.m_sc.setExpandHorizontal(true);
        this.m_sc.setExpandVertical(true);
        gl = new GridLayout(1, false);
        gl.verticalSpacing = 0;
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        this.m_sc.setLayout((Layout)gl);
        this.m_sc.setLayoutData((Object)new GridData(4, 4, true, true));
        this.m_sc.setBackground(BMUI.color_light_green);
        this.m_comp_main = new Composite((Composite)this.m_sc, 0);
        gl = new GridLayout(2, true);
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        gl.horizontalSpacing = 25;
        this.m_comp_main.setLayout((Layout)gl);
        this.m_comp_main.setLayoutData((Object)new GridData(4, 4, true, true));
        Composite comp_left = new Composite(this.m_comp_main, 0);
        gl = new GridLayout(2, false);
        comp_left.setLayout((Layout)gl);
        comp_left.setLayoutData((Object)new GridData(4, 4, true, true));
        Composite comp_right = new Composite(this.m_comp_main, 0);
        gl = new GridLayout(2, false);
        comp_right.setLayout((Layout)gl);
        comp_right.setLayoutData((Object)new GridData(4, 4, true, true));
        this.m_mSpID = this.m_gui.addTextReadOnly(comp_left, "ID: ", "", 1, 1, 1, 1, null, null);
        this.m_mSpName = this.m_gui.addInputFieldSingle(comp_left, "SPName", "Name: ", "", 1, 1, 1, 1, 1, this);
        this.m_mSpDescr = this.m_gui.addInputFieldMultiLineWrap(comp_left, "SPDescr", "Description: ", "", 1, 1, 60, 20, 1, 1, this);
        Group start_group = new Group(comp_left, 0);
        start_group.setText("Start Time");
        gl = new GridLayout(1, false);
        gl.verticalSpacing = 0;
        start_group.setLayout((Layout)gl);
        GridData gd = new GridData(4, 4, true, false, 2, 1);
        gd.verticalIndent = 5;
        start_group.setLayoutData((Object)gd);
        this.m_startDate = new DateTimeGroup((Composite)start_group, null);
        this.m_startDate.addModifyListener(this);
        Composite comp = this.createIntervalComposite(comp_left);
        ((GridLayout)comp.getLayout()).marginTop = 5;
        this.createSchedule(comp_left);
        this.m_gui.addTextField(comp_left, null, "Server Time: ", 1, 1, 1, 1, null);
        final Label st = this.m_gui.addTextField(comp_left, null, "", 1, 1, 1, 1, null);
        this.setServerTime(st);
        this.m_serverTimeTimer = new Timer("clock1", false);
        Calendar cal = Calendar.getInstance();
        cal.set(13, 0);
        cal.set(14, 0);
        cal.add(12, 1);
        this.m_serverTimeTimer.schedule(new TimerTask(){

            @Override
            public void run() {
                UIJob uiJob = new UIJob("clcki1refr"){

                    @Override
                    public IStatus runInUIThread(IProgressMonitor monitor) {
                        ScheduledMaintenanceDetailsComposite.this.setServerTime(st);
                        return null;
                    }
                };
                UIJobManager.getInstance().schedule(uiJob);
            }
        }, cal.getTime(), 60000L);
        Composite action_comp = new Composite(comp_right, 0);
        action_comp.setLayout((Layout)new GridLayout(2, true));
        action_comp.setLayoutData((Object)new GridData(16384, 4, false, false, 2, 1));
        this.m_mSpAction = this.m_gui.addDropDown(action_comp, "SPAction", "Action: ", new String[]{"DROP", "HIDE"}, "HIDE", "", 1, 1, 1, 1, this);
        this.m_mSpPostAction = this.m_gui.addDropDown(action_comp, "SPPostAction", "Post Action: ", new String[]{"NONE", "DROP", "PUBLISH"}, "NONE", "", 1, 1, 1, 1, this);
        this.createFilterTable(comp_right);
        this.m_mSpOwner = this.m_gui.addTextReadOnly(comp_right, "Owner: ", "", 1, 1, 1, 1, null, null);
        this.m_sc.setContent((Control)this.m_comp_main);
        this.m_sc.setMinSize(this.m_comp_main.computeSize(-1, -1, true));
        Composite compLine = new Composite((Composite)this, 0);
        gl = new GridLayout(1, false);
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        compLine.setLayout((Layout)gl);
        compLine.setLayoutData((Object)new GridData(4, 128, true, false));
        Label line = new Label(compLine, 259);
        line.setForeground(BMUI.color_darkGrey2);
        line.setLayoutData((Object)new GridData(4, 128, true, false));
        Composite compBtn = new Composite((Composite)this, 0);
        compBtn.setLayout((Layout)new GridLayout(4, true));
        compBtn.setLayoutData((Object)new GridData(16384, 4, false, false));
        this.m_save = this.m_gui.addButton(compBtn, "SAVE_BTN", "&Save Maintenance", false, 90, 30, 0, 8, this);
        this.m_save.setLayoutData((Object)new GridData(4, 128, false, false));
        this.m_undo = this.m_gui.addButton(compBtn, "UNDO_BTN", "&Undo Changes", false, 90, 30, 0, 8, this);
        this.m_undo.setLayoutData((Object)new GridData(4, 128, false, false));
        this.m_mSpReadOnly = this.m_gui.addTextReadOnlyNoBorder(compBtn, null, "Read Only!", 1, 1, 0, 0, null);
        ((GridData)this.m_mSpReadOnly.getLayoutData()).horizontalAlignment = 4;
        this.m_mSpReadOnly.setFont(BMUI.font_arial8_bold);
        this.m_mSpReadOnly.setForeground(BMUI.color_critical);
        this.m_mSpReadOnly.setVisible(false);
        this.checkButtons();
    }

    private Composite createSchedule(Composite parent) {
        this.m_gui.addTextField(parent, null, "Schedule:", 1, 1, 1, 1, null);
        Composite comp = new Composite(parent, 0);
        GridLayout gl = new GridLayout(2, false);
        gl.verticalSpacing = 0;
        gl.horizontalSpacing = 0;
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        comp.setLayout((Layout)gl);
        comp.setLayoutData((Object)new GridData(4, 4, false, false));
        this.m_mask = this.m_gui.addInputFieldSingle(comp, SP_MASK, null, "", 1, 1, 1, 1, 1, this);
        Button helpIcon = new Button(comp, 0x800000);
        GridData layoutData = new GridData(4, 4, false, false);
        layoutData.verticalIndent = 1;
        layoutData.heightHint = 18;
        helpIcon.setLayoutData((Object)layoutData);
        helpIcon.setImage(BMUI.IMAGE_ARROW_DOWN);
        helpIcon.addListener(4, new Listener(){

            public void handleEvent(Event event) {
                PopupList plist = new PopupList(ScheduledMaintenanceDetailsComposite.this.m_mask.getShell());
                plist.setItems(new String[]{"*/*/* MON(*) 22:00:00     # every Monday at 22:00:00", "*/*/* 1-5(*) 08:00:00         # Monday-Friday at 08:00:00", "*/*/* *(*) 10,20:*:*            # daily at 10 and 20 o'clock", "*/*/* *(*) *:05:00               # hourly at 5th minutes", "*/*/1L *(*) 23:00:00             # Last day of every month at 23:00:00", "*/*/* SAT(1L) 00:00:00     # last Saturday of each month at midnight", "*/*/15,1L *(*) 23:05:00     # 15th and last day of every month at 23:05:00"});
                Point text0 = ScheduledMaintenanceDetailsComposite.this.m_mask.getDisplay().map((Control)ScheduledMaintenanceDetailsComposite.this.m_mask, (Control)ScheduledMaintenanceDetailsComposite.this.m_mask.getShell(), ScheduledMaintenanceDetailsComposite.this.m_mask.getShell().getLocation());
                Rectangle rect = new Rectangle(text0.x + ScheduledMaintenanceDetailsComposite.this.m_interval.getBorderWidth() + 1, text0.y + ScheduledMaintenanceDetailsComposite.this.m_interval.getBounds().height + ScheduledMaintenanceDetailsComposite.this.m_interval.getBorderWidth(), ScheduledMaintenanceDetailsComposite.this.m_interval.getBounds().width, 50);
                String selected = plist.open(rect);
                if (selected != null) {
                    String mask = selected.split("#", 2)[0];
                    ScheduledMaintenanceDetailsComposite.this.m_mask.setText(mask.trim());
                    ScheduledMaintenanceDetailsComposite.this.m_mask.setFocus();
                    ScheduledMaintenanceDetailsComposite.this.m_mask.setSelection(ScheduledMaintenanceDetailsComposite.this.m_mask.getText().length());
                }
            }
        });
        return comp;
    }

    private Composite createIntervalComposite(Composite parent) {
        this.m_gui.addTextField(parent, null, "Duration: ", 1, 1, 1, 1, null);
        Composite comp = new Composite(parent, 0);
        GridLayout gl = new GridLayout(2, false);
        gl.verticalSpacing = 0;
        gl.horizontalSpacing = 0;
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        comp.setLayout((Layout)gl);
        comp.setLayoutData((Object)new GridData(4, 4, false, false));
        this.m_interval = this.m_gui.addInputFieldSingle(comp, "SP_INTERVAL", null, null, 1, 1, 1, 1, 1, this);
        Button helpIcon = new Button(comp, 0x800000);
        GridData layoutData = new GridData(4, 4, false, false);
        layoutData.verticalIndent = 1;
        layoutData.heightHint = 18;
        helpIcon.setLayoutData((Object)layoutData);
        helpIcon.setImage(BMUI.IMAGE_ARROW_DOWN);
        helpIcon.addListener(4, new Listener(){

            public void handleEvent(Event event) {
                PopupList plist = new PopupList(ScheduledMaintenanceDetailsComposite.this.m_interval.getShell());
                plist.setItems(new String[]{"1h # one hour", "1d # one day", "7d # one week", "5d10h5m # 5 days 10 hours 5 minutes", "365d # one year", "\u221e # unlimited"});
                Point text0 = ScheduledMaintenanceDetailsComposite.this.m_interval.getDisplay().map((Control)ScheduledMaintenanceDetailsComposite.this.m_interval, (Control)ScheduledMaintenanceDetailsComposite.this.m_interval.getShell(), ScheduledMaintenanceDetailsComposite.this.m_interval.getShell().getLocation());
                Rectangle rect = new Rectangle(text0.x + ScheduledMaintenanceDetailsComposite.this.m_interval.getBorderWidth() + 1, text0.y + ScheduledMaintenanceDetailsComposite.this.m_interval.getBounds().height + ScheduledMaintenanceDetailsComposite.this.m_interval.getBorderWidth(), ScheduledMaintenanceDetailsComposite.this.m_interval.getBounds().width, 50);
                String selected = plist.open(rect);
                if (selected != null) {
                    String interval = selected.split("#", 2)[0];
                    ScheduledMaintenanceDetailsComposite.this.m_interval.setText(interval.trim());
                    ScheduledMaintenanceDetailsComposite.this.m_interval.setFocus();
                    ScheduledMaintenanceDetailsComposite.this.m_interval.setSelection(ScheduledMaintenanceDetailsComposite.this.m_interval.getText().length());
                }
            }
        });
        return comp;
    }

    public void modifyText(ModifyEvent e) {
        if (this.m_ignoreModifyTextEvents) {
            return;
        }
        Object obj = e.getSource();
        if (obj instanceof Text) {
            Text widget = (Text)obj;
            String fieldName = (String)widget.getData();
            String text = widget.getText().trim();
            if (fieldName.equals("SPName")) {
                if (this.m_server != null && this.m_server.length() > 0) {
                    this.m_cTab.setText(String.valueOf(text) + "@@" + this.m_server);
                } else {
                    this.m_cTab.setText(text);
                }
                this.m_mSpName.setToolTipText(null);
            } else if (fieldName.equals("SP_INTERVAL")) {
                this.validate();
            } else {
                fieldName.equals(SP_MASK);
            }
        }
        this.setDirty(true);
    }

    public void update() {
        this.m_ignoreModifyTextEvents = true;
        try {
            if (this.m_sp == null) {
                this.m_fp.setFilters(null);
                this.m_mSpID.setText("");
                this.m_mSpName.setText("");
                this.m_mSpOwner.setText("");
                this.m_mSpDescr.setText("");
                this.m_mSpAction.setText("HIDE");
                this.m_mSpPostAction.setText("NONE");
                this.m_startDate.setTime(-1L);
                this.m_interval.setText("");
                this.m_mask.setText("");
            } else {
                this.m_fp.setFilters(this.m_sp.getFilters());
                this.m_mSpID.setText(this.m_sp.getID());
                this.m_mSpName.setText(this.m_sp.getName());
                this.m_mSpOwner.setText(this.m_sp.getOwner());
                this.m_mSpDescr.setText(this.m_sp.getDescription());
                this.m_mSpAction.setText(ServerPolicyTemplate.getActionLabel(this.m_sp.getAction()));
                this.m_mSpPostAction.setText(ServerPolicyTemplate.getActionLabel(this.m_sp.getPostAction()));
                if (this.m_sp.getAction() == 1) {
                    this.m_mSpPostAction.setEnabled(false);
                }
                this.m_startDate.setTime(this.m_sp.getTimeInterval().getFirstStart());
                long itvl = this.m_sp.getTimeInterval().getInterval();
                if (itvl == Long.MAX_VALUE) {
                    this.m_interval.setText("\u221e");
                } else if (itvl > 0L) {
                    Interval i = Interval.getSimpleInterval((int)(itvl / 1000L));
                    this.m_interval.setText(i.toString());
                } else {
                    this.m_interval.setText("");
                }
                TimeMask tm = this.m_sp.getTimeInterval().getTimeMask();
                if (tm != null) {
                    this.m_mask.setText(tm.getMask());
                } else {
                    this.m_mask.setText("");
                }
            }
            this.m_table_filters.setInput((Object)this.m_fp.getElements(null));
            this.m_startDate.update();
        }
        finally {
            this.m_ignoreModifyTextEvents = false;
        }
        this.validate();
        this.computeSize(-1, -1);
        super.update();
    }

    public void widgetSelected(SelectionEvent e) {
        Object obj = e.getSource();
        if (obj instanceof Button) {
            Button btn = (Button)obj;
            String name = (String)btn.getData();
            if ("SAVE_BTN".equals(name)) {
                this.saveServerPolicy(this.m_server);
                AgentScheduledMaintenanceView.getOverviewTab().refresh();
            } else if ("UNDO_BTN".equals(name)) {
                AgentScheduledMaintenanceView.reOpenTab(this.m_sp, this.m_mSpName.getText().trim(), this.m_parent, this.m_server);
            } else if ("FILTER_DELETE".equals(name)) {
                AbstractMaintenanceDetailsComposite.FilterAction filerAction = new AbstractMaintenanceDetailsComposite.FilterAction(this.m_parent.getShell(), this.m_table_filters, this.m_fp, "FILTER_DELETE");
                filerAction.run();
            } else if ("FILTER_EDIT".equals(name)) {
                AbstractMaintenanceDetailsComposite.FilterAction filerAction = new AbstractMaintenanceDetailsComposite.FilterAction(this.m_parent.getShell(), this.m_table_filters, this.m_fp, "FILTER_EDIT");
                filerAction.run();
            } else if ("FILTER_NEW".equals(name)) {
                AbstractMaintenanceDetailsComposite.FilterAction filerAction = new AbstractMaintenanceDetailsComposite.FilterAction(this.m_parent.getShell(), this.m_table_filters, this.m_fp, "FILTER_NEW");
                filerAction.run();
            }
        } else if (obj instanceof CCombo) {
            CCombo cc = (CCombo)obj;
            String type = (String)cc.getData();
            if ("SPAction".equals(type)) {
                if ("DROP".equals(cc.getText())) {
                    this.m_mSpPostAction.setText("NONE");
                    this.m_gui.enableField(this.m_mSpPostAction, false);
                } else {
                    this.m_gui.enableField(this.m_mSpPostAction, true);
                }
            } else {
                "SPPostAction".equals(type);
            }
            this.setDirty(true);
            this.checkButtons();
        }
    }

    @Override
    public boolean saveServerPolicy(String server) {
        OutagePolicy toSave;
        try {
            toSave = new OutagePolicy(this.m_sp.getID(), this.m_sp.getName());
            toSave.setName(this.m_mSpName.getText());
            toSave.setDescription(this.m_mSpDescr.getText());
            toSave.setAction(OutagePolicy.getAction(this.m_mSpAction.getItem(this.m_mSpAction.getSelectionIndex())));
            toSave.setPostAction(OutagePolicy.getAction(this.m_mSpPostAction.getItem(this.m_mSpPostAction.getSelectionIndex())));
            String itext = this.m_interval.getText();
            long itvl = -1L;
            if ("\u221e".equals(itext)) {
                itvl = Long.MAX_VALUE;
            } else {
                Interval ivl = Interval.parseInterval(this.m_interval.getText(), -1);
                if (ivl.getIntervalSeconds() == -1) {
                    throw new RuntimeException("Invalid Duration");
                }
                itvl = ivl.getIntervalMilliseconds();
            }
            String mask = this.m_mask.getText();
            TimeMask tm = null;
            if (mask != null && mask.length() > 0) {
                tm = new TimeMask(mask);
            }
            TimeInterval ti = new TimeInterval(this.m_startDate.getTime(), itvl, tm);
            toSave.setTimeInterval(ti);
            toSave.getTimeInterval().m_firstStart = this.m_startDate.getTime();
            toSave.setFilters(this.m_fp.getFilters());
        }
        catch (Throwable e) {
            RTLogger.print(3, "Error saving Server Policy", e.getMessage());
            new ShowMessageBox("Error saving Server Policy", e.getMessage(), 1);
            return false;
        }
        ArrayList<ServerPolicyTemplate> tosave = new ArrayList<ServerPolicyTemplate>(1);
        tosave.add(toSave);
        ServerClient sc = null;
        sc = server == null || server.length() == 0 ? new ScSaveServerPolicies(Repository.getInstance(), tosave) : new ScSaveServerPoliciesSlave(Repository.getInstance(), tosave, server);
        sc.run();
        boolean success = sc.isSuccess();
        if (!success) {
            RTLogger.print(3, "Error saving Server Policy", sc.getLastException().getMessage());
            new ShowMessageBox("Error saving Server Policy", sc.getLastException().getMessage(), 1);
        } else {
            this.m_sp = toSave;
            this.setDirty(false);
        }
        return success;
    }

    private void setServerTime(Label st) {
        Calendar mServerCalendar = Repository.getInstance().m_serverCalendar;
        if (mServerCalendar != null && Repository.getInstance().m_serverTimeZone != null) {
            mServerCalendar.setTimeInMillis(System.currentTimeMillis() + (long)Repository.getInstance().m_serverDiffMilliseconds);
            SimpleDateFormat simpleDateFormat2 = new SimpleDateFormat("yyyy-MM-dd HH:mm '" + Repository.getInstance().m_serverTimeZone + "'(Z)");
            simpleDateFormat2.setTimeZone(mServerCalendar.getTimeZone());
            st.setText(simpleDateFormat2.format(mServerCalendar.getTime()));
        }
    }

    public void doubleClick(DoubleClickEvent event) {
        AbstractMaintenanceDetailsComposite.FilterAction filerAction = new AbstractMaintenanceDetailsComposite.FilterAction(this.m_parent.getShell(), this.m_table_filters, this.m_fp, "FILTER_EDIT");
        filerAction.run();
    }

    @Override
    public void validate() {
        this.m_isValid = true;
        if (!this.isReadOnly()) {
            super.validate();
        }
        if (this.m_interval.getText() != null && this.m_interval.getText().length() > 0) {
            Interval seconds = Interval.parseInterval(this.m_interval.getText(), -1);
            if (!"\u221e".equals(this.m_interval.getText()) && seconds.getIntervalSeconds() < 60) {
                this.m_isValid = false;
                this.m_interval.setBackground(BMUI.color_critical);
            } else {
                this.m_interval.setBackground(null);
            }
        } else {
            this.m_interval.setBackground(BMUI.color_critical);
        }
    }

    public void setTabReadOnly() {
        this.m_mSpReadOnly.setVisible(true);
        this.m_gui.enableField(this.m_newF, false);
        this.m_comp_main.setEnabled(false);
    }

    public void dispose() {
        this.m_serverTimeTimer.cancel();
        super.dispose();
    }
}

