/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.views.outages;

import com.blixx.boom.engine.BMUI;
import com.blixx.boom.engine.ICommandListener;
import com.blixx.boom.engine.Repository;
import com.blixx.boom.gui.Activator;
import com.blixx.boom.gui.dialogs.ShowMessageDialog;
import com.blixx.boom.gui.utils.FilterComposite;
import com.blixx.boom.gui.utils.GUIDisplayElements;
import com.blixx.boom.gui.views.FancyToolTipSupport;
import com.blixx.boom.gui.views.MaintenanceView;
import com.blixx.boom.gui.views.outages.AbstractMaintenanceOverviewTab;
import com.blixx.boom.gui.views.outages.AgentMaintenanceTableProvider;
import com.blixx.boom.gui.views.outages.AgentScheduledMaintenanceView;
import com.blixx.boom.gui.views.outages.StatusViewFilter;
import com.blixx.log.RTLogger;
import com.blixx.shared.ext.OutagePolicy;
import com.blixx.shared.ext.ServerPolicyStatus;
import com.blixx.shared.ext.ServerPolicyTemplate;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.ISharedImages;

public class ScheduledMaintenanceOverviewTab
extends AbstractMaintenanceOverviewTab
implements SelectionListener,
IDoubleClickListener,
ICommandListener {
    public static final String SHOWDISABLED = "SHOWDISABLED";
    public static final String SHOWENABLED = "SHOWENABLED";
    public static final String SHOWALL = "SHOWALL";
    private static String REFRESH_BTN = "REFRESH_BTN";
    public static String VIEWER_TYPE_OVERVIEW = "OVERVIEW";
    public static String VIEWER_TYPE_NONE = "NONE";
    public static String VIEWER_TYPE = "VIEWER_TYPE";
    public static String BUTTON_SAVE_ORDER = "save";
    public static String BUTTON_UNDO_ORDER = "undo";
    public static String BUTTON_UP = "Up";
    public static String BUTTON_DOWN = "Down";
    public static String BUTTON_TOP = "Top";
    public static String BUTTON_BOTTOM = "Bottom";
    public static String BUTTON_CREATE = "create";
    public static String BUTTON_COPY = "copy";
    public static String BUTTON_DELETE = "delete";
    private ScheduledMaintenanceOverviewTab m_overviewTab = this;
    private CTabFolder m_folder = null;
    private Composite m_compositeInView = null;
    private Composite m_compMain = null;
    private Composite m_compTable = null;
    private GUIDisplayElements m_gui = null;
    private Composite m_sc = null;
    private Table m_table = null;
    private TableViewer m_tableViewer = null;
    private Button m_refresh_btn = null;
    public Button m_save_Button = null;
    public Button m_undo_Button = null;
    public Button m_up_Button = null;
    public Button m_down_Button = null;
    public Button m_top_Button = null;
    public Button m_bottom_Button = null;
    public Button m_add_btn = null;
    public Button m_copy_Button = null;
    public Button m_del_btn = null;
    public static HashMap<String, Integer> m_colIndices = null;
    public static HashMap<Integer, String> m_colNames = null;
    public static HashMap<String, Integer> m_columnWidth = new HashMap();
    public AgentMaintenanceTableProvider m_provider = null;
    public String m_server = "";

    static {
        m_columnWidth.put("ID", 36);
        m_columnWidth.put("Name", 80);
        m_columnWidth.put("Enabled", 20);
        m_columnWidth.put("Enabled by", 80);
        m_columnWidth.put("Disabled by", 80);
        m_columnWidth.put("Active", 20);
        m_columnWidth.put("Action", 50);
        m_columnWidth.put("PostAction", 50);
        m_columnWidth.put("Filters", 200);
        m_columnWidth.put("Start Time", 80);
        m_columnWidth.put("Interval", 40);
        m_columnWidth.put("Expected End", 40);
        m_columnWidth.put("End Time", 80);
        m_columnWidth.put("Enabled Time", 80);
        m_columnWidth.put("Schedule", 200);
        m_columnWidth.put("Description", 100);
    }

    public ScheduledMaintenanceOverviewTab(CTabFolder parent, int style, String serverName) {
        super(parent, style);
        this.m_folder = parent;
        String tabID = "OVERVIEW";
        if (serverName == null || serverName.length() == 0) {
            this.setText("Overview");
        } else {
            this.m_server = serverName;
            this.setText("Overview@@" + serverName);
            tabID = "OVERVIEW@@+serverName";
        }
        this.setImage(BMUI.IMAGE_OUTAGE);
        this.setData("TABID", tabID);
        this.createMainArea();
        if (Repository.getInstance().getRights(2010) > 1) {
            Repository.getInstance().getCmdRouter().addCmdListener("GET_SERVER_POLICIES_STATUS", this);
        }
    }

    @Override
    public void onCommand(String command, String action) {
        this.m_provider.reloadData();
    }

    public void createMainArea() {
        this.m_gui = new GUIDisplayElements();
        this.m_compositeInView = new Composite((Composite)this.m_folder, 0);
        GridLayout gl = new GridLayout(1, false);
        gl.verticalSpacing = 0;
        gl.horizontalSpacing = 0;
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        this.m_compositeInView.setLayout((Layout)gl);
        this.m_sc = new Composite(this.m_compositeInView, 0);
        this.m_sc.setLayout((Layout)gl);
        this.m_sc.setLayoutData((Object)new GridData(4, 4, true, true));
        this.m_compMain = new Composite(this.m_sc, 2048);
        gl = new GridLayout(3, false);
        gl.verticalSpacing = 0;
        this.m_compMain.setLayout((Layout)gl);
        this.m_compMain.setLayoutData((Object)new GridData(4, 4, true, true));
        Group filterGroupOnStatus = new Group(this.m_compMain, 0);
        filterGroupOnStatus.setText("Filter on Status");
        filterGroupOnStatus.setLayout((Layout)new GridLayout(3, false));
        GridData gd = new GridData(4, 4, false, false);
        gd.minimumWidth = 100;
        filterGroupOnStatus.setLayoutData((Object)gd);
        Button showAll = this.m_gui.addRadioButton((Composite)filterGroupOnStatus, SHOWALL, "All", true, 1, 1, 0, 0, this);
        showAll.setLayoutData((Object)new GridData(1, 0x1000000, false, true));
        Button showEnabled = this.m_gui.addRadioButton((Composite)filterGroupOnStatus, SHOWENABLED, "Enabled", false, 1, 1, 0, 0, this);
        showEnabled.setLayoutData((Object)new GridData(1, 0x1000000, false, true));
        Button showDisabled = this.m_gui.addRadioButton((Composite)filterGroupOnStatus, SHOWDISABLED, "Disabled", false, 1, 1, 0, 0, this);
        showDisabled.setLayoutData((Object)new GridData(1, 0x1000000, false, true));
        Group filterGroup = new Group(this.m_compMain, 0);
        filterGroup.setText("Filter on Name or ID");
        gl = new GridLayout(3, false);
        gl.horizontalSpacing = 0;
        gl.marginWidth = 0;
        filterGroup.setLayout((Layout)gl);
        gd = new GridData(4, 4, true, false);
        gd.minimumWidth = 100;
        filterGroup.setLayoutData((Object)gd);
        FilterComposite filterComp = new FilterComposite((Composite)filterGroup, this);
        filterComp.setCompositeLayoutData(new GridData(4, 0x1000000, true, true));
        Composite compBtn_refresh = new Composite(this.m_compMain, 0);
        compBtn_refresh.setLayout((Layout)new GridLayout(1, false));
        compBtn_refresh.setLayoutData((Object)new GridData(4, 4, false, false));
        this.m_refresh_btn = this.m_gui.addButton(compBtn_refresh, REFRESH_BTN, "Refresh ", true, 35, 20, 0, this);
        this.m_refresh_btn.setImage(BMUI.IMAGE_REFRESH_14x14);
        ((GridData)this.m_refresh_btn.getLayoutData()).horizontalAlignment = 4;
        ((GridData)this.m_refresh_btn.getLayoutData()).verticalAlignment = 0x1000000;
        ((GridData)this.m_refresh_btn.getLayoutData()).grabExcessHorizontalSpace = true;
        ((GridData)this.m_refresh_btn.getLayoutData()).verticalIndent = 7;
        this.m_compTable = new Composite(this.m_compMain, 0);
        gl = new GridLayout(1, false);
        gl.verticalSpacing = 0;
        gl.horizontalSpacing = 0;
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        this.m_compTable.setLayout((Layout)gl);
        this.m_compTable.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        this.createTable();
        Composite compBtn_right = new Composite(this.m_compMain, 0);
        gl = new GridLayout(1, true);
        gl.verticalSpacing = 3;
        compBtn_right.setLayout((Layout)gl);
        GridData gdB = new GridData(4, 4, false, true);
        compBtn_right.setLayoutData((Object)gdB);
        new Label(compBtn_right, 0);
        this.m_top_Button = this.m_gui.addButton(compBtn_right, BUTTON_TOP, BUTTON_TOP, false, 35, 20, 1, this);
        this.m_top_Button.setLayoutData((Object)new GridData(4, 128, true, false, 1, 1));
        this.m_up_Button = this.m_gui.addButton(compBtn_right, BUTTON_UP, " Up ", false, 35, 20, 1, this);
        this.m_up_Button.setLayoutData((Object)new GridData(4, 128, true, false, 1, 1));
        this.m_down_Button = this.m_gui.addButton(compBtn_right, BUTTON_DOWN, " Down ", false, 35, 20, 1, this);
        this.m_down_Button.setLayoutData((Object)new GridData(4, 128, true, false, 1, 1));
        this.m_bottom_Button = this.m_gui.addButton(compBtn_right, BUTTON_BOTTOM, BUTTON_BOTTOM, false, 35, 20, 1, this);
        this.m_bottom_Button.setLayoutData((Object)new GridData(4, 128, true, false, 1, 1));
        new Label(compBtn_right, 0);
        this.m_undo_Button = this.m_gui.addButton(compBtn_right, BUTTON_UNDO_ORDER, "Undo Order", false, 35, 20, 1, this);
        this.m_undo_Button.setLayoutData((Object)new GridData(4, 128, true, false, 1, 1));
        this.m_save_Button = this.m_gui.addButton(compBtn_right, BUTTON_SAVE_ORDER, "Save Order", false, 35, 20, 1, this);
        this.m_save_Button.setLayoutData((Object)new GridData(4, 128, true, false, 1, 1));
        ISharedImages sharedImages = Activator.getDefault().getWorkbench().getActiveWorkbenchWindow().getWorkbench().getSharedImages();
        Composite compBtn_footer = new Composite(this.m_compMain, 0);
        gl = new GridLayout(3, true);
        gl.marginWidth = 0;
        compBtn_footer.setLayout((Layout)gl);
        compBtn_footer.setLayoutData((Object)new GridData(16384, 4, false, false, 2, 1));
        this.m_add_btn = this.m_gui.addButton(compBtn_footer, BUTTON_CREATE, "Add Maintenance", !this.isReadOnly(), 35, 20, 0, this);
        this.m_add_btn.setImage(sharedImages.getImage("IMG_OBJ_ADD"));
        this.m_del_btn = this.m_gui.addButton(compBtn_footer, BUTTON_DELETE, "Delete Maintenance", false, 35, 20, 0, this);
        this.m_del_btn.setImage(sharedImages.getImage("IMG_TOOL_DELETE"));
        if (this.isReadOnly()) {
            Text readOnly = this.m_gui.addTextReadOnlyNoBorder(compBtn_footer, null, "Read Only!", 1, 1, 0, 0, null);
            ((GridData)readOnly.getLayoutData()).horizontalAlignment = 4;
            readOnly.setFont(BMUI.font_arial8_bold);
            readOnly.setForeground(BMUI.color_critical);
        }
        this.setControl((Control)this.m_compositeInView);
    }

    public boolean isReadOnly() {
        int rights = Repository.getInstance().getRights(2010);
        return rights < 3;
    }

    protected void createTable() {
        this.m_table = new Table(this.m_compTable, 68354);
        this.m_table.setHeaderVisible(true);
        this.m_table.setLinesVisible(true);
        GridLayout gl = new GridLayout();
        gl.verticalSpacing = 0;
        this.m_table.setLayout((Layout)gl);
        GridData gd = new GridData(4, 4, true, true, 1, 1);
        gd.verticalIndent = 5;
        gd.heightHint = 50;
        this.m_table.setLayoutData((Object)gd);
        this.m_tableViewer = new TableViewer(this.m_table);
        this.m_tableViewer.setData(VIEWER_TYPE, (Object)VIEWER_TYPE_OVERVIEW);
        this.m_tableViewer.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                if (element instanceof ServerPolicyTemplate) {
                    ServerPolicyTemplate spt = (ServerPolicyTemplate)element;
                    String id = spt.getID();
                    ServerPolicyStatus st = ScheduledMaintenanceOverviewTab.this.m_provider.getServerPolicyStatus(id);
                    if (st.m_access <= ServerPolicyStatus.ACCESS_INVISIBLE) {
                        return false;
                    }
                }
                return true;
            }
        });
        this.m_provider = new AgentMaintenanceTableProvider(this.m_tableViewer, this, this.m_server);
        TableViewerColumn col0 = new TableViewerColumn(this.m_tableViewer, 16384);
        col0.getColumn().setText("ID");
        col0.getColumn().setWidth(Integer.parseInt("" + m_columnWidth.get("ID")));
        col0.setLabelProvider((CellLabelProvider)this.m_provider);
        TableViewerColumn col1 = new TableViewerColumn(this.m_tableViewer, 16384);
        col1.getColumn().setText("Name");
        col1.getColumn().setWidth(Integer.parseInt("" + m_columnWidth.get("Name")));
        col1.setLabelProvider((CellLabelProvider)this.m_provider);
        TableViewerColumn col2 = new TableViewerColumn(this.m_tableViewer, 16384);
        col2.getColumn().setText("Enabled");
        col2.getColumn().setWidth(Integer.parseInt("" + m_columnWidth.get("Enabled")));
        col2.setLabelProvider((CellLabelProvider)this.m_provider);
        TableViewerColumn col3 = new TableViewerColumn(this.m_tableViewer, 16384);
        col3.getColumn().setText("Enabled by");
        col3.getColumn().setWidth(Integer.parseInt("" + m_columnWidth.get("Enabled by")));
        col3.setLabelProvider((CellLabelProvider)this.m_provider);
        TableViewerColumn col4 = new TableViewerColumn(this.m_tableViewer, 16384);
        col4.getColumn().setText("Disabled by");
        col4.getColumn().setWidth(Integer.parseInt("" + m_columnWidth.get("Disabled by")));
        col4.setLabelProvider((CellLabelProvider)this.m_provider);
        TableViewerColumn col5 = new TableViewerColumn(this.m_tableViewer, 16384);
        col5.getColumn().setText("Active");
        col5.getColumn().setWidth(Integer.parseInt("" + m_columnWidth.get("Active")));
        col5.setLabelProvider((CellLabelProvider)this.m_provider);
        TableViewerColumn col6 = new TableViewerColumn(this.m_tableViewer, 16384);
        col6.getColumn().setText("Action");
        col6.getColumn().setWidth(Integer.parseInt("" + m_columnWidth.get("Action")));
        col6.setLabelProvider((CellLabelProvider)this.m_provider);
        TableViewerColumn col7 = new TableViewerColumn(this.m_tableViewer, 16384);
        col7.getColumn().setText("PostAction");
        col7.getColumn().setWidth(Integer.parseInt("" + m_columnWidth.get("PostAction")));
        col7.setLabelProvider((CellLabelProvider)this.m_provider);
        TableViewerColumn col8 = new TableViewerColumn(this.m_tableViewer, 16384);
        col8.getColumn().setText("Start Time");
        col8.getColumn().setWidth(Integer.parseInt("" + m_columnWidth.get("Start Time")));
        col8.setLabelProvider((CellLabelProvider)this.m_provider);
        TableViewerColumn col9 = new TableViewerColumn(this.m_tableViewer, 16384);
        col9.getColumn().setText("Interval");
        col9.getColumn().setWidth(Integer.parseInt("" + m_columnWidth.get("Interval")));
        col9.setLabelProvider((CellLabelProvider)this.m_provider);
        TableViewerColumn col10 = new TableViewerColumn(this.m_tableViewer, 16384);
        col10.getColumn().setText("Expected End");
        col10.getColumn().setWidth(Integer.parseInt("" + m_columnWidth.get("Expected End")));
        col10.setLabelProvider((CellLabelProvider)this.m_provider);
        TableViewerColumn col11 = new TableViewerColumn(this.m_tableViewer, 16384);
        col11.getColumn().setText("End Time");
        col11.getColumn().setWidth(Integer.parseInt("" + m_columnWidth.get("End Time")));
        col11.setLabelProvider((CellLabelProvider)this.m_provider);
        TableViewerColumn col12 = new TableViewerColumn(this.m_tableViewer, 16384);
        col12.getColumn().setText("Schedule");
        col12.getColumn().setWidth(Integer.parseInt("" + m_columnWidth.get("Schedule")));
        col12.setLabelProvider((CellLabelProvider)this.m_provider);
        TableViewerColumn col13 = new TableViewerColumn(this.m_tableViewer, 16384);
        col13.getColumn().setText("Description");
        col13.getColumn().setWidth(Integer.parseInt("" + m_columnWidth.get("Description")));
        col13.setLabelProvider((CellLabelProvider)this.m_provider);
        TableViewerColumn col14 = new TableViewerColumn(this.m_tableViewer, 16384);
        col14.getColumn().setText("Filters");
        col14.getColumn().setWidth(Integer.parseInt("" + m_columnWidth.get("Filters")));
        col14.setLabelProvider((CellLabelProvider)this.m_provider);
        TableViewerColumn col15 = new TableViewerColumn(this.m_tableViewer, 16384);
        col15.getColumn().setText("Enabled Time");
        col15.getColumn().setWidth(Integer.parseInt("" + m_columnWidth.get("Enabled Time")));
        col15.setLabelProvider((CellLabelProvider)this.m_provider);
        m_colIndices = new HashMap();
        m_colNames = new HashMap();
        TableColumn[] cols = this.m_table.getColumns();
        int i = 0;
        while (i < cols.length) {
            TableColumn col = cols[i];
            m_colIndices.put(col.getText(), i);
            m_colNames.put(i, col.getText());
            ++i;
        }
        int[] nArray = new int[16];
        nArray[1] = 1;
        nArray[2] = 2;
        nArray[3] = 5;
        nArray[4] = 3;
        nArray[5] = 4;
        nArray[6] = 6;
        nArray[7] = 7;
        nArray[8] = 8;
        nArray[9] = 15;
        nArray[10] = 9;
        nArray[11] = 10;
        nArray[12] = 11;
        nArray[13] = 12;
        nArray[14] = 13;
        nArray[15] = 14;
        this.m_tableViewer.getTable().setColumnOrder(nArray);
        this.m_tableViewer.setContentProvider((IContentProvider)this.m_provider);
        this.m_tableViewer.setInput((Object)this.m_provider.getElements(null));
        this.m_tableViewer.addDoubleClickListener((IDoubleClickListener)this);
        this.m_tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ScheduledMaintenanceOverviewTab.this.checkButtons();
            }
        });
        FancyToolTipSupport.enableFor((ColumnViewer)this.m_tableViewer, 2);
        this.m_table.setToolTipText("");
        this.m_provider.reloadData();
        this.createPolicyTable_CM();
    }

    public void createPolicyTable_CM() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(false);
        Menu menu = menuMgr.createContextMenu(this.m_tableViewer.getControl());
        this.m_tableViewer.getControl().setMenu(menu);
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                try {
                    int minAccess = ServerPolicyStatus.ACCESS_EDIT_DELETE;
                    boolean activateEnable = false;
                    boolean activateDisable = false;
                    IStructuredSelection ss = (IStructuredSelection)ScheduledMaintenanceOverviewTab.this.m_tableViewer.getSelection();
                    for (ServerPolicyTemplate object : ss) {
                        String id = object.getID();
                        object.getAction();
                        ServerPolicyStatus sp = ScheduledMaintenanceOverviewTab.this.m_provider.getServerPolicyStatus(id);
                        if (sp == null) continue;
                        minAccess = Math.min(sp.m_access, minAccess);
                        if (sp.m_enabled) {
                            activateDisable = true;
                            continue;
                        }
                        activateEnable = true;
                    }
                    manager.add((IAction)new RefreshTableAction());
                    manager.add((IContributionItem)new Separator());
                    manager.add((IAction)new OpenMaintenanceAction(ScheduledMaintenanceOverviewTab.this.m_overviewTab));
                    manager.add((IAction)new CreateMaintenanceAction());
                    DeleteMaintenanceAction delete = new DeleteMaintenanceAction(ScheduledMaintenanceOverviewTab.this.m_tableViewer);
                    if (minAccess < ServerPolicyStatus.ACCESS_EDIT_DELETE) {
                        delete.setEnabled(false);
                    }
                    manager.add((IAction)delete);
                    manager.add((IContributionItem)new Separator());
                    if (activateEnable) {
                        EnableMaintenanceAction enable = new EnableMaintenanceAction();
                        if (minAccess < ServerPolicyStatus.ACCESS_ENABLE_DISABLE) {
                            enable.setEnabled(false);
                        }
                        manager.add((IAction)enable);
                    }
                    if (activateDisable) {
                        DisableMaintenanceAction disable = new DisableMaintenanceAction(0);
                        if (minAccess < ServerPolicyStatus.ACCESS_ENABLE_DISABLE) {
                            disable.setEnabled(false);
                        }
                        manager.add((IAction)disable);
                        DisableMaintenanceAction disable_publish = new DisableMaintenanceAction(5);
                        if (minAccess < ServerPolicyStatus.ACCESS_ENABLE_DISABLE) {
                            disable_publish.setEnabled(false);
                        }
                        manager.add((IAction)disable_publish);
                        DisableMaintenanceAction disable_drop = new DisableMaintenanceAction(1);
                        if (minAccess < ServerPolicyStatus.ACCESS_ENABLE_DISABLE) {
                            disable_drop.setEnabled(false);
                        }
                        manager.add((IAction)disable_drop);
                    }
                    manager.add((IContributionItem)new Separator());
                    try {
                        final OutagePolicy sp = (OutagePolicy)ss.getFirstElement();
                        manager.add((IAction)new Action(){

                            public String getText() {
                                return "Show Indications";
                            }

                            public void run() {
                                if (sp != null) {
                                    MaintenanceView.showMaintenanceTab(sp.getID(), sp.getName(), sp.getName());
                                }
                            }

                            public boolean isEnabled() {
                                return sp != null;
                            }

                            public ImageDescriptor getImageDescriptor() {
                                return BMUI.IMAGE_DESC_INDICATIONS;
                            }
                        });
                    }
                    catch (Throwable throwable) {}
                }
                catch (RuntimeException e) {
                    RTLogger.print(5, "Error creating context menu", e);
                }
            }
        });
    }

    public void refresh() {
        this.m_provider.reloadData();
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
        String name = "";
        if (!(e.getSource() instanceof Table) && e.getSource() instanceof Button) {
            Button b = (Button)e.getSource();
            name = (String)b.getData();
            if (name.equals(REFRESH_BTN)) {
                this.refresh();
            } else if (name.equals(BUTTON_TOP)) {
                int selected = this.m_table.getSelectionIndex();
                if (selected > 0) {
                    OutagePolicy op = (OutagePolicy)this.m_table.getItem(selected).getData();
                    this.m_provider.order(op.getID(), Integer.MIN_VALUE);
                }
            } else if (name.equals(BUTTON_BOTTOM)) {
                int selected = this.m_table.getSelectionIndex();
                if (selected > -1 && selected < this.m_provider.getOutagePoliciesCount() - 1) {
                    OutagePolicy op = (OutagePolicy)this.m_table.getItem(selected).getData();
                    this.m_provider.order(op.getID(), Integer.MAX_VALUE);
                }
            } else if (name.equals(BUTTON_UP)) {
                int selected = this.m_table.getSelectionIndex();
                if (selected > 0) {
                    OutagePolicy op = (OutagePolicy)this.m_table.getItem(selected).getData();
                    this.m_provider.order(op.getID(), -1);
                }
            } else if (name.equals(BUTTON_DOWN)) {
                int selected = this.m_table.getSelectionIndex();
                if (selected > -1 && selected < this.m_provider.getOutagePoliciesCount() - 1) {
                    OutagePolicy op = (OutagePolicy)this.m_table.getItem(selected).getData();
                    this.m_provider.order(op.getID(), 1);
                }
            } else if (name.equals(BUTTON_SAVE_ORDER)) {
                this.m_provider.saveOrder();
            } else if (name.equals(BUTTON_UNDO_ORDER)) {
                this.m_provider.m_newOrder.clear();
                this.m_provider.reloadData();
            } else if (name.equals(BUTTON_DELETE)) {
                DeleteMaintenanceAction del = new DeleteMaintenanceAction(this.m_tableViewer);
                del.run();
            } else if (name.equals(BUTTON_CREATE)) {
                CreateMaintenanceAction cn = new CreateMaintenanceAction();
                cn.run();
            } else if (name.equals(SHOWALL)) {
                LinkedList<ViewerFilter> toAdd = new LinkedList<ViewerFilter>();
                ViewerFilter[] viewerFilterArray = this.m_tableViewer.getFilters();
                int n = viewerFilterArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ViewerFilter vf = viewerFilterArray[n2];
                    if (!(vf instanceof StatusViewFilter)) {
                        toAdd.add(vf);
                    }
                    ++n2;
                }
                this.m_tableViewer.setFilters(toAdd.toArray(new ViewerFilter[0]));
            } else if (name.equals(SHOWENABLED)) {
                LinkedList<ViewerFilter> toAdd = new LinkedList<ViewerFilter>();
                ViewerFilter[] viewerFilterArray = this.m_tableViewer.getFilters();
                int n = viewerFilterArray.length;
                int n3 = 0;
                while (n3 < n) {
                    ViewerFilter vf = viewerFilterArray[n3];
                    if (!(vf instanceof StatusViewFilter)) {
                        toAdd.add(vf);
                    }
                    ++n3;
                }
                StatusViewFilter svf = new StatusViewFilter(this.m_provider, true);
                toAdd.add(svf);
                this.m_tableViewer.setFilters(toAdd.toArray(new ViewerFilter[0]));
            } else if (name.equals(SHOWDISABLED)) {
                LinkedList<ViewerFilter> toAdd = new LinkedList<ViewerFilter>();
                ViewerFilter[] viewerFilterArray = this.m_tableViewer.getFilters();
                int n = viewerFilterArray.length;
                int n4 = 0;
                while (n4 < n) {
                    ViewerFilter vf = viewerFilterArray[n4];
                    if (!(vf instanceof StatusViewFilter)) {
                        toAdd.add(vf);
                    }
                    ++n4;
                }
                StatusViewFilter svf = new StatusViewFilter(this.m_provider, false);
                toAdd.add(svf);
                this.m_tableViewer.setFilters(toAdd.toArray(new ViewerFilter[0]));
            }
        }
        this.checkButtons();
    }

    @Override
    protected void checkButtons() {
        this.m_gui.enableField(this.m_save_Button, !this.isReadOnly() && !this.m_provider.isNewOrderSaved());
        this.m_gui.enableField(this.m_undo_Button, !this.isReadOnly() && !this.m_provider.isNewOrderSaved());
        this.m_gui.enableField(this.m_add_btn, !this.isReadOnly());
        this.m_gui.enableField(this.m_del_btn, !this.isReadOnly() && this.m_table.getSelectionCount() > 0);
        this.m_gui.enableField(this.m_top_Button, !this.isReadOnly() && this.m_table.getSelectionCount() > 0);
        this.m_gui.enableField(this.m_up_Button, !this.isReadOnly() && this.m_table.getSelectionCount() > 0);
        this.m_gui.enableField(this.m_bottom_Button, !this.isReadOnly() && this.m_table.getSelectionCount() > 0);
        this.m_gui.enableField(this.m_down_Button, !this.isReadOnly() && this.m_table.getSelectionCount() > 0);
    }

    public void doubleClick(DoubleClickEvent event) {
        TableViewer tv;
        String type;
        Object obj = event.getSource();
        if (obj instanceof TableViewer && (type = (String)(tv = (TableViewer)obj).getData(VIEWER_TYPE)).equals(VIEWER_TYPE_OVERVIEW)) {
            OpenMaintenanceAction openAction = new OpenMaintenanceAction(this.m_overviewTab);
            openAction.run();
        }
    }

    public void dispose() {
        Repository.getInstance().getCmdRouter().removeCmdListener("GET_SERVER_POLICIES_STATUS", this);
        super.dispose();
    }

    public TableViewer getTableViewer() {
        return this.m_tableViewer;
    }

    public AgentMaintenanceTableProvider getTableProvider() {
        return this.m_provider;
    }

    public void setTableViewer(TableViewer tableViewer) {
        this.m_tableViewer = tableViewer;
    }

    private class CreateMaintenanceAction
    extends Action {
        public CreateMaintenanceAction() {
            super("AddScheduledMaintenance");
            this.setId("addscheduledmaintenance");
            this.setText("Add Maintenance");
            if (Repository.getInstance().getRights(2010) < 3) {
                this.setEnabled(false);
                return;
            }
        }

        public void run() {
            if (!this.isEnabled()) {
                return;
            }
            AgentScheduledMaintenanceView.displayTab(null, ScheduledMaintenanceOverviewTab.this.m_server);
        }
    }

    private class DeleteMaintenanceAction
    extends Action {
        private IStructuredSelection ssel;

        public DeleteMaintenanceAction(TableViewer tv) {
            super("DeleteScheduledMaintenance");
            this.ssel = null;
            this.setId("deletescheduledmaintenance");
            this.setText("Delete Maintenance");
            ISharedImages sharedImages = Activator.getDefault().getWorkbench().getActiveWorkbenchWindow().getWorkbench().getSharedImages();
            this.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_DELETE"));
            this.setDisabledImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_DELETE_DISABLED"));
            if (Repository.getInstance().getRights(2010) < 3 || tv == null || tv.getSelection() == null || tv.getSelection().isEmpty()) {
                this.setEnabled(false);
                return;
            }
            this.ssel = (IStructuredSelection)tv.getSelection();
        }

        public void run() {
            if (!this.isEnabled()) {
                return;
            }
            LinkedList<String> ids = new LinkedList<String>();
            LinkedList<ServerPolicyTemplate> elements = new LinkedList<ServerPolicyTemplate>();
            for (ServerPolicyTemplate object : this.ssel) {
                ids.add(object.getID());
                elements.add(object);
            }
            String header = "Do you want to delete the following Scheduled Maintenance:";
            String footer = String.valueOf(elements.size()) + " Scheduled Maintenance to delete!";
            String title = "   Delete Scheduled Maintenance";
            String noElementsText = "No Scheduled Maintenance to delete!";
            ShowMessageDialog md = new ShowMessageDialog(new Shell(Display.getCurrent().getActiveShell()), title, header, footer, true, "Delete", elements, noElementsText);
            md.setBlockOnOpen(true);
            md.open();
            if (md.getReturnCode() == 0) {
                ScheduledMaintenanceOverviewTab.this.m_provider.deletePolicy(ids);
                int i = 0;
                while (i < ids.size()) {
                    String id = (String)ids.get(i);
                    AgentScheduledMaintenanceView.closeTab(id);
                    ++i;
                }
            }
        }
    }

    private class DisableMaintenanceAction
    extends Action {
        private int m_overridePostAction;
        private IStructuredSelection ssel;

        public DisableMaintenanceAction(int overridePostAction) {
            super("disableScheduledMaintenance" + overridePostAction);
            this.m_overridePostAction = 0;
            this.ssel = null;
            this.setId("disablescheduledmaintenance" + overridePostAction);
            switch (overridePostAction) {
                case 1: {
                    this.setText("Disable + Drop Indications");
                    break;
                }
                case 5: {
                    this.setText("Disable + Publish Indications");
                    break;
                }
                default: {
                    this.setText("Disable");
                }
            }
            this.m_overridePostAction = overridePostAction;
            this.ssel = (IStructuredSelection)ScheduledMaintenanceOverviewTab.this.m_tableViewer.getSelection();
            if (Repository.getInstance().getRights(2010) < 3 || this.ssel == null || this.ssel.isEmpty()) {
                this.setEnabled(false);
                return;
            }
        }

        public void run() {
            if (!this.isEnabled()) {
                return;
            }
            LinkedList<String> ids = new LinkedList<String>();
            for (ServerPolicyTemplate object : this.ssel) {
                ids.add(object.getID());
            }
            ScheduledMaintenanceOverviewTab.this.m_provider.disablePolicies(ids, this.m_overridePostAction);
        }
    }

    private class EnableMaintenanceAction
    extends Action {
        private IStructuredSelection ssel;

        public EnableMaintenanceAction() {
            super("EnableScheduledMaintenance");
            this.ssel = null;
            this.setId("enablescheduledmaintenance");
            this.setText("Enable");
            this.ssel = (IStructuredSelection)ScheduledMaintenanceOverviewTab.this.m_tableViewer.getSelection();
            if (Repository.getInstance().getRights(2010) < 3 || this.ssel == null || this.ssel.isEmpty()) {
                this.setEnabled(false);
                return;
            }
        }

        public void run() {
            if (!this.isEnabled()) {
                return;
            }
            LinkedList<String> ids = new LinkedList<String>();
            for (ServerPolicyTemplate object : this.ssel) {
                ids.add(object.getID());
            }
            ScheduledMaintenanceOverviewTab.this.m_provider.enablePolicies(ids);
        }
    }

    private class OpenMaintenanceAction
    extends Action {
        private ScheduledMaintenanceOverviewTab tab;
        private Iterator iterator;

        public OpenMaintenanceAction(ScheduledMaintenanceOverviewTab overviewTab) {
            super("openScheduledMaintenance");
            this.tab = null;
            this.iterator = null;
            this.setId("openscheduledMaintenance");
            this.setText("Open Maintenance");
            if (Repository.getInstance().getRights(2010) < 2 || overviewTab == null) {
                this.setEnabled(false);
                return;
            }
            StructuredSelection ssel = null;
            try {
                ssel = (StructuredSelection)overviewTab.getTableViewer().getSelection();
            }
            catch (Exception exception) {}
            if (ssel == null || ssel.isEmpty()) {
                this.setEnabled(false);
                return;
            }
            this.tab = overviewTab;
            this.iterator = ssel.iterator();
        }

        /*
         * Unable to fully structure code
         */
        public void run() {
            if (this.isEnabled()) ** GOTO lbl7
            return;
lbl-1000:
            // 1 sources

            {
                op = (OutagePolicy)this.iterator.next();
                sps = this.tab.m_provider.getServerPolicyStatus(op.getID());
                if (sps == null || sps.m_access < ServerPolicyStatus.ACCESS_READONLY) continue;
                AgentScheduledMaintenanceView.displayTab(op, this.tab.m_server);
lbl7:
                // 3 sources

                ** while (this.iterator.hasNext())
            }
lbl8:
            // 1 sources

        }
    }

    private class RefreshTableAction
    extends Action {
        public RefreshTableAction() {
            super("refreshtableSP");
            this.setId("refreshtableSP");
            this.setText("Refresh");
            this.setImageDescriptor(BMUI.IMAGE_DESCR_REFRESH);
        }

        public void run() {
            ScheduledMaintenanceOverviewTab.this.refresh();
        }
    }
}

