/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.views.outages;

import com.blixx.boom.engine.BMUI;
import com.blixx.boom.engine.Repository;
import com.blixx.boom.gui.views.outages.AgentScheduledMaintenanceView;
import com.blixx.boom.gui.views.outages.OutagePoliciesManager;
import com.blixx.boom.gui.views.outages.ScheduledMaintenanceDetailsComposite;
import com.blixx.shared.ext.OutagePolicy;
import com.blixx.shared.ext.ServerPolicyStatus;
import java.util.UUID;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class ScheduledMaintenanceTab
extends CTabItem {
    public OutagePolicy m_policy = null;
    private ScheduledMaintenanceDetailsComposite m_detailsComposite = null;
    public String m_server = null;

    public ScheduledMaintenanceTab(OutagePolicy p, CTabFolder parent, int style, String server) {
        super(parent, style);
        this.m_server = server;
        this.init(p);
    }

    public ScheduledMaintenanceTab(OutagePolicy p, CTabFolder parent, int style, int index, String server) {
        super(parent, style, index);
        this.m_server = server;
        this.init(p);
    }

    public void init(OutagePolicy p) {
        if (p == null) {
            p = new OutagePolicy(UUID.randomUUID().toString(), "New_Maintenance_" + System.currentTimeMillis());
        }
        this.m_policy = p;
        this.setData("TABID", p.getID());
        this.setImage(BMUI.IMAGE_OUTAGE);
        if (this.m_server != null && this.m_server.length() > 0) {
            this.setText(String.valueOf(this.m_policy.getName()) + "@@" + this.m_server);
        } else {
            this.setText(this.m_policy.getName());
        }
        this.m_detailsComposite = new ScheduledMaintenanceDetailsComposite(this, (Composite)this.getParent(), 0);
        this.m_detailsComposite.setServerPolicy(this.m_policy, this.isReadOnly(), this.m_server);
        this.setControl((Control)this.m_detailsComposite);
        AgentScheduledMaintenanceView.addTab(this);
    }

    public boolean isDirty() {
        return this.m_detailsComposite.isDirty();
    }

    public ScheduledMaintenanceDetailsComposite getDetailComposite() {
        return this.m_detailsComposite;
    }

    public void dispose() {
        super.dispose();
        this.m_detailsComposite.dispose();
        AgentScheduledMaintenanceView.closeTab(this.m_policy.getID());
    }

    public boolean isReadOnly() {
        boolean isReadOnly = false;
        if (Repository.getInstance().getRights(2010) < 3) {
            isReadOnly = true;
        } else {
            ServerPolicyStatus s = OutagePoliciesManager.getInstance().getServerPolicyStatus(this.m_policy.getID());
            if (s != null && s.m_access <= ServerPolicyStatus.ACCESS_READONLY) {
                isReadOnly = true;
            }
        }
        return isReadOnly;
    }
}

