/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.views.outages;

import com.blixx.boom.engine.BMUI;
import com.blixx.boom.engine.Repository;
import com.blixx.boom.gui.dialogs.ShowMessageBox;
import com.blixx.boom.gui.utils.ImageCombo;
import com.blixx.boom.gui.views.outages.AbstractMaintenanceDetailsComposite;
import com.blixx.boom.gui.views.outages.ServerPolicyView;
import com.blixx.ctrl.sc.ServerClient;
import com.blixx.ctrl.sc.in.ScSaveModifyServerPolicies;
import com.blixx.ctrl.sc.in.ScSaveModifyServerPoliciesSlave;
import com.blixx.shared.ext.ModifyServerPolicy;
import com.blixx.shared.ext.ServerPolicyTemplate;
import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.jface.bindings.keys.ParseException;
import org.eclipse.jface.fieldassist.ContentProposalAdapter;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.fieldassist.SimpleContentProposalProvider;
import org.eclipse.jface.fieldassist.TextContentAdapter;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class ServerPolicyDetailsComposite
extends AbstractMaintenanceDetailsComposite {
    protected static final String SP_SET_TEXT = "SP_SET_TEXT";
    protected static final String SP_SET_OBJ = "SP_SET_OBJ";
    protected static final String SP_SET_GRP = "SP_SET_GRP";
    protected static final String SP_SET_APP = "SP_SET_APP";
    protected static final String SP_SET_HOST = "SP_SET_HOST";
    public static final String CC_SEVERITY = "CC_SEVERITY";
    public static String[] SEVERITY_LIST = new String[]{"", "critical", "major", "minor", "warning", "normal", "unknown"};
    protected static HashMap<String, Image> m_severityList = new HashMap();
    ModifyServerPolicy m_sp = null;
    protected Text m_mSetApp;
    protected Text m_mSetGrp;
    protected Text m_mSetObj;
    protected Text m_mSetTxt;
    protected Text m_mSetHost;
    protected ImageCombo m_condSeverity_Combo;
    protected boolean m_ignoreModifyTextEvents = false;
    public String m_server = null;
    protected Composite m_compLeft;
    protected Composite m_compRight;

    static {
        m_severityList.put("critical", BMUI.IMAGE_CRITICAL);
        m_severityList.put("major", BMUI.IMAGE_MAJOR);
        m_severityList.put("minor", BMUI.IMAGE_MINOR);
        m_severityList.put("warning", BMUI.IMAGE_WARNING);
        m_severityList.put("normal", BMUI.IMAGE_NORMAL);
        m_severityList.put("unknown", BMUI.IMAGE_UNKNOWN);
        m_severityList.put("", BMUI.IMAGE_TRANSPARENT_12x12);
    }

    public ServerPolicyDetailsComposite(CTabItem cTab, Composite parent, int style, String server) {
        super(cTab, parent, style);
        this.m_server = server;
    }

    public void setServerPolicy(ModifyServerPolicy sp, boolean isReadOnly) {
        this.m_sp = sp;
        this.setReadOnly(isReadOnly);
        this.update();
        this.setDirty(false);
        if (this.isReadOnly()) {
            this.setTabReadOnly();
        }
        this.validate();
    }

    @Override
    public void init() {
        GridLayout gl = new GridLayout(1, false);
        gl.horizontalSpacing = 0;
        gl.verticalSpacing = 0;
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        this.setLayout((Layout)gl);
        this.setLayoutData(new GridData(4, 4, true, true));
        this.m_sc = new ScrolledComposite((Composite)this, 2816);
        this.m_sc.setAlwaysShowScrollBars(false);
        this.m_sc.setExpandHorizontal(true);
        this.m_sc.setExpandVertical(true);
        gl = new GridLayout(1, false);
        gl.horizontalSpacing = 0;
        gl.verticalSpacing = 0;
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        this.m_sc.setLayout((Layout)gl);
        this.m_sc.setLayoutData((Object)new GridData(4, 4, true, true));
        this.m_comp_main = new Composite((Composite)this.m_sc, 0);
        gl = new GridLayout(2, true);
        gl.verticalSpacing = 0;
        gl.marginWidth = 0;
        gl.horizontalSpacing = 25;
        this.m_comp_main.setLayout((Layout)gl);
        this.m_comp_main.setLayoutData((Object)new GridData(4, 4, true, true));
        this.m_compLeft = new Composite(this.m_comp_main, 0);
        this.m_compLeft.setLayout((Layout)new GridLayout(4, false));
        this.m_compLeft.setLayoutData((Object)new GridData(4, 4, true, true));
        this.m_mSpID = this.m_gui.addTextReadOnly(this.m_compLeft, "ID: ", "", 1, 1, 0, 0, null, null);
        this.m_mSpOwner = this.m_gui.addTextReadOnly(this.m_compLeft, "Owner: ", "", 1, 1, 0, 0, null, null);
        this.m_mSpName = this.m_gui.addInputFieldSingle(this.m_compLeft, "SPName", "Name: ", "", 3, 1, 0, 0, 100, this);
        this.m_mSpDescr = this.m_gui.addInputFieldMultiLineWrap(this.m_compLeft, "SPDescr", "Description: ", "", 3, 1, 100, 100, 0, 0, this);
        this.createFilterTable(this.m_compLeft);
        this.m_compRight = new Composite(this.m_comp_main, 0);
        this.m_compRight.setLayout((Layout)new GridLayout(2, false));
        this.m_compRight.setLayoutData((Object)new GridData(4, 4, true, true));
        this.m_mSetHost = this.m_gui.addInputFieldSingle(this.m_compRight, SP_SET_HOST, "Set Host: ", "", 1, 1, 0, 0, 100, this);
        this.m_condSeverity_Combo = this.m_gui.addDropDownWithImage(this.m_compRight, CC_SEVERITY, "Set Severity: ", m_severityList, SEVERITY_LIST, null, null, 1, 1, 0, 0, this);
        ((GridData)this.m_condSeverity_Combo.getLayoutData()).widthHint = 100;
        ((GridData)this.m_condSeverity_Combo.getLayoutData()).horizontalAlignment = 16384;
        this.m_condSeverity_Combo.setEditable(false);
        this.m_condSeverity_Combo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ServerPolicyDetailsComposite.this.setDirty(true);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.m_mSetApp = this.m_gui.addInputFieldSingle(this.m_compRight, SP_SET_APP, "Set Application: ", "", 1, 1, 0, 0, 100, this);
        this.m_mSetGrp = this.m_gui.addInputFieldSingle(this.m_compRight, SP_SET_GRP, "Set Group: ", "", 1, 1, 0, 0, 100, this);
        this.m_mSetObj = this.m_gui.addInputFieldSingle(this.m_compRight, SP_SET_OBJ, "Set Object: ", "", 1, 1, 0, 0, 100, this);
        this.m_mSetTxt = this.m_gui.addInputFieldMultiLineWrap(this.m_compRight, SP_SET_TEXT, "Set Text: ", "", 1, 1, 100, 100, 0, 0, this);
        this.createContentAssist((Control)this.m_mSetHost);
        this.createContentAssist((Control)this.m_mSetApp);
        this.createContentAssist((Control)this.m_mSetGrp);
        this.createContentAssist((Control)this.m_mSetObj);
        this.createContentAssist((Control)this.m_mSetTxt);
        this.m_sc.setContent((Control)this.m_comp_main);
        this.m_sc.setMinSize(this.m_comp_main.computeSize(-1, -1, true));
        Composite compLine = new Composite((Composite)this, 0);
        gl = new GridLayout(1, false);
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        compLine.setLayout((Layout)gl);
        compLine.setLayoutData((Object)new GridData(4, 128, true, false));
        Label line = new Label(compLine, 259);
        line.setForeground(BMUI.color_darkGrey2);
        line.setLayoutData((Object)new GridData(4, 128, true, false));
        Composite buttons = new Composite((Composite)this, 0);
        buttons.setLayout((Layout)new GridLayout(3, true));
        buttons.setLayoutData((Object)new GridData(16384, 4, false, false));
        this.m_save = this.m_gui.addButton(buttons, "SAVE_BTN", "Save Policy", false, 90, 30, 0, 8, this);
        this.m_save.setLayoutData((Object)new GridData(4, 128, false, false));
        this.m_undo = this.m_gui.addButton(buttons, "UNDO_BTN", "Undo Changes", false, 90, 30, 0, 8, this);
        this.m_undo.setLayoutData((Object)new GridData(4, 128, false, false));
        this.m_mSpReadOnly = this.m_gui.addTextReadOnlyNoBorder(buttons, null, "Read Only!", 1, 1, 0, 0, null);
        ((GridData)this.m_mSpReadOnly.getLayoutData()).horizontalAlignment = 4;
        this.m_mSpReadOnly.setFont(BMUI.font_arial8_bold);
        this.m_mSpReadOnly.setForeground(BMUI.color_critical);
        this.m_mSpReadOnly.setVisible(this.isReadOnly());
        if (this.isReadOnly()) {
            Control[] controlArray = this.m_sc.getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control ctrl = controlArray[n2];
                this.m_gui.enableFieldRecursive(ctrl, false, null);
                ++n2;
            }
        }
    }

    public void modifyText(ModifyEvent e) {
        Text field;
        String fieldName;
        if (this.m_ignoreModifyTextEvents) {
            return;
        }
        if (e.getSource() instanceof Text && (fieldName = (String)(field = (Text)e.getSource()).getData()).equals("SPName")) {
            String text = field.getText().trim();
            if (this.m_server != null && this.m_server.length() > 0) {
                this.m_cTab.setText(String.valueOf(text) + "@@" + this.m_server);
            } else {
                this.m_cTab.setText(text);
            }
            this.m_mSpName.setToolTipText(null);
        }
        this.setDirty(true);
    }

    public void update() {
        this.m_ignoreModifyTextEvents = true;
        try {
            if (this.m_sp == null) {
                this.m_fp.setFilters(null);
                this.m_mSpID.setText("");
                this.m_mSpName.setText("");
                this.m_mSpOwner.setText("");
                this.m_mSpDescr.setText("");
                this.m_mSetApp.setText("");
                this.m_mSetGrp.setText("");
                this.m_mSetObj.setText("");
                this.m_mSetHost.setText("");
                this.m_mSetTxt.setText("");
                this.m_condSeverity_Combo.setText("unknown");
            } else {
                this.m_fp.setFilters(this.m_sp.getFilters());
                this.m_mSpID.setText(this.m_sp.getID());
                this.m_mSpName.setText(this.m_sp.getName());
                this.m_mSpOwner.setText(this.m_sp.getOwner());
                this.m_mSpDescr.setText(this.m_sp.getDescription());
                this.m_mSetApp.setText(this.m_sp.getSetApplication());
                this.m_mSetGrp.setText(this.m_sp.getSetGroup());
                this.m_mSetObj.setText(this.m_sp.getSetObject());
                this.m_mSetHost.setText(this.m_sp.getSetHost());
                this.m_mSetTxt.setText(this.m_sp.getSetText());
                this.m_condSeverity_Combo.setText(this.m_sp.getSetSeverity());
            }
            this.m_table_filters.setInput((Object)this.m_fp.getElements(null));
        }
        finally {
            this.m_ignoreModifyTextEvents = false;
        }
        this.computeSize(-1, -1);
        super.update();
        this.m_dirty.set(false);
    }

    public void widgetSelected(SelectionEvent e) {
        Button bt;
        if (e.getSource() instanceof Button && (bt = (Button)e.getSource()).getData() != null) {
            String name = (String)bt.getData();
            if ("SAVE_BTN".equals(name)) {
                this.saveServerPolicy(this.m_server);
            } else if ("UNDO_BTN".equals(name)) {
                ServerPolicyView.reOpenTab(this.m_sp, this.m_mSpName.getText().trim(), this.m_parent, this.m_server);
            } else if ("FILTER_DELETE".equals(name)) {
                AbstractMaintenanceDetailsComposite.FilterAction filerAction = new AbstractMaintenanceDetailsComposite.FilterAction(this.m_parent.getShell(), this.m_table_filters, this.m_fp, "FILTER_DELETE");
                filerAction.run();
            } else if ("FILTER_EDIT".equals(name)) {
                AbstractMaintenanceDetailsComposite.FilterAction filerAction = new AbstractMaintenanceDetailsComposite.FilterAction(this.m_parent.getShell(), this.m_table_filters, this.m_fp, "FILTER_EDIT");
                filerAction.run();
            } else if ("FILTER_NEW".equals(name)) {
                AbstractMaintenanceDetailsComposite.FilterAction filerAction = new AbstractMaintenanceDetailsComposite.FilterAction(this.m_parent.getShell(), this.m_table_filters, this.m_fp, "FILTER_NEW");
                filerAction.run();
            }
        }
    }

    @Override
    public boolean saveServerPolicy(String server) {
        ModifyServerPolicy toSave;
        try {
            toSave = new ModifyServerPolicy(this.m_sp.getID(), this.m_sp.getName());
            toSave.setName(this.m_mSpName.getText());
            toSave.setDescription(this.m_mSpDescr.getText());
            toSave.setAction(4);
            toSave.setPostAction(0);
            toSave.setSetApplication(this.m_mSetApp.getText());
            toSave.setSetGroup(this.m_mSetGrp.getText());
            toSave.setSetObject(this.m_mSetObj.getText());
            toSave.setSetHost(this.m_mSetHost.getText());
            toSave.setSetText(this.m_mSetTxt.getText());
            toSave.setSetSeverity(this.m_condSeverity_Combo.getText());
            toSave.setFilters(this.m_fp.getFilters());
        }
        catch (Throwable e) {
            new ShowMessageBox("Error saving Server Policy", e.getMessage(), 1);
            return false;
        }
        ArrayList<ServerPolicyTemplate> tosave = new ArrayList<ServerPolicyTemplate>(1);
        tosave.add(toSave);
        ServerClient sc = null;
        sc = server == null || server.length() == 0 ? new ScSaveModifyServerPolicies(Repository.getInstance(), tosave) : new ScSaveModifyServerPoliciesSlave(Repository.getInstance(), tosave, server);
        sc.run();
        boolean success = sc.isSuccess();
        if (!success) {
            new ShowMessageBox("Error saving Server Policy", sc.getLastException().getMessage(), 1);
        } else {
            this.m_sp = toSave;
            this.setDirty(false);
        }
        return success;
    }

    public SimpleContentProposalProvider createContentAssist(Control ct) {
        String[] proposals = new String[]{"<$AGENT_HOST>", "<$AGENT_ID>", "<$AKEY>", "<$APPLICATION>", "<$DUPLICATES>", "<$FTIME_STR>", "<$GROUP>", "<$HOST>", "<$IID>", "<$KEY>", "<$OBJECT>", "<$SEVERITY>", "<$STIME_STR>", "<$TEXT>", "<$TIME_STR>"};
        char[] autoActivationCharacters = new char[]{};
        SimpleContentProposalProvider defaultProposalProvider = null;
        try {
            KeyStroke keyStroke = KeyStroke.getInstance((String)"Ctrl+Space");
            defaultProposalProvider = new SimpleContentProposalProvider(proposals);
            new ContentProposalAdapter(ct, (IControlContentAdapter)new TextContentAdapter(), (IContentProposalProvider)defaultProposalProvider, keyStroke, autoActivationCharacters);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return defaultProposalProvider;
    }

    public void doubleClick(DoubleClickEvent event) {
        AbstractMaintenanceDetailsComposite.FilterAction filerAction = new AbstractMaintenanceDetailsComposite.FilterAction(this.m_parent.getShell(), this.m_table_filters, this.m_fp, "FILTER_EDIT");
        filerAction.run();
    }

    @Override
    public void validate() {
        this.m_isValid = true;
        if (!this.isReadOnly()) {
            super.validate();
        }
    }

    public void setTabReadOnly() {
        this.m_mSpReadOnly.setVisible(true);
        this.m_gui.enableField(this.m_newF, false);
        this.m_comp_main.setEnabled(false);
    }
}

