/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.views.outages;

import com.blixx.boom.gui.dialogs.ShowMessageBox;
import com.blixx.ctrl.sc.ICmdPostProcess;
import com.blixx.ctrl.sc.ServerClient;
import com.blixx.ctrl.sc.in.ScGetExtendedServerPolicies;
import com.blixx.ctrl.sc.in.ScGetModifyServerPolicies;
import com.blixx.shared.ext.ExtendedServerPolicy;
import com.blixx.shared.ext.ModifyServerPolicy;
import com.blixx.shared.ext.ServerPolicyStatus;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class ServerPolicyManager
implements ICmdPostProcess {
    public Map<String, List<ModifyServerPolicy>> m_slaveModifyPolicies = new ConcurrentHashMap<String, List<ModifyServerPolicy>>();
    public Map<String, Map<String, ServerPolicyStatus>> m_slaveModifyPoliciesStatuses = new ConcurrentHashMap<String, Map<String, ServerPolicyStatus>>();
    private ReentrantReadWriteLock m_lock = new ReentrantReadWriteLock();
    private static ServerPolicyManager m_instance = null;

    public static synchronized ServerPolicyManager getInstance() {
        if (m_instance == null) {
            m_instance = new ServerPolicyManager();
        }
        return m_instance;
    }

    public void reloadData(ServerClient sc) {
        sc.addCmdPostProcess(this);
        sc.start();
    }

    public void postProcess(ServerClient client) {
        if (client instanceof ScGetModifyServerPolicies) {
            ScGetModifyServerPolicies sc = (ScGetModifyServerPolicies)client;
            if (sc.isSuccess()) {
                try {
                    this.m_lock.writeLock().lock();
                    this.m_slaveModifyPolicies.clear();
                    this.m_slaveModifyPoliciesStatuses.clear();
                    List<ModifyServerPolicy> listOP = sc.getServerPolicies();
                    Map<String, ServerPolicyStatus> listSP = sc.getStatuses();
                    for (ModifyServerPolicy op : listOP) {
                        List<ModifyServerPolicy> plist;
                        ServerPolicyStatus sps = listSP.get(op.getID());
                        if (sps == null) continue;
                        String slaveServer = sps.getOption("BOOMSERVER");
                        if (slaveServer == null) {
                            slaveServer = "";
                        }
                        if ((plist = this.m_slaveModifyPolicies.get(slaveServer)) == null) {
                            plist = new LinkedList<ModifyServerPolicy>();
                            this.m_slaveModifyPolicies.put(slaveServer, plist);
                        }
                        plist.add(op);
                        Map<String, ServerPolicyStatus> s = this.m_slaveModifyPoliciesStatuses.get(slaveServer);
                        if (s == null) {
                            s = new LinkedHashMap<String, ServerPolicyStatus>();
                            this.m_slaveModifyPoliciesStatuses.put(slaveServer, s);
                        }
                        s.put(op.getID(), sps);
                    }
                }
                finally {
                    this.m_lock.writeLock().unlock();
                }
            } else {
                new ShowMessageBox("Error", client.getLastException().getMessage(), 1);
            }
        } else if (client instanceof ScGetExtendedServerPolicies) {
            ScGetExtendedServerPolicies sc = (ScGetExtendedServerPolicies)client;
            if (sc.isSuccess()) {
                try {
                    this.m_lock.writeLock().lock();
                    this.m_slaveModifyPolicies.clear();
                    this.m_slaveModifyPoliciesStatuses.clear();
                    List<ExtendedServerPolicy> listOP = sc.getExtServerPolicies();
                    Map<String, ServerPolicyStatus> listSP = sc.getStatuses();
                    for (ExtendedServerPolicy op : listOP) {
                        List<ModifyServerPolicy> plist;
                        ServerPolicyStatus sps = listSP.get(op.getID());
                        if (sps == null) continue;
                        String slaveServer = sps.getOption("BOOMSERVER");
                        if (slaveServer == null) {
                            slaveServer = "";
                        }
                        if ((plist = this.m_slaveModifyPolicies.get(slaveServer)) == null) {
                            plist = new LinkedList<ModifyServerPolicy>();
                            this.m_slaveModifyPolicies.put(slaveServer, plist);
                        }
                        plist.add(op);
                        Map<String, ServerPolicyStatus> s = this.m_slaveModifyPoliciesStatuses.get(slaveServer);
                        if (s == null) {
                            s = new LinkedHashMap<String, ServerPolicyStatus>();
                            this.m_slaveModifyPoliciesStatuses.put(slaveServer, s);
                        }
                        s.put(op.getID(), sps);
                    }
                }
                finally {
                    this.m_lock.writeLock().unlock();
                }
            } else {
                new ShowMessageBox("Error", client.getLastException().getMessage(), 1);
            }
        }
    }

    public List<ModifyServerPolicy> getServerPolicies(String server) {
        List<ModifyServerPolicy> list;
        block7: {
            if (server == null) {
                server = "";
            }
            list = null;
            try {
                this.m_lock.readLock().lock();
                list = this.m_slaveModifyPolicies.get(server);
                if (list != null) break block7;
                this.m_lock.readLock().unlock();
                this.m_lock.writeLock().lock();
                try {
                    list = new LinkedList<ModifyServerPolicy>();
                    this.m_slaveModifyPolicies.put(server, list);
                }
                finally {
                    this.m_lock.writeLock().unlock();
                    this.m_lock.readLock().lock();
                }
            }
            finally {
                this.m_lock.readLock().unlock();
            }
        }
        return list;
    }

    public ServerPolicyStatus getServerPolicyStatus(String server, String id) {
        ServerPolicyStatus sps = null;
        try {
            this.m_lock.readLock().lock();
            Map<String, ServerPolicyStatus> map = this.m_slaveModifyPoliciesStatuses.get(server);
            if (map != null) {
                sps = map.get(id);
            }
        }
        finally {
            this.m_lock.readLock().unlock();
        }
        return sps;
    }

    public ServerPolicyStatus getServerPolicyStatus(String id) {
        ServerPolicyStatus sps = null;
        try {
            this.m_lock.readLock().lock();
            for (Map<String, ServerPolicyStatus> map : this.m_slaveModifyPoliciesStatuses.values()) {
                if (map == null || (sps = map.get(id)) == null) continue;
                break;
            }
        }
        finally {
            this.m_lock.readLock().unlock();
        }
        return sps;
    }
}

