/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.views.outages;

import com.blixx.boom.engine.BMUI;
import com.blixx.boom.engine.ICommandListener;
import com.blixx.boom.engine.Repository;
import com.blixx.boom.gui.Activator;
import com.blixx.boom.gui.dialogs.ShowMessageDialog;
import com.blixx.boom.gui.utils.FilterComposite;
import com.blixx.boom.gui.utils.GUIDisplayElements;
import com.blixx.boom.gui.views.FancyToolTipSupport;
import com.blixx.boom.gui.views.outages.AbstractMaintenanceOverviewTab;
import com.blixx.boom.gui.views.outages.ServerPolicyTableProvider;
import com.blixx.boom.gui.views.outages.ServerPolicyView;
import com.blixx.boom.gui.views.outages.StatusViewFilter;
import com.blixx.log.RTLogger;
import com.blixx.shared.ext.ModifyServerPolicy;
import com.blixx.shared.ext.ServerPolicyStatus;
import com.blixx.shared.ext.ServerPolicyTemplate;
import java.util.HashMap;
import java.util.LinkedList;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IElementComparer;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.ISharedImages;

public class ServerPolicyOverviewTab
extends AbstractMaintenanceOverviewTab
implements SelectionListener,
IDoubleClickListener,
ICommandListener {
    public static final String SHOWDISABLED = "SHOWDISABLED";
    public static final String SHOWENABLED = "SHOWENABLED";
    public static final String SHOWALL = "SHOWALL";
    private static String REFRESH_BTN = "REFRESH_BTN";
    private static String SEARCH_POL_BTN = "SEARCH_POL_BTN";
    public static String VIEWER_TYPE_OVERVIEW = "OVERVIEW";
    public static String VIEWER_TYPE_NONE = "NONE";
    public static String VIEWER_TYPE = "VIEWER_TYPE";
    public static String BUTTON_SAVE_ORDER = "save";
    public static String BUTTON_UNDO_ORDER = "undo";
    public static String BUTTON_UP = "Up";
    public static String BUTTON_DOWN = "Down";
    public static String BUTTON_TOP = "Top";
    public static String BUTTON_BOTTOM = "Bottom";
    public static String BUTTON_CREATE = "create";
    public static String BUTTON_DELETE = "delete";
    private CTabFolder m_folder = null;
    private Composite m_compositeInView = null;
    private Composite m_compMain = null;
    private Composite m_compTable = null;
    private GUIDisplayElements m_gui = null;
    private Composite m_sc = null;
    private Table m_table = null;
    private TableViewer m_tableViewer = null;
    private Button m_refresh_btn = null;
    public Button m_save_Button = null;
    public Button m_undo_Button = null;
    public Button m_up_Button = null;
    public Button m_down_Button = null;
    public Button m_top_Button = null;
    public Button m_bottom_Button = null;
    public Button m_create_Button = null;
    public Button m_delete_Button = null;
    public static HashMap<String, Integer> m_colIndices = null;
    public static HashMap<Integer, String> m_colNames = null;
    public static HashMap<String, Integer> m_columnWidth = new HashMap();
    public ServerPolicyTableProvider m_provider = null;
    public String m_server = "";

    static {
        m_columnWidth.put("ID", 36);
        m_columnWidth.put("Name", 80);
        m_columnWidth.put("Enabled", 20);
        m_columnWidth.put("Enabled by", 80);
        m_columnWidth.put("Disabled by", 80);
        m_columnWidth.put("Filters", 200);
        m_columnWidth.put("Description", 100);
        m_columnWidth.put("Set Application", 100);
        m_columnWidth.put("Set Group", 100);
        m_columnWidth.put("Set Object", 100);
        m_columnWidth.put("Set Host", 100);
        m_columnWidth.put("Set Severity", 50);
        m_columnWidth.put("Set Text", 100);
    }

    public ServerPolicyOverviewTab(CTabFolder parent, int style, String serverName) {
        super(parent, style);
        this.m_folder = parent;
        String tabID = "OVERVIEW";
        if (serverName == null || serverName.length() == 0) {
            this.setText("Overview");
        } else {
            this.m_server = serverName;
            this.setText("Overview@@" + serverName);
            tabID = "OVERVIEW@@+serverName";
        }
        this.setImage(BMUI.IMAGE_MODIFYPOL);
        this.setData("TABID", tabID);
        this.createMainArea();
        if (Repository.getInstance().getRights(2012) > 1) {
            Repository.getInstance().getCmdRouter().addCmdListener("GET_SERVER_POLICIES_STATUS_MOD", this);
        }
    }

    @Override
    public void onCommand(String command, String action) {
        this.refresh();
    }

    public void createMainArea() {
        this.m_gui = new GUIDisplayElements();
        this.m_compositeInView = new Composite((Composite)this.m_folder, 0);
        GridLayout gl = new GridLayout(1, false);
        gl.verticalSpacing = 0;
        gl.horizontalSpacing = 0;
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        this.m_compositeInView.setLayout((Layout)gl);
        this.m_sc = new Composite(this.m_compositeInView, 0);
        this.m_sc.setLayout((Layout)gl);
        this.m_sc.setLayoutData((Object)new GridData(4, 4, true, true));
        this.m_compMain = new Composite(this.m_sc, 2048);
        gl = new GridLayout(4, false);
        gl.verticalSpacing = 0;
        this.m_compMain.setLayout((Layout)gl);
        this.m_compMain.setLayoutData((Object)new GridData(4, 4, true, true));
        Group filterGroupOnStatus = new Group(this.m_compMain, 0);
        filterGroupOnStatus.setText("Filter on Status");
        filterGroupOnStatus.setLayout((Layout)new GridLayout(3, false));
        GridData gdb = new GridData(4, 4, false, false);
        gdb.minimumWidth = 100;
        filterGroupOnStatus.setLayoutData((Object)gdb);
        Button showAll = this.m_gui.addRadioButton((Composite)filterGroupOnStatus, SHOWALL, "All", true, 1, 1, 0, 0, this);
        showAll.setLayoutData((Object)new GridData(1, 0x1000000, false, true));
        Button showEnabled = this.m_gui.addRadioButton((Composite)filterGroupOnStatus, SHOWENABLED, "Enabled", false, 1, 1, 0, 0, this);
        showEnabled.setLayoutData((Object)new GridData(1, 0x1000000, false, true));
        Button showDisabled = this.m_gui.addRadioButton((Composite)filterGroupOnStatus, SHOWDISABLED, "Disabled", false, 1, 1, 0, 0, this);
        showDisabled.setLayoutData((Object)new GridData(1, 0x1000000, false, true));
        Group filterGroup = new Group(this.m_compMain, 0);
        filterGroup.setText("Filter");
        gl = new GridLayout(3, false);
        gl.horizontalSpacing = 0;
        gl.marginWidth = 0;
        filterGroup.setLayout((Layout)gl);
        GridData gd = new GridData(4, 4, true, false, 2, 1);
        gd.minimumWidth = 100;
        filterGroup.setLayoutData((Object)gd);
        FilterComposite filterComp = new FilterComposite((Composite)filterGroup, this);
        filterComp.setCompositeLayoutData(new GridData(4, 0x1000000, true, true));
        Composite compBtn_refresh = new Composite(this.m_compMain, 0);
        compBtn_refresh.setLayout((Layout)new GridLayout(1, false));
        compBtn_refresh.setLayoutData((Object)new GridData(4, 4, true, false));
        this.m_refresh_btn = this.m_gui.addButton(compBtn_refresh, REFRESH_BTN, "Refresh ", true, 35, 20, 0, this);
        this.m_refresh_btn.setImage(BMUI.IMAGE_REFRESH_14x14);
        ((GridData)this.m_refresh_btn.getLayoutData()).horizontalAlignment = 4;
        ((GridData)this.m_refresh_btn.getLayoutData()).verticalAlignment = 0x1000000;
        ((GridData)this.m_refresh_btn.getLayoutData()).grabExcessHorizontalSpace = true;
        ((GridData)this.m_refresh_btn.getLayoutData()).verticalIndent = 7;
        this.m_compTable = new Composite(this.m_compMain, 0);
        gl = new GridLayout(1, false);
        gl.verticalSpacing = 0;
        gl.horizontalSpacing = 0;
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        this.m_compTable.setLayout((Layout)gl);
        this.m_compTable.setLayoutData((Object)new GridData(4, 4, true, true, 3, 1));
        this.createTable();
        Composite buttons = new Composite(this.m_compMain, 0);
        gl = new GridLayout(1, true);
        gl.verticalSpacing = 3;
        buttons.setLayout((Layout)gl);
        GridData gdB = new GridData(4, 4, false, true);
        buttons.setLayoutData((Object)gdB);
        new Label(buttons, 0);
        this.m_top_Button = this.m_gui.addButton(buttons, BUTTON_TOP, BUTTON_TOP, false, 35, 20, 1, this);
        this.m_top_Button.setLayoutData((Object)new GridData(4, 128, true, false, 1, 1));
        this.m_up_Button = this.m_gui.addButton(buttons, BUTTON_UP, " Up ", false, 35, 20, 1, this);
        this.m_up_Button.setLayoutData((Object)new GridData(4, 128, true, false, 1, 1));
        this.m_down_Button = this.m_gui.addButton(buttons, BUTTON_DOWN, " Down ", false, 35, 20, 1, this);
        this.m_down_Button.setLayoutData((Object)new GridData(4, 128, true, false, 1, 1));
        this.m_bottom_Button = this.m_gui.addButton(buttons, BUTTON_BOTTOM, BUTTON_BOTTOM, false, 35, 20, 1, this);
        this.m_bottom_Button.setLayoutData((Object)new GridData(4, 128, true, false, 1, 1));
        new Label(buttons, 0);
        this.m_undo_Button = this.m_gui.addButton(buttons, BUTTON_UNDO_ORDER, "Undo Order", false, 35, 20, 1, this);
        this.m_undo_Button.setLayoutData((Object)new GridData(4, 128, true, false, 1, 1));
        this.m_save_Button = this.m_gui.addButton(buttons, BUTTON_SAVE_ORDER, "Save Order", false, 35, 20, 1, this);
        this.m_save_Button.setLayoutData((Object)new GridData(4, 128, true, false, 1, 1));
        Composite compBtn_footer = new Composite(this.m_compMain, 0);
        gl = new GridLayout(3, true);
        gl.marginWidth = 0;
        compBtn_footer.setLayout((Layout)gl);
        compBtn_footer.setLayoutData((Object)new GridData(16384, 4, false, false));
        this.m_create_Button = this.m_gui.addButton(compBtn_footer, BUTTON_CREATE, "Create Policy", !this.isReadOnly(), 35, 20, 0, this);
        this.m_delete_Button = this.m_gui.addButton(compBtn_footer, BUTTON_DELETE, "Delete Policy", false, 35, 20, 0, this);
        if (this.isReadOnly()) {
            Text readOnly = this.m_gui.addTextReadOnlyNoBorder(compBtn_footer, null, "Read Only!", 1, 1, 0, 0, null);
            ((GridData)readOnly.getLayoutData()).horizontalAlignment = 4;
            readOnly.setFont(BMUI.font_arial8_bold);
            readOnly.setForeground(BMUI.color_critical);
        }
        this.setControl((Control)this.m_compositeInView);
    }

    public boolean isReadOnly() {
        int rights = Repository.getInstance().getRights(2012);
        return rights < 3;
    }

    protected void createTable() {
        GridData gd = null;
        GridLayout gl = null;
        this.m_table = new Table(this.m_compTable, 68354);
        this.m_table.setHeaderVisible(true);
        this.m_table.setLinesVisible(true);
        gl = new GridLayout();
        gl.verticalSpacing = 0;
        this.m_table.setLayout((Layout)gl);
        gd = new GridData(4, 4, true, true, 1, 1);
        gd.verticalIndent = 5;
        gd.heightHint = 50;
        this.m_table.setLayoutData((Object)gd);
        this.m_tableViewer = new TableViewer(this.m_table);
        this.m_tableViewer.setData(VIEWER_TYPE, (Object)VIEWER_TYPE_OVERVIEW);
        this.m_provider = new ServerPolicyTableProvider(this.m_tableViewer, this, this.m_server);
        this.m_tableViewer.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                if (element instanceof ServerPolicyTemplate) {
                    ServerPolicyTemplate spt = (ServerPolicyTemplate)element;
                    String id = spt.getID();
                    ServerPolicyStatus st = ServerPolicyOverviewTab.this.m_provider.getServerPolicyStatus(id);
                    if (st.m_access <= ServerPolicyStatus.ACCESS_INVISIBLE) {
                        return false;
                    }
                }
                return true;
            }
        });
        TableViewerColumn col0 = new TableViewerColumn(this.m_tableViewer, 16384);
        col0.getColumn().setText("ID");
        col0.getColumn().setWidth(Integer.parseInt("" + m_columnWidth.get("ID")));
        col0.setLabelProvider((CellLabelProvider)this.m_provider);
        TableViewerColumn col1 = new TableViewerColumn(this.m_tableViewer, 16384);
        col1.getColumn().setText("Name");
        col1.getColumn().setWidth(Integer.parseInt("" + m_columnWidth.get("Name")));
        col1.setLabelProvider((CellLabelProvider)this.m_provider);
        TableViewerColumn col2 = new TableViewerColumn(this.m_tableViewer, 16384);
        col2.getColumn().setText("Enabled");
        col2.getColumn().setWidth(Integer.parseInt("" + m_columnWidth.get("Enabled")));
        col2.setLabelProvider((CellLabelProvider)this.m_provider);
        TableViewerColumn col3 = new TableViewerColumn(this.m_tableViewer, 16384);
        col3.getColumn().setText("Enabled by");
        col3.getColumn().setWidth(Integer.parseInt("" + m_columnWidth.get("Enabled by")));
        col3.setLabelProvider((CellLabelProvider)this.m_provider);
        TableViewerColumn col4 = new TableViewerColumn(this.m_tableViewer, 16384);
        col4.getColumn().setText("Disabled by");
        col4.getColumn().setWidth(Integer.parseInt("" + m_columnWidth.get("Disabled by")));
        col4.setLabelProvider((CellLabelProvider)this.m_provider);
        TableViewerColumn colFL = new TableViewerColumn(this.m_tableViewer, 16384);
        colFL.getColumn().setText("Filters");
        colFL.getColumn().setWidth(Integer.parseInt("" + m_columnWidth.get("Filters")));
        colFL.setLabelProvider((CellLabelProvider)this.m_provider);
        TableViewerColumn colDSC = new TableViewerColumn(this.m_tableViewer, 16384);
        colDSC.getColumn().setText("Description");
        colDSC.getColumn().setWidth(Integer.parseInt("" + m_columnWidth.get("Description")));
        colDSC.setLabelProvider((CellLabelProvider)this.m_provider);
        TableViewerColumn colAPP = new TableViewerColumn(this.m_tableViewer, 16384);
        colAPP.getColumn().setText("Set Application");
        colAPP.getColumn().setWidth(Integer.parseInt("" + m_columnWidth.get("Set Application")));
        colAPP.setLabelProvider((CellLabelProvider)this.m_provider);
        TableViewerColumn colGRP = new TableViewerColumn(this.m_tableViewer, 16384);
        colGRP.getColumn().setText("Set Group");
        colGRP.getColumn().setWidth(Integer.parseInt("" + m_columnWidth.get("Set Group")));
        colGRP.setLabelProvider((CellLabelProvider)this.m_provider);
        TableViewerColumn colOBJ = new TableViewerColumn(this.m_tableViewer, 16384);
        colOBJ.getColumn().setText("Set Object");
        colOBJ.getColumn().setWidth(Integer.parseInt("" + m_columnWidth.get("Set Object")));
        colOBJ.setLabelProvider((CellLabelProvider)this.m_provider);
        TableViewerColumn colTXT = new TableViewerColumn(this.m_tableViewer, 16384);
        colTXT.getColumn().setText("Set Text");
        colTXT.getColumn().setWidth(Integer.parseInt("" + m_columnWidth.get("Set Text")));
        colTXT.setLabelProvider((CellLabelProvider)this.m_provider);
        TableViewerColumn colSEV = new TableViewerColumn(this.m_tableViewer, 16384);
        colSEV.getColumn().setText("Set Severity");
        colSEV.getColumn().setWidth(Integer.parseInt("" + m_columnWidth.get("Set Severity")));
        colSEV.setLabelProvider((CellLabelProvider)this.m_provider);
        TableViewerColumn colHOST = new TableViewerColumn(this.m_tableViewer, 16384);
        colHOST.getColumn().setText("Set Host");
        colHOST.getColumn().setWidth(Integer.parseInt("" + m_columnWidth.get("Set Host")));
        colHOST.setLabelProvider((CellLabelProvider)this.m_provider);
        m_colIndices = new HashMap();
        m_colNames = new HashMap();
        TableColumn[] cols = this.m_table.getColumns();
        int i = 0;
        while (i < cols.length) {
            TableColumn col = cols[i];
            m_colIndices.put(col.getText(), i);
            m_colNames.put(i, col.getText());
            ++i;
        }
        int[] nArray = new int[13];
        nArray[1] = 1;
        nArray[2] = 2;
        nArray[3] = 3;
        nArray[4] = 4;
        nArray[5] = 11;
        nArray[6] = 12;
        nArray[7] = 7;
        nArray[8] = 8;
        nArray[9] = 9;
        nArray[10] = 10;
        nArray[11] = 6;
        nArray[12] = 5;
        this.m_tableViewer.getTable().setColumnOrder(nArray);
        this.m_tableViewer.setContentProvider((IContentProvider)this.m_provider);
        this.m_tableViewer.setComparer((IElementComparer)this.m_provider);
        this.m_tableViewer.setInput((Object)this.m_provider.getElements(null));
        this.m_tableViewer.addDoubleClickListener((IDoubleClickListener)this);
        this.m_tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ServerPolicyOverviewTab.this.checkButtons();
            }
        });
        FancyToolTipSupport.enableFor((ColumnViewer)this.m_tableViewer, 2);
        this.m_provider.reloadData();
        this.createPolicyTable_CM();
    }

    public void createPolicyTable_CM() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(false);
        Menu menu = menuMgr.createContextMenu(this.m_tableViewer.getControl());
        this.m_tableViewer.getControl().setMenu(menu);
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                try {
                    int minAccess = ServerPolicyStatus.ACCESS_EDIT_DELETE;
                    boolean activateEnable = false;
                    boolean activateDisable = false;
                    IStructuredSelection ss = (IStructuredSelection)ServerPolicyOverviewTab.this.m_tableViewer.getSelection();
                    for (ServerPolicyTemplate object : ss) {
                        String id = object.getID();
                        ServerPolicyStatus sp = ServerPolicyView.getProvider().getServerPolicyStatus(id);
                        if (sp == null) continue;
                        minAccess = Math.min(sp.m_access, minAccess);
                        if (sp.m_enabled) {
                            activateDisable = true;
                            continue;
                        }
                        activateEnable = true;
                    }
                    manager.add((IAction)new RefreshTableAction());
                    manager.add((IContributionItem)new Separator());
                    manager.add((IAction)new CreateNewPolicyAction());
                    manager.add((IAction)new OpenSPAction());
                    DeleteSPAction dp = new DeleteSPAction();
                    if (minAccess < ServerPolicyStatus.ACCESS_EDIT_DELETE) {
                        dp.setEnabled(false);
                    }
                    manager.add((IAction)dp);
                    manager.add((IContributionItem)new Separator());
                    if (activateEnable) {
                        EnableDisableSPAction ea = new EnableDisableSPAction(true);
                        if (minAccess < ServerPolicyStatus.ACCESS_ENABLE_DISABLE) {
                            ea.setEnabled(false);
                        }
                        manager.add((IAction)ea);
                    }
                    if (activateDisable) {
                        EnableDisableSPAction da = new EnableDisableSPAction(false);
                        if (minAccess < ServerPolicyStatus.ACCESS_ENABLE_DISABLE) {
                            da.setEnabled(false);
                        }
                        manager.add((IAction)da);
                    }
                }
                catch (RuntimeException e) {
                    RTLogger.print(5, "Error creating context menu", e);
                }
            }
        });
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
        String name = "";
        if (!(e.getSource() instanceof Table) && e.getSource() instanceof Button) {
            Button b = (Button)e.getSource();
            name = (String)b.getData();
            if (name.equals(REFRESH_BTN)) {
                this.m_provider.reloadData();
            } else if (!name.equals(SEARCH_POL_BTN)) {
                if (name.equals(BUTTON_TOP)) {
                    int selected = this.m_table.getSelectionIndex();
                    if (selected > 0) {
                        ModifyServerPolicy op = (ModifyServerPolicy)this.m_table.getItem(selected).getData();
                        this.m_provider.order(op.getID(), Integer.MIN_VALUE);
                    }
                } else if (name.equals(BUTTON_BOTTOM)) {
                    int selected = this.m_table.getSelectionIndex();
                    if (selected > -1 && selected < this.m_provider.getModifyPoliciesCount() - 1) {
                        ModifyServerPolicy op = (ModifyServerPolicy)this.m_table.getItem(selected).getData();
                        this.m_provider.order(op.getID(), Integer.MAX_VALUE);
                    }
                } else if (name.equals(BUTTON_UP)) {
                    int selected = this.m_table.getSelectionIndex();
                    if (selected > 0) {
                        ModifyServerPolicy op = (ModifyServerPolicy)this.m_table.getItem(selected).getData();
                        this.m_provider.order(op.getID(), -1);
                    }
                } else if (name.equals(BUTTON_DOWN)) {
                    int selected = this.m_table.getSelectionIndex();
                    if (selected > -1 && selected < this.m_provider.getModifyPoliciesCount() - 1) {
                        ModifyServerPolicy op = (ModifyServerPolicy)this.m_table.getItem(selected).getData();
                        this.m_provider.order(op.getID(), 1);
                    }
                } else if (name.equals(BUTTON_SAVE_ORDER)) {
                    this.m_provider.saveOrder();
                } else if (name.equals(BUTTON_UNDO_ORDER)) {
                    this.m_provider.m_newOrder.clear();
                    this.m_provider.reloadData();
                } else if (name.equals(BUTTON_DELETE)) {
                    DeleteSPAction del = new DeleteSPAction();
                    del.run();
                } else if (name.equals(BUTTON_CREATE)) {
                    CreateNewPolicyAction cn = new CreateNewPolicyAction();
                    cn.run();
                } else if (name.equals(SHOWALL)) {
                    LinkedList<ViewerFilter> toAdd = new LinkedList<ViewerFilter>();
                    ViewerFilter[] viewerFilterArray = this.m_tableViewer.getFilters();
                    int n = viewerFilterArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ViewerFilter vf = viewerFilterArray[n2];
                        if (!(vf instanceof StatusViewFilter)) {
                            toAdd.add(vf);
                        }
                        ++n2;
                    }
                    this.m_tableViewer.setFilters(toAdd.toArray(new ViewerFilter[0]));
                } else if (name.equals(SHOWENABLED)) {
                    LinkedList<ViewerFilter> toAdd = new LinkedList<ViewerFilter>();
                    ViewerFilter[] viewerFilterArray = this.m_tableViewer.getFilters();
                    int n = viewerFilterArray.length;
                    int n3 = 0;
                    while (n3 < n) {
                        ViewerFilter vf = viewerFilterArray[n3];
                        if (!(vf instanceof StatusViewFilter)) {
                            toAdd.add(vf);
                        }
                        ++n3;
                    }
                    StatusViewFilter svf = new StatusViewFilter(this.m_provider, true);
                    toAdd.add(svf);
                    this.m_tableViewer.setFilters(toAdd.toArray(new ViewerFilter[0]));
                } else if (name.equals(SHOWDISABLED)) {
                    LinkedList<ViewerFilter> toAdd = new LinkedList<ViewerFilter>();
                    ViewerFilter[] viewerFilterArray = this.m_tableViewer.getFilters();
                    int n = viewerFilterArray.length;
                    int n4 = 0;
                    while (n4 < n) {
                        ViewerFilter vf = viewerFilterArray[n4];
                        if (!(vf instanceof StatusViewFilter)) {
                            toAdd.add(vf);
                        }
                        ++n4;
                    }
                    StatusViewFilter svf = new StatusViewFilter(this.m_provider, false);
                    toAdd.add(svf);
                    this.m_tableViewer.setFilters(toAdd.toArray(new ViewerFilter[0]));
                }
            }
        }
        this.checkButtons();
    }

    @Override
    protected void checkButtons() {
        this.m_save_Button.setEnabled(!this.isReadOnly() && !this.m_provider.isNewOrderSaved());
        this.m_undo_Button.setEnabled(!this.isReadOnly() && !this.m_provider.isNewOrderSaved());
        this.m_create_Button.setEnabled(!this.isReadOnly());
        this.m_delete_Button.setEnabled(!this.isReadOnly() && this.m_table.getSelectionCount() > 0);
        this.m_top_Button.setEnabled(!this.isReadOnly() && this.m_table.getSelectionCount() > 0);
        this.m_up_Button.setEnabled(!this.isReadOnly() && this.m_table.getSelectionCount() > 0);
        this.m_bottom_Button.setEnabled(!this.isReadOnly() && this.m_table.getSelectionCount() > 0);
        this.m_down_Button.setEnabled(!this.isReadOnly() && this.m_table.getSelectionCount() > 0);
    }

    public void refresh() {
        this.m_provider.reloadData();
    }

    public void doubleClick(DoubleClickEvent event) {
        OpenSPAction edit = new OpenSPAction();
        edit.run();
    }

    public void dispose() {
        Repository.getInstance().getCmdRouter().removeCmdListener("GET_SERVER_POLICIES_STATUS_MOD", this);
        super.dispose();
    }

    public TableViewer getTableViewer() {
        return this.m_tableViewer;
    }

    private class CreateNewPolicyAction
    extends Action {
        public CreateNewPolicyAction() {
            super("cnpMP");
            this.setId("cnpMP");
            this.setText("Create Server Policy");
            ISharedImages sharedImages = Activator.getDefault().getWorkbench().getActiveWorkbenchWindow().getWorkbench().getSharedImages();
            this.setImageDescriptor(sharedImages.getImageDescriptor("IMG_OBJ_ADD"));
            this.setDisabledImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_DELETE_DISABLED"));
            if (Repository.getInstance().getRights(2012) < 3) {
                this.setEnabled(false);
            }
        }

        public void run() {
            ServerPolicyView.displayTab(null, ServerPolicyOverviewTab.this.m_server);
        }
    }

    private class DeleteSPAction
    extends Action {
        public DeleteSPAction() {
            super("deleteMP");
            this.setId("deleteMP");
            this.setText("Delete Server Policy");
            ISharedImages sharedImages = Activator.getDefault().getWorkbench().getActiveWorkbenchWindow().getWorkbench().getSharedImages();
            this.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_DELETE"));
            this.setDisabledImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_DELETE_DISABLED"));
            if (Repository.getInstance().getRights(2012) < 3 || ServerPolicyOverviewTab.this.m_tableViewer.getSelection().isEmpty() || ServerPolicyOverviewTab.this.isReadOnly()) {
                this.setEnabled(false);
                return;
            }
            if (ServerPolicyOverviewTab.this.m_tableViewer.getTable().getSelectionCount() > 1) {
                this.setText("Delete Server Policies");
            }
        }

        public void run() {
            if (!this.isEnabled()) {
                return;
            }
            IStructuredSelection ss = (IStructuredSelection)ServerPolicyOverviewTab.this.m_tableViewer.getSelection();
            LinkedList<String> ids = new LinkedList<String>();
            LinkedList<ServerPolicyTemplate> elements = new LinkedList<ServerPolicyTemplate>();
            for (ServerPolicyTemplate object : ss) {
                ids.add(object.getID());
                elements.add(object);
            }
            String header = "";
            String footer = "";
            String title = "";
            String noElementsText = "No Policies to delete!";
            if (elements.size() == 1) {
                title = "   Delete Policy";
                header = "Do you want to delete the following Policy:";
                footer = "1 Policy to delete!";
            } else if (elements.size() > 1) {
                title = "   Delete Policies";
                header = "Do you want to delete the following Policies:";
                footer = String.valueOf(elements.size()) + " Policies to delete!";
            }
            ShowMessageDialog md = new ShowMessageDialog(new Shell(Display.getCurrent().getActiveShell()), title, header, footer, true, "Delete", elements, noElementsText);
            md.setBlockOnOpen(true);
            md.open();
            if (md.getReturnCode() == 0) {
                ServerPolicyOverviewTab.this.m_provider.deletePolicy(ids);
            }
        }
    }

    private class EnableDisableSPAction
    extends Action {
        boolean m_enable;

        public EnableDisableSPAction(boolean enable) {
            super("enableMP" + enable);
            this.m_enable = false;
            this.m_enable = enable;
            this.setId("enableMP" + enable);
            if (enable) {
                this.setText("Enable");
            } else {
                this.setText("Disable");
            }
            if (Repository.getInstance().getRights(2012) < 3 || ServerPolicyOverviewTab.this.m_tableViewer.getSelection().isEmpty() || ServerPolicyOverviewTab.this.isReadOnly()) {
                this.setEnabled(false);
                return;
            }
        }

        public void run() {
            if (!this.isEnabled()) {
                return;
            }
            IStructuredSelection ss = (IStructuredSelection)ServerPolicyOverviewTab.this.m_tableViewer.getSelection();
            LinkedList<String> ids = new LinkedList<String>();
            for (ServerPolicyTemplate object : ss) {
                ids.add(object.getID());
            }
            ServerPolicyOverviewTab.this.m_provider.enablePolicies(ids, this.m_enable);
        }
    }

    private class OpenSPAction
    extends Action {
        public OpenSPAction() {
            super("openMP");
            this.setId("openMP");
            this.setText("Open Server Policy");
            if (Repository.getInstance().getRights(2012) < 2 || ServerPolicyOverviewTab.this.m_tableViewer.getSelection().isEmpty()) {
                this.setEnabled(false);
                return;
            }
            if (ServerPolicyOverviewTab.this.m_tableViewer.getTable().getSelectionCount() > 1) {
                this.setText("Open Server Policies");
            }
        }

        public void run() {
            if (!this.isEnabled()) {
                return;
            }
            IStructuredSelection ssel = (IStructuredSelection)ServerPolicyOverviewTab.this.m_tableViewer.getSelection();
            for (ModifyServerPolicy mp : ssel) {
                ServerPolicyStatus sps = ServerPolicyOverviewTab.this.m_provider.getServerPolicyStatus(mp.getID());
                if (sps == null || sps.m_access < ServerPolicyStatus.ACCESS_READONLY) continue;
                ServerPolicyView.displayTab(mp, ServerPolicyOverviewTab.this.m_server);
            }
        }
    }

    private class RefreshTableAction
    extends Action {
        public RefreshTableAction() {
            super("refreshtableMP");
            this.setId("refreshtableMP");
            this.setText("Refresh");
            this.setImageDescriptor(BMUI.IMAGE_DESCR_REFRESH);
        }

        public void run() {
            ServerPolicyOverviewTab.this.refresh();
        }
    }
}

