/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.views.outages;

import com.blixx.boom.engine.BMUI;
import com.blixx.boom.engine.Repository;
import com.blixx.boom.gui.views.outages.ExtendedPolicyDetailsComposite;
import com.blixx.boom.gui.views.outages.ServerPolicyDetailsComposite;
import com.blixx.boom.gui.views.outages.ServerPolicyTableProvider;
import com.blixx.boom.gui.views.outages.ServerPolicyView;
import com.blixx.shared.ext.ExtendedServerPolicy;
import com.blixx.shared.ext.ModifyServerPolicy;
import com.blixx.shared.ext.ServerPolicyStatus;
import java.util.UUID;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class ServerPolicyTab
extends CTabItem {
    ModifyServerPolicy m_policy = null;
    private ServerPolicyDetailsComposite m_detailComposite = null;
    public String m_server = null;

    public ServerPolicyTab(ModifyServerPolicy p, CTabFolder parent, int style, String server) {
        super(parent, style);
        this.m_server = server;
        this.init(p);
    }

    public ServerPolicyTab(ModifyServerPolicy p, CTabFolder parent, int style, int index, String server) {
        super(parent, style, index);
        this.m_server = server;
        this.init(p);
    }

    public void init(ModifyServerPolicy p) {
        if (p == null) {
            p = new ExtendedServerPolicy(UUID.randomUUID().toString(), "New_ServerPolicy_" + System.currentTimeMillis());
        }
        this.m_policy = p;
        this.setData("TABID", p.getID());
        this.setImage(BMUI.IMAGE_MODIFYPOL);
        if (this.m_server != null && this.m_server.length() > 0) {
            this.setText(String.valueOf(this.m_policy.getName()) + "@@" + this.m_server);
        } else {
            this.setText(this.m_policy.getName());
        }
        if (this.m_policy instanceof ExtendedServerPolicy) {
            this.m_detailComposite = new ExtendedPolicyDetailsComposite(this, (Composite)this.getParent(), 0, this.m_server);
            this.m_detailComposite.setServerPolicy(this.m_policy, this.isReadOnly());
        } else {
            this.m_detailComposite = new ServerPolicyDetailsComposite(this, (Composite)this.getParent(), 0, this.m_server);
            this.m_detailComposite.setServerPolicy(this.m_policy, this.isReadOnly());
        }
        this.setControl((Control)this.m_detailComposite);
        ServerPolicyView.addTab(this);
    }

    public boolean isDirty() {
        return this.m_detailComposite.isDirty();
    }

    public ServerPolicyDetailsComposite getPolicyDetailComposite() {
        return this.m_detailComposite;
    }

    public void dispose() {
        super.dispose();
        ServerPolicyView.closeTab(this.m_policy.getID());
    }

    public boolean isReadOnly() {
        boolean isReadOnly = false;
        if (Repository.getInstance().getRights(2012) < 3) {
            isReadOnly = true;
        } else {
            ServerPolicyStatus s;
            ServerPolicyTableProvider pr = ServerPolicyView.getProvider();
            if (pr != null && (s = pr.getServerPolicyStatus(this.m_policy.getID())) != null && s.m_access <= ServerPolicyStatus.ACCESS_READONLY) {
                isReadOnly = true;
            }
        }
        return isReadOnly;
    }
}

