/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.views.outages;

import com.blixx.boom.engine.BMUI;
import com.blixx.boom.engine.JobManager;
import com.blixx.boom.engine.Repository;
import com.blixx.boom.engine.UIJob;
import com.blixx.boom.engine.UIJobManager;
import com.blixx.boom.gui.dialogs.ShowMessageBox;
import com.blixx.boom.gui.views.outages.AbstractMaintenanceOverviewTab;
import com.blixx.boom.gui.views.outages.IServerPolicyStatusProvider;
import com.blixx.boom.gui.views.outages.ServerPolicyManager;
import com.blixx.ctrl.sc.ICmdPostProcess;
import com.blixx.ctrl.sc.ServerClient;
import com.blixx.ctrl.sc.in.ScDeleteModifyServerPolicy;
import com.blixx.ctrl.sc.in.ScEnableModifyServerPolicy;
import com.blixx.ctrl.sc.in.ScGetExtendedServerPolicies;
import com.blixx.ctrl.sc.in.ScGetModifyServerPolicies;
import com.blixx.ctrl.sc.in.ScSetExtendedServerPoliciesOrder;
import com.blixx.ctrl.sc.in.ScSetExtendedServerPoliciesOrderSlave;
import com.blixx.ctrl.sc.in.ScSetModifyServerPoliciesOrder;
import com.blixx.ctrl.sc.in.ScSetModifyServerPoliciesOrderSlave;
import com.blixx.ctrl.sc.in.ScValidateCmd;
import com.blixx.shared.ext.ExtendedServerPolicy;
import com.blixx.shared.ext.ModifyServerPolicy;
import com.blixx.shared.ext.ServerPolicyStatus;
import com.blixx.shared.ext.ServerPolicyTemplate;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.IElementComparer;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.graphics.Image;

public class ServerPolicyTableProvider
extends CellLabelProvider
implements IElementComparer,
IStructuredContentProvider,
ICmdPostProcess,
IServerPolicyStatusProvider {
    public static final String COL_POLICY_ID = "ID";
    public static final String COL_POLICY_NAME = "Name";
    public static final String COL_ENABLED = "Enabled";
    public static final String COL_ENABLEDBY = "Enabled by";
    public static final String COL_DISABLEDBY = "Disabled by";
    public static final String COL_FILTERS = "Filters";
    public static final String COL_DESCRIPTION = "Description";
    public static final String COL_SET_APP = "Set Application";
    public static final String COL_SET_GRP = "Set Group";
    public static final String COL_SET_OBJ = "Set Object";
    public static final String COL_SET_TXT = "Set Text";
    public static final String COL_SET_SEV = "Set Severity";
    public static final String COL_SET_HOST = "Set Host";
    public static final int COL_POLICY_ID_INT = 0;
    public static final int COL_POLICY_NAME_INT = 1;
    public static final int COL_ENABLED_INT = 2;
    public static final int COL_ENABLEDBY_INT = 3;
    public static final int COL_DISABLEDBY_INT = 4;
    public static final int COL_FILTERS_INT = 5;
    public static final int COL_DESCRIPTION_INT = 6;
    public static final int COL_SET_APP_INT = 7;
    public static final int COL_SET_GRP_INT = 8;
    public static final int COL_SET_OBJ_INT = 9;
    public static final int COL_SET_TXT_INT = 10;
    public static final int COL_SET_SEV_INT = 11;
    public static final int COL_SET_HOST_INT = 12;
    List<String> m_newOrder = new ArrayList<String>();
    AbstractMaintenanceOverviewTab m_ctab = null;
    TableViewer m_table = null;
    String m_server = "";

    public ServerPolicyTableProvider(TableViewer table, AbstractMaintenanceOverviewTab ctab) {
        this.m_table = table;
        this.m_ctab = ctab;
    }

    public ServerPolicyTableProvider(TableViewer table, AbstractMaintenanceOverviewTab ctab, String slaveServer) {
        this(table, ctab);
        this.m_server = slaveServer;
    }

    public boolean equals(Object a, Object b) {
        return a == null ? b == null : a.equals(b);
    }

    public int hashCode(Object element) {
        return element.hashCode();
    }

    public Object[] getElements(Object inputElement) {
        if (this.m_newOrder.size() > 0) {
            LinkedList<ModifyServerPolicy> list = new LinkedList<ModifyServerPolicy>();
            int i = 0;
            while (i < this.m_newOrder.size()) {
                list.add(this.getModifyServerPolicy(this.m_newOrder.get(i)));
                ++i;
            }
            if (this.checkAndMergeServerUpdate(list)) {
                list = new LinkedList();
                i = 0;
                while (i < this.m_newOrder.size()) {
                    list.add(this.getModifyServerPolicy(this.m_newOrder.get(i)));
                    ++i;
                }
            }
            return list.toArray();
        }
        return ServerPolicyManager.getInstance().getServerPolicies(this.m_server).toArray();
    }

    private boolean checkAndMergeServerUpdate(List<ModifyServerPolicy> list) {
        boolean isNewOrderListChanged = false;
        List<ModifyServerPolicy> m_serverPolicies = ServerPolicyManager.getInstance().getServerPolicies(this.m_server);
        if (!list.containsAll(m_serverPolicies) || !m_serverPolicies.containsAll(list)) {
            isNewOrderListChanged = true;
            LinkedList<String> actualIDs = new LinkedList<String>();
            for (ModifyServerPolicy op : m_serverPolicies) {
                actualIDs.add(op.getID());
            }
            this.m_newOrder.retainAll(actualIDs);
            int i = 0;
            while (i < m_serverPolicies.size()) {
                ModifyServerPolicy op = m_serverPolicies.get(i);
                if (!this.m_newOrder.contains(op.getID())) {
                    if (i < this.m_newOrder.size()) {
                        this.m_newOrder.add(i, op.getID());
                    } else {
                        this.m_newOrder.add(op.getID());
                    }
                }
                ++i;
            }
        }
        return isNewOrderListChanged;
    }

    public ModifyServerPolicy getModifyServerPolicy(String id) {
        if (id != null) {
            for (ModifyServerPolicy op : ServerPolicyManager.getInstance().getServerPolicies(this.m_server)) {
                if (!op.getID().equals(id)) continue;
                return op;
            }
        }
        return null;
    }

    @Override
    public ServerPolicyStatus getServerPolicyStatus(String id) {
        return ServerPolicyManager.getInstance().getServerPolicyStatus(id);
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public void update(ViewerCell cell) {
        ModifyServerPolicy sp = (ModifyServerPolicy)cell.getElement();
        String label = "";
        Image image = null;
        ServerPolicyStatus sps = this.getServerPolicyStatus(sp.getID());
        if (sps != null && sps.m_access < ServerPolicyStatus.ACCESS_EDIT_DELETE) {
            cell.setForeground(BMUI.color_darkGrey2);
        }
        int colindex = cell.getColumnIndex();
        switch (colindex) {
            case 0: {
                label = sp.getID();
                break;
            }
            case 1: {
                label = sp.getName();
                break;
            }
            case 2: {
                boolean enabled = sps.m_enabled;
                label = null;
                image = enabled ? BMUI.IMAGE_ACCEPT_GREEN : BMUI.IMAGE_CANCEL_ROUND;
                break;
            }
            case 3: {
                label = sps.m_enabledBy;
                break;
            }
            case 4: {
                label = sps.m_disabledBy;
                break;
            }
            case 6: {
                label = sp.getDescription();
                break;
            }
            case 5: {
                label = sp.getFilters().toString();
                break;
            }
            case 7: {
                label = sp.getSetApplication();
                break;
            }
            case 8: {
                label = sp.getSetGroup();
                break;
            }
            case 9: {
                label = sp.getSetObject();
                break;
            }
            case 10: {
                label = sp.getSetText();
                break;
            }
            case 11: {
                label = sp.getSetSeverity();
                break;
            }
            case 12: {
                label = sp.getSetHost();
                break;
            }
        }
        cell.setText(label);
        cell.setImage(image);
    }

    public void reloadData() {
        final ServerPolicyTableProvider mtp = this;
        ScValidateCmd cval = new ScValidateCmd(Repository.getInstance(), "GET_SERVER_POLICIES_STATUS_EXT");
        cval.addCmdPostProcess(new ICmdPostProcess(){

            public void postProcess(ServerClient sc) {
                ServerClient scN = null;
                scN = sc.isSuccess() ? new ScGetExtendedServerPolicies(Repository.getInstance()) : new ScGetModifyServerPolicies(Repository.getInstance());
                scN.addCmdPostProcess(mtp);
                ServerPolicyManager.getInstance().reloadData(scN);
            }
        });
        JobManager.getInstance().schedule(cval);
    }

    public void postProcess(ServerClient client) {
        if (client instanceof ScGetModifyServerPolicies || client instanceof ScGetExtendedServerPolicies) {
            if (client.isSuccess()) {
                UIJob uj = new UIJob("SeModPolRefresh"){

                    @Override
                    public IStatus runInUIThread(IProgressMonitor monitor) {
                        ServerPolicyTableProvider.this.m_table.setInput((Object)ServerPolicyTableProvider.this.getElements(null));
                        return null;
                    }
                };
                UIJobManager.getInstance().schedule(uj);
            }
        } else if (client instanceof ScSetModifyServerPoliciesOrder || client instanceof ScSetExtendedServerPoliciesOrder || client instanceof ScSetModifyServerPoliciesOrderSlave || client instanceof ScSetExtendedServerPoliciesOrderSlave) {
            if (client.isSuccess()) {
                this.m_newOrder.clear();
                UIJob uj = new UIJob("BModchk"){

                    @Override
                    public IStatus runInUIThread(IProgressMonitor monitor) {
                        ServerPolicyTableProvider.this.m_ctab.checkButtons();
                        return Status.OK_STATUS;
                    }
                };
                UIJobManager.getInstance().schedule(uj);
            } else {
                new ShowMessageBox("Error", client.getLastException().getMessage(), 1);
            }
        } else {
            this.reloadData();
            if (!client.isSuccess()) {
                new ShowMessageBox("Error", client.getLastException().getMessage(), 1);
            }
        }
    }

    public void enablePolicies(List<String> ids, boolean enable) {
        ScEnableModifyServerPolicy sc = new ScEnableModifyServerPolicy(Repository.getInstance(), ids, enable, "");
        sc.addCmdPostProcess(this);
        sc.start();
    }

    public void deletePolicy(List<String> ids) {
        ScDeleteModifyServerPolicy sc = new ScDeleteModifyServerPolicy(Repository.getInstance(), ids, null);
        sc.addCmdPostProcess(this);
        sc.start();
    }

    public void saveOrder(List<String> ids) {
        if (ids != null && ids.size() > 0) {
            ServerClient sc = null;
            sc = this.m_server == null || this.m_server.length() == 0 ? (this.getModifyServerPolicy(ids.get(0)) instanceof ExtendedServerPolicy ? new ScSetExtendedServerPoliciesOrder(Repository.getInstance(), ids) : new ScSetModifyServerPoliciesOrder(Repository.getInstance(), ids)) : (this.getModifyServerPolicy(ids.get(0)) instanceof ExtendedServerPolicy ? new ScSetExtendedServerPoliciesOrderSlave(Repository.getInstance(), ids, this.m_server) : new ScSetModifyServerPoliciesOrderSlave(Repository.getInstance(), ids, this.m_server));
            sc.addCmdPostProcess(this);
            sc.start();
        }
    }

    public void order(String id, int step) {
        int n;
        if (this.m_newOrder.size() == 0) {
            for (ServerPolicyTemplate serverPolicyTemplate : ServerPolicyManager.getInstance().getServerPolicies(this.m_server)) {
                this.m_newOrder.add(serverPolicyTemplate.getID());
            }
        }
        if ((n = this.m_newOrder.indexOf(id)) >= 0) {
            String IDbkp = this.m_newOrder.remove(n);
            try {
                if (step == Integer.MAX_VALUE) {
                    this.m_newOrder.add(id);
                } else if (step == Integer.MIN_VALUE) {
                    if (this.m_newOrder.size() == 0) {
                        this.m_newOrder.add(id);
                    } else {
                        this.m_newOrder.add(0, id);
                    }
                } else {
                    this.m_newOrder.add(n + step, id);
                }
            }
            catch (Throwable throwable) {
                this.m_newOrder.add(n, IDbkp);
            }
            this.m_table.setInput((Object)this.getElements(null));
        }
    }

    public boolean isNewOrderSaved() {
        return this.m_newOrder.size() == 0;
    }

    public void saveOrder() {
        this.saveOrder(this.m_newOrder);
    }

    public int getModifyPoliciesCount() {
        return ServerPolicyManager.getInstance().getServerPolicies(this.m_server).size();
    }
}

