/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.views.outages;

import com.blixx.boom.engine.BMUI;
import com.blixx.boom.engine.Repository;
import com.blixx.boom.engine.UIJob;
import com.blixx.boom.gui.dialogs.SaveDialog;
import com.blixx.boom.gui.views.outages.OpenSaveDialogMulitple;
import com.blixx.boom.gui.views.outages.ServerPolicyOverviewTab;
import com.blixx.boom.gui.views.outages.ServerPolicyTab;
import com.blixx.boom.gui.views.outages.ServerPolicyTableProvider;
import com.blixx.shared.ext.ModifyServerPolicy;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabFolder2Listener;
import org.eclipse.swt.custom.CTabFolderEvent;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.part.ViewPart;

public class ServerPolicyView
extends ViewPart
implements Listener,
MenuListener {
    public static final String TABID = "TABID";
    public static final String ID = "com.blixx.boom.gui.views.serverPolicyView";
    public static final int VIEW_ID = 2012;
    private static ServerPolicyView m_instance = null;
    public static CTabFolder folder = null;
    public static ServerPolicyOverviewTab m_overviewCTab = null;
    public static Map<String, CTabItem> m_tabList = new HashMap<String, CTabItem>();
    public static final String CLOSE_ALL = "CLOSE_ALL";
    public static final String CLOSE_OTHERS = "CLOSE_OTHERS";
    public static final String CLOSE = "CLOSE";

    public ServerPolicyView() {
        m_instance = this;
    }

    public static ServerPolicyView getInstance() {
        return m_instance;
    }

    public void createPartControl(Composite parent) {
        this.setTitleImage(BMUI.IMAGE_MODIFYPOL);
        if (Repository.getInstance().getRights(2012) <= 1) {
            parent.setLayout((Layout)new GridLayout(2, false));
            Label l = new Label(parent, 0);
            l.setText(" Insufficient rights.");
            l.setForeground(BMUI.color_critical);
            Button close = new Button(parent, 8);
            close.setText("Close");
            close.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                }

                public void widgetSelected(SelectionEvent e) {
                    ServerPolicyView.this.getSite().getPage().hideView(ServerPolicyView.this.getSite().getPage().findView(ServerPolicyView.ID));
                }
            });
            UIJob uiJob = new UIJob("Close Viewcom.blixx.boom.gui.views.serverPolicyView"){

                @Override
                public IStatus runInUIThread(IProgressMonitor monitor) {
                    ServerPolicyView.this.getSite().getPage().hideView(ServerPolicyView.this.getSite().getPage().findView(ServerPolicyView.ID));
                    return Status.OK_STATUS;
                }
            };
            Repository.getUIJobManager().schedule(uiJob);
            return;
        }
        this.setTitleImage(BMUI.IMAGE_MODIFYPOL);
        this.createFolder(parent);
    }

    public void createFolder(Composite parent) {
        folder = new CTabFolder(parent, 2816);
        folder.setSimple(false);
        folder.setMinimizeVisible(false);
        folder.setMaximizeVisible(false);
        folder.setBorderVisible(false);
        folder.setBackground(BMUI.color_unknown);
        folder.addCTabFolder2Listener(new CTabFolder2Listener(){

            public void showList(CTabFolderEvent event) {
            }

            public void restore(CTabFolderEvent event) {
            }

            public void minimize(CTabFolderEvent event) {
            }

            public void maximize(CTabFolderEvent event) {
            }

            public void close(CTabFolderEvent event) {
                ServerPolicyTab opt;
                if (event.item != null && event.item instanceof ServerPolicyTab && (opt = (ServerPolicyTab)event.item).getPolicyDetailComposite() != null && opt.getPolicyDetailComposite().isDirty()) {
                    SaveDialog dialog = new SaveDialog(opt.getPolicyDetailComposite().getShell());
                    dialog.init(opt.getParent(), ServerPolicyView.CLOSE, null, SaveDialog.POLICY);
                    dialog.setBlockOnOpen(true);
                    dialog.open();
                    int returnCode = dialog.getReturnCode();
                    if (returnCode == 1) {
                        event.doit = false;
                    } else if (returnCode == 0) {
                        opt.getPolicyDetailComposite().saveServerPolicy(opt.m_server);
                    }
                }
            }
        });
        folder.addListener(35, new Listener(){

            public void handleEvent(Event event) {
                Point point = folder.getDisplay().map(null, (Control)folder, new Point(event.x, event.y));
                CTabItem newSelectedTab = folder.getItem(point);
                CTabItem activeTab = folder.getSelection();
                if (newSelectedTab != null && !newSelectedTab.equals(activeTab)) {
                    int i = 0;
                    while (i < folder.getItemCount()) {
                        CTabItem tab = folder.getItem(i);
                        if (tab != null && tab.equals(newSelectedTab)) {
                            if (tab instanceof ServerPolicyOverviewTab) {
                                ((ServerPolicyOverviewTab)tab).getControl().setVisible(true);
                            } else if (tab instanceof ServerPolicyTab) {
                                ((ServerPolicyTab)tab).getControl().setVisible(true);
                            }
                            folder.setSelection(tab);
                            break;
                        }
                        ++i;
                    }
                }
            }
        });
        ServerPolicyView.createContentMenu();
        m_overviewCTab = new ServerPolicyOverviewTab(folder, 0, null);
        List<String> slaves = Repository.getInstance().getSlaves(1);
        for (String slave : slaves) {
            new ServerPolicyOverviewTab(folder, 0, slave);
        }
        folder.setSelection((CTabItem)m_overviewCTab);
    }

    public static void createContentMenu() {
        Menu menu = new Menu((Control)folder);
        menu.addMenuListener((MenuListener)m_instance);
        MenuItem mi = new MenuItem(menu, 2);
        mi = new MenuItem(menu, -1);
        mi.setText("Close");
        mi.setData((Object)CLOSE);
        mi.addListener(13, (Listener)m_instance);
        mi = new MenuItem(menu, -1);
        mi.setText("Close Others");
        mi.setData((Object)CLOSE_OTHERS);
        mi.addListener(13, (Listener)m_instance);
        mi = new MenuItem(menu, -1);
        mi.setText("Close All");
        mi.setData((Object)CLOSE_ALL);
        mi.addListener(13, (Listener)m_instance);
        folder.setMenu(menu);
    }

    public void setFocus() {
    }

    public static void displayTab(ModifyServerPolicy policy, String server) {
        CTabItem tab = null;
        if (policy != null) {
            tab = ServerPolicyView.getTab(policy.getID());
        }
        if (tab == null) {
            tab = new ServerPolicyTab(policy, folder, 64, server);
            folder.setSelection(tab);
            if (policy != null) {
                ServerPolicyView.addTab(tab);
            }
        } else {
            folder.setSelection(tab);
        }
    }

    public static void displayTab(ModifyServerPolicy policy, int index, String server) {
        if (index > 0) {
            ServerPolicyTab tab = new ServerPolicyTab(policy, folder, 64, index, server);
            folder.setSelection((CTabItem)tab);
            ServerPolicyView.addTab(tab);
        } else {
            ServerPolicyView.displayTab(policy, server);
        }
    }

    public static CTabItem getTab(String idOrName) {
        CTabItem cTabItem = m_tabList.get(idOrName);
        if (cTabItem != null && cTabItem.isDisposed()) {
            m_tabList.remove(idOrName);
            cTabItem = null;
        }
        return cTabItem;
    }

    public static boolean isTabOpen(String name) {
        boolean b = false;
        if (m_tabList.get(name) != null) {
            b = true;
        }
        return b;
    }

    public static boolean isTabActiv(CTabItem tab) {
        boolean b = false;
        CTabItem activeTab = folder.getSelection();
        if (tab.getText().equals(activeTab.getText())) {
            b = true;
        }
        return b;
    }

    public static void reOpenTab(ModifyServerPolicy outagePolicy, String newName, Composite parent, String server) {
        int index = -1;
        String id = outagePolicy.getID();
        CTabItem oldTab = ServerPolicyView.getTab(id);
        if (oldTab != null) {
            index = ServerPolicyView.getTabIndex(newName);
            ServerPolicyView.closeTab(id);
            if (index > 0) {
                ServerPolicyView.displayTab(outagePolicy, index, server);
            } else {
                ServerPolicyView.displayTab(outagePolicy, server);
            }
        }
    }

    public static void closeTab(String idOrName) {
        if (m_tabList.containsKey(idOrName)) {
            CTabItem cTabItem = m_tabList.get(idOrName);
            try {
                cTabItem.dispose();
            }
            catch (Throwable throwable) {}
            m_tabList.remove(idOrName);
        }
    }

    public static void addTab(CTabItem tab) {
        if (tab.getData(TABID) != null) {
            m_tabList.put("" + tab.getData(TABID), tab);
        } else {
            m_tabList.put(tab.getText(), tab);
        }
    }

    public static int getTabIndex(String tabName) {
        CTabItem[] items = folder.getItems();
        int i = 0;
        while (i < items.length) {
            CTabItem tab = items[i];
            if (tab.getText().equals(tabName) || tabName.equals(tab.getData(TABID))) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static ServerPolicyTableProvider getProvider() {
        ServerPolicyTableProvider provider = null;
        try {
            provider = ServerPolicyView.m_overviewCTab.m_provider;
        }
        catch (Throwable throwable) {}
        return provider;
    }

    public void menuHidden(MenuEvent e) {
    }

    public void menuShown(MenuEvent e) {
        block24: {
            CTabItem selTab;
            int cTabCount;
            MenuItem[] mi;
            block22: {
                block23: {
                    Menu menu = (Menu)e.getSource();
                    mi = menu.getItems();
                    cTabCount = folder.getItemCount();
                    selTab = folder.getSelection();
                    if (cTabCount == 0) {
                        int index = 0;
                        while (index < mi.length) {
                            String action = (String)mi[index].getData();
                            if (action != null) {
                                mi[index].setEnabled(false);
                            }
                            ++index;
                        }
                        return;
                    }
                    if (!(selTab instanceof ServerPolicyOverviewTab)) break block22;
                    if (cTabCount != 1) break block23;
                    int index = 0;
                    while (index < mi.length) {
                        String action = (String)mi[index].getData();
                        if (action != null) {
                            mi[index].setEnabled(false);
                        }
                        ++index;
                    }
                    break block24;
                }
                if (cTabCount <= 1) break block24;
                int index = 0;
                while (index < mi.length) {
                    String action = (String)mi[index].getData();
                    if (action != null) {
                        if (action.equals(CLOSE_ALL) || action.equals(CLOSE_OTHERS)) {
                            mi[index].setEnabled(true);
                        } else {
                            mi[index].setEnabled(false);
                        }
                    }
                    ++index;
                }
                break block24;
            }
            if (selTab instanceof ServerPolicyTab) {
                if (cTabCount == 2) {
                    int index = 0;
                    while (index < mi.length) {
                        String action = (String)mi[index].getData();
                        if (action != null) {
                            if (action.equals(CLOSE)) {
                                mi[index].setEnabled(true);
                            } else {
                                mi[index].setEnabled(false);
                            }
                        }
                        ++index;
                    }
                } else if (cTabCount > 2) {
                    int index = 0;
                    while (index < mi.length) {
                        String action = (String)mi[index].getData();
                        if (action != null) {
                            mi[index].setEnabled(true);
                        }
                        ++index;
                    }
                } else {
                    int index = 0;
                    while (index < mi.length) {
                        String action = (String)mi[index].getData();
                        if (action != null) {
                            mi[index].setEnabled(false);
                        }
                        ++index;
                    }
                }
            }
        }
    }

    public void handleEvent(Event event) {
        boolean dirtyStatus = false;
        String menuAction = (String)event.widget.getData();
        CTabItem selectedTab = folder.getSelection();
        if (menuAction.equals(CLOSE)) {
            if (selectedTab instanceof ServerPolicyTab) {
                ServerPolicyTab modifyPolicyTab = (ServerPolicyTab)selectedTab;
                if (modifyPolicyTab.getPolicyDetailComposite() != null && modifyPolicyTab.getPolicyDetailComposite().isDirty()) {
                    SaveDialog dialog = new SaveDialog(modifyPolicyTab.getPolicyDetailComposite().getShell());
                    dialog.init(modifyPolicyTab.getParent(), CLOSE, null, SaveDialog.POLICY);
                    dialog.setBlockOnOpen(true);
                    dialog.open();
                    int returnCode = dialog.getReturnCode();
                    if (returnCode == 1) {
                        event.doit = false;
                    } else if (returnCode == 0) {
                        modifyPolicyTab.getPolicyDetailComposite().saveServerPolicy(modifyPolicyTab.m_server);
                        this.runContentMenuAction(CLOSE);
                    } else {
                        this.runContentMenuAction(CLOSE);
                    }
                } else {
                    this.runContentMenuAction(CLOSE);
                }
            }
        } else if (menuAction.equals(CLOSE_OTHERS)) {
            CTabItem[] cTabs = folder.getItems();
            int index = 0;
            while (index < cTabs.length) {
                ServerPolicyTab modifyPolicyTab;
                CTabItem tab = cTabs[index];
                if (!(tab instanceof ServerPolicyOverviewTab) && !tab.equals(selectedTab) && tab instanceof ServerPolicyTab && (modifyPolicyTab = (ServerPolicyTab)tab).getPolicyDetailComposite() != null && modifyPolicyTab.getPolicyDetailComposite().isDirty()) {
                    dirtyStatus = true;
                    break;
                }
                ++index;
            }
            if (dirtyStatus) {
                new OpenSaveDialogMulitple(folder, CLOSE_OTHERS);
            } else {
                this.runContentMenuAction(CLOSE_OTHERS);
            }
        } else if (menuAction.equals(CLOSE_ALL)) {
            CTabItem[] cTabs = folder.getItems();
            int index = 0;
            while (index < cTabs.length) {
                ServerPolicyTab modifyPolicyTab;
                CTabItem tab = cTabs[index];
                if (!(tab instanceof ServerPolicyOverviewTab) && tab instanceof ServerPolicyTab && (modifyPolicyTab = (ServerPolicyTab)tab).getPolicyDetailComposite() != null && modifyPolicyTab.getPolicyDetailComposite().isDirty()) {
                    dirtyStatus = true;
                    break;
                }
                ++index;
            }
            if (dirtyStatus) {
                new OpenSaveDialogMulitple(folder, CLOSE_ALL);
            } else {
                this.runContentMenuAction(CLOSE_ALL);
            }
        }
    }

    public void runContentMenuAction(String type) {
        block8: {
            CTabItem selTab;
            CTabItem[] openTabs;
            block7: {
                openTabs = folder.getItems();
                selTab = folder.getSelection();
                if (!type.equals(CLOSE)) break block7;
                if (selTab instanceof ServerPolicyOverviewTab) break block8;
                selTab.dispose();
                break block8;
            }
            if (type.equals(CLOSE_ALL)) {
                int index = 0;
                while (index < openTabs.length) {
                    CTabItem cTab = openTabs[index];
                    if (!(cTab instanceof ServerPolicyOverviewTab)) {
                        cTab.dispose();
                    }
                    ++index;
                }
            } else if (type.equals(CLOSE_OTHERS)) {
                int index = 0;
                while (index < openTabs.length) {
                    CTabItem cTab;
                    if (!openTabs[index].equals(selTab) && !((cTab = openTabs[index]) instanceof ServerPolicyOverviewTab)) {
                        cTab.dispose();
                    }
                    ++index;
                }
            }
        }
    }
}

