/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.views.sim;

import com.blixx.boom.engine.BMUI;
import com.blixx.boom.sim.cluster.Cluster;
import com.blixx.boom.sim.cluster.ClusterStatistics;
import com.blixx.shared.SEvent;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.graphics.Image;

public class ClusterPatternLabelProvider
extends ColumnLabelProvider {
    private static final String TIME_FORMAT = "yyyy-MM-dd HH:mm:ss:SSS";

    public void update(ViewerCell cell) {
        Object element = cell.getElement();
        if (element instanceof Cluster) {
            Cluster cluster = (Cluster)element;
            ClusterStatistics statistics = cluster.getStatistics();
            int columnIndex = cell.getColumnIndex();
            switch (columnIndex) {
                case 0: {
                    cell.setText(String.valueOf(cluster.size()));
                    break;
                }
                case 1: {
                    cell.setImage(this.getColumnImage(cluster.getPatternElement().getEvent()));
                    break;
                }
                case 8: {
                    cell.setText(String.valueOf(statistics.duplicatesCount));
                    break;
                }
                case 9: {
                    cell.setText(String.valueOf(statistics.distinctAgentsCount));
                    break;
                }
                case 10: {
                    Date date = new Date(statistics.minServerTime);
                    cell.setText(new SimpleDateFormat(TIME_FORMAT).format(date));
                    break;
                }
                case 11: {
                    Date date = new Date(statistics.maxServerTime);
                    cell.setText(new SimpleDateFormat(TIME_FORMAT).format(date));
                    break;
                }
                case 12: {
                    cell.setText(cluster.getPattern());
                    break;
                }
                case 2: {
                    Integer count = statistics.severityCounts.getCount(0);
                    if (count == null) break;
                    cell.setText(String.valueOf(count));
                    break;
                }
                case 3: {
                    Integer countNo = statistics.severityCounts.getCount(1);
                    if (countNo == null) break;
                    cell.setText(String.valueOf(countNo));
                    break;
                }
                case 4: {
                    Integer countWa = statistics.severityCounts.getCount(2);
                    if (countWa == null) break;
                    cell.setText(String.valueOf(countWa));
                    break;
                }
                case 5: {
                    Integer countMi = statistics.severityCounts.getCount(3);
                    if (countMi == null) break;
                    cell.setText(String.valueOf(countMi));
                    break;
                }
                case 6: {
                    Integer countMa = statistics.severityCounts.getCount(4);
                    if (countMa == null) break;
                    cell.setText(String.valueOf(countMa));
                    break;
                }
                case 7: {
                    Integer countCr = statistics.severityCounts.getCount(5);
                    if (countCr == null) break;
                    cell.setText(String.valueOf(countCr));
                }
            }
        }
    }

    public Image getColumnImage(Object element) {
        Image image = null;
        SEvent e = (SEvent)element;
        image = this.getSeverityImage(e.getSeverityInt());
        return image;
    }

    public Image getSeverityImage(int severity) {
        if (severity < 0) {
            severity += 6;
        }
        return BMUI.getIcon(severity);
    }
}

