/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.views.sim;

import com.blixx.boom.sim.cluster.Cluster;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Comparator;
import org.eclipse.jface.viewers.IElementComparer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;

public class ClusterPatternSorter
extends ViewerSorter
implements IElementComparer,
Comparator,
Serializable {
    private static final long serialVersionUID = 1803279124795645833L;
    private int columnNumber = -1;
    private int dir = 1024;
    private int delta;

    public ClusterPatternSorter(int columnNumber, int dir) {
        this.setConfig(columnNumber, dir);
    }

    public void setConfig(int columnNumber, int direction) {
        this.columnNumber = columnNumber;
        this.dir = direction;
    }

    public String getCurrentSorting() {
        String direction = "up";
        if (this.dir == 1024) {
            direction = "down";
        }
        return this.columnNumber + "|" + direction;
    }

    public int compare(Viewer viewer, Object e1, Object e2) {
        return this.compare(e1, e2);
    }

    public int compare(Object c1, Object c2) {
        int result = 0;
        if (!(c1 instanceof Cluster) || !(c2 instanceof Cluster)) {
            return 0;
        }
        Cluster cluster1 = (Cluster)c1;
        Cluster cluster2 = (Cluster)c2;
        switch (this.columnNumber) {
            case 0: {
                result = this.compareSize(cluster1, cluster2);
                break;
            }
            case 1: {
                result = this.compareGroupSeverity(cluster1, cluster2);
                break;
            }
            case 2: {
                result = this.compareSeverity(cluster1, cluster2, 0);
                break;
            }
            case 3: {
                result = this.compareSeverity(cluster1, cluster2, 1);
                break;
            }
            case 4: {
                result = this.compareSeverity(cluster1, cluster2, 2);
                break;
            }
            case 5: {
                result = this.compareSeverity(cluster1, cluster2, 3);
                break;
            }
            case 6: {
                result = this.compareSeverity(cluster1, cluster2, 4);
                break;
            }
            case 7: {
                result = this.compareSeverity(cluster1, cluster2, 5);
                break;
            }
            case 8: {
                result = this.compareDuplicatesCount(cluster1, cluster2);
                break;
            }
            case 9: {
                result = this.compareDistinctAgents(cluster1, cluster2);
                break;
            }
            case 10: {
                result = this.compareMinTime(cluster1, cluster2);
                break;
            }
            case 11: {
                result = this.compareMaxTime(cluster1, cluster2);
                break;
            }
            case 12: {
                result = this.comparePattern(cluster1, cluster2);
                if (result != 0) break;
                result = this.compareSize(cluster1, cluster2);
            }
        }
        if (this.columnNumber != 12 && result == 0) {
            result = this.comparePattern(cluster1, cluster2);
        }
        if (this.dir == 1024) {
            result *= -1;
        }
        return result;
    }

    private int compareSeverity(Cluster cluster1, Cluster cluster2, int severity) {
        Integer y;
        Integer x = cluster1.getStatistics().severityCounts.getCount(severity);
        if (x == null) {
            x = 0;
        }
        if ((y = cluster2.getStatistics().severityCounts.getCount(severity)) == null) {
            y = 0;
        }
        return this.compareInts(x, y);
    }

    private int compareSize(Cluster cluster1, Cluster cluster2) {
        int x = cluster1.size();
        int y = cluster2.size();
        return this.compareInts(x, y);
    }

    private int compareGroupSeverity(Cluster cluster1, Cluster cluster2) {
        int x = cluster1.getPatternElement().getEvent().getSeverityInt();
        int y = cluster2.getPatternElement().getEvent().getSeverityInt();
        return this.compareInts(x, y);
    }

    private int comparePattern(Cluster cluster1, Cluster cluster2) {
        return cluster1.getPattern().compareTo(cluster2.getPattern());
    }

    private int compareDuplicatesCount(Cluster cluster1, Cluster cluster2) {
        return this.compareInts(cluster1.getStatistics().duplicatesCount, cluster2.getStatistics().duplicatesCount);
    }

    private int compareDistinctAgents(Cluster cluster1, Cluster cluster2) {
        return this.compareInts(cluster1.getStatistics().distinctAgentsCount, cluster2.getStatistics().distinctAgentsCount);
    }

    private int compareMinTime(Cluster cluster1, Cluster cluster2) {
        long x = cluster1.getStatistics().minServerTime;
        long y = cluster2.getStatistics().minServerTime;
        return x < y ? -1 : (x == y ? 0 : 1);
    }

    private int compareMaxTime(Cluster cluster1, Cluster cluster2) {
        long x = cluster1.getStatistics().maxServerTime;
        long y = cluster2.getStatistics().maxServerTime;
        return x < y ? -1 : (x == y ? 0 : 1);
    }

    private int compareInts(int x, int y) {
        return x < y ? -1 : (x == y ? 0 : 1);
    }

    public void sort(Viewer viewer, Object[] elements) {
        Arrays.sort(elements, this);
    }

    public boolean equals(Object a, Object b) {
        return false;
    }

    public int hashCode(Object element) {
        return element.hashCode();
    }
}

