/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.views.sim;

import com.blixx.boom.engine.BMUI;
import com.blixx.boom.engine.EventStorageUtils;
import com.blixx.boom.engine.IEventProvider;
import com.blixx.boom.engine.ITableBrowserProvider;
import com.blixx.boom.engine.Repository;
import com.blixx.boom.gui.settings.PredefinedTab;
import com.blixx.boom.gui.settings.UISettings;
import com.blixx.boom.gui.views.MessageBrowserTab;
import com.blixx.boom.gui.views.MessagesView;
import com.blixx.boom.gui.views.sim.DummyEventProvider;
import com.blixx.boom.sim.cluster.Cluster;
import com.blixx.boom.sim.cluster.ClusterElement;
import com.blixx.shared.IEvent;
import com.blixx.shared.SEvent;
import com.blixx.shared.SEventFwd;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;

public class ClusteredIndicationTableBrowserProvider
implements ITableBrowserProvider {
    protected boolean m_isShowActive = true;
    private int numUnknMessages = 0;
    private int numNormMessages = 0;
    private int numWarnMessages = 0;
    private int numMinorMessages = 0;
    private int numMajorMessages = 0;
    private int numCritMessages = 0;
    private int totalActualMessages = 0;
    private int totalAcknMessages = 0;

    private void resetCounts() {
        this.numUnknMessages = 0;
        this.numNormMessages = 0;
        this.numWarnMessages = 0;
        this.numMinorMessages = 0;
        this.numMajorMessages = 0;
        this.numCritMessages = 0;
        this.totalActualMessages = 0;
        this.totalAcknMessages = 0;
    }

    private void updateCounts(SEvent event) {
        switch (event.getSeverityInt()) {
            case 0: {
                ++this.numUnknMessages;
                break;
            }
            case 1: {
                ++this.numNormMessages;
                break;
            }
            case 2: {
                ++this.numWarnMessages;
                break;
            }
            case 3: {
                ++this.numMinorMessages;
                break;
            }
            case 4: {
                ++this.numMajorMessages;
                break;
            }
            case 5: {
                ++this.numCritMessages;
            }
        }
        if (event.getState() != '-') {
            ++this.totalAcknMessages;
        }
        ++this.totalActualMessages;
    }

    public void setSelected(List list) {
        this.resetCounts();
        for (Object listElement : list) {
            if (!(listElement instanceof Cluster)) continue;
            Cluster cluster = (Cluster)listElement;
            List<ClusterElement> elements = cluster.getElementsCopy();
            for (ClusterElement element : elements) {
                if (this.isShowActive() && element.getEvent().getState() == '-') {
                    this.updateCounts(element.getEvent());
                    continue;
                }
                if (this.isShowActive() || element.getEvent().getState() != 'O' && element.getEvent().getState() != 'A') continue;
                this.updateCounts(element.getEvent());
            }
        }
    }

    public Object[] getElements(Object inputElement) {
        ArrayList<SEvent> resultList = new ArrayList<SEvent>();
        if (inputElement instanceof List) {
            List list = (List)inputElement;
            for (Object listElement : list) {
                if (!(listElement instanceof Cluster)) continue;
                Cluster cluster = (Cluster)listElement;
                List<ClusterElement> elements = cluster.getElementsCopy();
                for (ClusterElement element : elements) {
                    if (this.isShowActive() && element.getEvent().getState() == '-') {
                        resultList.add(element.getEvent());
                        continue;
                    }
                    if (this.isShowActive() || element.getEvent().getState() == '-') continue;
                    resultList.add(element.getEvent());
                }
            }
        }
        return resultList.toArray();
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public Image getColumnImage(Object element, int columnIndex) {
        SEventFwd sef;
        String res;
        Image image = null;
        SEvent e = (SEvent)element;
        if (columnIndex == 0) {
            switch (e.getSeverityInt()) {
                case 5: {
                    image = BMUI.IMAGE_CRITICAL;
                    break;
                }
                case 4: {
                    image = BMUI.IMAGE_MAJOR;
                    break;
                }
                case 3: {
                    image = BMUI.IMAGE_MINOR;
                    break;
                }
                case 2: {
                    image = BMUI.IMAGE_WARNING;
                    break;
                }
                case 1: {
                    image = BMUI.IMAGE_NORMAL;
                    break;
                }
                case 0: {
                    image = BMUI.IMAGE_UNKNOWN;
                    break;
                }
                case -1: {
                    image = BMUI.IMAGE_CRITICAL_F;
                    break;
                }
                case -2: {
                    image = BMUI.IMAGE_MAJOR_F;
                    break;
                }
                case -3: {
                    image = BMUI.IMAGE_MINOR_F;
                    break;
                }
                case -4: {
                    image = BMUI.IMAGE_WARNING_F;
                    break;
                }
                case -5: {
                    image = BMUI.IMAGE_NORMAL_F;
                    break;
                }
                case -6: {
                    image = BMUI.IMAGE_UNKNOWN_F;
                    break;
                }
            }
        } else if (columnIndex == 31 && e instanceof SEventFwd && (res = (sef = (SEventFwd)e).getT5()) != null && res.indexOf(10) != -1) {
            image = res.startsWith(String.valueOf(Repository.m_user) + '\n') ? BMUI.IMAGE_OWNED_ME : BMUI.IMAGE_OWNED;
        }
        return image;
    }

    public String getColumnText(Object element, int columnIndex) {
        SEvent e = (SEvent)element;
        String label = EventStorageUtils.getLabel(e, columnIndex);
        return label;
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }

    public Color getForeground(Object element, int columnIndex) {
        return null;
    }

    public Color getBackground(Object element, int columnIndex) {
        Color bgColor = null;
        boolean active = this.isBGColoringActive(columnIndex);
        if (active && element != null && element instanceof IEvent) {
            IEvent sef = (IEvent)element;
            switch (sef.getSeverityInt()) {
                case 0: {
                    bgColor = BMUI.color_unknown;
                    break;
                }
                case 1: {
                    bgColor = BMUI.color_normal;
                    break;
                }
                case 2: {
                    bgColor = BMUI.color_warning;
                    break;
                }
                case 3: {
                    bgColor = BMUI.color_minor;
                    break;
                }
                case 4: {
                    bgColor = BMUI.color_major;
                    break;
                }
                case 5: {
                    bgColor = BMUI.color_critical;
                    break;
                }
            }
        }
        return bgColor;
    }

    @Override
    public boolean isShowActive() {
        return this.m_isShowActive;
    }

    @Override
    public void setShowActive(boolean isShowActive) {
        this.m_isShowActive = isShowActive;
    }

    @Override
    public int getNumUnknMessages() {
        return this.numUnknMessages;
    }

    @Override
    public int getNumNormMessages() {
        return this.numNormMessages;
    }

    @Override
    public int getNumWarnMessages() {
        return this.numWarnMessages;
    }

    @Override
    public int getNumMinorMessages() {
        return this.numMinorMessages;
    }

    @Override
    public int getNumMajorMessages() {
        return this.numMajorMessages;
    }

    @Override
    public int getNumCritMessages() {
        return this.numCritMessages;
    }

    @Override
    public int getTotalActualMessages() {
        return this.totalActualMessages;
    }

    @Override
    public int getTotalAcknMessages() {
        return this.totalAcknMessages;
    }

    @Override
    public IEventProvider getEventProvider() {
        return new DummyEventProvider();
    }

    @Override
    public void enable(boolean enable) {
    }

    @Override
    public int getType() {
        return 0;
    }

    public boolean isBGColoringActive(int colIndexOrig) {
        boolean isBGColorActive = false;
        try {
            MessageBrowserTab activeBrowserTab = (MessageBrowserTab)MessagesView.getInstance().m_folder.getSelection();
            if (activeBrowserTab != null) {
                PredefinedTab tab;
                String colName = EventStorageUtils.getColumnNameByID(colIndexOrig);
                isBGColorActive = UISettings.getInstance().IB_isBGColoringActive(colName);
                if ((activeBrowserTab.isPredefinedTab() || activeBrowserTab.isUserTab()) && (tab = activeBrowserTab.m_predefinedOrUserTab) != null) {
                    isBGColorActive = tab.getColumn(colName).isColoringActive();
                }
            }
        }
        catch (Throwable throwable) {}
        return isBGColorActive;
    }
}

