/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.views.sim;

import com.blixx.boom.gui.settings.UISettings;
import com.blixx.boom.gui.views.sim.SimTab;
import com.blixx.boom.sim.ClusterProvider;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.widgets.Display;

public class FindMessageClusterAction
extends Action {
    private SimTab m_window;
    private TableViewer m_tviewer = null;
    private ClusterProvider m_clusterProvider;

    public FindMessageClusterAction(SimTab tab, TableViewer tViewer, ClusterProvider clusterProvider) {
        super("viewFindMessage");
        this.setId("viewFindMessage");
        this.setText("Find Clusters");
        this.m_tviewer = tViewer;
        this.m_window = tab;
        this.m_clusterProvider = clusterProvider;
        this.setEnabled(true);
    }

    public void run() {
        if (!this.isEnabled()) {
            return;
        }
        this.m_tviewer.setSelection((ISelection)StructuredSelection.EMPTY);
        InputDialog dlg = new InputDialog(Display.getCurrent().getActiveShell(), "Find clusters", "Enter message Ids separated by space:", "", null);
        if (dlg.open() == 0) {
            String[] ids = dlg.getValue().split(" ");
            if (dlg.getValue().matches("[0-9a-f]{8}-([0-9a-f]{4}-){3}[0-9a-f]{12}")) {
                this.m_tviewer.setSelection((ISelection)new StructuredSelection(this.m_clusterProvider.findClustersByIds(ids).toArray()), true);
            } else {
                this.m_tviewer.setSelection((ISelection)new StructuredSelection(this.m_clusterProvider.findClustersByPattern(dlg.getValue()).toArray()), true);
            }
        }
        this.m_window.isShowing();
        UISettings.getInstance().storeAndReload();
    }
}

