/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.views.sim;

import com.blixx.boom.engine.BMUI;
import com.blixx.boom.engine.EventFilter;
import com.blixx.boom.engine.EventStorage;
import com.blixx.boom.engine.IEventProvider;
import com.blixx.boom.engine.Repository;
import com.blixx.boom.engine.UIJob;
import com.blixx.boom.engine.UIJobManager;
import com.blixx.boom.gui.dialogs.ProgressDialog;
import com.blixx.boom.gui.settings.UISettings;
import com.blixx.boom.gui.utils.GUIDisplayElements;
import com.blixx.boom.gui.views.MessageBrowserTab;
import com.blixx.boom.gui.views.SimilarView;
import com.blixx.boom.gui.views.actions.AcknowledgeAction;
import com.blixx.boom.gui.views.actions.ArchiveMessagesAction;
import com.blixx.boom.gui.views.actions.ReopenMessagesAction;
import com.blixx.boom.gui.views.actions.ViewFilterAction;
import com.blixx.boom.gui.views.sim.ClusterPatternLabelProvider;
import com.blixx.boom.gui.views.sim.ClusterPatternSorter;
import com.blixx.boom.gui.views.sim.ClusteredIndicationTableBrowserProvider;
import com.blixx.boom.gui.views.sim.IndicationPatternTableViewer;
import com.blixx.boom.gui.views.sim.ViewActiveMessagesAction;
import com.blixx.boom.sim.ClusterProvider;
import com.blixx.boom.sim.ClusterUpdateListener;
import com.blixx.boom.sim.FilterProvider;
import com.blixx.boom.sim.ProgressListener;
import com.blixx.boom.sim.cluster.Cluster;
import com.blixx.boom.sim.cluster.ClusterElement;
import com.blixx.log.RTLogger;
import com.blixx.shared.SEvent;
import com.blixx.shared.Severity;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.IWorkbenchPartSite;

public class SimTab
extends CTabItem
implements ProgressListener,
ClusterUpdateListener,
FilterProvider,
DisposeListener {
    private static SimTab m_tab = null;
    public IndicationPatternTableViewer indicationPatternTableViewer = null;
    private IEventProvider m_eventStorage = null;
    private ClusterProvider m_clusterProvider = null;
    private ClusterPatternProvider m_clusterPatternProvider = null;
    private GUIDisplayElements m_gui = null;
    protected Label m_totalGroupsCountLabel = null;
    protected Button m_groupSeverityCheckBox = null;
    protected ClusterPatternSorter m_clusterPatternSorter = null;
    private MessageBrowserTab m_filteredGroupMessageBrowserTab = null;
    private MessageBrowserTab m_uniqueMessageBrowserTab = null;
    private ClusteredIndicationTableBrowserProvider m_indicationBrowserProvider = null;
    private ClusteredIndicationTableBrowserProvider m_uniqueIndicationBrowserProvider = null;
    private ClusterPatternLabelProvider m_clusterPatternLabelProvider = null;
    public boolean m_showActive = true;
    private ProgressDialog m_progressDialog = null;
    private Composite m_summaryComp = null;
    private static final AtomicBoolean m_clusteringInProgress = new AtomicBoolean(false);
    private TableColumn m_clusterSeverityColumn = null;
    private List<TableColumn> m_severityColumns = new ArrayList<TableColumn>();
    private static final int MIN_ELEMENTS_IN_CLUSTERS = 2;
    public Listener groupPatternSortListener = new Listener(){

        public void handleEvent(Event e) {
            if (!UISettings.getInstance().IB_canSortTable()) {
                return;
            }
            if (e.type == 13) {
                TableColumn sortColumn = SimTab.this.indicationPatternTableViewer.getTable().getSortColumn();
                TableColumn currentColumn = (TableColumn)e.widget;
                int dir = SimTab.this.indicationPatternTableViewer.getTable().getSortDirection();
                if (sortColumn == currentColumn) {
                    dir = dir == 128 ? 1024 : 128;
                } else {
                    SimTab.this.indicationPatternTableViewer.getTable().setSortColumn(currentColumn);
                    dir = 128;
                }
                Integer columnIndex = (Integer)currentColumn.getData("ColumnIndex");
                SimTab.this.m_clusterPatternSorter.setConfig(columnIndex, dir);
                SimTab.this.indicationPatternTableViewer.getTable().setSortDirection(dir);
                if (SimTab.this.indicationPatternTableViewer.getSorter() != SimTab.this.m_clusterPatternSorter) {
                    SimTab.this.indicationPatternTableViewer.setSorter(SimTab.this.m_clusterPatternSorter);
                } else {
                    SimTab.this.indicationPatternTableViewer.refresh(true, false);
                }
                UISettings.getInstance().storeAndReload();
            }
        }
    };

    public SimTab(CTabFolder parent, int style, String titleIfnecessary) {
        super(parent, style);
        m_tab = this;
        this.m_showActive = true;
        if (titleIfnecessary != null) {
            this.setText(titleIfnecessary);
        } else {
            this.setText("Similar Indications ");
        }
        this.checkTitle();
        this.m_gui = new GUIDisplayElements();
        this.m_eventStorage = EventStorage.getInstance();
        this.m_clusterPatternSorter = new ClusterPatternSorter(0, 1024);
        this.m_clusterProvider = new ClusterProvider(this.m_eventStorage);
        this.m_clusterProvider.addProgressListener(this);
        this.m_clusterProvider.setFilterProvider(this);
        this.m_clusterProvider.addUpdateListener(this);
        this.addDisposeListener(this);
        SashForm sash = new SashForm((Composite)parent, 512);
        this.createSimmilarIndiTable((Composite)sash);
        this.createGroupFilteredTable((Composite)sash);
        this.createUniqueMessagesTable((Composite)sash);
        sash.setWeights(new int[]{35, 35, 30});
        this.setControl((Control)sash);
        this.createThreadToWaitUtilServerIsOnline();
    }

    private void createThreadToWaitUtilServerIsOnline() {
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    m_clusteringInProgress.set(true);
                    while (!Repository.getInstance().isServerOnline()) {
                        Thread.sleep(1000L);
                    }
                    UIJob uij = new UIJob("Initialize Sim Tab" + System.currentTimeMillis()){

                        @Override
                        public IStatus runInUIThread(IProgressMonitor monitor) {
                            try {
                                SimTab.this.m_eventStorage.registerSEventUpdateLitener(SimTab.this.m_clusterProvider);
                                SimTab.this.switchClusterViewTo((this).SimTab.this.m_showActive);
                                m_clusteringInProgress.set(false);
                            }
                            catch (Throwable throwable) {}
                            return Status.OK_STATUS;
                        }
                    };
                    UIJobManager.getInstance().schedule(uij);
                }
                catch (InterruptedException interruptedException) {}
            }
        });
        thread.start();
    }

    public void switchClusterViewTo(boolean active) {
        this.m_showActive = active;
        this.m_clusterProvider.setProcessActive(this.m_showActive);
    }

    private void createUniqueMessagesTable(Composite comp) {
        CTabFolder ctf = new CTabFolder(comp, 2816);
        ctf.setSimple(false);
        ctf.setBorderVisible(false);
        ctf.setBackground(BMUI.color_unknown);
        this.m_uniqueIndicationBrowserProvider = new ClusteredIndicationTableBrowserProvider();
        this.m_uniqueMessageBrowserTab = new MessageBrowserTab(SimilarView.getInstance().getSite(), ctf, 0, 1, "Unique ", true, this.m_uniqueIndicationBrowserProvider, EventStorage.getInstance(), MessageBrowserTab.SIM_TAB, null);
        ctf.setSelection((CTabItem)this.m_uniqueMessageBrowserTab);
    }

    private void createGroupFilteredTable(Composite comp) {
        CTabFolder ctf = new CTabFolder(comp, 2816);
        ctf.setSimple(false);
        ctf.setBorderVisible(false);
        ctf.setBackground(BMUI.color_unknown);
        this.m_indicationBrowserProvider = new ClusteredIndicationTableBrowserProvider();
        this.m_filteredGroupMessageBrowserTab = new MessageBrowserTab(SimilarView.getInstance().getSite(), ctf, 0, 1, "Related Indications ", true, this.m_indicationBrowserProvider, EventStorage.getInstance(), MessageBrowserTab.SIM_TAB, null);
        ctf.setSelection((CTabItem)this.m_filteredGroupMessageBrowserTab);
    }

    public void createSimmilarIndiTable(Composite parent) {
        Composite comp = new Composite(parent, 0);
        GridLayout gl = new GridLayout(1, false);
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        comp.setLayout((Layout)gl);
        comp.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        this.m_groupSeverityCheckBox = this.m_gui.addCheckbox(comp, null, " Group by Severity", true, 1, 1, 5, null);
        ((GridData)this.m_groupSeverityCheckBox.getLayoutData()).horizontalIndent = 5;
        this.m_groupSeverityCheckBox.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                SimTab.this.m_clusterProvider.setGroupBySeverity(SimTab.this.m_groupSeverityCheckBox.getSelection());
                if (SimTab.this.m_groupSeverityCheckBox.getSelection()) {
                    for (TableColumn column : SimTab.this.m_severityColumns) {
                        column.setWidth(0);
                        column.setResizable(false);
                    }
                    SimTab.this.m_clusterSeverityColumn.setWidth(50);
                    SimTab.this.m_clusterSeverityColumn.setResizable(true);
                } else {
                    for (TableColumn column : SimTab.this.m_severityColumns) {
                        column.setWidth(50);
                        column.setResizable(true);
                    }
                    SimTab.this.m_clusterSeverityColumn.setWidth(0);
                    SimTab.this.m_clusterSeverityColumn.setResizable(false);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Table tbl = new Table(comp, 268503810);
        tbl.setHeaderVisible(true);
        tbl.setLinesVisible(true);
        this.m_clusterPatternLabelProvider = new ClusterPatternLabelProvider();
        this.createTableColumn(tbl, 0, "Count", 75, this.groupPatternSortListener);
        this.m_clusterSeverityColumn = this.createTableColumn(tbl, 1, "Severity", 20, this.groupPatternSortListener);
        this.createTableColumn(tbl, 2, null, 0, this.groupPatternSortListener);
        this.createTableColumn(tbl, 3, null, 0, this.groupPatternSortListener);
        this.createTableColumn(tbl, 4, null, 0, this.groupPatternSortListener);
        this.createTableColumn(tbl, 5, null, 0, this.groupPatternSortListener);
        this.createTableColumn(tbl, 6, null, 0, this.groupPatternSortListener);
        this.createTableColumn(tbl, 7, null, 0, this.groupPatternSortListener);
        this.createTableColumn(tbl, 8, "Duplicates", 50, this.groupPatternSortListener);
        this.createTableColumn(tbl, 9, "Distinct Agents", 50, this.groupPatternSortListener);
        this.createTableColumn(tbl, 10, "Min Server Time", 150, this.groupPatternSortListener);
        this.createTableColumn(tbl, 11, "Max Server Time", 150, this.groupPatternSortListener);
        this.createTableColumn(tbl, 12, "Pattern", 1500, this.groupPatternSortListener);
        GridData data0 = new GridData(4, 4, true, true);
        data0.heightHint = 450;
        tbl.setLayoutData((Object)data0);
        this.m_clusterPatternProvider = new ClusterPatternProvider();
        this.indicationPatternTableViewer = new IndicationPatternTableViewer(tbl);
        this.indicationPatternTableViewer.setUseHashlookup(true);
        this.indicationPatternTableViewer.setSorter(this.m_clusterPatternSorter);
        this.indicationPatternTableViewer.addFilterChangeListener(this.m_clusterProvider);
        this.indicationPatternTableViewer.setContentProvider((IContentProvider)this.m_clusterPatternProvider);
        this.indicationPatternTableViewer.setLabelProvider((IBaseLabelProvider)this.m_clusterPatternLabelProvider);
        this.indicationPatternTableViewer.getControl().addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
            }

            public void keyReleased(KeyEvent e) {
                if ((e.character == 's' || e.character == 'S') && (e.stateMask & 0x40000) == 0) {
                    ViewActiveMessagesAction switchAction = new ViewActiveMessagesAction(m_tab, SimTab.this.indicationPatternTableViewer, SimTab.this.m_showActive);
                    switchAction.run();
                }
            }
        });
        this.indicationPatternTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                StructuredSelection ssel = (StructuredSelection)SimTab.this.indicationPatternTableViewer.getSelection();
                SimTab.this.setTableSelection(ssel);
            }
        });
        this.indicationPatternTableViewer.refresh();
        this.createSummary(comp);
        this.createContentMenu();
    }

    private TableColumn createTableColumn(Table tbl, int columnIndex, String name, int width, Listener groupPatternSortListener) {
        TableColumn column = new TableColumn(tbl, 16384, columnIndex);
        if (columnIndex >= 2 && columnIndex <= 7) {
            this.m_severityColumns.add(column);
            Image image = this.m_clusterPatternLabelProvider.getSeverityImage(columnIndex - 2);
            column.setImage(image);
            name = Severity.getSeverity(columnIndex - 2);
        }
        column.setData("COL_DEFAULT_NAME", (Object)name);
        column.setData("ColumnIndex", (Object)columnIndex);
        column.setText(name);
        column.setToolTipText(name);
        column.setWidth(width);
        column.addListener(13, groupPatternSortListener);
        column.setMoveable(true);
        column.setResizable(width > 0);
        return column;
    }

    public void createSummary(Composite parent) {
        if (this.m_summaryComp == null) {
            this.m_summaryComp = new Composite(parent, 0);
            GridLayout gl = new GridLayout(2, false);
            gl.marginHeight = 0;
            gl.marginBottom = 5;
            this.m_summaryComp.setLayout((Layout)gl);
            this.m_summaryComp.setLayoutData((Object)new GridData(4, 128, true, false));
            this.m_totalGroupsCountLabel = new Label(this.m_summaryComp, 0);
            this.m_totalGroupsCountLabel.setLayoutData((Object)new GridData());
        }
        int count = 0;
        if (this.m_clusterProvider != null) {
            count = this.m_clusterProvider.getClusterCountWithMinXElements(2);
        }
        this.m_totalGroupsCountLabel.setText("Total:  " + count);
        this.m_summaryComp.pack();
    }

    public void createContentMenu() {
        try {
            MenuManager menuMgr = new MenuManager("#PopupMenu");
            menuMgr.setRemoveAllWhenShown(false);
            Menu menu = menuMgr.createContextMenu(this.indicationPatternTableViewer.getControl());
            this.indicationPatternTableViewer.getControl().setMenu(menu);
            IWorkbenchPartSite site = SimilarView.getInstance().getSite();
            site.registerContextMenu(menuMgr, (ISelectionProvider)this.indicationPatternTableViewer);
            menuMgr.setRemoveAllWhenShown(true);
            menuMgr.addMenuListener(new IMenuListener(){

                public void menuAboutToShow(IMenuManager manager) {
                    try {
                        ViewActiveMessagesAction switchAction = new ViewActiveMessagesAction(m_tab, SimTab.this.indicationPatternTableViewer, SimTab.this.m_showActive);
                        switchAction.setEnabled(true);
                        manager.add((IAction)switchAction);
                        if (!m_clusteringInProgress.get()) {
                            StructuredSelection ssel = (StructuredSelection)SimTab.this.indicationPatternTableViewer.getSelection();
                            ArrayList<SEvent> events = new ArrayList<SEvent>();
                            Iterator iterator = ssel.iterator();
                            while (iterator.hasNext()) {
                                List<ClusterElement> elements = ((Cluster)iterator.next()).getElementsCopy();
                                for (ClusterElement element : elements) {
                                    events.add(element.getEvent());
                                }
                            }
                            if (events.size() > 0) {
                                manager.add((IContributionItem)new Separator());
                                if (SimTab.this.m_showActive) {
                                    manager.add((IAction)new AcknowledgeAction(((SimTab)SimTab.this).m_filteredGroupMessageBrowserTab.tableViewer, events.iterator(), SimTab.this.isOutage()));
                                    manager.add((IAction)new ArchiveMessagesAction(null, ((SimTab)SimTab.this).m_filteredGroupMessageBrowserTab.tableViewer, events.iterator(), SimTab.this.isOutage()));
                                } else {
                                    manager.add((IAction)new ArchiveMessagesAction(null, ((SimTab)SimTab.this).m_filteredGroupMessageBrowserTab.tableViewer, events.iterator(), SimTab.this.isOutage()));
                                    manager.add((IAction)new ReopenMessagesAction(null, ((SimTab)SimTab.this).m_filteredGroupMessageBrowserTab.tableViewer, events.iterator(), SimTab.this.isOutage()));
                                }
                            }
                            manager.add((IContributionItem)new Separator());
                            ViewFilterAction newFilterAction = new ViewFilterAction(m_tab, SimTab.this.m_filteredGroupMessageBrowserTab, SimTab.this.indicationPatternTableViewer, null, null, false, SimTab.this.getText());
                            manager.add((IAction)newFilterAction);
                            Iterator<EventFilter> it = ViewFilterAction.getActiveFiltersIterator(SimTab.this.indicationPatternTableViewer);
                            while (it.hasNext()) {
                                EventFilter ef = it.next();
                                ViewFilterAction action = new ViewFilterAction(m_tab, SimTab.this.m_filteredGroupMessageBrowserTab, SimTab.this.indicationPatternTableViewer, ef, ef.getLabelOrName(), ef.m_isActive, m_tab.getText());
                                manager.add((IAction)action);
                            }
                        }
                    }
                    catch (RuntimeException e) {
                        RTLogger.print(4, "", e);
                    }
                }
            });
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public void checkTitle() {
        try {
            String title = this.getText();
            title = title.replace("[Active]", "");
            title = title.replace("[Closed]", "");
            title = this.m_showActive ? String.valueOf(title) + "[Active]" : String.valueOf(title) + "[Closed]";
            this.setText(title);
            this.setFont(BMUI.font_arial8_bold);
            if (this.indicationPatternTableViewer.getFilters() != null && this.indicationPatternTableViewer.getFilters().length > 0) {
                this.setImage(BMUI.IMAGE_FILTERED);
            } else {
                this.setImage(null);
            }
        }
        catch (Throwable throwable) {}
    }

    public void setColors() {
        if (this.indicationPatternTableViewer != null && this.indicationPatternTableViewer.getTable() != null && !this.indicationPatternTableViewer.getTable().isDisposed()) {
            Color bgColor_tableNormalActive = UISettings.getInstance().getIB_BackgroundColors(0, true);
            Color bgColor_tableNormalClosed = UISettings.getInstance().getIB_BackgroundColors(0, false);
            if (this.m_showActive) {
                this.indicationPatternTableViewer.getTable().setBackground(bgColor_tableNormalActive);
            } else {
                this.indicationPatternTableViewer.getTable().setBackground(bgColor_tableNormalClosed);
            }
            this.indicationPatternTableViewer.getTable().setForeground(BMUI.color_black);
        }
    }

    @Override
    public void taskStarted(final String taskName, final int maxValue) {
        UIJob uij = new UIJob("Create progress bar: " + taskName + " " + System.nanoTime()){

            @Override
            public IStatus runInUIThread(IProgressMonitor monitor) {
                try {
                    if (SimTab.this.m_progressDialog != null && SimTab.this.m_progressDialog.getShell() != null && !SimTab.this.m_progressDialog.getShell().isDisposed()) {
                        SimTab.this.m_progressDialog.close();
                        SimTab.this.m_progressDialog = null;
                    }
                    SimTab.this.m_progressDialog = new ProgressDialog(taskName, "Processing...", 0, maxValue);
                    SimTab.this.m_progressDialog.setBlockOnOpen(false);
                    SimTab.this.m_progressDialog.open();
                }
                catch (Throwable throwable) {}
                return Status.OK_STATUS;
            }
        };
        UIJobManager.getInstance().schedule(uij);
    }

    @Override
    public void progressMade(final String taskName, final int currentValue, int maxValue) {
        UIJob uij = new UIJob("Update progress bar: " + taskName){

            @Override
            public IStatus runInUIThread(IProgressMonitor monitor) {
                try {
                    if (SimTab.this.m_progressDialog != null && SimTab.this.m_progressDialog.getShell() != null && !SimTab.this.m_progressDialog.getShell().isDisposed()) {
                        SimTab.this.m_progressDialog.setProgress(taskName, currentValue);
                    }
                }
                catch (Throwable throwable) {}
                return Status.OK_STATUS;
            }
        };
        UIJobManager.getInstance().schedule(uij);
    }

    @Override
    public void taskFinished(String taskName) {
        UIJob uij = new UIJob("Dispose progress bar" + taskName + " " + System.nanoTime()){

            @Override
            public IStatus runInUIThread(IProgressMonitor monitor) {
                try {
                    if (SimTab.this.m_progressDialog != null && SimTab.this.m_progressDialog.getShell() != null && !SimTab.this.m_progressDialog.getShell().isDisposed()) {
                        SimTab.this.m_progressDialog.close();
                        SimTab.this.m_progressDialog = null;
                    }
                }
                catch (Throwable throwable) {}
                return Status.OK_STATUS;
            }
        };
        UIJobManager.getInstance().schedule(uij);
    }

    @Override
    public void clustersUpdated() {
        UIJob uij = new UIJob("Refresh clusters view"){

            @Override
            public IStatus runInUIThread(IProgressMonitor monitor) {
                try {
                    SimTab.this.m_indicationBrowserProvider.setShowActive(SimTab.this.m_showActive);
                    SimTab.this.m_filteredGroupMessageBrowserTab.checkTitle();
                    SimTab.this.m_filteredGroupMessageBrowserTab.setColors();
                    SimTab.this.m_uniqueIndicationBrowserProvider.setShowActive(SimTab.this.m_showActive);
                    SimTab.this.m_uniqueMessageBrowserTab.checkTitle();
                    SimTab.this.m_uniqueMessageBrowserTab.setColors();
                    SimTab.this.createSummary(null);
                    SimTab.this.checkTitle();
                    SimTab.this.setColors();
                    SimTab.this.indicationPatternTableViewer.setInput(SimTab.this.m_clusterProvider.getClustersWithMinXElements(2));
                    ((SimTab)SimTab.this).m_filteredGroupMessageBrowserTab.tableViewer.refresh();
                    StructuredSelection ssel = (StructuredSelection)SimTab.this.indicationPatternTableViewer.getSelection();
                    SimTab.this.m_indicationBrowserProvider.setSelected(ssel.toList());
                    List<Cluster> uniqueClusters = SimTab.this.m_clusterProvider.getClustersWithMaxXElements(1);
                    SimTab.this.m_uniqueIndicationBrowserProvider.setSelected(uniqueClusters);
                    ((SimTab)SimTab.this).m_uniqueMessageBrowserTab.tableViewer.setInput(uniqueClusters);
                    SimTab.this.m_filteredGroupMessageBrowserTab.createSummary();
                    SimTab.this.m_uniqueMessageBrowserTab.createSummary();
                    SimTab.this.createSummary(null);
                }
                catch (Throwable e) {
                    RTLogger.print(4, "", e);
                }
                return Status.OK_STATUS;
            }
        };
        try {
            UIJobManager.getInstance().schedule(uij);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public void setTableSelection(StructuredSelection ssel) {
        this.m_filteredGroupMessageBrowserTab.tableViewer.setInput(ssel.toList());
        this.m_indicationBrowserProvider.setSelected(ssel.toList());
        this.m_filteredGroupMessageBrowserTab.createSummary();
    }

    @Override
    public Iterator<EventFilter> getActiveFiltersIterator() {
        return ViewFilterAction.getActiveFiltersIterator(this.indicationPatternTableViewer);
    }

    public TableViewer getTableViewerMessageBrowser() {
        return this.indicationPatternTableViewer;
    }

    public TableViewer getTableViewerGroupFiltered() {
        return this.m_filteredGroupMessageBrowserTab.getTableViewer();
    }

    public TableViewer getTableViewerUniqueMessages() {
        return this.m_uniqueMessageBrowserTab.getTableViewer();
    }

    public void widgetDisposed(DisposeEvent e) {
        this.m_eventStorage.unregisterSEventUpdateLitener(this.m_clusterProvider);
        try {
            this.m_filteredGroupMessageBrowserTab.dispose();
        }
        catch (Throwable throwable) {}
        try {
            this.m_uniqueMessageBrowserTab.dispose();
        }
        catch (Throwable throwable) {}
        try {
            this.m_uniqueIndicationBrowserProvider.dispose();
        }
        catch (Throwable throwable) {}
        try {
            this.indicationPatternTableViewer.resetFilters();
        }
        catch (Throwable throwable) {}
        try {
            this.indicationPatternTableViewer.getTable().dispose();
        }
        catch (Throwable throwable) {}
        try {
            this.m_clusterProvider.dispose();
        }
        catch (Throwable throwable) {}
        this.m_clusterProvider = null;
        try {
            this.getControl().dispose();
        }
        catch (Throwable throwable) {}
        try {
            this.dispose();
        }
        catch (Throwable throwable) {}
        this.taskFinished("Dispose");
    }

    public boolean isOutage() {
        return this.m_eventStorage != null && this.m_eventStorage.getType() == 1;
    }

    private class ClusterPatternProvider
    implements IStructuredContentProvider {
        private ClusterPatternProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            Object[] res = null;
            if (inputElement != null && inputElement instanceof List) {
                List list = (List)inputElement;
                res = list.toArray();
            }
            return res;
        }
    }
}

