/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.internationalization;

import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class Localization {
    public static String LOCALE_EN_US = "en_US";
    public static String LOCALE_DE_DE = "de_DE";
    public static String LOCALE_FR_FR = "fr_FR";
    public static String PROPERTIES_EN_US = "MessagePolicy_en_US.properties";
    public static String PROPERTIES_DE_DE = "MessagePolicy_de_DE.properties";
    public static String PROPERTIES_FR_FR = "MessagePolicy_fr_FR.properties";
    public Locale m_locale;
    public ResourceBundle m_messages;
    public String m_properties;

    public void Localization() {
        this.setDefault();
    }

    public void setDefault() {
        this.m_locale = new Locale("en", "US");
        this.m_properties = PROPERTIES_EN_US;
        this.m_messages = this.getResourceBundle();
    }

    private ResourceBundle getResourceBundle() {
        ResourceBundle prop = null;
        try {
            prop = ResourceBundle.getBundle("com.blixx.internationalization.MessagePolicy_en_US.properties", this.m_locale, this.getClass().getClassLoader());
        }
        catch (MissingResourceException mre) {
            mre.printStackTrace();
        }
        return prop;
    }

    public void setLanguage(String language) {
        if (language.equals(LOCALE_EN_US)) {
            this.setDefault();
        } else if (language.equals(LOCALE_DE_DE)) {
            this.m_locale = new Locale("de", "DE");
            this.m_properties = PROPERTIES_DE_DE;
            this.m_messages = this.getResourceBundle();
        } else if (language.equals(LOCALE_FR_FR)) {
            this.m_locale = new Locale("fr", "FR");
            this.m_properties = PROPERTIES_FR_FR;
            this.m_messages = this.getResourceBundle();
        } else {
            this.setDefault();
        }
    }

    public ResourceBundle getMessages() {
        return this.m_messages;
    }

    public Locale getLocale() {
        return this.m_locale;
    }

    public String getLanguage() {
        return this.m_locale.getLanguage();
    }

    public String getCountry() {
        return this.m_locale.getCountry();
    }
}

