/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.omu;

import com.blixx.boom.omu.PolicyConvereter;
import com.blixx.log.SALogger;
import com.blixx.shared.utils.StrUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class OMUInstructionsReader {
    static Map<String, String> interfaces = new LinkedHashMap<String, String>();
    static Map<File, List<String>> filesProcessed = new LinkedHashMap<File, List<String>>();

    public static boolean readFile(String filePath, SALogger logger) {
        File f = new File(filePath);
        if (f.exists()) {
            return OMUInstructionsReader.readFile(f, logger);
        }
        throw new RuntimeException("File not found: " + filePath);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean readFile(File file, SALogger logger) {
        filesProcessed.put(file, new LinkedList());
        FileReader in = null;
        BufferedReader br = null;
        try {
            in = new FileReader(file);
            br = new BufferedReader(in);
            String line = null;
            String ifaceName = null;
            String ifaceCall = null;
            StrUtils su = new StrUtils();
            while (true) {
                String[] arr;
                if ((line = br.readLine()) == null) {
                    if (ifaceName != null && ifaceCall != null) {
                        interfaces.put(ifaceName, ifaceCall);
                        filesProcessed.get(file).add(ifaceName);
                    }
                    break;
                }
                if ((line = line.trim()).startsWith("INSTRUCTION_INTERFACE")) {
                    if (ifaceName != null && ifaceCall != null) {
                        interfaces.put(ifaceName, ifaceCall);
                        filesProcessed.get(file).add(ifaceName);
                        ifaceName = null;
                        ifaceCall = null;
                    }
                    try {
                        arr = su.processQuoted(line);
                        ifaceName = su.removeQuotes(arr[1]);
                    }
                    catch (Throwable e) {
                        logger.print(1, "", e);
                    }
                }
                if (ifaceName == null || !line.startsWith("INSTR_INTERF_CALL")) continue;
                try {
                    arr = su.processQuoted(line);
                    ifaceCall = su.removeQuotes(arr[1]);
                }
                catch (Throwable throwable) {}
            }
        }
        catch (Throwable e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                try {
                    br.close();
                }
                catch (Throwable throwable2) {}
                try {
                    in.close();
                    throw throwable;
                }
                catch (Throwable throwable3) {}
                throw throwable;
            }
        }
        try {
            br.close();
        }
        catch (Throwable throwable) {}
        try {
            in.close();
            return true;
        }
        catch (Throwable throwable) {}
        return true;
    }

    public static Map<String, String> getInterfaces() {
        return interfaces;
    }

    public static Map<File, List<String>> getFilesProcessed() {
        return filesProcessed;
    }

    public static void registerInterfaces(SALogger sl) {
        Map<String, String> interfaces = OMUInstructionsReader.getInterfaces();
        for (Map.Entry<String, String> en : interfaces.entrySet()) {
            String name = en.getKey();
            String parameters = en.getValue();
            PolicyConvereter.addInstructionInterface(name, parameters, sl, null, null);
        }
    }
}

