/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.omu;

import com.blixx.log.RTLogger;
import com.blixx.log.SALogger;
import com.blixx.shared.XMLFactory;
import com.blixx.shared.utils.GroupTreeObject;
import com.blixx.shared.utils.GroupTreeObjectLast;
import com.blixx.shared.utils.StrUtils;
import com.blixx.shared.utils.TreeObject;
import com.blixx.shared.utils.XMLTree;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Document;

public class OMUNodeGroupsReader {
    public static Map<String, List<String>> m_assignmentsGR = new HashMap<String, List<String>>();
    public static Map<String, List<String>> m_assignmentsPO = new HashMap<String, List<String>>();
    public static Map<String, List<String>> m_agents = new HashMap<String, List<String>>();
    private static GroupTreeObject root_Nodes = new GroupTreeObject(new TreeObject("root", "", null));
    private static GroupTreeObject NodeGroups = new GroupTreeObject(new TreeObject("_Groups", "", null));

    static {
        root_Nodes.addElement(NodeGroups);
    }

    public static GroupTreeObject getNodeGroupsTree() {
        return root_Nodes;
    }

    public static void clearTrees() {
        root_Nodes.clean();
        NodeGroups = new GroupTreeObject(new TreeObject("_Groups", "", null));
        root_Nodes.addElement(NodeGroups);
        m_assignmentsGR.clear();
        m_assignmentsPO.clear();
    }

    public static void readFile(File file, SALogger logger) {
        FileReader in = null;
        BufferedReader br = null;
        try {
            try {
                in = new FileReader(file);
                br = new BufferedReader(in);
                String line = null;
                String currentNodeGroupName = null;
                List<Object> parentGTOs = new LinkedList();
                boolean nodesActive = false;
                boolean asnActive = false;
                StrUtils su = new StrUtils();
                while ((line = br.readLine()) != null) {
                    List<String> alist;
                    String name;
                    line = line.trim();
                    if ((line = line.replace('\t', ' ')).length() < 3) continue;
                    if (line.startsWith("NODE_GROUP")) {
                        currentNodeGroupName = su.removeQuotes(su.processQuoted(line)[1]);
                        parentGTOs = root_Nodes.findGroups(currentNodeGroupName, "");
                        if (parentGTOs.size() == 0) {
                            GroupTreeObject parentGTO = new GroupTreeObject(new TreeObject(currentNodeGroupName, "", null));
                            NodeGroups.addElement(parentGTO);
                        }
                    } else if (line.startsWith("NODE { IP ")) {
                        String hostname = su.removeQuotes(su.processQuoted(line)[4]);
                        parentGTOs = new LinkedList();
                        GroupTreeObjectLast agent = new GroupTreeObjectLast(new TreeObject(currentNodeGroupName, "agt", hostname), null, null);
                        parentGTOs.add(agent);
                    } else {
                        if (line.startsWith("SUBENTITIES NODE")) {
                            nodesActive = true;
                            asnActive = false;
                            continue;
                        }
                        if (line.startsWith("SUBENTITIES TEMPLATE")) {
                            nodesActive = false;
                            asnActive = true;
                            continue;
                        }
                    }
                    if ((nodesActive || asnActive) && line.equals(";")) {
                        nodesActive = false;
                        asnActive = false;
                        currentNodeGroupName = null;
                    }
                    if (nodesActive) {
                        String[] arr = su.processQuoted(line);
                        if (arr.length > 2 && "IP".equalsIgnoreCase(arr[0])) {
                            String hostName = su.removeQuotes(arr[2]);
                            List<String> ng_paths = m_agents.get(hostName);
                            if (ng_paths == null) {
                                ng_paths = new LinkedList<String>();
                                m_agents.put(hostName, ng_paths);
                            }
                            OMUNodeGroupsReader.fillList(parentGTOs, ng_paths);
                        } else {
                            String name2 = su.removeQuotes(line);
                            if (name2.contains(" IP_FLAGS ")) continue;
                            GroupTreeObject subGroup = new GroupTreeObject(new TreeObject(name2, "", null));
                            for (GroupTreeObject groupTreeObject : parentGTOs) {
                                if (groupTreeObject.getChild(subGroup.getName(), subGroup.getType()) != null) continue;
                                groupTreeObject.addElement(subGroup);
                            }
                        }
                    }
                    if (!asnActive) continue;
                    if (line.startsWith("MEMBER_TEMPLATE_GROUP")) {
                        name = su.removeQuotes(su.processQuoted(line)[1]);
                        alist = m_assignmentsGR.get(name);
                        if (alist == null) {
                            alist = new LinkedList<String>();
                            m_assignmentsGR.put(name, alist);
                        }
                        OMUNodeGroupsReader.fillList(parentGTOs, alist);
                        continue;
                    }
                    if (!line.startsWith("MEMBER_")) continue;
                    name = su.removeQuotes(su.processQuoted(line)[1]);
                    alist = m_assignmentsPO.get(name);
                    if (alist == null) {
                        alist = new LinkedList<String>();
                        m_assignmentsPO.put(name, alist);
                    }
                    OMUNodeGroupsReader.fillList(parentGTOs, alist);
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
        }
        catch (Throwable throwable) {
            try {
                br.close();
            }
            catch (Throwable throwable2) {}
            try {
                in.close();
            }
            catch (Throwable throwable3) {}
            throw throwable;
        }
        try {
            br.close();
        }
        catch (Throwable throwable) {}
        try {
            in.close();
        }
        catch (Throwable throwable) {}
    }

    protected static void fillList(List<GroupTreeObject> parentGTOs, List<String> ng_paths) {
        for (GroupTreeObject groupTreeObject : parentGTOs) {
            String currentPath = null;
            currentPath = "agt".equals(groupTreeObject.getType()) ? "" + groupTreeObject.getTreeObject().getObject() : groupTreeObject.getPath();
            if (ng_paths.contains(currentPath)) continue;
            ng_paths.add(currentPath);
        }
    }

    public static void saveNodeGroupXML(String filepath) {
        for (Map.Entry<String, List<String>> en : m_agents.entrySet()) {
            TreeObject to = new TreeObject(en.getKey(), "agt", en.getKey());
            GroupTreeObjectLast gtol = new GroupTreeObjectLast(to, en.getKey(), null);
            for (String ngPath : en.getValue()) {
                GroupTreeObject gto = root_Nodes.searchPath(ngPath, "");
                try {
                    if (gto == null) continue;
                    gto.addElement(gtol.clone());
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
        }
        XMLTree m_xmlTools = new XMLTree();
        Document doc = m_xmlTools.getXML(root_Nodes);
        File gt = new File(filepath);
        try {
            XMLFactory.writeXml(doc, filepath);
        }
        catch (Throwable e) {
            RTLogger.print(1, "Error saving " + filepath, e);
        }
        if (gt.length() == 0L) {
            try {
                XMLFactory.writeXml(doc, filepath);
            }
            catch (Throwable e) {
                RTLogger.print(1, "2xError saving " + filepath, e);
            }
        }
    }
}

