/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.omu;

import com.blixx.boom.omu.PolicyConvereter;
import com.blixx.log.RTLogger;
import com.blixx.log.SALogger;
import com.blixx.shared.XMLFactory;
import com.blixx.shared.utils.GroupTreeObject;
import com.blixx.shared.utils.GroupTreeObjectLast;
import com.blixx.shared.utils.StrUtils;
import com.blixx.shared.utils.TreeObject;
import com.blixx.shared.utils.XMLTree;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.Iterator;
import java.util.List;
import org.w3c.dom.Document;

public class OMUPolicyGroupsReader {
    private static GroupTreeObject root_Policies = new GroupTreeObject(new TreeObject("root", "", null));
    private static GroupTreeObject policies = new GroupTreeObject(new TreeObject("Policies", "toplevel", null));
    private static GroupTreeObject root_ASN;
    private static GroupTreeObject asn;

    static {
        root_Policies.addElement(policies);
        root_ASN = new GroupTreeObject(new TreeObject("root", "", null));
        asn = new GroupTreeObject(new TreeObject("Assignments", "toplevel", null));
        root_ASN.addElement(asn);
    }

    public static GroupTreeObject getPolicyTree() {
        return root_Policies;
    }

    public static GroupTreeObject getAsnTree() {
        return root_ASN;
    }

    public static void clearTrees() {
        root_Policies.clean();
        policies = new GroupTreeObject(new TreeObject("Policies", "toplevel", null));
        root_Policies.addElement(policies);
        root_ASN.clean();
        asn = new GroupTreeObject(new TreeObject("Assignments", "toplevel", null));
        root_ASN.addElement(asn);
    }

    public static void readFile(String filePath, SALogger logger) {
        File f = new File(filePath);
        if (!f.exists()) {
            throw new RuntimeException("File not found: " + filePath);
        }
        OMUPolicyGroupsReader.readFile(f, logger);
    }

    public static void readFile(File file, SALogger logger) {
        FileReader in = null;
        BufferedReader br = null;
        try {
            try {
                GroupTreeObject asnGrp2;
                in = new FileReader(file);
                br = new BufferedReader(in);
                String line = null;
                String parentElement = null;
                GroupTreeObject parentGTOinPolicyTree = null;
                StrUtils su = new StrUtils();
                while ((line = br.readLine()) != null) {
                    List<GroupTreeObject> folders;
                    String parentNameAsn;
                    GroupTreeObjectLast gto;
                    String polName;
                    line = line.trim();
                    String[] omuLineSplitted = su.processQuoted(line);
                    String omuName = omuLineSplitted[omuLineSplitted.length - 1];
                    if (line.startsWith("TEMPLATE_GROUP")) {
                        parentElement = null;
                        try {
                            parentElement = su.removeQuotes(omuName);
                            parentGTOinPolicyTree = root_Policies.findFirstGroupByName(parentElement);
                            if (parentGTOinPolicyTree == null) {
                                parentGTOinPolicyTree = new GroupTreeObject(new TreeObject(parentElement, "", null));
                                policies.addElement(parentGTOinPolicyTree);
                                GroupTreeObject clone = parentGTOinPolicyTree.clone();
                                clone.setType("pga");
                                asn.addElement(clone);
                            }
                            if (asn.getChild(parentElement, "pga") != null) continue;
                            GroupTreeObject asngto = new GroupTreeObject(new TreeObject(parentElement, "pga", null));
                            asn.addElement(asngto);
                        }
                        catch (Throwable e) {
                            e.getCause();
                        }
                        continue;
                    }
                    if (line.startsWith("MEMBER_TEMPLATE_GROUP")) {
                        String subFolder = su.removeQuotes(omuName);
                        GroupTreeObject asnGroup = asn.getChild(parentElement, "pga");
                        GroupTreeObject gto2 = new GroupTreeObject(new TreeObject(subFolder, "", null));
                        parentGTOinPolicyTree.addElement(gto2);
                        if (asnGroup == null) continue;
                        GroupTreeObject clone = gto2.clone();
                        GroupTreeObject asnFound = asn.getChild(clone.getName(), "pga");
                        if (asnFound != null) {
                            GroupTreeObject clasnf = asnFound.clone();
                            clasnf.setType("");
                            try {
                                asnGroup.addElement(clasnf);
                            }
                            catch (Throwable e) {
                                e.printStackTrace();
                            }
                            continue;
                        }
                        asnGroup.addElement(gto2.clone());
                        continue;
                    }
                    if (line.startsWith("MEMBER_OPCMSG") || line.startsWith("MEMBER_LOGFILE") || line.startsWith("MEMBER_SNMP") || line.startsWith("MEMBER_SCHED")) {
                        polName = su.removeQuotes(omuName);
                        polName = PolicyConvereter.normalizePolicyName(polName);
                        gto = null;
                        gto = root_Policies.findElement(polName, "msg");
                        if (gto == null) {
                            gto = new GroupTreeObjectLast(new TreeObject(polName, "msg", null), null, null);
                            parentGTOinPolicyTree.addElement(gto);
                        }
                        if ("MS Windows 2K,XP & 2K3".equals(parentNameAsn = parentGTOinPolicyTree.getName())) {
                            System.out.println("");
                        }
                        folders = root_ASN.findElements(parentNameAsn, "");
                        folders.addAll(root_ASN.findElements(parentNameAsn, "pga"));
                        for (GroupTreeObject g : folders) {
                            g.addElement(new GroupTreeObjectLast(new TreeObject(polName, "msg", null), gto.getPath(), null));
                        }
                        continue;
                    }
                    if (!line.startsWith("MEMBER_MONITOR")) continue;
                    polName = su.removeQuotes(omuName);
                    polName = PolicyConvereter.normalizePolicyName(polName);
                    gto = null;
                    gto = root_Policies.findElement(polName, "mon");
                    if (gto == null) {
                        gto = new GroupTreeObjectLast(new TreeObject(polName, "mon", null), null, null);
                        parentGTOinPolicyTree.addElement(gto);
                    }
                    parentNameAsn = parentGTOinPolicyTree.getName();
                    folders = root_ASN.findElements(parentNameAsn, "");
                    folders.addAll(root_ASN.findElements(parentNameAsn, "pga"));
                    for (GroupTreeObject g : folders) {
                        g.addElement(new GroupTreeObjectLast(new TreeObject(polName, "mon", null), gto.getPath(), null));
                    }
                }
                for (GroupTreeObject asnGrp2 : asn.getElements()) {
                    List<GroupTreeObject> subfolders = asn.findElements(asnGrp2.getName(), "");
                    for (GroupTreeObject fo : subfolders) {
                        fo.clean();
                        List<GroupTreeObject> asnElements = asnGrp2.getElements();
                        for (GroupTreeObject el : asnElements) {
                            fo.addElement(el.clone());
                        }
                    }
                }
                Iterator<GroupTreeObject> allAsnGrpsIT = asn.getElements().iterator();
                while (allAsnGrpsIT.hasNext()) {
                    asnGrp2 = allAsnGrpsIT.next();
                    boolean isContainsLast = false;
                    for (GroupTreeObject e : asnGrp2.getElements()) {
                        if (!(e instanceof GroupTreeObjectLast)) continue;
                        isContainsLast = true;
                        break;
                    }
                    if (isContainsLast) continue;
                    allAsnGrpsIT.remove();
                    asnGrp2.clean();
                }
                allAsnGrpsIT = asn.getElements().iterator();
                while (allAsnGrpsIT.hasNext()) {
                    asnGrp2 = allAsnGrpsIT.next();
                    List<GroupTreeObject> subfolders = asn.findElements(asnGrp2.getName(), "");
                    if (subfolders.size() <= 0) continue;
                    allAsnGrpsIT.remove();
                    asnGrp2.clean();
                }
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        }
        catch (Throwable throwable) {
            try {
                br.close();
            }
            catch (Throwable throwable2) {}
            try {
                in.close();
            }
            catch (Throwable throwable3) {}
            throw throwable;
        }
        try {
            br.close();
        }
        catch (Throwable throwable) {}
        try {
            in.close();
        }
        catch (Throwable throwable) {}
    }

    public static synchronized void saveTree(GroupTreeObject m_treeRoot, String filepath) {
        XMLTree m_xmlTools = new XMLTree();
        Document doc = m_xmlTools.getXML(m_treeRoot);
        File gt = new File(filepath);
        try {
            XMLFactory.writeXml(doc, filepath);
        }
        catch (Throwable e) {
            RTLogger.print(1, "Error saving " + filepath, e);
        }
        if (gt.length() == 0L) {
            try {
                XMLFactory.writeXml(doc, filepath);
            }
            catch (Throwable e) {
                RTLogger.print(1, "2xError saving " + filepath, e);
            }
        }
    }
}

