/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.omu;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Vector;
import javax.swing.JFileChooser;

public class OVPolicy {
    public static String SPI_NAME_PREFIX = "MySQL";
    public static File M_STAT = new File("temp.idx");
    public static File M_MLIST = new File("metricList.txt");
    public static BufferedWriter m_IDX_WRITER = null;
    public static BufferedWriter m_MLIST_WRITER = null;
    public static HashMap m_mlistMap = new HashMap();
    public static String[] SYNTAX_VERSION = new String[]{"", "", "", "", "", "SYNTAX_VERSION 5", "SYNTAX_VERSION 6"};
    public static String[] MONITOR = new String[]{"", "", "", "", "", "MONITOR", "ADVMONITOR"};
    public static String[] PROGRAM = new String[]{"", "", "", "", "", "", "PROGRAM"};
    public static String[] DESCRIPTION = new String[]{"", "", "", "", "", "DESCRIPTION", "DESCRIPTION"};
    public static String[] INTERVAL = new String[]{"", "", "", "", "", "INTERVAL", "INTERVAL"};
    public static String[] INSTANCEMODE = new String[]{"", "", "", "", "", "", "INSTANCEMODE"};
    public static String[] MAXTHRESHOLD = new String[]{"", "", "", "", "", "MAXTHRESHOLD", "MAXTHRESHOLD"};
    public static String[] MINTHRESHOLD = new String[]{"", "", "", "", "", "MINTHRESHOLD", "MINTHRESHOLD"};
    public static String[] SEPARATORS = new String[]{"", "", "", "", "", "SEPARATORS", "SEPARATORS"};
    public static String[] GEN_ALWAYS = new String[]{"", "", "", "", "", "GEN_ALWAYS", "GEN_ALWAYS"};
    public static String[] SEVERITY = new String[]{"", "", "", "", "", "SEVERITY", "SEVERITY"};
    public static String[] MSGCONDITIONS = new String[]{"", "", "", "", "", "MSGCONDITIONS", "MSGCONDITIONS"};
    public static String[] APPLICATION = new String[]{"", "", "", "", "", "APPLICATION", "APPLICATION"};
    public static String[] MSGGRP = new String[]{"", "", "", "", "", "MSGGRP", "MSGGRP"};
    public static String[] MSGKEY = new String[]{"", "", "", "", "", "MSGKEY", "MSGKEY"};
    public static String[] MONPROG = new String[]{"", "", "", "", "", "MONPROG", "MONPROG"};
    public static String[] AUTOACTION = new String[]{"", "", "", "", "", "AUTOACTION", "AUTOACTION"};
    public static String[] MSGKEYRELATION = new String[]{"", "", "", "", "", "MSGKEYRELATION", "MSGKEYRELATION"};
    public static String[] CONDITION_ID = new String[]{"", "", "", "", "", "CONDITION_ID", "CONDITION_ID"};
    public static String[] CONDITION = new String[]{"", "", "", "", "", "CONDITION", "CONDITION"};
    public static String[] THRESHOLD = new String[]{"", "", "", "", "", "THRESHOLD", "THRESHOLD"};
    public static String[] RESET = new String[]{"", "", "", "", "", "RESET", "RESET"};
    public static String[] SET = new String[]{"", "", "", "", "", "SET", "SETSTART"};
    public static String[] SERVICE_NAME = new String[]{"", "", "", "", "", "", "SERVICE_NAME"};
    public static String[] MSGTYPE = new String[]{"", "", "", "", "", "MSGTYPE", "MSGTYPE"};
    public static String[] TEXT = new String[]{"", "", "", "", "", "TEXT", "TEXT"};
    public static String[] HELPTEXT = new String[]{"", "", "", "", "", "HELPTEXT", "HELPTEXT"};
    public static String[] HELP = new String[]{"", "", "", "", "", "HELP", "HELP"};
    public static String[] OBJECT = new String[]{"", "", "", "", "", "OBJECT", "OBJECT"};
    public static HashMap ALIASES = new HashMap();
    public Vector m_header = new Vector();
    public Vector m_monitor = new Vector();
    public Vector m_conditions = new Vector();
    public Vector m_header_R = new Vector();
    public Vector m_monitor_R = new Vector();
    public Vector m_conditions_R = new Vector();
    public StringBuffer m_masterDescription;
    private String m_topDescRes;
    private static boolean m_update;
    private static File m_dir;
    private static File m_newDir;
    private static File outList;
    private static BufferedWriter m_outWriter;

    static {
        ALIASES.put(MONITOR[6], MONITOR[5]);
        ALIASES.put(SET[6], SET[5]);
        outList = new File("mlist.tmp");
        m_outWriter = null;
    }

    public void readFile(String filename, boolean isConvert) {
        try {
            m_MLIST_WRITER = new BufferedWriter(new FileWriter(M_MLIST, true));
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        Vector actualSection = this.m_header;
        File f = new File(filename);
        StringBuffer sb = new StringBuffer();
        if (f.exists()) {
            try {
                BufferedReader br = new BufferedReader(new FileReader(f));
                String line = null;
                while ((line = br.readLine()) != null) {
                    if (line.trim().startsWith("ADVMONITOR") || line.trim().startsWith("MONITOR")) {
                        actualSection = this.m_monitor;
                        if (m_outWriter != null) {
                            m_outWriter.write(String.valueOf(line.replaceAll("\\QADVMONITOR\\E", "MEMBER_MONITOR")) + "\n");
                        }
                        if (isConvert) {
                            sb.append(String.valueOf(line.replaceAll("ADVMONITOR", "PROCESSED")) + "\n");
                        }
                    } else if (line.trim().startsWith("MSGCONDITIONS")) {
                        actualSection = this.m_conditions;
                    }
                    actualSection.add(line);
                }
                br.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            System.err.println("Can't find file: " + filename);
        }
        try {
            if (isConvert) {
                m_IDX_WRITER.write(sb.toString());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void writeFile(String filename, Vector lines) {
        File f = new File(filename);
        try {
            BufferedWriter br = new BufferedWriter(new FileWriter(f));
            Iterator it = lines.iterator();
            while (it.hasNext()) {
                br.write((String)it.next());
                br.write(10);
            }
            br.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void convert6to5(String filename6, String filename5) {
        this.readFile(filename6, true);
        try {
            Vector nv = this.convertLines6to5();
            this.writeFile(filename5, nv);
        }
        catch (NVFException nVFException) {
            System.err.println("File=" + filename6 + " invalid.");
        }
    }

    public void update6(String filename6, String filename6_1) {
        this.readFile(filename6, false);
        try {
            Vector nv = this.updateVersion6();
            m_MLIST_WRITER.close();
            this.writeFile(filename6_1, nv);
        }
        catch (NVFException nVFException) {
            System.err.println("File=" + filename6 + " invalid.");
        }
        catch (IOException iOException) {
            System.err.println("error closing mlist file");
        }
    }

    public Vector updateVersion6() throws NVFException {
        Vector res = new Vector();
        try {
            String line = (String)this.m_header.get(0);
            if (!line.trim().startsWith("SYNTAX_VERSION")) {
                throw new NVFException();
            }
        }
        catch (Throwable throwable) {
            throw new NVFException();
        }
        this.m_header_R = this.m_header;
        this.m_conditions_R = this.m_conditions;
        this.m_monitor_R = this.m_monitor;
        String description = this.findDescription(this.m_monitor_R);
        String monName = (String)this.m_monitor_R.get(0);
        monName = monName.replaceAll("\\QADVMONITOR\\E", "");
        String toFileD = description.replace('\n', ' ');
        toFileD = toFileD.replaceAll("\\QDESCRIPTION\\E", "");
        try {
            m_MLIST_WRITER.write(String.valueOf(monName) + "\t" + toFileD + "\n");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.removeFirstEl(this.m_monitor_R, "DESCRIPTION");
        this.addToMonitors(this.m_monitor_R, description, 1);
        this.removeEl(this.m_monitor_R, "MSGKEY");
        this.removeEl(this.m_monitor_R, "MSGGRP");
        this.removeEl(this.m_monitor_R, "APPLICATION");
        this.removeEl(this.m_monitor_R, "SEPARATORS");
        this.addToMonitors(this.m_monitor_R, 2);
        this.removeEl(this.m_conditions_R, "MSGKEY");
        this.removeEl(this.m_conditions_R, "MSGKEYRELATION");
        this.addToConditions(this.m_conditions_R);
        res.addAll(this.m_header_R);
        res.addAll(this.m_monitor_R);
        res.addAll(this.m_conditions_R);
        return res;
    }

    public void removeEl(Vector in, String TAG) {
        Iterator it = in.iterator();
        while (it.hasNext()) {
            String tag = it.next().toString().trim();
            if (!tag.startsWith(String.valueOf(TAG) + " ")) continue;
            it.remove();
        }
    }

    public void removeFirstEl(Vector in, String TAG) {
        Iterator it = in.iterator();
        while (it.hasNext()) {
            String tag = it.next().toString().trim();
            if (!tag.startsWith(String.valueOf(TAG) + " ")) continue;
            if (tag.indexOf(34) != -1 && !tag.endsWith("\"")) {
                it.remove();
                tag = it.next().toString();
                while (tag.indexOf(34) == -1) {
                    it.remove();
                    tag = it.next().toString();
                }
                it.remove();
                break;
            }
            it.remove();
            break;
        }
    }

    public Vector convertLines6to5() throws NVFException {
        Vector<String> newLines = this.m_header_R;
        Vector lines = this.m_header;
        int i = 0;
        while (i < lines.size()) {
            String line = (String)lines.get(i);
            if (i == 0) {
                if (!line.trim().startsWith("SYNTAX_VERSION")) {
                    throw new NVFException();
                }
                if (line.trim().endsWith(" 5")) {
                    newLines.addAll(this.m_header);
                    newLines.addAll(this.m_monitor);
                    newLines.addAll(this.m_conditions);
                    return newLines;
                }
                String resLine = line.replaceFirst("6", "5");
                newLines.add(resLine);
            }
            if (line.trim().length() == 0) {
                newLines.add(line);
            }
            ++i;
        }
        this.processMonitorVector(this.m_monitor_R, this.m_monitor);
        this.processConditionsVector(this.m_conditions_R, this.m_conditions);
        newLines = new Vector<String>();
        newLines.addAll(this.m_header_R);
        newLines.addAll(this.m_monitor_R);
        newLines.addAll(this.m_conditions_R);
        return newLines;
    }

    private void processMonitorVector(Vector newLines, Vector lines) {
        String lastValidTAG = null;
        int i = 0;
        while (i < lines.size()) {
            block17: {
                String line = (String)lines.get(i);
                line.indexOf(String.valueOf(SPI_NAME_PREFIX) + "SPI_AlterDbDelta");
                if (line.trim().length() == 0) {
                    newLines.add(line);
                } else {
                    try {
                        Field field;
                        String[] arr;
                        String alias;
                        String trimmed;
                        String DEF = trimmed = line.trim();
                        if (trimmed.indexOf(32) != -1) {
                            DEF = trimmed.substring(0, trimmed.indexOf(32));
                        }
                        if ((alias = (String)ALIASES.get(DEF)) != null) {
                            DEF = alias;
                        }
                        if ((arr = (String[])(field = OVPolicy.class.getDeclaredField(DEF)).get(this))[5].length() == 0) {
                            lastValidTAG = DEF;
                        } else if (DEF.startsWith("DESCRIPTION") && lastValidTAG.equalsIgnoreCase("PROGRAM")) {
                            lastValidTAG = DEF;
                            this.m_masterDescription = new StringBuffer();
                            if (!line.trim().endsWith("\"")) {
                                this.m_masterDescription.append(line).append(" ");
                                ++i;
                                while (!(line = (String)lines.get(i)).trim().endsWith("\"")) {
                                    ++i;
                                    this.m_masterDescription.append(line).append(" ");
                                }
                                this.m_masterDescription.append(line);
                            } else {
                                this.m_masterDescription.append(line);
                            }
                            newLines.add(1, this.m_masterDescription.toString());
                        } else if (DEF.startsWith("DESCRIPTION") && !lastValidTAG.equalsIgnoreCase("PROGRAM")) {
                            lastValidTAG = DEF;
                        } else {
                            String resLine = line.replaceFirst("\\Q" + arr[6] + "\\E", arr[5]);
                            newLines.add(resLine);
                            lastValidTAG = DEF;
                        }
                    }
                    catch (Throwable e) {
                        if (!lastValidTAG.equals("DESCRIPTION")) {
                            e.printStackTrace();
                        }
                        if (lastValidTAG != "HELPTEXT") break block17;
                        newLines.add(line);
                    }
                }
            }
            ++i;
        }
        this.addToMonitors(newLines, 2);
    }

    private void processConditionsVector(Vector newLines, Vector lines) {
        int i = 0;
        while (i < lines.size()) {
            String line = (String)lines.get(i);
            if (line.trim().length() == 0) {
                newLines.add(line);
            } else {
                try {
                    Field field;
                    String[] arr;
                    String alias;
                    String trimmed;
                    String DEF = trimmed = line.trim();
                    if (trimmed.indexOf(32) != -1) {
                        DEF = trimmed.substring(0, trimmed.indexOf(32));
                    }
                    if ((alias = (String)ALIASES.get(DEF)) != null) {
                        DEF = alias;
                    }
                    if ((arr = (String[])(field = OVPolicy.class.getDeclaredField(DEF)).get(this))[5].length() == 0) {
                    } else {
                        String resLine = line.replaceFirst("\\Q" + arr[6] + "\\E", arr[5]);
                        newLines.add(resLine);
                    }
                }
                catch (Throwable throwable) {
                    newLines.add(line);
                }
            }
            ++i;
        }
        this.addToConditions(newLines);
    }

    public String findDescription(Vector lines) {
        String res = null;
        this.m_topDescRes = "";
        String lastValidTAG = null;
        int i = 0;
        while (i < lines.size()) {
            String line = (String)lines.get(i);
            if (line.trim().length() != 0) {
                try {
                    String trimmed;
                    String DEF = trimmed = line.trim();
                    if (trimmed.indexOf(32) != -1) {
                        DEF = trimmed.substring(0, trimmed.indexOf(32));
                    }
                    if (DEF.startsWith("DESCRIPTION") && lastValidTAG.equalsIgnoreCase("PROGRAM")) {
                        lastValidTAG = DEF;
                        this.m_masterDescription = new StringBuffer();
                        if (!line.trim().endsWith("\"")) {
                            this.m_masterDescription.append(line).append("\n");
                            ++i;
                            while (!(line = (String)lines.get(i)).trim().endsWith("\"")) {
                                ++i;
                                this.m_masterDescription.append(line).append("\n");
                            }
                            this.m_masterDescription.append(line);
                        } else {
                            this.m_masterDescription.append(line);
                        }
                        res = this.m_masterDescription.toString();
                        if (res != null && res.trim().length() > 16) {
                            return res;
                        }
                        if (this.m_topDescRes != null && this.m_topDescRes.trim().length() > 16) {
                            lines.set(i, "  " + this.m_topDescRes);
                            return this.m_topDescRes;
                        }
                        return res;
                    }
                    if (DEF.startsWith("DESCRIPTION") && !lastValidTAG.equalsIgnoreCase("PROGRAM")) {
                        StringBuffer topDescription = new StringBuffer();
                        if (!line.trim().endsWith("\"")) {
                            topDescription.append(line).append("\n");
                            ++i;
                            while (!(line = (String)lines.get(i)).trim().endsWith("\"")) {
                                ++i;
                                topDescription.append(line).append("\n");
                            }
                            topDescription.append(line);
                        } else {
                            topDescription.append(line);
                        }
                        this.m_topDescRes = topDescription.toString();
                    } else {
                        lastValidTAG = DEF;
                    }
                }
                catch (Throwable throwable) {}
            }
            ++i;
        }
        return res;
    }

    public void addToMonitors(Vector res, int pos) {
        res.insertElementAt("        MSGKEY \"" + SPI_NAME_PREFIX + "SPI:<$MSG_NODE_NAME>:<$MSG_OBJECT>:<$NAME>:<$VALUE>\"", pos);
        res.insertElementAt("        APPLICATION \"" + SPI_NAME_PREFIX + "SPI\"", pos);
        res.insertElementAt("        MSGGRP \"" + SPI_NAME_PREFIX + "DB\"", pos);
        res.insertElementAt("        SEPARATORS \" \t\"", pos);
    }

    public void addToMonitors(Vector res, String line, int pos) {
        res.insertElementAt(line, pos);
    }

    public void addToConditions(Vector res) {
        this.addMsgKeyRelAck(res, "CONDITION", "CONDITION", "OBJECT ", "            OBJECT \"<*>\"");
        this.addMsgKeyRelAck(res, "SET", "SETSTART", "MSGKEYRELATION ACK", "              MSGKEYRELATION ACK \"" + SPI_NAME_PREFIX + "SPI:<$MSG_NODE_NAME>:<$MSG_OBJECT>:<$NAME>:<*>\"");
    }

    private void addMsgKeyRelAck(Vector res, String levelUnix, String levelWin, String tag, String msg) {
        String line;
        int i = 0;
        while (i < res.size()) {
            line = (String)res.get(i);
            if (line.trim().startsWith(tag)) {
                return;
            }
            ++i;
        }
        i = 0;
        while (i < res.size()) {
            line = (String)res.get(i);
            if (line.trim().equalsIgnoreCase(levelUnix) || line.trim().equalsIgnoreCase(levelWin)) {
                res.insertElementAt(msg, i + 1);
                ++i;
            }
            ++i;
        }
    }

    public static void main(String[] args) {
        File inF;
        int idx;
        int i;
        File[] pcvFL;
        LinkedList<String> list = new LinkedList<String>();
        int i2 = 0;
        while (i2 < args.length) {
            list.add(args[i2].trim());
            ++i2;
        }
        try {
            m_outWriter = new BufferedWriter(new FileWriter(outList, false));
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
        if (list.contains("-SPI")) {
            int idx2 = list.indexOf("-SPI");
            String perifix = args[idx2 + 1];
            if (perifix.startsWith("-")) {
                System.err.println("-SPI <prefix> parameter incorrect!");
                System.exit(-1);
            } else {
                SPI_NAME_PREFIX = perifix;
            }
        }
        if (list.contains("-pcvx") && list.contains("-dir")) {
            int idx3 = list.indexOf("-dir");
            pcvFL = new File(args[idx3 + 1]).listFiles(new NOTDOT());
            i = 0;
            while (i < pcvFL.length) {
                try {
                    String[] cmdarr = new String[]{"ovpmutil", "pcv", "-x", "\"" + pcvFL[i].getCanonicalPath() + "\""};
                    Process p = Runtime.getRuntime().exec(cmdarr);
                    p.waitFor();
                    OVPolicy.logSTD(p);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                ++i;
            }
            System.exit(0);
        }
        if (list.contains("-pcvc") && list.contains("-dir")) {
            int idx4 = list.indexOf("-dir");
            pcvFL = new File(args[idx4 + 1]).listFiles(new NOTDOT());
            i = 0;
            while (i < pcvFL.length) {
                String name = pcvFL[i].getName();
                if (!name.endsWith(".data") && !name.endsWith(".header")) {
                    try {
                        String[] cmdarr = new String[]{"ovpmutil", "pcv", "-c", "\"" + pcvFL[i].getCanonicalPath() + "\"", "-v", "2.0"};
                        int j = 0;
                        while (j < cmdarr.length) {
                            System.out.print(String.valueOf(cmdarr[j]) + " ");
                            ++j;
                        }
                        Process p = Runtime.getRuntime().exec(cmdarr);
                        p.waitFor();
                        OVPolicy.logSTD(p);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                ++i;
            }
            System.exit(0);
        }
        m_update = false;
        if (list.contains("-update")) {
            m_update = true;
        }
        File in = null;
        Vector<File> in_arr = null;
        if (list.contains("-file")) {
            idx = list.indexOf("-file");
            in = new File(args[idx + 1]);
        } else if (list.contains("-dir")) {
            idx = list.indexOf("-dir");
            m_dir = new File(args[idx + 1]);
            if (m_dir.exists()) {
                in_arr = new Vector<File>();
                File[] lf = m_dir.listFiles(new FNF(".data"));
                int i3 = 0;
                while (i3 < lf.length) {
                    in = lf[i3];
                    in_arr.add(in);
                    ++i3;
                }
            } else {
                System.err.print("dir: " + args[idx + 1] + " not exist");
                System.exit(0);
            }
        } else {
            in = OVPolicy.FileSelectDialog();
        }
        if (in == null) {
            System.exit(0);
        }
        if (m_update) {
            M_MLIST.delete();
            try {
                M_MLIST.createNewFile();
                m_MLIST_WRITER = new BufferedWriter(new FileWriter(M_MLIST, false));
                m_MLIST_WRITER.write("MonitorName\tDescription\n");
                m_MLIST_WRITER.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (in_arr != null) {
                m_newDir = new File(m_dir.getParentFile(), String.valueOf(m_dir.getName()) + " (update)");
                if (!m_newDir.exists()) {
                    m_newDir.mkdir();
                }
                int i4 = 0;
                while (i4 < in_arr.size()) {
                    inF = null;
                    try {
                        inF = (File)in_arr.get(i4);
                        OVPolicy.updateFile6(inF);
                    }
                    catch (Throwable throwable) {
                        try {
                            File oldDataFile = new File(inF.getCanonicalPath());
                            File newDataFile = new File(m_newDir, oldDataFile.getName());
                            OVPolicy.copy(oldDataFile, newDataFile);
                        }
                        catch (Throwable e1) {
                            e1.printStackTrace();
                        }
                    }
                    ++i4;
                }
                OVPolicy.copyAllFiles();
            } else {
                m_newDir = new File(in.getParentFile(), "SPI for " + SPI_NAME_PREFIX + "DB (update)");
                if (!m_newDir.exists()) {
                    m_newDir.mkdir();
                }
                try {
                    OVPolicy.updateFile6(in);
                }
                catch (Throwable e) {
                    e.printStackTrace();
                    System.err.print("File " + in.getName() + " was skipped due to an error: " + e.getMessage());
                }
            }
        } else if (in_arr != null) {
            m_newDir = new File(m_dir.getParentFile(), String.valueOf(m_dir.getName()) + " (Unix)");
            if (!m_newDir.exists()) {
                m_newDir.mkdir();
            }
            try {
                M_STAT.delete();
                M_STAT.createNewFile();
                m_IDX_WRITER = new BufferedWriter(new FileWriter(M_STAT, true));
            }
            catch (IOException e2) {
                e2.printStackTrace();
            }
            int i5 = 0;
            while (i5 < in_arr.size()) {
                inF = null;
                try {
                    inF = (File)in_arr.get(i5);
                    OVPolicy.convertFile5To6(inF);
                }
                catch (Throwable e) {
                    e.printStackTrace();
                    System.err.print("File " + inF.getName() + " convertion failed: " + e.getMessage());
                    System.out.print("File " + inF.getName() + " will be copied as is.");
                    try {
                        File fff = new File(inF.getCanonicalPath());
                        OVPolicy.copy(fff, new File(m_newDir, fff.getName()));
                    }
                    catch (IOException e1) {
                        e1.printStackTrace();
                    }
                }
                ++i5;
            }
            try {
                m_IDX_WRITER.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            m_newDir = new File(in.getParentFile(), "SPI for " + SPI_NAME_PREFIX + "DB (Unix)");
            if (!m_newDir.exists()) {
                m_newDir.mkdir();
            }
            try {
                OVPolicy.convertFile5To6(in);
            }
            catch (Throwable e) {
                e.printStackTrace();
                System.err.print("File " + in.getName() + " was skipped due to an error: " + e.getMessage());
            }
        }
        try {
            m_outWriter.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void copyAllFiles() {
        File[] copylist = m_dir.listFiles(new EXT(".header"));
        int i = 0;
        while (i < copylist.length) {
            try {
                OVPolicy.copy(copylist[i], new File(m_newDir, copylist[i].getName()));
            }
            catch (IOException e) {
                e.printStackTrace();
                System.err.println("copy of file " + copylist[i].getName() + " failed.");
            }
            ++i;
        }
        copylist = m_dir.listFiles(new EXT(".mm"));
        i = 0;
        while (i < copylist.length) {
            try {
                OVPolicy.copy(copylist[i], new File(m_newDir, copylist[i].getName()));
            }
            catch (IOException e) {
                e.printStackTrace();
                System.err.println("copy of file " + copylist[i].getName() + " failed.");
            }
            ++i;
        }
        copylist = m_dir.listFiles(new NOTDOT());
        i = 0;
        while (i < copylist.length) {
            try {
                OVPolicy.copy(copylist[i], new File(m_newDir, copylist[i].getName()));
            }
            catch (IOException e) {
                e.printStackTrace();
                System.err.println("copy of file " + copylist[i].getName() + " failed.");
            }
            ++i;
        }
    }

    public static void logSTD(Process p) {
        try {
            InputStream is = p.getErrorStream();
            byte[] arr = new byte[is.available()];
            is.read(arr);
            String msg = new String(arr);
            if (msg.trim().length() > 0) {
                System.out.println("\nSTDERR: " + new String(arr));
            }
            is = p.getInputStream();
            arr = new byte[is.available()];
            is.read(arr);
            System.out.println(new String(arr));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void convertFile5To6(File in) {
        OVPolicy pm = new OVPolicy();
        try {
            String nfile = String.valueOf(m_newDir.getCanonicalPath()) + File.separator + in.getName().substring(0, in.getName().lastIndexOf(95)) + ".dat";
            pm.convert6to5(in.getCanonicalPath(), nfile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void updateFile6(File in) {
        OVPolicy pm = new OVPolicy();
        try {
            String newFilename = String.valueOf(m_newDir.getCanonicalPath()) + File.separator + in.getName();
            pm.update6(in.getCanonicalPath(), newFilename);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static File FileSelectDialog() {
        JFileChooser jfc = new JFileChooser();
        jfc.setMultiSelectionEnabled(false);
        jfc.showOpenDialog(null);
        File in = jfc.getSelectedFile();
        return in;
    }

    public static void copy(File src, File dst) throws IOException {
        int len;
        FileInputStream in = new FileInputStream(src);
        FileOutputStream out = new FileOutputStream(dst);
        byte[] buf = new byte[10240];
        while ((len = ((InputStream)in).read(buf)) > 0) {
            ((OutputStream)out).write(buf, 0, len);
        }
        ((InputStream)in).close();
        ((OutputStream)out).close();
    }

    public static class EXT
    implements FilenameFilter {
        private String m_ext = ".data";

        public EXT(String extension) {
            this.m_ext = extension;
        }

        @Override
        public boolean accept(File dir, String name) {
            return name.endsWith(this.m_ext);
        }
    }

    public static class FNF
    implements FilenameFilter {
        String m_ext = null;

        public FNF(String ext) {
            this.m_ext = ext;
        }

        @Override
        public boolean accept(File dir, String name) {
            return name.endsWith(this.m_ext);
        }
    }

    public static class NOTDOT
    implements FilenameFilter {
        @Override
        public boolean accept(File dir, String name) {
            boolean is_policy = false;
            if (name.lastIndexOf(46) == -1) {
                is_policy = true;
            } else if (name.lastIndexOf(46) < name.length() - 5) {
                is_policy = true;
            }
            return is_policy;
        }
    }

    public static class NVFException
    extends Exception {
    }
}

