/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.omu;

import com.blixx.log.SALogger;
import com.blixx.shared.AbstractCondition;
import com.blixx.shared.AbstractPolicy;
import com.blixx.shared.Condition;
import com.blixx.shared.Conditions;
import com.blixx.shared.Interval;
import com.blixx.shared.MsgCondition;
import com.blixx.shared.MsgConditions;
import com.blixx.shared.MsgPolicy;
import com.blixx.shared.PatternB;
import com.blixx.shared.Policy;
import com.blixx.shared.Severity;
import com.blixx.shared.exceptions.PolicyException;
import com.blixx.shared.utils.StrUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PolicyConvereter {
    public static final String UTF_8 = "UTF-8";
    public Vector<String> m_header = new Vector();
    public Vector<String> m_monitor = new Vector();
    public Vector<String> m_conditions = new Vector();
    public Vector<PolicyConvereter> m_REST = new Vector();
    public Map<String, String> m_headerAsMap = new HashMap<String, String>();
    public SALogger m_logger = new SALogger();
    public String m_globalServiceName = null;
    public boolean m_isSNMP = false;
    public boolean m_isSCHEDULE = false;
    public int deduplicationMode = 2;
    public static Map<String, StringBuffer> m_instrInterfaces = new HashMap<String, StringBuffer>();
    static Pattern p = Pattern.compile("\\Q$OPC_CUSTOM[\\E([\\S&&[^\\]\\[]]+)\\]");
    static Pattern p1 = Pattern.compile("\\Q<$OPTION(\\E([\\S]+)\\Q)>\\E");
    static Pattern p2 = Pattern.compile("\\Q<$\\E([\\S&&[^\\>]]+)\\>");
    public static Map<String, String> unsupportedKeys = new LinkedHashMap<String, String>();
    public static Map<String, String> supportedUrlEnc;

    static {
        unsupportedKeys.put("$OPC_MSG.ACTIONS.AUTOMATIC.ACKNOWLEDGE", "--OPC_MSG.ACTIONS.AUTOMATIC.ACKNOWLEDGE");
        unsupportedKeys.put("$OPC_MSG.ACTIONS.AUTOMATIC.ANNOTATION", "--OPC_MSG.ACTIONS.AUTOMATIC.ANNOTATION");
        unsupportedKeys.put("$OPC_MSG.ACTIONS.AUTOMATIC.COMMAND", "--OPC_MSG.ACTIONS.AUTOMATIC.COMMAND");
        unsupportedKeys.put("$OPC_MSG.ACTIONS.AUTOMATIC.NODE", "--OPC_MSG.ACTIONS.AUTOMATIC.NODE");
        unsupportedKeys.put("$OPC_MSG.ACTIONS.AUTOMATIC.STATUS", "--OPC_MSG.ACTIONS.AUTOMATIC.STATUS");
        unsupportedKeys.put("$OPC_MSG.ACTIONS.AUTOMATIC", "--OPC_MSG.ACTIONS.AUTOMATIC");
        unsupportedKeys.put("$OPC_MSG.ACTIONS.OPERATOR.ACKNOWLEDGE", "--OPC_MSG.ACTIONS.OPERATOR.ACKNOWLEDGE");
        unsupportedKeys.put("$OPC_MSG.ACTIONS.OPERATOR.ANNOTATION", "--OPC_MSG.ACTIONS.OPERATOR.ANNOTATION");
        unsupportedKeys.put("$OPC_MSG.ACTIONS.OPERATOR.COMMAND", "--OPC_MSG.ACTIONS.OPERATOR.COMMAND");
        unsupportedKeys.put("$OPC_MSG.ACTIONS.OPERATOR.NODE", "--OPC_MSG.ACTIONS.OPERATOR.NODE");
        unsupportedKeys.put("$OPC_MSG.ACTIONS.OPERATOR.STATUS", "--OPC_MSG.ACTIONS.OPERATOR.STATUS");
        unsupportedKeys.put("$OPC_MSG.ACTIONS.OPERATOR", "--OPC_MSG.ACTIONS.OPERATOR");
        unsupportedKeys.put("$OPC_MSG.ACTIONS.TROUBLE_TICKET.ACKNOWLEDGE", "--OPC_MSG.ACTIONS.TROUBLE_TICKET.ACKNOWLEDGE");
        unsupportedKeys.put("$OPC_MSG.ACTIONS.TROUBLE_TICKET.STATUS", "--OPC_MSG.ACTIONS.TROUBLE_TICKET.STATUS");
        unsupportedKeys.put("$OPC_MSG.ANNOTATIONS", "--OPC_MSG.ANNOTATION");
        unsupportedKeys.put("$OPC_MSG.ATTRIBUTES", "--OPC_MSG.ATTRIBUTES");
        unsupportedKeys.put("$OPC_MSG.ESCALATION.TO", "--OPC_MSG.ESCALATION.TO");
        unsupportedKeys.put("$OPC_MSG.ESCALATION.BY", "--OPC_MSG.ESCALATION.BY");
        unsupportedKeys.put("$OPC_MSG.ESCALATION.TIME", "--OPC_MSG.ESCALATION.TIME");
        unsupportedKeys.put("$OPC_MSG.INSTRUCTIONS", "--OPC_MSG.INSTRUCTIONS");
        unsupportedKeys.put("$OPC_MSG.NO_OF_ANNOTATIONS", "--OPC_MSG.NO_OF_ANNOTATIONS");
        unsupportedKeys.put("$OPC_MSG.ORIG_TEXT", "--OPC_MSG.ORIG_TEXT");
        unsupportedKeys.put("$OPC_MSG.OWNER", "--OPC_MSG.OWNER");
        unsupportedKeys.put("$OPC_MSG.SERVICE.MAPPED_SVC_COUNT", "--OPC_MSG.SERVICE.MAPPED_SVC_COUNT");
        unsupportedKeys.put("$OPC_MSG.SERVICE.MAPPED_SVC[n]", "--OPC_MSG.SERVICE.MAPPED_SVC[");
        unsupportedKeys.put("$OPC_MSG.SERVICE.MAPPED_SVCS", "--OPC_MSG.SERVICE.MAPPED_SVCS");
        unsupportedKeys.put("$OPC_MSG.TEXT[n]", "--OPC_MSG.TEXT[");
        unsupportedKeys.put("$OPC_MSG.TIME_OWNED", "--OPC_MSG.TIME_OWNED");
        unsupportedKeys.put("$OPC_MSG.TYPE", "--OPC_MSG.TYPE");
        unsupportedKeys.put("$OPC_EXACT_SELECTED_NODE_LABELS", "--OPC_EXACT_SELECTED_NODE_LABELS");
        unsupportedKeys.put("$OPC_GUI_CLIENT_WEB", "--OPC_GUI_CLIENT_WEB");
        unsupportedKeys.put("$OPC_GUI_CLIENT", "--OPC_GUI_CLIENT");
        unsupportedKeys.put("$OPC_NODE_LABELS", "--OPC_NODE_LABELS");
        unsupportedKeys.put("$OPC_USER", "--OPC_USER");
        unsupportedKeys.put("$OPC_NODES", "--OPC_NODES");
        unsupportedKeys.put("$OPC_MSGIDS_PEND", "--OPC_MSGIDS_PEND");
        unsupportedKeys.put("$OPC_MSGIDS_HIST", "--OPC_MSGIDS_HIST");
        unsupportedKeys.put("$OPC_MSGIDS_ACT", "--OPC_MSGIDS_ACT");
        unsupportedKeys.put("$OPC_MSG_GEN_NODES", "--OPC_MSG_GEN_NODES");
        unsupportedKeys.put("$OPC_MSG_NODES", "--OPC_MSG_NODES");
        unsupportedKeys.put("$OPC_EXT_NODES", "--OPC_EXT_NODES");
        unsupportedKeys.put("$OPC_ENV(", "--OPC_ENV(");
        supportedUrlEnc = new HashMap<String, String>();
        try {
            supportedUrlEnc.put(URLEncoder.encode("<$HOST>", UTF_8), "<$HOST>");
            supportedUrlEnc.put(URLEncoder.encode("<$GROUP>", UTF_8), "<$GROUP>");
            supportedUrlEnc.put(URLEncoder.encode("<$APPLICATION>", UTF_8), "<$APPLICATION>");
            supportedUrlEnc.put(URLEncoder.encode("<$OBJECT>", UTF_8), "<$OBJECT>");
            supportedUrlEnc.put(URLEncoder.encode("<$SOURCE>", UTF_8), "<$SOURCE>");
            supportedUrlEnc.put(URLEncoder.encode("<$IID>", UTF_8), "<$IID>");
            supportedUrlEnc.put(URLEncoder.encode("<$IID>", UTF_8), "<$IID>");
            supportedUrlEnc.put(URLEncoder.encode("<$TIME_STR>", UTF_8), "<$TIME_STR>");
            supportedUrlEnc.put(URLEncoder.encode("<$DUPLICATES>", UTF_8), "<$DUPLICATES>");
            supportedUrlEnc.put(URLEncoder.encode("<$STIME_STR>", UTF_8), "<$STIME_STR>");
            supportedUrlEnc.put(URLEncoder.encode("<$KEY>", UTF_8), "<$KEY>");
            supportedUrlEnc.put(URLEncoder.encode("<$FTIME_STR>", UTF_8), "<$FTIME_STR>");
            supportedUrlEnc.put(URLEncoder.encode("<$SERVICE_NAME>", UTF_8), "<$SERVICE_NAME>");
            supportedUrlEnc.put(URLEncoder.encode("<$SEVERITY>", UTF_8), "<$SEVERITY>");
            supportedUrlEnc.put(URLEncoder.encode("<$TEXT>", UTF_8), "<$TEXT>");
            supportedUrlEnc.put(URLEncoder.encode("<$BOOM_SERVER>", UTF_8), "<$BOOM_SERVER>");
        }
        catch (UnsupportedEncodingException e1) {
            e1.printStackTrace();
        }
    }

    @Deprecated
    public PolicyConvereter(SALogger logger, boolean isDeduplicationsByDefault) {
        this.m_logger = logger;
        if (!isDeduplicationsByDefault) {
            this.deduplicationMode = 0;
        }
    }

    public PolicyConvereter(SALogger logger, int dedupl) {
        this.m_logger = logger;
        if (dedupl < 0 || dedupl > 2) {
            throw new RuntimeException("Unsupported dedupl value!! 0 - no dedupl, 1 - keyOnle, 2 - full dedupl");
        }
        this.deduplicationMode = dedupl;
    }

    public static void addInstructionInterface(String name, String parameters, SALogger logger, AbstractPolicy ap, AbstractCondition cond) {
        StringBuffer packedInUrlEncoded = PolicyConvereter.packInstructionParameters(parameters, 1, logger, ap, cond);
        m_instrInterfaces.put(name, packedInUrlEncoded);
    }

    /*
     * Unable to fully structure code
     */
    public Conditions createConditions(Policy p) {
        this.m_logger.print(0, "+++   Start importing policy " + p.getName());
        conditionDescr = p.getDescription();
        conds = new Conditions();
        cond = null;
        setSectionOfCondition = false;
        i = 0;
        while (i < this.m_conditions.size()) {
            block95: {
                block102: {
                    block96: {
                        block98: {
                            block100: {
                                block101: {
                                    block99: {
                                        block97: {
                                            param = null;
                                            val = null;
                                            str = this.m_conditions.get(i);
                                            if ((str = PolicyConvereter.replaceOVOVars(str)).indexOf(34) == -1) break block96;
                                            posOfLastSpace = str.indexOf(34);
                                            param = str.substring(0, posOfLastSpace).trim();
                                            val = str.substring(posOfLastSpace).trim();
                                            if (!val.endsWith("\"") || val.endsWith("\\\"")) break block97;
                                            this.m_logger.print(3, String.valueOf(param) + " -> " + val);
                                            break block98;
                                        }
                                        posend = val.lastIndexOf(34);
                                        if (posend <= 1 || val.charAt(posend - 1) == '\\') break block99;
                                        val = val.substring(0, posend + 1);
                                        break block100;
                                    }
                                    if (!val.endsWith("\" ICASE")) break block101;
                                    val = val.substring(0, val.indexOf("\" ICASE") + 1);
                                    val = "<^(?i)^>" + val;
                                    break block100;
                                }
                                if (!val.endsWith("\" ANNOTATE ACK")) ** GOTO lbl33
                                val = val.substring(0, val.indexOf("\" ANNOTATE ACK") + 1);
                                break block100;
lbl-1000:
                                // 1 sources

                                {
                                    val = String.valueOf(val) + "\n" + this.m_conditions.get(++i);
lbl33:
                                    // 2 sources

                                    ** while (!val.endsWith((String)"\"") || val.endsWith((String)"\\\""))
                                }
                            }
                            this.m_logger.print(3, String.valueOf(param) + " -> " + val);
                        }
                        if (val.length() < 3) break block95;
                        val = val.substring(1, val.length() - 1);
                        break block102;
                    }
                    posOfLastSpace = str.lastIndexOf(32);
                    if (posOfLastSpace == -1) {
                        param = str;
                        this.m_logger.print(3, String.valueOf(param) + " -> !YES!");
                    } else {
                        param = str.substring(0, posOfLastSpace).trim();
                        val = str.substring(posOfLastSpace).trim();
                        this.m_logger.print(3, String.valueOf(param) + " -> " + val);
                    }
                }
                if (val != null) {
                    val = val.replace("\\\"", "\"");
                    val = val.replace("\\\\", "\\");
                }
                if (param.equalsIgnoreCase("MSGCONDITIONS")) {
                    conds.description = conditionDescr;
                    conds.uuid = UUID.randomUUID();
                } else if (param.equalsIgnoreCase("DESCRIPTION")) {
                    this.putCondition(conds, (Condition)cond);
                    cond = Condition.getNew(conds.getConditionCount());
                    cond.setReset(NaN);
                    cond.setDescription(val);
                } else if (param.equalsIgnoreCase("CONDITION_ID")) {
                    cond.setConditionId(val);
                    setSectionOfCondition = false;
                } else if (param.equalsIgnoreCase("SET")) {
                    setSectionOfCondition = true;
                } else if (param.startsWith("THRESHOLD")) {
                    block94: {
                        if (param.indexOf("FOR") != -1) {
                            arr = param.split("\\s+");
                            if (arr.length == 3) {
                                cond.setThreshold(Condition.getDouble(arr[1]));
                                this.m_logger.print(3, "THRESHOLD=" + cond.getThreshold());
                                try {
                                    interval = Interval.parseInterval(val, -1).getIntervalSeconds();
                                    policyInterval = Interval.parseInterval(p.getIntervalStr(), -1).getIntervalSeconds();
                                    cond.setSilenceCount(interval / policyInterval);
                                    if (interval < policyInterval) {
                                        cond.setSilenceCount(1L);
                                        this.m_logger.print(1, "Suppress interval: ({2}) is less than policy interval ({3}). SilenceCount=1 for policy ({0}), condition ({1}) ", new String[]{p.getName(), cond.getDescription(), val, p.getIntervalStr()});
                                        break block94;
                                    }
                                    this.m_logger.print(1, "Suppress interval: ({2}) converted to SilenceCount={3} for policy ({0}), condition ({1}) ", new String[]{p.getName(), cond.getDescription(), val, "" + cond.getSilenceCount()});
                                }
                                catch (Throwable v0) {
                                    this.m_logger.print(1, "Failed to parse suppress interval: ({2}) policy ({0}), condition ({1}) ", new String[]{p.getName(), cond.getDescription(), val});
                                }
                            } else {
                                this.m_logger.print(1, "Error can't recognize THRESHOLD");
                            }
                        } else {
                            try {
                                cond.setThreshold(Condition.getDouble(val));
                            }
                            catch (Throwable v1) {
                                this.m_logger.print(1, "Failed to parse threshold value: ({2}) policy ({0}), condition ({1}) ", new String[]{p.getName(), cond.getDescription(), val});
                            }
                        }
                    }
                    if (Double.isNaN(cond.getReset())) {
                        cond.setReset(cond.getThreshold());
                    }
                } else if (param.equalsIgnoreCase("RESET")) {
                    cond.setReset(Condition.getDouble(val));
                } else if (param.equalsIgnoreCase("OBJECT")) {
                    if (!setSectionOfCondition) {
                        cond.setObjectFilter(PolicyConvereter.removeQuotes(val));
                        try {
                            PatternB.getPattern(cond.getObjectFilter());
                        }
                        catch (PolicyException v2) {
                            this.m_logger.print(1, "INVALID OBJECT MASK Pattern: ({0}) in policy ({1}), condition ({2}) ", new String[]{cond.getObjectFilter(), p.getName(), cond.getDescription()});
                        }
                    } else {
                        cond.setSetObject(PolicyConvereter.normVariables(PolicyConvereter.removeQuotes(val)));
                    }
                } else if (param.equalsIgnoreCase("SEVERITY")) {
                    cond.setSetSeverity(Severity.getSeverity(val));
                } else if (param.equalsIgnoreCase("MSGKEYRELATION ACK")) {
                    sepi = val.indexOf("\" SEPARATORS");
                    if (sepi != -1) {
                        val = val.substring(0, sepi);
                    }
                    val = PolicyConvereter.normVariables(val);
                    cond.setCloseMask(val);
                    try {
                        PatternB.getPattern(cond.getCloseMask());
                        if (cond.getCloseMask().indexOf(124) != -1) {
                            this.m_logger.print(1, "Warning: Please review pipe character '|' in Close Key: ({0}) in policy ({1}), condition ({2}) ", new String[]{cond.getCloseMask(), p.getName(), cond.getDescription()});
                        }
                    }
                    catch (PolicyException v3) {
                        this.m_logger.print(1, "INVALID CLOSE MASK Pattern: ({0}) in policy ({1}), condition ({2}) ", new String[]{cond.getCloseMask(), p.getName(), cond.getDescription()});
                    }
                } else if (param.equalsIgnoreCase("TEXT")) {
                    cond.setSetText(PolicyConvereter.normVariables(val));
                } else if (param.equalsIgnoreCase("DURATION")) {
                    cond.setSilenceCount((long)Condition.getDouble(val));
                } else if (param.equalsIgnoreCase("HELPTEXT")) {
                    cond.setHelptext(val);
                } else if (param.equalsIgnoreCase("HELP")) {
                    cond.setHelptextId(val);
                } else if (param.equalsIgnoreCase("OPACTION")) {
                    if (val.indexOf("ACTIONNODE IP") != -1) {
                        val = val.substring(0, val.indexOf(" ACTIONNODE IP") - 1);
                    }
                    cond.setOpAction(val);
                    this.m_logger.print(1, "CHECK Operator Action: ({0}) in policy ({1}), condition ({2}) ", new String[]{cond.getOpAction(), p.getName(), cond.getSetText()});
                } else if (param.equalsIgnoreCase("AUTOACTION")) {
                    if (val.indexOf("ACTIONNODE IP") != -1) {
                        val = val.substring(0, val.indexOf(" ACTIONNODE IP") - 1);
                    }
                    if (val.indexOf("ANNOTATE ACK") != -1) {
                        val = val.substring(0, val.indexOf(" ANNOTATE ACK") - 1);
                    }
                    cond.setAutoAction(val);
                    this.m_logger.print(1, "CHECK Auto Action: ({0}) in policy ({1}), condition ({2}) ", new String[]{cond.getAutoAction(), p.getName(), cond.getSetText()});
                } else if (param.equalsIgnoreCase("APPLICATION")) {
                    cond.setSetApplication(PolicyConvereter.normVariables(PolicyConvereter.removeQuotes(val)));
                } else if (param.equalsIgnoreCase("MSGGRP")) {
                    cond.setSetGroup(PolicyConvereter.normVariables(PolicyConvereter.removeQuotes(val)));
                } else if (param.equalsIgnoreCase("MSGKEY")) {
                    val = PolicyConvereter.normVariables(val);
                    cond.setKey(val);
                } else if (param.equalsIgnoreCase("SERVERLOGONLY")) {
                    cond.setInsertClosed(1);
                } else if (param.equalsIgnoreCase("NODE IP 0.0.0.0")) {
                    if (setSectionOfCondition) {
                        cond.setSetNode(PolicyConvereter.normVariables(PolicyConvereter.removeQuotes(val)));
                    }
                } else if (param.startsWith("NODE IP")) {
                    if (setSectionOfCondition) {
                        cond.setSetNode(PolicyConvereter.normVariables(PolicyConvereter.removeQuotes(val)));
                    }
                } else if (param.equalsIgnoreCase("SUPP_DUPL_COND")) {
                    this.m_logger.print(1, "Unsupported SUPP_DUPL_COND for policy ({0}), condition ({1}) ", new String[]{p.getName(), cond.getDescription()});
                } else if (param.equalsIgnoreCase("SERVICE_NAME")) {
                    val = PolicyConvereter.normVariables(val);
                    if (cond != null) {
                        cond.getCustomAttributes().set(1, String.valueOf(param) + "=" + val);
                        this.m_logger.print(2, "SERVICE_NAME attribute is now mapped to CA2 in policy ({0}), condition ({1}) ", new String[]{p.getName(), cond.getDescription()});
                    }
                } else if (param.equalsIgnoreCase("MSGTYPE")) {
                    val = PolicyConvereter.normVariables(val);
                    cond.getCustomAttributes().set(0, String.valueOf(param) + "=" + val);
                    this.m_logger.print(2, "MSGTYPE attribute is now mapped to CA1 in policy ({0}), condition ({1}) ", new String[]{p.getName(), cond.getDescription()});
                } else if (param.startsWith("CUSTOM")) {
                    su = new StrUtils();
                    line = PolicyConvereter.normVariables(str);
                    params = su.processQuoted(line);
                    if (params.length == 3 && "CUSTOM".equals(params[0])) {
                        caName = su.removeQuotes(params[1]);
                        res = this.addCustomAttribute(cond, caName, caValue = su.removeQuotes(params[2]));
                        if (res < 0) {
                            this.m_logger.print(1, "Failed to set custom attribute: " + str + " in policy ({0}), condition ({1})  . No more free slots", new String[]{p.getName(), cond.getDescription()});
                        }
                    } else {
                        this.m_logger.print(1, "Failed to parse custom attribute: " + str, new String[]{p.getName(), cond.getDescription()});
                    }
                } else if (param.equalsIgnoreCase("TROUBLETICKET")) {
                    if (val == null) {
                        val = "";
                    }
                    if ((res = this.addCustomAttribute(cond, "TROUBLETICKET", val)) < 0) {
                        this.m_logger.print(1, "Failed to set TROUBLETICKET attribute: " + str + " in policy ({0}), condition ({1}). No more free slots", new String[]{p.getName(), cond.getDescription()});
                    }
                } else if (param.startsWith("INSTRUCTION_TEXT_INTERFACE")) {
                    try {
                        su = new StrUtils();
                        params = su.processQuoted(str);
                        IIName = su.removeQuotes(params[1]);
                        cond.setInstructionAction("<$INSTRUCTION_SERVER>iiname=" + IIName);
                        if (PolicyConvereter.m_instrInterfaces.get(IIName) != null && PolicyConvereter.m_instrInterfaces.get(IIName).length() > 0) {
                            cond.setInstructionAction(String.valueOf(cond.getInstructionAction()) + PolicyConvereter.m_instrInterfaces.get(IIName));
                        }
                    }
                    catch (Throwable v4) {
                        this.m_logger.print(1, "Failed to set INSTRUCTION_ACTION in policy ({0}), condition ({1}) -- " + str, new String[]{p.getName(), cond.getDescription()});
                    }
                } else if (param.startsWith("INSTRUCTION_PARAMETERS")) {
                    try {
                        pstart = 1;
                        pstart = PolicyConvereter.getNextInstructionParameterNumber(cond.getInstructionAction());
                        sb = PolicyConvereter.packInstructionParameters(str, pstart, this.m_logger, p, cond);
                        cond.setInstructionAction(String.valueOf(cond.getInstructionAction()) + sb.toString());
                    }
                    catch (Throwable e) {
                        this.m_logger.print(1, "Failed to set INSTRUCTION parameters in policy ({0}), condition ({1}) -- " + str + "\n{2}", new String[]{p.getName(), cond.getDescription(), e.getMessage()});
                    }
                }
            }
            ++i;
        }
        this.putCondition(conds, (Condition)cond);
        return conds;
    }

    public static int getNextInstructionParameterNumber(String instrAction) throws Exception {
        int pstart = 1;
        if (instrAction == null || instrAction.length() == 0) {
            return pstart;
        }
        try {
            int posLa = instrAction.lastIndexOf(38);
            int posEq = instrAction.lastIndexOf(61);
            if (posLa > -1 && posLa < posEq) {
                String tail = instrAction.substring(posLa + 2, posEq);
                pstart = Integer.parseInt(tail) + 1;
            }
        }
        catch (Throwable throwable) {
            throw new Exception("Failed during parsing INSTRUCTION_ACTION parameter number");
        }
        return pstart;
    }

    private static StringBuffer packInstructionParameters(String str, int pstart, SALogger logger, AbstractPolicy p, AbstractCondition c) {
        StrUtils su = new StrUtils();
        String[] arr = su.processQuoted(str);
        String[] params = null;
        params = arr.length == 2 && "INSTR_INTERF_CALL".equalsIgnoreCase(arr[0]) ? su.processQuoted(su.removeQuotes(arr[1])) : arr;
        StringBuffer sb = new StringBuffer();
        int jj = 0;
        while (jj < params.length) {
            String parameter = su.removeQuotes(params[jj]);
            parameter = PolicyConvereter.normVariables(parameter);
            parameter = PolicyConvereter.replaceOVOVars(parameter);
            if ((parameter = PolicyConvereter.replaceSNMP_OVOVars(parameter)).indexOf(36) != -1) {
                parameter = PolicyConvereter.replaceInstructionVariables(parameter, logger, p, c);
                sb.append("&p").append(jj + pstart).append('=').append(parameter);
            } else {
                try {
                    sb.append("&p").append(jj + pstart).append('=').append(URLEncoder.encode(parameter, UTF_8));
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {}
            }
            ++jj;
        }
        return sb;
    }

    private static String replaceInstructionVariables(String parameter, SALogger logger, AbstractPolicy ap, AbstractCondition cond) {
        String replacement;
        String ca_name;
        HashMap<String, String> caNE = new HashMap<String, String>(supportedUrlEnc);
        Matcher m = p.matcher(parameter);
        while (m.find()) {
            ca_name = m.group(1);
            replacement = "<$" + ca_name + ">";
            try {
                caNE.put(URLEncoder.encode(replacement, UTF_8), replacement);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {}
            parameter = parameter.replace("$OPC_CUSTOM[" + ca_name + "]", replacement);
            m = p.matcher(parameter);
        }
        m = p1.matcher(parameter);
        while (m.find()) {
            ca_name = m.group(1);
            replacement = "<$" + ca_name + ">";
            try {
                caNE.put(URLEncoder.encode(replacement, UTF_8), replacement);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {}
            parameter = parameter.replace("<$OPTION(" + ca_name + ")>", replacement);
            m = p1.matcher(parameter);
        }
        m = p2.matcher(parameter);
        int start = 0;
        while (m.find(start)) {
            start = m.end();
            String ca_name2 = m.group(1);
            String replacement2 = "<$" + ca_name2 + ">";
            try {
                caNE.put(URLEncoder.encode(replacement2, UTF_8), replacement2);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {}
            parameter = parameter.replace("<$" + ca_name2 + ">", replacement2);
        }
        for (Map.Entry<String, String> en : unsupportedKeys.entrySet()) {
            if (!parameter.contains(en.getKey())) continue;
            parameter = parameter.replace(en.getKey(), en.getValue());
            String pname = "test";
            String condName = "test";
            if (ap != null) {
                pname = ap.getName();
            }
            if (cond != null) {
                condName = cond.getDescription();
            }
            logger.print(1, "WARNING: Unsupported variable: ({0}) replaced with: ({1}) in policy ({2}), condition ({3}) ", en.getKey(), en.getValue(), pname, condName);
        }
        parameter = parameter.replace("$OPC_MSG.NODE", "<$HOST>");
        parameter = parameter.replace("$OPC_MSG.GROUP", "<$GROUP>");
        parameter = parameter.replace("$OPC_MSG.APPLICATION", "<$APPLICATION>");
        parameter = parameter.replace("$OPC_MSG.OBJECT", "<$OBJECT>");
        parameter = parameter.replace("$OPC_MSG.SOURCE", "<$SOURCE>");
        parameter = parameter.replace("$OPC_MSG.MSG_ID", "<$IID>");
        parameter = parameter.replace("$OPC_MSG_IDS", "<$IID>");
        parameter = parameter.replace("$OPC_MSG.CREATED", "<$TIME_STR>");
        parameter = parameter.replace("$OPC_MSG.DUPLICATES", "<$DUPLICATES>");
        parameter = parameter.replace("$OPC_MSG.LAST_RECEIVED", "<$STIME_STR>");
        parameter = parameter.replace("$OPC_MSG.MSG_KEY", "<$KEY>");
        parameter = parameter.replace("$OPC_MSG.RECEIVED", "<$FTIME_STR>");
        parameter = parameter.replace("$OPC_MSG.SERVICE", "<$SERVICE_NAME>");
        parameter = parameter.replace("$OPC_MSG.SEVERITY", "<$SEVERITY>");
        parameter = parameter.replace("$OPC_MSG.TEXT", "<$TEXT>");
        parameter = parameter.replace("$OPC_MGMTSV", "<$BOOM_SERVER>");
        try {
            parameter = URLEncoder.encode(parameter, UTF_8);
            for (Map.Entry entry : caNE.entrySet()) {
                parameter = parameter.replace((CharSequence)entry.getKey(), (CharSequence)entry.getValue());
            }
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return parameter;
    }

    private void putCondition(Conditions conds, Condition cond) {
        if (cond != null) {
            String serviceNameInCond;
            if (this.m_globalServiceName != null && ((serviceNameInCond = cond.getCustomAttributes().get(1)) == null || serviceNameInCond.length() == 0)) {
                cond.getCustomAttributes().set(1, "SERVICE_NAME=" + this.m_globalServiceName);
            }
            this.setDefaults(cond, this.m_headerAsMap);
            conds.addCondition(cond);
        }
    }

    /*
     * Unable to fully structure code
     */
    public Policy createPolicy(String spiName) {
        p = Policy.createNewPolicy();
        p.setReset(true);
        p.setKey("");
        p.setSetApplication("");
        p.setSetGroup("");
        i = 0;
        while (i < this.m_monitor.size()) {
            block30: {
                block31: {
                    block26: {
                        block28: {
                            block29: {
                                block27: {
                                    param = null;
                                    val = null;
                                    str = this.m_monitor.get(i);
                                    if (str.indexOf(34) == -1) break block26;
                                    posOfLastSpace = str.indexOf(34);
                                    param = str.substring(0, posOfLastSpace).trim();
                                    val = str.substring(posOfLastSpace).trim();
                                    if (!val.endsWith("\"")) break block27;
                                    this.m_logger.print(3, String.valueOf(param) + " -> " + val);
                                    break block28;
                                }
                                posend = val.lastIndexOf(34);
                                if (posend <= 1 || val.charAt(posend - 1) == '\\') ** GOTO lbl24
                                val = val.substring(0, posend + 1);
                                break block29;
lbl-1000:
                                // 1 sources

                                {
                                    val = String.valueOf(val) + "\n" + this.m_monitor.get(++i);
lbl24:
                                    // 2 sources

                                    ** while (!val.endsWith((String)"\""))
                                }
                            }
                            this.m_logger.print(3, String.valueOf(param) + " -> " + val);
                        }
                        if (val.length() < 3) break block30;
                        val = val.substring(1, val.length() - 1);
                        break block31;
                    }
                    posOfLastSpace = str.lastIndexOf(32);
                    if (posOfLastSpace == -1) {
                        param = str;
                        this.m_logger.print(3, String.valueOf(param) + " -> !YES!");
                    } else {
                        param = str.substring(0, posOfLastSpace).trim();
                        val = str.substring(posOfLastSpace).trim();
                        this.m_logger.print(3, String.valueOf(param) + " -> " + val);
                    }
                }
                if (val != null) {
                    val = val.replace("\\\"", "\"");
                    val = val.replace("\\\\", "\\");
                }
                if (param.equalsIgnoreCase("DESCRIPTION")) {
                    p.setDescription(val);
                } else if (param.equalsIgnoreCase("INTERVAL")) {
                    this.parseInterval(p, val);
                } else if (param.equalsIgnoreCase("MAXTHRESHOLD") || param.equalsIgnoreCase("MINTHRESHOLD")) {
                    p.setType(param);
                } else if (param.equalsIgnoreCase("APPLICATION")) {
                    p.setSetApplication(val);
                } else if (param.equalsIgnoreCase("MSGGRP")) {
                    p.setSetGroup(val);
                } else if (param.equalsIgnoreCase("MSGKEY")) {
                    p.setKey(val);
                } else if (param.equalsIgnoreCase("MONPROG")) {
                    p.setMonprog(val);
                    p.setCallType("EXEC");
                } else if (param.equalsIgnoreCase("EXTERNAL")) {
                    p.setMonprog("");
                    p.setCallType("EXTERNAL");
                } else if (param.equalsIgnoreCase("ADVMONITOR") || param.equalsIgnoreCase("MONITOR")) {
                    p.setName(PolicyConvereter.normalizePolicyName(val));
                } else if (param.equalsIgnoreCase("GEN_ALWAYS")) {
                    p.setReset(false);
                } else if (param.equalsIgnoreCase("SERVICE_NAME")) {
                    this.m_globalServiceName = PolicyConvereter.normVariables(val);
                }
            }
            ++i;
        }
        p.setVersion("1.0");
        p.setSpiName(spiName);
        p.setSeparator("\u25ba");
        p.setSyntax("1");
        return p;
    }

    /*
     * Unable to fully structure code
     */
    public MsgPolicy createMsgPolicy(String spiName) {
        this.m_isSCHEDULE = false;
        this.m_isSNMP = false;
        intervalMIN = "";
        intervalHRS = "";
        intervalWDA = "";
        intervalMDA = "";
        p = MsgPolicy.createNewPolicy();
        p.setName(null);
        this.m_logger.printStringDirect("\n");
        i = 0;
        while (i < this.m_monitor.size()) {
            block111: {
                block112: {
                    block107: {
                        block109: {
                            block110: {
                                block108: {
                                    param = null;
                                    val = null;
                                    str = this.m_monitor.get(i);
                                    if (str.indexOf(34) == -1) break block107;
                                    posOfLastSpace = str.indexOf(34);
                                    param = str.substring(0, posOfLastSpace).trim();
                                    val = str.substring(posOfLastSpace).trim();
                                    if (!val.endsWith("\"")) break block108;
                                    this.m_logger.print(3, String.valueOf(param) + " -> " + val);
                                    break block109;
                                }
                                posend = val.lastIndexOf(34);
                                if (posend <= 1 || val.charAt(posend - 1) == '\\') ** GOTO lbl28
                                val = val.substring(0, posend + 1);
                                break block110;
lbl-1000:
                                // 1 sources

                                {
                                    val = String.valueOf(val) + "\n" + this.m_monitor.get(++i);
lbl28:
                                    // 2 sources

                                    ** while (!val.endsWith((String)"\""))
                                }
                            }
                            this.m_logger.print(3, String.valueOf(param) + " -> " + val);
                        }
                        if (val.length() < 3) break block111;
                        val = val.substring(1, val.length() - 1);
                        break block112;
                    }
                    posOfLastSpace = str.lastIndexOf(32);
                    if (posOfLastSpace == -1) {
                        param = str;
                        this.m_logger.print(3, String.valueOf(param) + " -> !YES!");
                    } else {
                        param = str.substring(0, posOfLastSpace).trim();
                        val = str.substring(posOfLastSpace).trim();
                        this.m_logger.print(3, String.valueOf(param) + " -> " + val);
                    }
                }
                if (val != null) {
                    val = val.replace("\\\"", "\"");
                    val = val.replace("\\\\", "\\");
                }
                if (param.equalsIgnoreCase("DESCRIPTION")) {
                    p.setDescription(val);
                } else if (param.equalsIgnoreCase("OPCMSG") || param.equalsIgnoreCase("LOGFILE") || param.equalsIgnoreCase("SNMP") || param.equalsIgnoreCase("SCHEDULE")) {
                    p.setName(PolicyConvereter.normalizePolicyName(val));
                    if (param.equalsIgnoreCase("SNMP")) {
                        this.m_isSNMP = true;
                    }
                    if (param.equalsIgnoreCase("SCHEDULE")) {
                        this.m_isSCHEDULE = true;
                    }
                } else if (param.equalsIgnoreCase("LOGPATH")) {
                    if (val.startsWith("<`") && val.endsWith("`>")) {
                        val = val.substring(2, val.length() - 2);
                        val = "<$LOGFILES(" + val.trim() + ")>";
                    } else {
                        try {
                            su = new StrUtils();
                            files = su.processQuoted(val);
                            if (files.length > 1) {
                                logfiles = new StringBuffer();
                                z = 0;
                                while (z < files.length) {
                                    if (files[z] != null && (pathLF = su.removeQuotes(files[z].trim())).length() != 0) {
                                        logfiles.append(pathLF).append('|');
                                    }
                                    ++z;
                                }
                                val = logfiles.toString();
                                if (val.endsWith("|")) {
                                    val = val.substring(0, val.length() - 1);
                                }
                            }
                        }
                        catch (Throwable v0) {}
                    }
                    p.setMonprog("com.blixx.agent.monitors.MPathLogFileMonitor\n" + val + "\n.*\n.*");
                    p.setCallType("JAVA");
                } else if (param.equalsIgnoreCase("INTERVAL")) {
                    this.parseInterval(p, val);
                } else if (param.equals("ALWAYS_FROM_BEGIN")) {
                    if (p.getMonprog().startsWith("com.blixx.agent.monitors.MPathLogFileMonitor")) {
                        if (p.getMonprog().endsWith("\n.*\n.*")) {
                            p.setMonprog(String.valueOf(p.getMonprog()) + "\nFROM_START");
                        } else {
                            p.setMonprog(p.getMonprog().replace("\n.*\n.*\n", "\n.*\n.*\nFROM_START"));
                        }
                    }
                } else if (param.equals("FROM_LAST_POS")) {
                    if (p.getMonprog().startsWith("com.blixx.agent.monitors.MPathLogFileMonitor")) {
                        if (p.getMonprog().endsWith("\n.*\n.*")) {
                            p.setMonprog(String.valueOf(p.getMonprog()) + "\nFROM_LAST");
                        } else {
                            p.setMonprog(p.getMonprog().replace("\n.*\n.*\n", "\n.*\n.*\nFROM_LAST"));
                        }
                    }
                } else if (param.equals("FIRST_FROM_BEGIN")) {
                    if (p.getMonprog().startsWith("com.blixx.agent.monitors.MPathLogFileMonitor")) {
                        if (p.getMonprog().endsWith("\n.*\n.*")) {
                            p.setMonprog(String.valueOf(p.getMonprog()) + "\nFROM_LAST");
                        } else {
                            p.setMonprog(p.getMonprog().replace("\n.*\n.*\n", "\n.*\n.*\nFROM_LAST"));
                        }
                    }
                    this.m_logger.print(1, "FIRST_FROM_BEGIN keyword unsupported. Replaced with FROM_LAST. Policy: ({0})}", new String[]{p.getName()});
                } else if (param.equals("EXEFILE")) {
                    if (p.getMonprog().length() == 0) {
                        p.setMonprog("com.blixx.agent.monitors.MPathLogFileMonitor\n\n.*\n.*");
                        p.setCallType("JAVA");
                    }
                    if (p.getMonprog().startsWith("com.blixx.agent.monitors.MPathLogFileMonitor")) {
                        if (p.getMonprog().endsWith("\nFROM_START") || p.getMonprog().endsWith("\nFROM_LAST")) {
                            p.setMonprog(String.valueOf(p.getMonprog()) + "\n" + PolicyConvereter.removeQuotes(val));
                        } else {
                            p.setMonprog(String.valueOf(p.getMonprog()) + "\n\n" + PolicyConvereter.removeQuotes(val));
                        }
                    }
                    this.m_logger.print(1, "LogFileMonitor executable needs to be checked:({0}) Policy: ({1})}", new String[]{val, p.getName()});
                } else if (param.equalsIgnoreCase("READFILE")) {
                    arr = p.getMonprog().split("\n");
                    oldval = arr[1];
                    arr[1] = PolicyConvereter.removeQuotes(val);
                    p.setMonprog("");
                    k = 0;
                    while (k < arr.length) {
                        p.setMonprog(String.valueOf(p.getMonprog()) + arr[k]);
                        if (k < arr.length - 1) {
                            p.setMonprog(String.valueOf(p.getMonprog()) + "\n");
                        }
                        ++k;
                    }
                    this.m_logger.print(1, "LOGPATH: ({0}) replaced with READFILE: ({1}) in policy ({2})", new String[]{oldval, val, p.getName()});
                } else if (param.equalsIgnoreCase("APPLICATION")) {
                    p.setSetApplication(val);
                } else if (param.equalsIgnoreCase("MSGGRP")) {
                    p.setSetGroup(val);
                } else if (this.m_isSCHEDULE && param.equalsIgnoreCase("SCHEDPROG")) {
                    p.setMonprog(PolicyConvereter.removeQuotes(val));
                    if (p.getMonprog().startsWith("/")) {
                        p.setMonprog("#" + p.getMonprog());
                    }
                    p.setCallType("NAGIN");
                    p.setIntervalStr("5m");
                    suppressAll = MsgCondition.getNew(1);
                    suppressAll.setDescription("Suppress All messages");
                    suppressAll.setSetSeverity("unknown");
                    suppressAll.setActionType("STOP");
                    p.getConditions().addCondition(suppressAll);
                } else if (this.m_isSCHEDULE && param.equalsIgnoreCase("SEND_OUTPUT")) {
                    this.m_conditions.add("DESCRIPTION \"SEND_OUTPUT\"");
                    this.m_conditions.add("CONDITION");
                    this.m_conditions.add("CONDITION_ID \"" + UUID.randomUUID().toString() + "\"");
                    this.m_conditions.add("SEVERITY \"normal\"");
                    this.m_conditions.add("SET");
                    this.m_conditions.add("SEVERITY \"normal\"");
                } else if (this.m_isSCHEDULE && param.equalsIgnoreCase("MINUTE")) {
                    intervalMIN = PolicyConvereter.removeQuotes(val);
                } else if (this.m_isSCHEDULE && param.equalsIgnoreCase("HOUR")) {
                    intervalHRS = PolicyConvereter.removeQuotes(val);
                } else if (this.m_isSCHEDULE && param.equalsIgnoreCase("WEEKDAY")) {
                    intervalWDA = PolicyConvereter.removeQuotes(val);
                } else if (this.m_isSCHEDULE && param.equalsIgnoreCase("MONTHDAY")) {
                    intervalMDA = PolicyConvereter.removeQuotes(val);
                } else if (this.m_isSCHEDULE && param.equalsIgnoreCase("FAILURE")) {
                    this.m_conditions.add("DESCRIPTION \"FAILURE\"");
                    this.m_conditions.add("CONDITION");
                    this.m_conditions.add("CONDITION_ID \"" + UUID.randomUUID().toString() + "\"");
                    this.m_conditions.add("SEVERITY \"unknown|warning|minor|major|critical\"");
                    iii = i + 1;
                    while (iii < this.m_monitor.size()) {
                        this.m_conditions.add(this.m_monitor.get(iii));
                        ++iii;
                    }
                    break;
                }
            }
            ++i;
        }
        p.setVersion("1.0");
        p.setSpiName(spiName);
        p.setSeparator("\u25ba");
        p.setSyntax("1");
        if (this.m_isSCHEDULE) {
            block106: {
                sb = new StringBuffer();
                sb.append("\nOriginal OMU Interval: \n");
                if (intervalMIN.length() > 0) {
                    sb.append("MINUTES ").append(intervalMIN).append('\n');
                }
                if (intervalHRS.length() > 0) {
                    sb.append("HOURS ").append(intervalHRS).append('\n');
                }
                if (intervalWDA.length() > 0) {
                    sb.append("WEEKDAY ").append(intervalWDA).append('\n');
                }
                if (intervalMDA.length() > 0) {
                    sb.append("MONTHDAY ").append(intervalMDA).append('\n');
                }
                intervalStr = "";
                if (intervalMIN.length() == 1) {
                    intervalMIN = "0" + intervalMIN;
                } else if (intervalMIN.length() == 0) {
                    intervalMIN = "00";
                }
                if (intervalWDA.length() != 0) {
                    if ("0-6".equals(intervalWDA)) {
                        intervalWDA = "";
                    } else if ("0,1,2,3,4,5,6".equals(intervalWDA)) {
                        intervalWDA = "";
                    } else if (intervalWDA.length() != 1) {
                        try {
                            deactivate = "";
                            pp = Pattern.compile("[" + intervalWDA + "]{1}");
                            i = 1;
                            while (i <= 7) {
                                m = pp.matcher("" + (i - 1));
                                if (!m.matches()) {
                                    deactivate = String.valueOf(deactivate) + i;
                                }
                                ++i;
                            }
                            if (deactivate.length() > 0) {
                                deactivate = String.valueOf(deactivate) + ";00:00;24:00";
                                p.setDeactivationTimes(deactivate);
                                intervalWDA = "";
                            }
                        }
                        catch (Throwable v1) {}
                    }
                }
                if (intervalHRS.length() == 1) {
                    intervalHRS = "0" + intervalHRS;
                } else if ("0-23".equals(intervalHRS)) {
                    intervalHRS = "";
                }
                if ("1-31".equals(intervalMDA)) {
                    intervalMDA = "";
                }
                if (intervalMDA.length() > 0) {
                    intervalStr = "w1:01:01:01";
                    this.m_logger.print(1, "Unsupported INTERVAL syntax: ({0}) replaced with : ({1}) in policy ({2})", new String[]{sb.toString(), intervalStr, p.getName()});
                } else if (intervalWDA.length() == 0 && intervalHRS.length() == 0) {
                    if (intervalMIN.indexOf(44) == -1) {
                        intervalStr = "h0:00:" + intervalMIN + ":00";
                    } else {
                        try {
                            arr = intervalMIN.split(",");
                            m1 = Integer.parseInt(arr[0]);
                            m2 = Integer.parseInt(arr[1]);
                            deltaMin = m2 - m1;
                            if (deltaMin < 10) {
                                intervalStr = "m" + deltaMin + ":00:0" + m1 + ":00";
                                break block106;
                            }
                            intervalStr = "m" + deltaMin + ":00:" + m1 + ":00";
                        }
                        catch (Throwable v2) {
                            intervalStr = "h0:00:00:01";
                            this.m_logger.print(1, "Error parsing INTERVAL: ({0}) replaced with : ({1}) in policy ({2})", new String[]{sb.toString(), intervalStr, p.getName()});
                        }
                    }
                } else {
                    digitsOnly = Pattern.compile("\\d+");
                    m = digitsOnly.matcher(intervalMIN);
                    if (m.matches()) {
                        m = digitsOnly.matcher(intervalHRS);
                        if (m.matches()) {
                            if (intervalWDA.length() == 0) {
                                intervalStr = "h0:" + intervalHRS + ":" + intervalMIN + ":00";
                            } else if (intervalWDA.length() == 1) {
                                wdaInt = Integer.parseInt(intervalWDA);
                                intervalStr = "w" + ++wdaInt + ":" + intervalHRS + ":" + intervalMIN + ":00";
                            }
                        } else {
                            intervalStr = "h0:00:05:01";
                            this.m_logger.print(1, "Error parsing INTERVAL: ({0}) replaced with : ({1}) in policy ({2})", new String[]{sb.toString(), intervalStr, p.getName()});
                        }
                    } else {
                        intervalStr = "h0:00:10:01";
                        this.m_logger.print(1, "Error parsing INTERVAL: ({0}) replaced with : ({1}) in policy ({2})", new String[]{sb.toString(), intervalStr, p.getName()});
                    }
                }
            }
            p.setIntervalStr(intervalStr);
            p.setDescription(String.valueOf(p.getDescription()) + sb.toString());
        }
        return p;
    }

    private void parseInterval(AbstractPolicy p, String val) {
        Interval ivl = Interval.parseInterval(val, -1);
        if (ivl.getIntervalSeconds() < 60) {
            this.m_logger.print(1, "Failed to parse interval ({0}) in policy ({1}). Forced to 5m ", val, p.getName());
            val = "5m";
        }
        p.setIntervalStr(val);
    }

    public static String normalizePolicyName(String val) {
        return val.replaceAll("[\\s\\p{Punct}&&[^\\.\\-]]", "_");
    }

    /*
     * Unable to fully structure code
     */
    public MsgConditions createMsgConditions(MsgPolicy p) {
        if (this.m_conditions.size() == 0 && p.getConditions() != null && p.getConditions().getConditionList() != null && p.getConditions().getConditionList().size() > 0) {
            return p.getConditions();
        }
        this.m_logger.print(0, "+++   Start importing policy " + p.getName());
        conditionDescr = p.getDescription();
        conds = new MsgConditions();
        cond = null;
        SNMP_trap_e = "";
        SNMP_trap_G = "<*>";
        SNMP_trap_S = "<*>";
        SNMP_trap_VAR = "";
        SNMP_trap_VAR_PATTERN = "";
        flagCondition = true;
        suppressConditionsBlock = false;
        NEGATION = false;
        i = 0;
        while (i < this.m_conditions.size()) {
            block131: {
                block136: {
                    block132: {
                        block134: {
                            block135: {
                                block133: {
                                    ICASE = false;
                                    SEPARATORS = null;
                                    param = null;
                                    val = null;
                                    str = this.m_conditions.get(i);
                                    if ((str = PolicyConvereter.replaceOVOVars(str)).indexOf(34) == -1) break block132;
                                    posOfLastSpace = str.indexOf(34);
                                    param = str.substring(0, posOfLastSpace).trim();
                                    val = str.substring(posOfLastSpace).trim();
                                    if (val.endsWith("\" ICASE")) {
                                        val = val.substring(0, val.indexOf("\" ICASE") + 1);
                                        ICASE = true;
                                    }
                                    if ((sepM = (separat = Pattern.compile("(.+\") SEPARATORS \"(.+)\"\\s*")).matcher(val)).matches()) {
                                        val = sepM.group(1);
                                        sep = sepM.group(2);
                                        ssb = new StringBuilder();
                                        is = 0;
                                        while (is < sep.length()) {
                                            ssb.append('\\').append(sep.charAt(is));
                                            ++is;
                                        }
                                        sep = ssb.toString().replace("\t", "t");
                                        SEPARATORS = "<^[" + sep + "]+^>";
                                    }
                                    if (!val.endsWith("\"") || val.endsWith("\\\"")) break block133;
                                    this.m_logger.print(3, String.valueOf(param) + " -> " + val);
                                    break block134;
                                }
                                posend = val.lastIndexOf(34);
                                if (posend <= 1 || val.charAt(posend - 1) == '\\') ** GOTO lbl50
                                val = val.substring(0, posend + 1);
                                break block135;
lbl-1000:
                                // 1 sources

                                {
                                    val = String.valueOf(val) + "\n" + this.m_conditions.get(++i);
lbl50:
                                    // 2 sources

                                    ** while (!val.endsWith((String)"\"") || val.endsWith((String)"\\\""))
                                }
                            }
                            this.m_logger.print(3, String.valueOf(param) + " -> " + val);
                        }
                        if (val.length() < 3) break block131;
                        val = val.substring(1, val.length() - 1);
                        break block136;
                    }
                    posOfLastSpace = str.lastIndexOf(32);
                    if (posOfLastSpace == -1) {
                        param = str;
                        this.m_logger.print(3, String.valueOf(param) + " -> !YES!");
                    } else {
                        param = str.substring(0, posOfLastSpace).trim();
                        val = str.substring(posOfLastSpace).trim();
                        this.m_logger.print(3, String.valueOf(param) + " -> " + val);
                    }
                }
                if (val != null) {
                    val = val.replace("\\\"", "\"");
                    val = val.replace("\\\\", "\\");
                    val = val.replace("<$MSG_TEXT>", "<$ORIG_TEXT>");
                }
                if (param.equalsIgnoreCase("MSGCONDITIONS") || param.equalsIgnoreCase("SUPPRESSCONDITIONS") || param.equalsIgnoreCase("SUPP_UNM_CONDITIONS")) {
                    conds.description = conditionDescr;
                    conds.uuid = UUID.randomUUID();
                    suppressConditionsBlock = param.equalsIgnoreCase("SUPPRESSCONDITIONS") != false || param.equalsIgnoreCase("SUPP_UNM_CONDITIONS") != false;
                    NEGATION = param.equalsIgnoreCase("SUPP_UNM_CONDITIONS");
                } else if (param.equalsIgnoreCase("DESCRIPTION")) {
                    if (cond != null) {
                        this.setDefaults(cond, this.m_headerAsMap, NEGATION);
                        if (this.m_isSNMP) {
                            this.fillSNMPfields(cond, SNMP_trap_e, SNMP_trap_G, SNMP_trap_S, SNMP_trap_VAR, SNMP_trap_VAR_PATTERN);
                        }
                        conds.addCondition(cond);
                    }
                    cond = MsgCondition.getNew(conds.getConditionCount());
                    if (NEGATION) {
                        cond.setExpected(false);
                    }
                    SNMP_trap_e = "";
                    SNMP_trap_G = "<*>";
                    SNMP_trap_S = "<*>";
                    SNMP_trap_VAR = "";
                    SNMP_trap_VAR_PATTERN = "";
                    cond.setDescription(val);
                    cond.setCloseMask("");
                    cond.setKey("");
                    if (suppressConditionsBlock) {
                        cond.setActionType("STOP");
                        cond.setKey("");
                        cond.setStopEvaluation(true);
                    } else {
                        cond.setActionType("SEND");
                        cond.setStopEvaluation(false);
                    }
                } else if (param.equalsIgnoreCase("CONDITION_ID")) {
                    cond.setConditionId(val);
                    flagCondition = true;
                } else if (param.equalsIgnoreCase("SET")) {
                    flagCondition = false;
                } else if (param.equalsIgnoreCase("OBJECT")) {
                    if (val.equals("<$OBJECT>")) {
                        val = "";
                    }
                    if (flagCondition) {
                        cond.setObjectFilter(val);
                        try {
                            PatternB.getPattern(cond.getObjectFilter());
                        }
                        catch (PolicyException v0) {
                            this.m_logger.print(1, "INVALID OBJECT MASK Pattern: ({0}) in policy ({1}), condition ({2}) ", new String[]{cond.getObjectFilter(), p.getName(), cond.getDescription()});
                        }
                    } else {
                        val = PolicyConvereter.normVariables(val);
                        cond.setSetObject(val);
                    }
                } else if (param.equalsIgnoreCase("SEVERITY")) {
                    if ((val = val.toLowerCase()).indexOf(32) != -1) {
                        val = val.replace(' ', '|');
                    }
                    if (flagCondition) {
                        cond.setSeverityFilter(val);
                    } else {
                        cond.setSetSeverity(val);
                    }
                } else if (param.equalsIgnoreCase("MSGKEYRELATION ACK")) {
                    val = val.replace("\n", "");
                    sepi = (val = val.replace("\r", "")).indexOf("\" SEPARATORS");
                    if (sepi != -1) {
                        val = val.substring(0, sepi);
                    }
                    val = PolicyConvereter.normVariables(val);
                    cond.setCloseMask(val);
                    try {
                        PatternB.getPattern(cond.getCloseMask());
                        if (cond.getCloseMask().indexOf(124) != -1) {
                            this.m_logger.print(1, "Warning: Please review pipe character '|' in Close Key: ({0}) in policy ({1}), condition ({2}) ", new String[]{cond.getCloseMask(), p.getName(), cond.getDescription()});
                        }
                    }
                    catch (PolicyException v1) {
                        this.m_logger.print(1, "INVALID CLOSE MASK Pattern: ({0}) in policy ({1}), condition ({2}) ", new String[]{cond.getCloseMask(), p.getName(), cond.getDescription()});
                    }
                } else if (param.equalsIgnoreCase("TEXT")) {
                    if (flagCondition) {
                        cond.setTextFilter(val);
                        cond.setTextFilter(PolicyConvereter.convertOVOPattern(cond.getTextFilter(), ICASE, SEPARATORS));
                        try {
                            PatternB.getPattern(cond.getTextFilter());
                        }
                        catch (PolicyException v2) {
                            this.m_logger.print(1, "INVALID TEXT Pattern: ({0}) in policy ({1}), condition ({2}) ", new String[]{cond.getTextFilter(), p.getName(), cond.getDescription()});
                        }
                    } else {
                        val = PolicyConvereter.normVariables(val);
                        cond.setSetText(val);
                    }
                } else if (param.equalsIgnoreCase("HELPTEXT")) {
                    cond.setHelptext(val);
                } else if (param.equalsIgnoreCase("HELP")) {
                    cond.setHelptextId(val);
                } else if (param.equalsIgnoreCase("OPACTION")) {
                    if (val.indexOf("ACTIONNODE IP") != -1) {
                        val = val.substring(0, val.indexOf(" ACTIONNODE IP") - 1);
                    }
                    val = PolicyConvereter.normVariables(val);
                    cond.setOpAction(val);
                    this.m_logger.print(1, "CHECK Operator Action: ({0}) in policy ({1}), condition ({2}) ", new String[]{cond.getOpAction(), p.getName(), cond.getTextFilter()});
                } else if (param.equalsIgnoreCase("AUTOACTION")) {
                    if (val.indexOf("ACTIONNODE IP") != -1) {
                        val = val.substring(0, val.indexOf(" ACTIONNODE IP") - 1);
                    }
                    if (val.indexOf("ANNOTATE ACK") != -1) {
                        val = val.substring(0, val.indexOf(" ANNOTATE ACK") - 1);
                    }
                    val = PolicyConvereter.normVariables(val);
                    cond.setAutoAction(val);
                    this.m_logger.print(1, "CHECK Auto Action: ({0}) in policy ({1}), condition ({2}) ", new String[]{cond.getAutoAction(), p.getName(), cond.getTextFilter()});
                } else if (param.equalsIgnoreCase("APPLICATION")) {
                    if (flagCondition) {
                        cond.setApplicationFilter(val);
                    } else {
                        val = PolicyConvereter.normVariables(val);
                        cond.setSetApplication(val);
                    }
                } else if (param.equalsIgnoreCase("MSGGRP")) {
                    if (flagCondition) {
                        cond.setGroupFilter(val);
                    } else {
                        val = PolicyConvereter.normVariables(val);
                        cond.setSetGroup(val);
                    }
                } else if (param.equalsIgnoreCase("MSGKEY") || param.equalsIgnoreCase("MSG_KEY")) {
                    val = PolicyConvereter.normVariables(val);
                    cond.setKey(val);
                } else if (param.equalsIgnoreCase("SERVICE_NAME")) {
                    val = PolicyConvereter.normVariables(val);
                    cond.getCustomAttributes().set(1, String.valueOf(param) + "=" + val);
                    this.m_logger.print(2, "SERVICE_NAME attribute is now mapped to CA2 in policy ({0}), condition ({1}) ", new String[]{p.getName(), cond.getDescription()});
                } else if (param.equalsIgnoreCase("MSGTYPE")) {
                    val = PolicyConvereter.normVariables(val);
                    cond.getCustomAttributes().set(0, String.valueOf(param) + "=" + val);
                    this.m_logger.print(2, "MSGTYPE attribute is now mapped to CA1 in policy ({0}), condition ({1}) ", new String[]{p.getName(), cond.getDescription()});
                } else if (param.equalsIgnoreCase("SERVERLOGONLY")) {
                    cond.setInsertClosed(1);
                } else if (param.equalsIgnoreCase("NODE IP 0.0.0.0")) {
                    cond.setSetNode(PolicyConvereter.normVariables(PolicyConvereter.removeQuotes(val)));
                } else if (param.startsWith("NODE IP") || param.startsWith("NODE OTHER")) {
                    if (flagCondition) {
                        ipsOrNodes = (String.valueOf(param) + " \"" + val + "\"").split("[\r\n \t]+");
                        sb = new StringBuffer();
                        if (cond.getNodeFilter().indexOf(124) != -1) {
                            sb.append(cond.getNodeFilter());
                        }
                        is = ipsOrNodes;
                        ssb = ipsOrNodes.length;
                        posend = 0;
                        while (posend < ssb) {
                            strI = is[posend];
                            if (!("IP".equalsIgnoreCase(strI) || "NODE".equals(strI) || "OTHER".equals(strI))) {
                                if (strI.endsWith("\"IP")) {
                                    strI = strI.replace("\"IP", "");
                                }
                                if (strI.endsWith("\"OTHER")) {
                                    strI = strI.replace("\"OTHER", "");
                                }
                                strI = PolicyConvereter.removeQuotes(strI);
                                strI = strI.replace("*", "<*>");
                                strI = strI.replace("<<", "<");
                                strI = strI.replace(">>", ">");
                                if (sb.length() > 0) {
                                    if (sb.charAt(0) != '[') {
                                        sb.insert(0, '[');
                                        sb.append(']');
                                    }
                                    sb.insert(sb.length() - 1, '|');
                                    sb.insert(sb.length() - 1, strI);
                                } else {
                                    sb.append(strI);
                                }
                            }
                            ++posend;
                        }
                        cond.setNodeFilter(sb.toString());
                    } else {
                        cond.setSetNode(PolicyConvereter.normVariables(PolicyConvereter.removeQuotes(val)));
                    }
                } else if (param.equalsIgnoreCase("SUPP_DUPL_COND") || param.equalsIgnoreCase("SUPP_DUPL_IDENT")) {
                    if (val == null && !(val = this.m_conditions.get(++i)).startsWith("\"")) {
                        --i;
                    } else {
                        try {
                            cond.setSuppressInterval(Interval.parseInterval(PolicyConvereter.removeQuotes(val), 0).getIntervalSeconds());
                        }
                        catch (Throwable v3) {
                            this.m_logger.print(1, "Failed to parse suppress interval ({0}) in policy ({1}), condition ({2}) ", new String[]{val, p.getName(), cond.getDescription()});
                        }
                    }
                } else if (param.equalsIgnoreCase("SUPP_DUPL_IDENT_OUTPUT_MSG")) {
                    if (val == null && !(val = this.m_conditions.get(++i)).startsWith("\"")) {
                        --i;
                    } else {
                        try {
                            val = val.trim().split("\\s+")[0];
                            cond.setSuppressInterval(Interval.parseInterval(PolicyConvereter.removeQuotes(val), 0).getIntervalSeconds());
                        }
                        catch (Throwable v4) {
                            this.m_logger.print(1, "Failed to parse suppress interval ({0}) in policy ({1}), condition ({2}) ", new String[]{val, p.getName(), cond.getDescription()});
                        }
                    }
                } else if (this.m_isSNMP && param.startsWith("$")) {
                    if (param.equalsIgnoreCase("$e")) {
                        SNMP_trap_e = val;
                    } else if (param.equalsIgnoreCase("$G")) {
                        SNMP_trap_G = val;
                    } else if (param.equalsIgnoreCase("$S")) {
                        SNMP_trap_S = val;
                    } else if (Pattern.matches("\\$\\d+", param)) {
                        SNMP_trap_VAR = SNMP_trap_VAR.length() > 0 ? String.valueOf(SNMP_trap_VAR) + "\u2663<" + param + ">" : "<" + param + ">";
                        if (SNMP_trap_VAR_PATTERN.length() > 0) {
                            val = PolicyConvereter.convertOVOPattern(val, ICASE, SEPARATORS);
                            SNMP_trap_VAR_PATTERN = String.valueOf(SNMP_trap_VAR_PATTERN) + '\u2663' + val;
                        } else {
                            SNMP_trap_VAR_PATTERN = val = PolicyConvereter.convertOVOPattern(val, ICASE, SEPARATORS);
                        }
                    } else {
                        this.m_logger.print(1, "Unsupported SNMP variable: " + param, new String[]{p.getName(), cond.getDescription()});
                    }
                } else if (param.startsWith("CUSTOM")) {
                    su = new StrUtils();
                    line = PolicyConvereter.normVariables(str);
                    params = su.processQuoted(line);
                    if (params.length == 3 && "CUSTOM".equals(params[0])) {
                        caName = su.removeQuotes(params[1]);
                        res = this.addCustomAttribute(cond, caName, caValue = su.removeQuotes(params[2]));
                        if (res < 0) {
                            this.m_logger.print(1, "Failed to set custom attribute: " + str + " . No more free slots", new String[]{p.getName(), cond.getDescription()});
                        }
                    } else {
                        this.m_logger.print(1, "Failed to parse custom attribute: " + str, new String[]{p.getName(), cond.getDescription()});
                    }
                } else if (param.equalsIgnoreCase("TROUBLETICKET")) {
                    if (val == null) {
                        val = "";
                    }
                    if ((res = this.addCustomAttribute(cond, "TROUBLETICKET", val)) < 0) {
                        this.m_logger.print(1, "Failed to set TROUBLETICKET attribute: " + str + " . No more free slots", new String[]{p.getName(), cond.getDescription()});
                    }
                } else if (param.startsWith("INSTRUCTION_TEXT_INTERFACE")) {
                    try {
                        su = new StrUtils();
                        params = su.processQuoted(str);
                        IIName = su.removeQuotes(params[1]);
                        cond.setInstructionAction("<$INSTRUCTION_SERVER>iiname=" + IIName);
                        if (PolicyConvereter.m_instrInterfaces.get(IIName) != null && PolicyConvereter.m_instrInterfaces.get(IIName).length() > 0) {
                            cond.setInstructionAction(String.valueOf(cond.getInstructionAction()) + PolicyConvereter.m_instrInterfaces.get(IIName));
                        }
                    }
                    catch (Throwable v5) {
                        this.m_logger.print(1, "Failed to set INSTRUCTION_ACTION in policy ({0}), condition ({1}) -- " + str, new String[]{p.getName(), cond.getDescription()});
                    }
                } else if (param.startsWith("INSTRUCTION_PARAMETERS")) {
                    try {
                        pstart = 1;
                        pstart = PolicyConvereter.getNextInstructionParameterNumber(cond.getInstructionAction());
                        sb = PolicyConvereter.packInstructionParameters(str, pstart, this.m_logger, p, cond);
                        cond.setInstructionAction(String.valueOf(cond.getInstructionAction()) + sb.toString());
                    }
                    catch (Throwable e) {
                        this.m_logger.print(1, "Failed to set INSTRUCTION parameters in policy ({0}), condition ({1}) -- " + str + "\n{2}", new String[]{p.getName(), cond.getDescription(), e.getMessage()});
                    }
                }
            }
            ++i;
        }
        if (cond != null) {
            this.setDefaults(cond, this.m_headerAsMap, NEGATION);
            if (this.m_isSNMP) {
                this.fillSNMPfields(cond, SNMP_trap_e, SNMP_trap_G, SNMP_trap_S, SNMP_trap_VAR, SNMP_trap_VAR_PATTERN);
            }
            conds.addCondition(cond);
        }
        if (this.m_headerAsMap.containsKey("FORWARDUNMATCHED")) {
            cond = MsgCondition.getNew(0);
            cond.setKey("");
            cond.setCloseMask("");
            cond.setDescription("FORWARDUNMATCHED");
            conds.addCondition(cond);
        }
        return conds;
    }

    public int addCustomAttribute(AbstractCondition condition, String name, String value) {
        int res = -1;
        int i = 2;
        while (i < 15) {
            String val = condition.getCustomAttributes().get(i);
            if (val == null || val.length() == 0) {
                condition.getCustomAttributes().set(i, String.valueOf(name) + "=" + value);
                res = i;
                break;
            }
            ++i;
        }
        return res;
    }

    public static String convertOVOPattern(String val, boolean ICASE, String separatorsReplacement) {
        if (val == null) {
            return "";
        }
        if ("".equals(val)) {
            return "";
        }
        boolean strictStart = val.startsWith("^");
        boolean strictEnd = val.endsWith("$");
        if (strictStart) {
            val = val.substring(1);
        } else if (!val.startsWith("<*")) {
            val = "<*>" + val;
        }
        if (strictEnd) {
            val = val.substring(0, val.length() - 1);
        } else if (!PolicyConvereter.isEndedWithStar(val)) {
            val = String.valueOf(val) + "<*>";
        }
        if (ICASE) {
            val = "<^(?i)^>" + val;
        }
        if (separatorsReplacement != null) {
            val = val.replace("<_>", separatorsReplacement);
            val = val.replace("<S>", separatorsReplacement);
            Pattern p = Pattern.compile(".*<(\\d+)S>.*");
            Matcher m = p.matcher(val);
            while (m.matches()) {
                String num = m.group(1);
                val = val.replace("<" + num + "S>", separatorsReplacement.replace("+^>", "{" + num + "}^>"));
                m = p.matcher(val);
            }
        } else {
            val = val.replace("<S>", "<_>");
            Pattern p = Pattern.compile(".*<(\\d+)S>.*");
            Matcher m = p.matcher(val);
            while (m.matches()) {
                String num = m.group(1);
                val = val.replace("<" + num + "S>", "<" + num + "_>");
                m = p.matcher(val);
            }
        }
        return val;
    }

    public static boolean isEndedWithStar(String value) {
        String ending;
        if (value.endsWith("<*>")) {
            return true;
        }
        int lastCh = value.lastIndexOf(60);
        return (value.endsWith(">") || value.endsWith(">]")) && lastCh != -1 && Pattern.matches("<\\*\\.[^<>]+>\\]?", ending = value.substring(lastCh));
    }

    private void fillSNMPfields(MsgCondition cond, String SNMP_trap_e, String SNMP_trap_G, String SNMP_trap_S, String SNMP_trap_VAR, String SNMP_trap_VAR_PATTERN) {
        if ("".equals(SNMP_trap_e)) {
            SNMP_trap_e = "<*>";
        }
        cond.setObjectFilter(SNMP_trap_e);
        if (!"<*>".equals(SNMP_trap_e)) {
            cond.setObjectFilter(String.valueOf(cond.getObjectFilter()) + "<*>");
        }
        if (SNMP_trap_VAR.length() > 0 && SNMP_trap_VAR_PATTERN.length() > 0) {
            cond.setVfilterAsInPolicy(String.valueOf(SNMP_trap_VAR) + " " + SNMP_trap_VAR_PATTERN);
        }
        if ("".equals(SNMP_trap_S)) {
            SNMP_trap_S = "<*>";
        }
        if ("".equals(SNMP_trap_G)) {
            SNMP_trap_G = "<*>";
        }
        if (!"<*>".equals(SNMP_trap_G) || !"<*>".equals(SNMP_trap_S)) {
            if (!SNMP_trap_S.equals("<*>")) {
                if (!"6".equals(SNMP_trap_G) && !"<*>".equals(SNMP_trap_G)) {
                    this.m_logger.print(1, "Condition ID=" + cond.getConditionId() + " has wrong SNMP varaibles $G=" + SNMP_trap_G + " $S=" + SNMP_trap_S);
                }
                cond.setObjectFilter(String.valueOf(cond.getObjectFilter()) + "[:|.][6.$S|$S|0.$S]");
                cond.setObjectFilter(cond.getObjectFilter().replace("$S", SNMP_trap_S));
            } else if ("6".equals(SNMP_trap_G)) {
                cond.setObjectFilter(String.valueOf(cond.getObjectFilter()) + "[:|.]<*>");
            } else {
                cond.setObjectFilter(String.valueOf(cond.getObjectFilter()) + ":" + SNMP_trap_G + ".0");
            }
        } else {
            cond.setObjectFilter(String.valueOf(cond.getObjectFilter()) + "[:|.]<*>");
        }
        cond.setApplicationFilter("SNMPTrapd");
        cond.setGroupFilter("SNMP");
        cond.setCloseMask(PolicyConvereter.replaceSNMP_OVOVars(cond.getCloseMask()));
        cond.setKey(PolicyConvereter.replaceSNMP_OVOVars(cond.getKey()));
        cond.setSetText(PolicyConvereter.replaceSNMP_OVOVars(cond.getSetText()));
        cond.setSetApplication(PolicyConvereter.replaceSNMP_OVOVars(cond.getSetApplication()));
        cond.setSetGroup(PolicyConvereter.replaceSNMP_OVOVars(cond.getSetGroup()));
        cond.setSetNode(PolicyConvereter.replaceSNMP_OVOVars(cond.getSetNode()));
        cond.setSetObject(PolicyConvereter.replaceSNMP_OVOVars(cond.getSetObject()));
        cond.setAutoAction(PolicyConvereter.replaceSNMP_OVOVars(cond.getAutoAction()));
        cond.setOpAction(PolicyConvereter.replaceSNMP_OVOVars(cond.getOpAction()));
        cond.setVfilterAsInPolicy(PolicyConvereter.replaceSNMP_OVOVars(cond.getVfilterAsInPolicy()));
        cond.setVfilterString(PolicyConvereter.replaceSNMP_OVOVars(cond.getVfilterString()));
    }

    private void setDefaults(MsgCondition cond, Map<String, String> defs, boolean negation) {
        switch (this.deduplicationMode) {
            case 0: {
                cond.setDedupl(false);
                cond.setDeduplKeyOnly(false);
                break;
            }
            case 1: {
                cond.setDedupl(false);
                cond.setDeduplKeyOnly(true);
                break;
            }
            case 2: {
                cond.setDedupl(true);
                cond.setDeduplKeyOnly(false);
                break;
            }
        }
        if (cond.getSetSeverity().length() == 0 && defs.containsKey("SEVERITY")) {
            cond.setSetSeverity(defs.get("SEVERITY"));
        }
        if (cond.getSetNode().length() == 0) {
            if (defs.containsKey("MSG_NODE")) {
                cond.setSetNode(PolicyConvereter.normVariables(defs.get("MSG_NODE")));
            }
            if (defs.containsKey("NODE")) {
                cond.setSetNode(PolicyConvereter.normVariables(defs.get("NODE")));
            }
            if (defs.containsKey("MSGNODE")) {
                cond.setSetNode(PolicyConvereter.normVariables(defs.get("MSGNODE")));
            }
        }
        if (cond.getSetObject().length() == 0 && defs.containsKey("OBJECT")) {
            cond.setSetObject(PolicyConvereter.normVariables(defs.get("OBJECT")));
        }
        if (cond.getSetObject().length() == 0 && defs.containsKey("MSGOBJECT")) {
            cond.setSetObject(PolicyConvereter.normVariables(defs.get("MSGOBJECT")));
        }
        if (cond.getKey().length() == 0 && defs.containsKey("MSGKEY")) {
            cond.setKey(PolicyConvereter.normVariables(defs.get("MSGKEY")));
        }
        if (cond.getKey().length() == 0 && defs.containsKey("MSG_KEY")) {
            cond.setKey(PolicyConvereter.normVariables(defs.get("MSG_KEY")));
        }
    }

    private void setDefaults(Condition cond, Map<String, String> defs) {
        switch (this.deduplicationMode) {
            case 0: {
                cond.setDedupl(false);
                cond.setDeduplKeyOnly(false);
                break;
            }
            case 1: {
                cond.setDedupl(false);
                cond.setDeduplKeyOnly(true);
                break;
            }
            case 2: {
                cond.setDedupl(true);
                cond.setDeduplKeyOnly(false);
                break;
            }
        }
        if (cond.getSetNode().length() == 0) {
            if (defs.containsKey("MSG_NODE")) {
                cond.setSetNode(PolicyConvereter.normVariables(defs.get("MSG_NODE")));
            }
            if (defs.containsKey("NODE")) {
                cond.setSetNode(PolicyConvereter.normVariables(defs.get("NODE")));
            }
            if (defs.containsKey("MSGNODE")) {
                cond.setSetNode(PolicyConvereter.normVariables(defs.get("MSGNODE")));
            }
        }
        if (cond.getSetObject().length() == 0 && defs.containsKey("OBJECT")) {
            cond.setSetObject(PolicyConvereter.normVariables(defs.get("OBJECT")));
        }
        if (cond.getSetObject().length() == 0 && defs.containsKey("MSGOBJECT")) {
            cond.setSetObject(PolicyConvereter.normVariables(defs.get("MSGOBJECT")));
        }
    }

    private static String normVariables(String val) {
        if (val == null || val.length() == 0) {
            return val;
        }
        val = val.replace("\n", "");
        val = val.replace("\r", "");
        String[] aaa = val.split("<");
        StringBuffer sbaaa = new StringBuffer();
        sbaaa.append(aaa[0]);
        int k = 1;
        while (k < aaa.length) {
            if (aaa[k].startsWith("$")) {
                sbaaa.append('<').append(aaa[k]);
            } else {
                Pattern ovoMasks = Pattern.compile("\\d*[@#_*]>.*");
                Matcher m = ovoMasks.matcher(aaa[k]);
                if (m.matches()) {
                    sbaaa.append("<");
                    sbaaa.append(aaa[k]);
                } else {
                    sbaaa.append("<$");
                    sbaaa.append(aaa[k]);
                }
            }
            ++k;
        }
        val = sbaaa.toString();
        return val;
    }

    public static String replaceSNMP_OVOVars(String val) {
        if (val == null) {
            return val;
        }
        val = val.replace("<$E>", "<$e>");
        val = val.replace("<$r>", "<$A>");
        val = val.replace("<$R>", "<$A>");
        val = val.replace("<$O>", "<$o>");
        return val;
    }

    public static String replaceOVOVars(String val) {
        if (val == null) {
            return val;
        }
        val = val.replace("<$*>", "<$OPTIONS>");
        val = val.replace("<$MSG_GEN_NODE>", "<$AGENT_IP>");
        val = val.replace("<$MSG_GEN_NODE_NAME>", "<$AGENT_HOST>");
        val = val.replace("<$MSG_TIME_CREATED>", "<$TIME>");
        return val;
    }

    public void readFile(String filename) {
        File f = new File(filename);
        this.readFile(f);
    }

    public void readFile(File f) {
        String fname = f.getName();
        Vector<String> actualSection = this.m_header;
        int count = 0;
        PolicyConvereter pcCURRENT = this;
        if (f.exists()) {
            try {
                Pattern startPolicy = Pattern.compile("\\w+\\s*[^\\\\]\"([^\"]*)[^\\\\]\"\\s*");
                BufferedReader br = new BufferedReader(new FileReader(f));
                String line = null;
                while ((line = br.readLine()) != null) {
                    line = line.trim();
                    StringBuffer lineSB = new StringBuffer();
                    int ii = 0;
                    while (ii < line.length()) {
                        char cc = line.charAt(ii);
                        if (!(cc <= '\b' || cc == '\u000b' || cc == '\f' || cc >= '\u000e' && cc <= '\u001f' || cc >= '\u007f' && cc <= '\u0084' || cc >= '\u0086' && cc <= '\u009f')) {
                            lineSB.append(cc);
                        }
                        ++ii;
                    }
                    line = lineSB.toString();
                    if (line.indexOf("<$OPTION(") != -1) {
                        line = line.replace("<$OPTION(", "<$");
                        line = line.replace(")>", ">");
                    }
                    if ((line.startsWith("ADVMONITOR") || line.startsWith("MONITOR") || line.startsWith("OPCMSG") || line.startsWith("LOGFILE") || line.startsWith("SNMP") || line.startsWith("SCHEDULE ")) && startPolicy.matcher(line).matches()) {
                        if (count > 0) {
                            PolicyConvereter pc;
                            pcCURRENT = pc = new PolicyConvereter(this.m_logger, this.deduplicationMode);
                            this.m_REST.add(pc);
                        }
                        actualSection = pcCURRENT.m_monitor;
                    } else if (line.startsWith("MSGCONDITIONS") || line.startsWith("SUPPRESSCONDITIONS") || line.startsWith("SUPP_UNM_CONDITIONS")) {
                        ++count;
                        actualSection = pcCURRENT.m_conditions;
                    } else if (line.startsWith("SCHEDPROG ")) {
                        ++count;
                    }
                    actualSection.add(line);
                    if (actualSection != pcCURRENT.m_monitor) continue;
                    String key = line.trim().split("\\s+")[0];
                    pcCURRENT.m_headerAsMap.put(key, PolicyConvereter.normVariables(PolicyConvereter.removeQuotes(line.replace(key, "").trim())));
                }
                br.close();
            }
            catch (Throwable e) {
                this.m_logger.print(3, "", e);
            }
        } else {
            System.err.println("Can't find file: " + fname);
        }
    }

    public static String removeQuotes(String in) {
        return new StrUtils().removeQuotes(in);
    }
}

