/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.sim;

import com.blixx.boom.engine.EventFilter;
import com.blixx.boom.engine.IEventProvider;
import com.blixx.boom.gui.dialogs.ISEventUpdateListener;
import com.blixx.boom.gui.views.sim.FilterChangeListener;
import com.blixx.boom.sim.ClusterUpdateListener;
import com.blixx.boom.sim.FilterProvider;
import com.blixx.boom.sim.ProgressListener;
import com.blixx.boom.sim.cluster.BigramIndex;
import com.blixx.boom.sim.cluster.Cluster;
import com.blixx.boom.sim.cluster.ClusterElement;
import com.blixx.boom.sim.cluster.ClusterFinder;
import com.blixx.boom.sim.token.AdvancedTokenizer;
import com.blixx.boom.sim.util.MultiValueHashMap;
import com.blixx.log.RTLogger;
import com.blixx.shared.SEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.Viewer;

public class ClusterProvider
implements ISEventUpdateListener,
FilterChangeListener {
    private static final int PROGRESS_STEP = 500;
    private static final int MIN_ELEMENTS_COUNT_TO_ACTIVATE_PROGRESSBAR = 1000;
    private static final float THRESHOLD = 0.7f;
    private Map<String, ClusterFinder> nameToFinderMap;
    private List<ProgressListener> progressListeners;
    private IEventProvider eventProvider;
    private Map<String, ClusterFinder> eventIdToFinderMap;
    private static final String COMPUTE_TOKENS = "Computing tokens of indication messages.";
    private static final String COMPUTE_CLUSTERS = "Computing groups of indication messages.";
    private static final String COMPUTE_PATTERNS = "Computing groups patterns of indication messages.";
    private boolean processActive = true;
    private final AdvancedTokenizer tokenizer = new AdvancedTokenizer();
    private FilterProvider filterProvider = null;
    private List<ClusterUpdateListener> updateListener;
    private BlockingQueue<ClusteringTask> processingQueue = new LinkedBlockingQueue<ClusteringTask>();
    private Thread processingThread;
    private ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private boolean activeEventsInitialized = false;
    private boolean closedEventsInitialized = false;
    private boolean groupBySeverity = true;
    private AtomicBoolean m_stopProvider = new AtomicBoolean(false);

    public ClusterProvider(IEventProvider eventProvider) {
        this.eventProvider = eventProvider;
        this.progressListeners = new ArrayList<ProgressListener>();
        this.nameToFinderMap = new HashMap<String, ClusterFinder>();
        this.eventIdToFinderMap = new HashMap<String, ClusterFinder>();
        this.updateListener = new ArrayList<ClusterUpdateListener>();
        this.createProcessingThread();
    }

    public void dispose() {
        this.m_stopProvider.compareAndSet(false, true);
        this.progressListeners.clear();
        this.processingQueue.clear();
        this.clear();
        this.updateListener.clear();
        try {
            Thread.sleep(20L);
            this.processingThread.interrupt();
        }
        catch (Throwable throwable) {}
    }

    public void clear() {
        for (ClusterFinder sf : this.nameToFinderMap.values()) {
            sf.clear();
        }
        this.nameToFinderMap.clear();
        this.eventIdToFinderMap.clear();
    }

    private void createProcessingThread() {
        this.processingThread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    while (!ClusterProvider.this.m_stopProvider.get()) {
                        boolean batchFinished = false;
                        ArrayList<SEvent> batch = new ArrayList<SEvent>();
                        Date batchStartTimeStamp = new Date();
                        do {
                            ClusteringTask task;
                            if ((task = (ClusteringTask)ClusterProvider.this.processingQueue.take()) instanceof SingleEventTask) {
                                batch.add(((SingleEventTask)task).event);
                            } else if (task instanceof EventBatchTask) {
                                batchFinished = true;
                                EventBatchTask batchTask = (EventBatchTask)task;
                                ClusterProvider.this.batchProcessEvents(batchTask.events, batchTask.isDeltaProcessing, batchTask.eventsAreActive);
                            }
                            if (new Date().getTime() - batchStartTimeStamp.getTime() <= 1000L) continue;
                            batchFinished = true;
                        } while (ClusterProvider.this.processingQueue.size() > 0 && !batchFinished);
                        ClusterProvider.this.batchProcessEvents(batch, true, false);
                    }
                }
                catch (InterruptedException interruptedException) {}
            }
        });
        this.processingThread.start();
    }

    public void processInitialBatch(Collection<SEvent> events, boolean eventsAreActive) {
        try {
            this.processingQueue.put(new EventBatchTask(events, eventsAreActive));
        }
        catch (InterruptedException interruptedException) {}
    }

    private void batchProcessEvents(Collection<SEvent> events, boolean isDeltaProcessing, boolean eventsAreActive) {
        this.lock.writeLock().lock();
        try {
            if (isDeltaProcessing) {
                ArrayList<SEvent> updatedEvents = new ArrayList<SEvent>(events.size());
                for (SEvent event : events) {
                    SEvent storedEvent = this.eventProvider.getEvent(event.getID());
                    if (storedEvent != null && event.getState() == '-' && storedEvent.getState() != '-') continue;
                    updatedEvents.add(storedEvent == null ? event : storedEvent);
                }
                events = updatedEvents;
            } else {
                this.clearClusters(eventsAreActive);
            }
            List<ClusterElement> elementsWithoutTokens = this.filterEvents(events);
            if (elementsWithoutTokens.size() > 0) {
                HashSet<Cluster> foundClusters = new HashSet<Cluster>(3000);
                List<ClusterElement> elements = this.setTokens(elementsWithoutTokens);
                this.notifyProgressListeners(COMPUTE_CLUSTERS, 0, elements.size(), false);
                if (isDeltaProcessing) {
                    MultiValueHashMap<String, ClusterElement> finderNamePrefixToElementsToRemove = new MultiValueHashMap<String, ClusterElement>();
                    for (ClusterElement element : elements) {
                        ClusterFinder previousFinder = this.eventIdToFinderMap.get(element.getId());
                        if (previousFinder == null) continue;
                        finderNamePrefixToElementsToRemove.add(previousFinder.getName(), element);
                    }
                    for (String finderName : finderNamePrefixToElementsToRemove.keySet()) {
                        ClusterFinder finder = this.getNamedFinder(finderName);
                        finder.removeClusterElements(finderNamePrefixToElementsToRemove.get(finderName));
                    }
                }
                String name = this.getFinderNamePrefix(eventsAreActive);
                int i = 0;
                while (i < elements.size()) {
                    this.notifyProgressListeners(COMPUTE_CLUSTERS, i + 1, elements.size(), false);
                    ClusterElement element = elements.get(i);
                    if (element.getEvent().getState() != 'D') {
                        String severity = element.getEvent().getSeverity();
                        if (isDeltaProcessing) {
                            name = this.getFinderNamePrefix(element.getEvent().getState() == '-');
                        }
                        ClusterFinder finder = this.getNamedFinder(this.getNameWithSeverity(name, severity));
                        Cluster cluster = finder.findCluster(element, 0.7f);
                        foundClusters.add(cluster);
                        this.eventIdToFinderMap.put(element.getEvent().getID(), finder);
                    }
                    ++i;
                }
                this.notifyProgressListeners(COMPUTE_CLUSTERS, elements.size(), elements.size(), false);
                i = 0;
                this.notifyProgressListeners(COMPUTE_PATTERNS, 0, foundClusters.size(), !isDeltaProcessing);
                for (Cluster cluster : foundClusters) {
                    cluster.computePattern();
                    cluster.calculateStatistics();
                    this.notifyProgressListeners(COMPUTE_PATTERNS, ++i, foundClusters.size(), !isDeltaProcessing);
                }
                this.notifyProgressListeners(COMPUTE_PATTERNS, foundClusters.size(), foundClusters.size(), !isDeltaProcessing);
            }
        }
        catch (Throwable throwable) {
            this.lock.writeLock().unlock();
            this.notifyListeners();
            try {
                this.notifyProgressListeners("end", 1000, 1000, true);
            }
            catch (Throwable throwable2) {}
            throw throwable;
        }
        this.lock.writeLock().unlock();
        this.notifyListeners();
        try {
            this.notifyProgressListeners("end", 1000, 1000, true);
        }
        catch (Throwable throwable) {}
    }

    private List<ClusterElement> filterEvents(Collection<SEvent> events) {
        LinkedList<ClusterElement> elements = new LinkedList();
        boolean filtersActive = this.filterProvider != null && this.filterProvider.getActiveFiltersIterator().hasNext();
        for (SEvent se : events) {
            boolean matched = true;
            if (filtersActive) {
                Iterator<EventFilter> filterIterator = this.filterProvider.getActiveFiltersIterator();
                while (filterIterator.hasNext()) {
                    Object[] res;
                    EventFilter ef = filterIterator.next();
                    if (!ef.m_isActive || (res = ef.filter((Viewer)null, TreePath.EMPTY, new Object[]{se})) != null && res.length != 0) continue;
                    matched = false;
                    break;
                }
            }
            if (!matched) continue;
            elements.add(new ClusterElement(se));
        }
        elements = new ArrayList(elements);
        return elements;
    }

    private String getNameWithSeverity(String prefix, String severity) {
        String result;
        if (this.groupBySeverity) {
            StringBuilder builder = new StringBuilder();
            builder.append(prefix).append("#").append(severity.replace("_f", ""));
            result = builder.toString();
        } else {
            result = prefix;
        }
        return result;
    }

    private ClusterFinder getNamedFinder(String name) {
        ClusterFinder result = null;
        result = this.nameToFinderMap.get(name);
        if (result == null) {
            result = new ClusterFinder(name, new BigramIndex());
            this.nameToFinderMap.put(name, result);
        }
        return result;
    }

    private List<ClusterElement> convertToElements(Collection<SEvent> events) {
        ArrayList<ClusterElement> elements = new ArrayList<ClusterElement>(events.size());
        for (SEvent event : events) {
            ClusterElement indication = new ClusterElement(event);
            elements.add(indication);
        }
        return this.setTokens(elements);
    }

    private List<ClusterElement> setTokens(List<ClusterElement> elements) {
        int totalCount = elements.size();
        final AtomicInteger progress = new AtomicInteger(0);
        ExecutorService executor = Executors.newFixedThreadPool(3);
        this.notifyProgressListeners(COMPUTE_TOKENS, progress.get(), totalCount, false);
        int chunkSize = elements.size() / 3;
        final ArrayList<ClusterElement> chunk1 = new ArrayList<ClusterElement>(elements.subList(0, chunkSize));
        final ArrayList<ClusterElement> chunk2 = new ArrayList<ClusterElement>(elements.subList(chunkSize, chunkSize * 2));
        final ArrayList<ClusterElement> chunk3 = new ArrayList<ClusterElement>(elements.subList(chunkSize * 2, elements.size()));
        Future<?> fu1 = executor.submit(new Runnable(){

            @Override
            public void run() {
                for (ClusterElement element : chunk1) {
                    element.setTokens(ClusterProvider.this.tokenizer.getTokens(element.getFullText()));
                    progress.incrementAndGet();
                }
            }
        });
        Future<?> fu2 = executor.submit(new Runnable(){

            @Override
            public void run() {
                for (ClusterElement element : chunk2) {
                    element.setTokens(ClusterProvider.this.tokenizer.getTokens(element.getFullText()));
                    progress.incrementAndGet();
                }
            }
        });
        Future<?> fu3 = executor.submit(new Runnable(){

            @Override
            public void run() {
                for (ClusterElement element : chunk3) {
                    element.setTokens(ClusterProvider.this.tokenizer.getTokens(element.getFullText()));
                    progress.incrementAndGet();
                }
            }
        });
        while (!(fu1.isDone() && fu2.isDone() && fu3.isDone())) {
            try {
                this.notifyProgressListeners(COMPUTE_TOKENS, progress.get(), totalCount, totalCount >= 1000);
                Thread.sleep(300L);
            }
            catch (Throwable throwable) {}
        }
        this.notifyProgressListeners(COMPUTE_TOKENS, totalCount, totalCount, false);
        executor.shutdown();
        return elements;
    }

    public List<Cluster> getClusters() {
        ArrayList<Cluster> result = new ArrayList<Cluster>();
        this.lock.readLock().lock();
        try {
            String namePrefix = this.getFinderNamePrefix(this.processActive);
            for (String name : this.nameToFinderMap.keySet()) {
                ClusterFinder finder;
                if (!name.startsWith(namePrefix) || (finder = this.nameToFinderMap.get(name)) == null) continue;
                result.addAll(finder.getClustersListCopy());
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
        return result;
    }

    private void notifyProgressListeners(String taskName, int currentValue, int maxValue, boolean force) {
        RTLogger.print(5, String.format("%b %d %d %s", force, currentValue, maxValue, taskName));
        if (force || maxValue >= 1000 && (currentValue % 500 == 0 || currentValue >= maxValue)) {
            for (ProgressListener progressListener : this.progressListeners) {
                if (currentValue == 0) {
                    progressListener.taskStarted(taskName, maxValue);
                    continue;
                }
                if (currentValue < maxValue) {
                    progressListener.progressMade(taskName, currentValue, maxValue);
                    continue;
                }
                progressListener.taskFinished(taskName);
            }
        }
    }

    public void addProgressListener(ProgressListener progressListener) {
        this.progressListeners.add(progressListener);
    }

    public void removeProgressListener(ProgressListener progressListener) {
        this.progressListeners.remove(progressListener);
    }

    public int getClusterCount() {
        int totalCount = 0;
        this.lock.readLock().lock();
        try {
            for (String name : this.nameToFinderMap.keySet()) {
                if (!name.startsWith(this.getFinderNamePrefix(this.processActive))) continue;
                totalCount += this.nameToFinderMap.get(name).getClustersCount();
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
        return totalCount;
    }

    public int getClusterCountWithMinXElements(int minElementsCount) {
        int totalCount = 0;
        this.lock.readLock().lock();
        try {
            for (String name : this.nameToFinderMap.keySet()) {
                if (!name.startsWith(this.getFinderNamePrefix(this.processActive))) continue;
                List<Cluster> clusters = this.nameToFinderMap.get(name).getClustersListCopy();
                for (Cluster cluster : clusters) {
                    if (cluster.size() < minElementsCount) continue;
                    ++totalCount;
                }
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
        return totalCount;
    }

    private String getFinderNamePrefix(boolean active) {
        return active ? "active" : "closed";
    }

    public void setProcessActive(boolean processActive) {
        this.processActive = processActive;
        if (processActive && this.activeEventsInitialized || !processActive && this.closedEventsInitialized) {
            this.notifyListeners();
        } else {
            this.clearClusters(processActive);
            if (processActive) {
                this.activeEventsInitialized = true;
                this.processInitialBatch(this.eventProvider.getActiveMap().values(), true);
            } else {
                this.closedEventsInitialized = true;
                this.processInitialBatch(this.eventProvider.getClosedMap().values(), false);
            }
        }
    }

    private void clearClusters(boolean processActive) {
        this.lock.writeLock().lock();
        try {
            String prefix = this.getFinderNamePrefix(processActive);
            ArrayList<String> keysToRemove = new ArrayList<String>();
            for (String key : this.nameToFinderMap.keySet()) {
                if (!key.startsWith(prefix)) continue;
                keysToRemove.add(key);
            }
            for (String key : keysToRemove) {
                this.nameToFinderMap.remove(key);
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public void update(SEvent se) {
        try {
            this.processingQueue.put(new SingleEventTask(se));
        }
        catch (InterruptedException interruptedException) {}
    }

    @Override
    public void update(Set<SEvent> list) {
        if (list.size() > 0) {
            try {
                EventBatchTask ebt = new EventBatchTask(list, false, true);
                this.processingQueue.put(ebt);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public void addUpdateListener(ClusterUpdateListener listener) {
        this.updateListener.add(listener);
    }

    public void removeUpdateListener(ClusterUpdateListener listener) {
        this.updateListener.remove(listener);
    }

    private void notifyListeners() {
        try {
            for (ClusterUpdateListener listener : this.updateListener) {
                listener.clustersUpdated();
            }
        }
        catch (Throwable throwable) {}
    }

    public List<Cluster> findClustersByIds(String[] ids) {
        ArrayList<Cluster> result = new ArrayList<Cluster>();
        this.lock.readLock().lock();
        try {
            String[] stringArray = ids;
            int n = ids.length;
            int n2 = 0;
            while (n2 < n) {
                String id = stringArray[n2];
                ClusterFinder finder = this.eventIdToFinderMap.get(id);
                if (finder != null) {
                    List<Cluster> clusters = finder.getClustersListCopy();
                    block4: for (Cluster cluster : clusters) {
                        List<ClusterElement> elements = cluster.getElementsCopy();
                        for (ClusterElement element : elements) {
                            if (!element.getId().contains(id)) continue;
                            result.add(cluster);
                            continue block4;
                        }
                    }
                }
                ++n2;
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
        return result;
    }

    public List<Cluster> findClustersByPattern(String text) {
        ArrayList<Cluster> result = new ArrayList<Cluster>();
        this.lock.readLock().lock();
        try {
            Collection<ClusterFinder> finders = this.eventIdToFinderMap.values();
            for (ClusterFinder finder : finders) {
                if (finder == null) continue;
                List<Cluster> clusters = finder.getClustersListCopy();
                for (Cluster cluster : clusters) {
                    if (!cluster.getPattern().contains(text)) continue;
                    result.add(cluster);
                }
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
        return result;
    }

    public void setFilterProvider(FilterProvider filterProvider) {
        this.filterProvider = filterProvider;
    }

    @Override
    public void recalculateClusters() {
        this.lock.writeLock().lock();
        try {
            this.nameToFinderMap.clear();
            this.activeEventsInitialized = false;
            this.closedEventsInitialized = false;
            this.setProcessActive(this.processActive);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public List<Cluster> getClustersWithMaxXElements(int maxElementsCount) {
        ArrayList<Cluster> result = new ArrayList<Cluster>();
        this.lock.readLock().lock();
        try {
            String namePrefix = this.getFinderNamePrefix(this.processActive);
            for (String name : this.nameToFinderMap.keySet()) {
                ClusterFinder finder;
                if (!name.startsWith(namePrefix) || (finder = this.nameToFinderMap.get(name)) == null) continue;
                List<Cluster> clusters = finder.getClustersListCopy();
                for (Cluster cluster : clusters) {
                    if (cluster.size() > maxElementsCount) continue;
                    result.add(cluster);
                }
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
        return result;
    }

    public List<Cluster> getClustersWithMinXElements(int minElementsCount) {
        ArrayList<Cluster> result = new ArrayList<Cluster>();
        this.lock.readLock().lock();
        try {
            String namePrefix = this.getFinderNamePrefix(this.processActive);
            for (String name : this.nameToFinderMap.keySet()) {
                ClusterFinder finder;
                if (!name.startsWith(namePrefix) || (finder = this.nameToFinderMap.get(name)) == null) continue;
                List<Cluster> clusters = finder.getClustersListCopy();
                for (Cluster cluster : clusters) {
                    if (cluster.size() < minElementsCount) continue;
                    result.add(cluster);
                }
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
        return result;
    }

    public boolean isGroupBySeverity() {
        return this.groupBySeverity;
    }

    public void setGroupBySeverity(boolean groupBySeverity) {
        this.groupBySeverity = groupBySeverity;
        this.clearClusters(this.processActive);
        this.activeEventsInitialized = false;
        this.closedEventsInitialized = false;
        this.recalculateClusters();
    }

    @Override
    public void cleanAll() {
        this.setGroupBySeverity(this.isGroupBySeverity());
    }

    private abstract class ClusteringTask {
        private ClusteringTask() {
        }
    }

    private class EventBatchTask
    extends ClusteringTask {
        public Collection<SEvent> events;
        boolean eventsAreActive;
        boolean isDeltaProcessing = false;

        public EventBatchTask(Collection<SEvent> events, boolean eventsAreActive) {
            this(events, eventsAreActive, false);
        }

        public EventBatchTask(Collection<SEvent> events, boolean eventsAreActive, boolean isDeltaProcessing) {
            this.events = events;
            this.eventsAreActive = eventsAreActive;
            this.isDeltaProcessing = isDeltaProcessing;
        }
    }

    private class SingleEventTask
    extends ClusteringTask {
        public SEvent event;

        public SingleEventTask(SEvent event) {
            this.event = event;
        }
    }
}

