/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.sim.cluster;

import com.blixx.boom.sim.cluster.ClusterElement;
import com.blixx.boom.sim.token.Token;

public class Bigram {
    private Token first;
    private Token second;

    public Bigram(Token first, Token second) {
        this.first = first;
        this.second = second;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Bigram bigram = (Bigram)o;
        if (!this.first.equals(bigram.first)) {
            return false;
        }
        return this.second.equals(bigram.second);
    }

    public int hashCode() {
        int result = this.first.hashCode();
        result = 31 * result + this.second.hashCode();
        return result;
    }

    public Token getFirst() {
        return this.first;
    }

    public Token getSecond() {
        return this.second;
    }

    public String asString(ClusterElement element) {
        StringBuilder builder = new StringBuilder();
        if (this.first.getTokenId() == Token.BEGIN_MARKER) {
            builder.append("^");
        } else {
            builder.append(element.getTokenText(this.first));
        }
        builder.append(" | ");
        if (this.second.getTokenId() == Token.END_MARKER) {
            builder.append("$");
        } else {
            builder.append(element.getTokenText(this.second));
        }
        return builder.toString();
    }
}

