/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.sim.cluster;

import com.blixx.boom.sim.cluster.Bigram;
import com.blixx.boom.sim.cluster.Cluster;
import com.blixx.boom.sim.cluster.ClusterElement;
import com.blixx.boom.sim.cluster.ClusterIndex;
import com.blixx.boom.sim.token.Token;
import com.blixx.boom.sim.util.Histogram;
import com.blixx.boom.sim.util.MultiValueHashMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class BigramIndex
implements ClusterIndex {
    private Token BEGIN_TOKEN = new Token(Token.BEGIN_MARKER, 0);
    private Token END_TOKEN = new Token(Token.END_MARKER, 0);
    private MultiValueHashMap<Integer, Cluster> bigramHashToClusterMap = new MultiValueHashMap(50000);
    private Map<Cluster, Histogram<Integer>> clusterToTokenStatistics = new HashMap<Cluster, Histogram<Integer>>(1000);
    private Set<String> debugIds = new HashSet<String>();
    private List<Cluster> clusters = new ArrayList<Cluster>(1000);
    private Set<String> strongStringTokens = new HashSet<String>();

    public BigramIndex() {
        this.initStrongTokens();
    }

    private void initStrongTokens() {
        this.strongStringTokens.add("exit");
        this.strongStringTokens.add("establish");
        this.strongStringTokens.add("lost");
        this.strongStringTokens.add("not");
        this.strongStringTokens.add("receive");
        this.strongStringTokens.add("alarm");
        this.strongStringTokens.add("able");
        this.strongStringTokens.add("install");
        this.strongStringTokens.add("fail");
        this.strongStringTokens.add("warn");
        this.strongStringTokens.add("start");
        this.strongStringTokens.add("stop");
        this.strongStringTokens.add("end");
        this.strongStringTokens.add("error");
        this.strongStringTokens.add("down");
        this.strongStringTokens.add("succe");
        this.strongStringTokens.add("schedul");
    }

    @Override
    public void index(Cluster cluster) {
        ClusterElement element = cluster.getPatternElement();
        if (element != null) {
            List<Bigram> bigrams = this.getBigrams(element);
            for (Bigram bigram : bigrams) {
                this.bigramHashToClusterMap.add(this.getBigramHash(bigram), cluster);
            }
            this.clusterToTokenStatistics.put(cluster, this.getStrongTokenStatistics(cluster.getPatternElement()));
            this.clusters.add(cluster);
        }
    }

    private List<Bigram> getBigrams(ClusterElement element) {
        ArrayList<Bigram> bigrams = new ArrayList<Bigram>();
        if (element.getTokens().size() == 0) {
            bigrams.add(new Bigram(this.BEGIN_TOKEN, this.END_TOKEN));
        } else {
            List<Token> tokens = element.getTokens();
            bigrams.add(new Bigram(this.BEGIN_TOKEN, tokens.get(0)));
            int i = 0;
            while (i < tokens.size() - 1) {
                bigrams.add(new Bigram(tokens.get(i), tokens.get(i + 1)));
                ++i;
            }
            bigrams.add(new Bigram(tokens.get(tokens.size() - 1), this.END_TOKEN));
        }
        return bigrams;
    }

    private int getBigramHash(Bigram bigram) {
        int bigramHash;
        if (bigram.getFirst().getTokenClassId() == -4 && bigram.getSecond().getTokenClassId() == -4) {
            bigramHash = this.getHash(bigram.getFirst().getTokenId(), bigram.getSecond().getTokenId());
        } else {
            int firstHash = this.getIdForTokenToUseInIndex(bigram.getFirst());
            int secondHash = this.getIdForTokenToUseInIndex(bigram.getSecond());
            bigramHash = this.getHash(firstHash, secondHash);
        }
        return bigramHash;
    }

    private int getIdForTokenToUseInIndex(Token token) {
        int id = token.getTokenClassId() == -5 || token.getTokenClassId() == -4 || token.getTokenClassId() == -2 ? token.getTokenClassId() : token.getTokenId();
        return id;
    }

    private int getHash(int first, int second) {
        int result = first;
        result = 31 * result + second;
        return result;
    }

    private int getMinBigramCountToMatch(int bigramsCount, float similarityIndex) {
        return (int)((float)(bigramsCount - 1) * similarityIndex);
    }

    private Histogram<Integer> getStrongTokenStatistics(ClusterElement element) {
        Histogram<Integer> statistics = new Histogram<Integer>();
        for (Token token : element.getTokens()) {
            if (!this.isStrongToken(token, element)) continue;
            if (token.getTokenClassId() == -1) {
                statistics.add(token.getTokenId());
                continue;
            }
            statistics.add(token.getTokenClassId());
        }
        return statistics;
    }

    @Override
    public Cluster findCluster(ClusterElement element, float similarityIndex) {
        Cluster result = null;
        int currentIndicationTokensCount = element.getTokens().size();
        Histogram<Cluster> matchedClustersHistogram = new Histogram<Cluster>(element.getTokens().size());
        List<Bigram> bigrams = this.getBigrams(element);
        Histogram<Integer> indicationStatistics = this.getStrongTokenStatistics(element);
        for (Bigram bigram : bigrams) {
            Set<Cluster> clusters = this.bigramHashToClusterMap.get(this.getBigramHash(bigram));
            if (clusters == null) continue;
            for (Cluster cluster : clusters) {
                int clusterIndicationTokensCount = cluster.getPatternElement().getTokens().size();
                float sizeIndex = (float)Math.min(currentIndicationTokensCount, clusterIndicationTokensCount) / (float)Math.max(currentIndicationTokensCount, clusterIndicationTokensCount);
                if (!(sizeIndex >= similarityIndex) || !indicationStatistics.contentEquals(this.clusterToTokenStatistics.get(cluster))) continue;
                matchedClustersHistogram.add(cluster);
            }
        }
        List topEntries = matchedClustersHistogram.getTopEntries();
        ArrayList<Cluster> results = new ArrayList<Cluster>();
        for (Map.Entry topEntry : topEntries) {
            Integer hitCount = topEntry.getValue();
            Cluster topCluster = (Cluster)topEntry.getKey();
            int minBigramsToMatch = this.getMinBigramCountToMatch(Math.max(bigrams.size(), topCluster.getPatternElement().getTokens().size() + 1), similarityIndex);
            if (this.debugIds.contains(element.getId()) || this.debugIds.contains(topCluster.getPatternElement().getId())) {
                this.explain(element, topCluster, hitCount, minBigramsToMatch);
            }
            if (hitCount < minBigramsToMatch) continue;
            results.add(topCluster);
        }
        if (results.size() == 1) {
            result = (Cluster)results.get(0);
        } else if (results.size() > 1) {
            result = (Cluster)results.get(0);
        }
        if (topEntries.size() == 0 && this.debugIds.contains(element.getEvent().getID())) {
            System.out.println("No hits for " + element.getEvent().getID());
            System.out.println("Indications Element: " + element.getFullText());
            System.out.println("Indications Tokens: " + element.getFilteredText());
            System.out.println("Indications Tokens Count: " + element.getTokens().size());
        }
        return result;
    }

    private void explain(ClusterElement element, Cluster topCluster, int hitCount, int minBigramsToMatch) {
        System.out.println("--------- " + element.getEvent().getID() + " ---------");
        System.out.println("Indications Element: " + element.getFullText());
        System.out.println("Indications Tokens: " + element.getFilteredText());
        System.out.println("Indications Tokens Count: " + element.getTokens().size());
        System.out.println("Cluster ElementId: " + topCluster.getPatternElement().getEvent().getID());
        System.out.println("Cluster Element: " + topCluster.getPatternElement().getFullText());
        System.out.println("Cluster Tokens: " + topCluster.getPatternElement().getFilteredText());
        System.out.println("Cluster Tokens Count: " + topCluster.getPatternElement().getTokens().size());
        System.out.println("Min bigrams to match: " + minBigramsToMatch);
        System.out.println("Hit count: " + hitCount);
        System.out.println("Matched bigrams: ");
        List<Bigram> bigrams = this.getBigrams(element);
        for (Bigram bigram : bigrams) {
            int bigramHash = this.getBigramHash(bigram);
            Set<Cluster> clusters = this.bigramHashToClusterMap.get(this.getBigramHash(bigram));
            if (clusters == null || !clusters.contains(topCluster)) continue;
            System.out.print(bigram.asString(element));
            List<Bigram> clusterBigrams = this.getBigrams(topCluster.getPatternElement());
            for (Bigram clusterBigram : clusterBigrams) {
                if (bigramHash != this.getBigramHash(clusterBigram)) continue;
                System.out.print(" || " + clusterBigram.asString(topCluster.getPatternElement()));
            }
            System.out.println();
        }
    }

    @Override
    public void removeCluster(Cluster cluster) {
        List<Bigram> bigrams = this.getBigrams(cluster.getPatternElement());
        for (Bigram bigram : bigrams) {
            Set<Cluster> bigramClusters = this.bigramHashToClusterMap.get(this.getBigramHash(bigram));
            if (bigramClusters == null) continue;
            bigramClusters.remove(cluster);
        }
        this.clusterToTokenStatistics.remove(cluster);
        this.clusters.remove(cluster);
    }

    public Cluster joinClusters(List<Cluster> clusters) {
        int count = 0;
        for (Cluster cluster : clusters) {
            count += cluster.size();
        }
        ArrayList<ClusterElement> elements = new ArrayList<ClusterElement>(count);
        for (Cluster cluster : clusters) {
            elements.addAll(cluster.getElementsCopy());
        }
        for (Cluster cluster : clusters) {
            this.removeCluster(cluster);
        }
        Cluster result = new Cluster(elements);
        this.index(result);
        return result;
    }

    @Override
    public List<Cluster> getClusters() {
        return new ArrayList<Cluster>(this.clusters);
    }

    @Override
    public int getClustersCount() {
        return this.clusters.size();
    }

    private boolean isStrongToken(Token token, ClusterElement element) {
        boolean result;
        boolean bl = result = token.getTokenClassId() == -2 || token.getTokenClassId() == -3 || token.getTokenClassId() == -5;
        if (!result && token.getTokenClassId() == -1) {
            String tokenText = element.getTokenText(token).toLowerCase();
            if (tokenText.equals("ok") || tokenText.equals("up")) {
                result = true;
            } else {
                for (String strongElement : this.strongStringTokens) {
                    if (!tokenText.contains(strongElement)) continue;
                    result = true;
                    break;
                }
            }
        }
        return result;
    }
}

