/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.sim.cluster;

import com.blixx.boom.sim.cluster.ClusterElement;
import com.blixx.boom.sim.cluster.ClusterPatternFinder;
import com.blixx.boom.sim.cluster.ClusterStatistics;
import com.blixx.shared.SEvent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class Cluster {
    private ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private static AtomicInteger sequence = new AtomicInteger(0);
    private List<ClusterElement> elements = new LinkedList<ClusterElement>();
    private ClusterStatistics statistics = new ClusterStatistics();
    private String pattern;
    private int id = Cluster.getNextId();

    private static int getNextId() {
        return sequence.incrementAndGet();
    }

    public Cluster() {
    }

    public Cluster(List<ClusterElement> elements) {
        this.elements = elements;
    }

    public int getId() {
        return this.id;
    }

    public List<ClusterElement> getElementsCopy() {
        ArrayList<ClusterElement> result;
        this.lock.readLock().lock();
        try {
            result = new ArrayList<ClusterElement>(this.elements);
        }
        finally {
            this.lock.readLock().unlock();
        }
        return result;
    }

    public void addElement(ClusterElement element) {
        this.lock.writeLock().lock();
        try {
            this.elements.add(element);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public void removeElement(ClusterElement element) {
        this.lock.writeLock().lock();
        try {
            this.elements.remove(element);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public ClusterElement getPatternElement() {
        ClusterElement result = null;
        this.lock.readLock().lock();
        try {
            if (this.elements.size() > 0) {
                result = this.elements.get(0);
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
        return result;
    }

    public String getPattern() {
        return this.pattern;
    }

    public void computePattern() {
        this.lock.writeLock().lock();
        try {
            ClusterPatternFinder patternFinder = new ClusterPatternFinder();
            if (this.elements instanceof LinkedList) {
                this.elements = new ArrayList<ClusterElement>(this.elements);
            }
            this.pattern = patternFinder.findPattern(this.elements);
            if (this.elements instanceof ArrayList) {
                this.elements = new LinkedList<ClusterElement>(this.elements);
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public void calculateStatistics() {
        this.statistics = new ClusterStatistics();
        if (this.elements.size() > 0) {
            HashSet<String> distinctAgents = new HashSet<String>();
            this.statistics.maxServerTime = this.statistics.minServerTime = this.elements.get(0).getEvent().getSTime();
            for (ClusterElement element : this.elements) {
                int severity;
                SEvent event = element.getEvent();
                this.statistics.duplicatesCount += event.getDuplicates();
                distinctAgents.add(event.getAgentNode());
                if (this.statistics.minServerTime > event.getSTime()) {
                    this.statistics.minServerTime = event.getSTime();
                }
                if (this.statistics.maxServerTime < event.getSTime()) {
                    this.statistics.maxServerTime = event.getSTime();
                }
                if ((severity = event.getSeverityInt()) < 0) {
                    severity += 6;
                }
                this.statistics.severityCounts.add(severity);
            }
            this.statistics.distinctAgentsCount = distinctAgents.size();
        }
    }

    public ClusterStatistics getStatistics() {
        return this.statistics;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.id;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Cluster other = (Cluster)obj;
        return this.id == other.id;
    }

    public int size() {
        int result;
        this.lock.readLock().lock();
        try {
            result = this.elements.size();
        }
        finally {
            this.lock.readLock().unlock();
        }
        return result;
    }
}

