/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.sim.cluster;

import com.blixx.boom.sim.token.Token;
import com.blixx.shared.SEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class ClusterElement {
    private SEvent event;
    private List<Token> tokens = new ArrayList<Token>();

    public ClusterElement(SEvent event) {
        this.event = event;
    }

    public String getId() {
        if (this.event == null) {
            return "";
        }
        return this.event.getID();
    }

    public String getFullText() {
        return this.event.getText();
    }

    public List<Token> getTokens() {
        return this.tokens;
    }

    public void setTokens(List<Token> tokens) {
        this.tokens = tokens;
    }

    public SEvent getEvent() {
        return this.event;
    }

    public String getTokenText(Token token) {
        String result = null;
        if (token.getStartPosition() >= 0 && token.getEndPosition() <= this.getFullText().length()) {
            result = this.getFullText().substring(token.getStartPosition(), token.getEndPosition());
        }
        return result;
    }

    public String getFilteredText() {
        Iterator<Token> iterator = this.tokens.iterator();
        StringBuilder builder = new StringBuilder();
        while (iterator.hasNext()) {
            Token token = iterator.next();
            builder.append(this.getTokenText(token));
            if (!iterator.hasNext()) continue;
            builder.append(" ");
        }
        return builder.toString();
    }

    public String getFilteredTextSavingTokenPositions() {
        int lastPosition = 0;
        StringBuilder builder = new StringBuilder();
        for (Token token : this.tokens) {
            while (lastPosition < token.getStartPosition()) {
                builder.append(" ");
                ++lastPosition;
            }
            builder.append(this.getTokenText(token));
            lastPosition += token.getTokenStringLength();
        }
        return builder.toString();
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.event == null ? 0 : this.event.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ClusterElement other = (ClusterElement)obj;
        return !(this.event == null ? other.event != null : !this.event.equals(other.event));
    }
}

