/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.sim.cluster;

import com.blixx.boom.sim.cluster.Cluster;
import com.blixx.boom.sim.cluster.ClusterElement;
import com.blixx.boom.sim.cluster.ClusterIndex;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class ClusterFinder {
    public static final float DEFAULT_THRESHOLD = 0.8f;
    private Map<String, Cluster> elementToClusterMap;
    private ClusterIndex index;
    private String name;

    public ClusterFinder(String name, ClusterIndex index) {
        this.name = name;
        this.index = index;
        this.elementToClusterMap = new HashMap<String, Cluster>(1000);
    }

    public void findClusters(List<ClusterElement> elements) {
        this.findClusters(elements, 0.8f);
    }

    public void findClusters(List<ClusterElement> elements, float threshold) {
        for (ClusterElement element : elements) {
            this.findCluster(element, threshold);
        }
    }

    public Cluster findCluster(ClusterElement element, float threshold) {
        Cluster cluster = this.index.findCluster(element, threshold);
        if (cluster == null) {
            cluster = new Cluster();
            cluster.addElement(element);
            this.elementToClusterMap.put(element.getId(), cluster);
            this.index.index(cluster);
        } else {
            cluster.addElement(element);
            this.elementToClusterMap.put(element.getId(), cluster);
        }
        return cluster;
    }

    public List<Cluster> getClustersListCopy() {
        return this.index.getClusters();
    }

    public int getClustersCount() {
        return this.index.getClustersCount();
    }

    public void removeClusterElements(Collection<ClusterElement> elements) {
        HashSet<Cluster> clustersToUpdatePattern = new HashSet<Cluster>();
        HashSet<Cluster> clustersToIndex = new HashSet<Cluster>();
        for (ClusterElement element : elements) {
            Cluster cluster = this.elementToClusterMap.get(element.getId());
            if (cluster == null) continue;
            this.elementToClusterMap.remove(element.getId());
            if (cluster.size() == 1) {
                this.index.removeCluster(cluster);
                clustersToUpdatePattern.remove(cluster);
                clustersToIndex.remove(cluster);
                continue;
            }
            String patternElementId = cluster.getPatternElement().getId();
            if (patternElementId.equals(element.getId())) {
                this.index.removeCluster(cluster);
                cluster.removeElement(element);
                clustersToIndex.add(cluster);
            } else {
                cluster.removeElement(element);
            }
            clustersToUpdatePattern.add(cluster);
        }
        for (Cluster cluster : clustersToIndex) {
            this.index.index(cluster);
        }
        for (Cluster cluster : clustersToUpdatePattern) {
            cluster.computePattern();
        }
    }

    public void clear() {
        this.elementToClusterMap.clear();
    }

    public String getName() {
        return this.name;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ClusterFinder other = (ClusterFinder)obj;
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }
}

