/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.sim.cluster;

import com.blixx.boom.sim.cluster.ClusterElement;
import com.blixx.boom.sim.token.Token;
import java.util.ArrayList;
import java.util.List;

public class ClusterPatternFinder {
    private static String WILDCARD = ".*";

    public String findPattern(List<ClusterElement> elements) {
        if (elements.size() == 0) {
            return "";
        }
        ClusterElement pattern = elements.get(0);
        StringBuilder builder = new StringBuilder();
        if (pattern.getTokens().size() > 0) {
            ArrayList<Integer> lastStepTokenIndexes = new ArrayList<Integer>(elements.size());
            int i = 0;
            while (i < elements.size()) {
                lastStepTokenIndexes.add(-1);
                ++i;
            }
            boolean lastTokenAppended = true;
            int patternClusterElementTokensCount = elements.get(0).getTokens().size();
            int currentToken = 0;
            while (currentToken < patternClusterElementTokensCount) {
                ArrayList<Integer> nextStepTokenIndexes = new ArrayList<Integer>(elements.size());
                nextStepTokenIndexes.add(currentToken);
                Token token = elements.get(0).getTokens().get(currentToken);
                boolean appendWildcard = false;
                boolean appendToken = true;
                int i2 = 1;
                while (i2 < elements.size()) {
                    int currentTokenIndex = (Integer)lastStepTokenIndexes.get(i2);
                    int nextFound = this.findNext(elements.get(i2), token, currentTokenIndex);
                    if (nextFound == -1) {
                        appendToken = false;
                        appendWildcard = true;
                    }
                    if (nextFound - currentTokenIndex > 1) {
                        appendWildcard = true;
                    }
                    if (nextFound >= 0) {
                        nextStepTokenIndexes.add(nextFound);
                    } else {
                        nextStepTokenIndexes.add(currentTokenIndex);
                    }
                    ++i2;
                }
                if (appendWildcard && lastTokenAppended && currentToken > 0) {
                    this.appendIgnoringWildcard(builder, this.getCommonSeparatorAfter(lastStepTokenIndexes, elements));
                } else if (appendWildcard && lastTokenAppended && currentToken == 0) {
                    ArrayList<Integer> temp = new ArrayList<Integer>(elements.size());
                    int i3 = 0;
                    while (i3 < elements.size()) {
                        temp.add(0);
                        ++i3;
                    }
                    this.appendIgnoringWildcard(builder, this.getCommonSeparatorBefore(temp, elements));
                }
                if (appendWildcard) {
                    this.appendIgnoringWildcard(builder, WILDCARD);
                }
                if (appendToken) {
                    this.appendIgnoringWildcard(builder, this.getCommonSeparatorBefore(nextStepTokenIndexes, elements));
                    builder.append(elements.get(0).getTokenText(token));
                }
                lastTokenAppended = appendToken;
                lastStepTokenIndexes = nextStepTokenIndexes;
                ++currentToken;
            }
            this.appendIgnoringWildcard(builder, this.getCommonTail(elements));
        } else {
            ArrayList<String> temp = new ArrayList<String>(elements.size());
            for (ClusterElement currentElement : elements) {
                temp.add(currentElement.getFullText());
            }
            builder.append(this.getCommonString(temp));
        }
        return builder.toString().replace("\n", " ");
    }

    private int findNext(ClusterElement indication, Token token, int startingPosition) {
        int foundPosition = startingPosition + 1;
        int size = indication.getTokens().size();
        while (foundPosition < size - 1 && !indication.getTokens().get(foundPosition).equals(token)) {
            ++foundPosition;
        }
        if (foundPosition > size - 1) {
            foundPosition = -1;
        } else if (foundPosition == size - 1 && !indication.getTokens().get(foundPosition).equals(token)) {
            foundPosition = -1;
        }
        return foundPosition;
    }

    private void appendIgnoringWildcard(StringBuilder builder, String suffix) {
        if (suffix.startsWith(WILDCARD)) {
            if (builder.length() >= WILDCARD.length() && builder.substring(builder.length() - WILDCARD.length()).equals(WILDCARD)) {
                builder.append(suffix.substring(WILDCARD.length()));
            } else {
                builder.append(suffix);
            }
        } else {
            builder.append(suffix);
        }
    }

    private List<String> getSeparatorsBeforeToken(List<Integer> tokenIndexes, List<ClusterElement> elements) {
        ArrayList<String> result = new ArrayList<String>();
        int i = 0;
        while (i < elements.size()) {
            ClusterElement indication = elements.get(i);
            int tokenIndex = tokenIndexes.get(i);
            if (tokenIndex == 0) {
                Token second = indication.getTokens().get(tokenIndex);
                result.add(indication.getFullText().substring(0, second.getStartPosition()));
            } else if (tokenIndex > 0) {
                Token first = indication.getTokens().get(tokenIndex - 1);
                Token second = indication.getTokens().get(tokenIndex);
                result.add(indication.getFullText().substring(first.getEndPosition(), second.getStartPosition()));
            }
            ++i;
        }
        return result;
    }

    private List<String> getSeparatorsAfterToken(List<Integer> tokenIndexes, List<ClusterElement> elements) {
        ArrayList<String> result = new ArrayList<String>();
        int i = 0;
        while (i < elements.size()) {
            Token first;
            ClusterElement indication = elements.get(i);
            int tokenIndex = tokenIndexes.get(i);
            if (tokenIndex == indication.getTokens().size() - 1) {
                first = indication.getTokens().get(tokenIndex);
                result.add(indication.getFullText().substring(first.getEndPosition(), indication.getFullText().length()));
            } else if (tokenIndex < indication.getTokens().size() - 1) {
                first = indication.getTokens().get(tokenIndex);
                Token second = indication.getTokens().get(tokenIndex + 1);
                result.add(indication.getFullText().substring(first.getEndPosition(), second.getStartPosition()));
            }
            ++i;
        }
        return result;
    }

    private String getCommonTail(List<ClusterElement> elements) {
        String result = "";
        ArrayList<String> separators = new ArrayList<String>(elements.size());
        for (ClusterElement indication : elements) {
            if (indication.getTokens().size() <= 0) continue;
            separators.add(indication.getFullText().substring(indication.getTokens().get(indication.getTokens().size() - 1).getEndPosition()));
        }
        result = this.getCommonString(separators);
        return result;
    }

    private String getCommonSeparatorBefore(List<Integer> tokenIndexes, List<ClusterElement> elements) {
        String result = "";
        List<String> separators = this.getSeparatorsBeforeToken(tokenIndexes, elements);
        if (separators.size() == elements.size()) {
            result = this.getCommonString(separators);
        }
        return result;
    }

    private String getCommonSeparatorAfter(List<Integer> tokenIndexes, List<ClusterElement> elements) {
        String result = "";
        List<String> separators = this.getSeparatorsAfterToken(tokenIndexes, elements);
        if (separators.size() == elements.size()) {
            result = this.getCommonString(separators);
        }
        return result;
    }

    private String getCommonString(List<String> separators) {
        String commonSeparator = "";
        if (this.stringsAreEqual(separators)) {
            commonSeparator = separators.get(0);
        } else {
            StringBuilder builder = new StringBuilder();
            int characterProcessed = 0;
            int commonLength = this.getMinStringLength(separators);
            if (commonLength > 0) {
                String separator = separators.get(0);
                int currentPosition = -1;
                boolean charMatches = true;
                while (currentPosition < commonLength - 1 && charMatches) {
                    char currentChar = separator.charAt(++currentPosition);
                    int i = 0;
                    while (i < separators.size() && charMatches) {
                        charMatches = separators.get(i).charAt(currentPosition) == currentChar;
                        ++i;
                    }
                    if (!charMatches) continue;
                    builder.append(currentChar);
                    ++characterProcessed;
                }
            }
            builder.append(WILDCARD);
            if (commonLength > 0) {
                StringBuilder tailBuilder = new StringBuilder();
                String separator = separators.get(0);
                int currentPosition = -1;
                boolean charMatches = true;
                while (currentPosition < commonLength - 1 && charMatches && characterProcessed < commonLength) {
                    char currentChar = separator.charAt(separator.length() - 1 - ++currentPosition);
                    int i = 0;
                    while (i < separators.size() && charMatches) {
                        charMatches = separators.get(i).charAt(separators.get(i).length() - 1 - currentPosition) == currentChar;
                        ++i;
                    }
                    if (!charMatches) continue;
                    tailBuilder.append(currentChar);
                    ++characterProcessed;
                }
                builder.append((CharSequence)tailBuilder.reverse());
            }
            commonSeparator = builder.toString();
        }
        return commonSeparator;
    }

    private boolean stringsAreEqual(List<String> list) {
        boolean result = true;
        if (list.size() > 0) {
            String first = list.get(0);
            int i = 1;
            while (i < list.size()) {
                if (!list.get(i).equals(first)) {
                    result = false;
                    break;
                }
                ++i;
            }
        }
        return result;
    }

    private int getMinStringLength(List<String> list) {
        int min = 0;
        if (list.size() > 0) {
            min = list.get(0).length();
            int i = 1;
            while (i < list.size()) {
                int currentLength = list.get(i).length();
                if (currentLength < min) {
                    min = currentLength;
                }
                ++i;
            }
        }
        return min;
    }
}

