/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.sim.perf;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;

public class Stopwatch {
    private DateFormat formatter = new SimpleDateFormat("HH:mm:ss:SSS");
    private String blockName;
    private long duration = 0L;
    private long start;
    private int measurementsCount = 0;

    Stopwatch(String blockName) {
        this.blockName = blockName;
    }

    public void start() {
        ++this.measurementsCount;
        this.start = System.nanoTime();
    }

    public void startAndPrintMessage() {
        this.start();
        System.out.println(String.valueOf(this.formatter.format(new Date())) + " " + this.blockName + " started");
    }

    public void stopAndPrintMessage() {
        this.stop();
        System.out.println(String.valueOf(this.formatter.format(new Date())) + " " + this.blockName + " finished. It took " + this.getDuration() + "ms");
    }

    public void printDuration() {
        System.out.println(String.valueOf(this.blockName) + " took " + this.getDuration() + "ms");
    }

    public void stop() {
        long end = System.nanoTime();
        this.duration = this.duration + end - this.start;
    }

    public void stopAndPrintDuration() {
        this.stop();
        this.printDuration();
    }

    public String getBlockName() {
        return this.blockName;
    }

    public long getDuration() {
        return this.duration / 1000000L;
    }

    public int getMeasurementsCount() {
        return this.measurementsCount;
    }
}

