/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.sim.token;

import com.blixx.boom.sim.token.Token;
import com.blixx.boom.sim.token.Tokenizer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

public class AdvancedTokenizer
implements Tokenizer {
    private static final String TRAP_ID_MIB = ".1.3.6.1.6.3.1.1.4.1.0";
    private static final String TRAP_ID_VENDOR_PREFIX = ".1.3.6.1.4.1.";
    private Pattern simpleWords = Pattern.compile("^[\\p{Alpha}]+\\.?$");
    private Pattern identifier = Pattern.compile("^\\p{Alpha}+.*$");
    private Pattern decimalValue = Pattern.compile("^\\d+(\\.\\d+)?\\.?$");
    private Pattern ipV4Address = Pattern.compile("(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})");
    private Pattern mibNumIds = Pattern.compile("\\.?1\\.3\\.(\\d+\\.){4,}\\d*");
    private Pattern exceptions = Pattern.compile("\\w{3,5}\\.\\w+\\.[\\w\\.]+");
    private Pattern urls = Pattern.compile("/.*|[\\p{Lower}\\p{Upper}]:\\\\.*");
    private Pattern mibStringIds = Pattern.compile("^\\p{Alpha}+\\.\\d+$");
    private Set<String> ignoreTokens;
    private Map<String, Integer> tokenToIdMap = new ConcurrentHashMap<String, Integer>(10000);
    private int sequenceId = 0;

    public AdvancedTokenizer() {
        this.ignoreTokens = new HashSet<String>();
        this.addWeekDays(this.ignoreTokens);
        this.addMonths(this.ignoreTokens);
        this.addTimeTokens(this.ignoreTokens);
        this.addTimeZones(this.ignoreTokens);
        this.ignoreTokens.add(".1.3.6.1.2.1.1.3");
    }

    @Override
    public List<Token> getTokens(String text) {
        int position = 0;
        String[] tokens = StringUtils.splitPreserveAllTokens(text, "!\"#$%&'()*+, :;<=>?@[]^`\u00b4{|}~\t\n");
        ArrayList<Token> filteredTokens = new ArrayList<Token>(tokens.length);
        boolean trapIdMibFound = false;
        boolean ignoreMibs = false;
        String[] stringArray = tokens;
        int n = tokens.length;
        int n2 = 0;
        while (n2 < n) {
            String lowerCaseToken;
            String tokenString = stringArray[n2];
            if (tokenString.length() > 0 && !this.ignoreTokens.contains(lowerCaseToken = tokenString.toLowerCase())) {
                Token token;
                if (this.simpleWords.matcher(tokenString).matches()) {
                    token = new Token(this.getTokenId(tokenString), position, tokenString.length());
                    token.setTokenClassId(-1);
                    if (position > 0 && position + tokenString.length() < text.length()) {
                        char charBefore = text.charAt(position - 1);
                        char charAfter = text.charAt(position + tokenString.length());
                        if (!(charBefore != '\'' && charBefore != '\"' && charBefore != '\u00b4' && charBefore != '`' || charAfter != '\'' && charAfter != '\"' && charAfter != '\u00b4' && charAfter != '`')) {
                            token.setTokenClassId(-4);
                        }
                    }
                    filteredTokens.add(token);
                } else if (this.ipV4Address.matcher(tokenString).matches()) {
                    token = new Token(this.getTokenId(tokenString), position, tokenString.length());
                    token.setTokenClassId(-2);
                    filteredTokens.add(token);
                } else if (this.mibNumIds.matcher(tokenString).matches()) {
                    if (!trapIdMibFound && tokenString.equals(TRAP_ID_MIB)) {
                        trapIdMibFound = true;
                    } else if (!ignoreMibs && trapIdMibFound && tokenString.startsWith(TRAP_ID_VENDOR_PREFIX)) {
                        ignoreMibs = true;
                        token = new Token(this.getTokenId(tokenString), position, tokenString.length());
                        token.setTokenClassId(-3);
                        filteredTokens.add(token);
                    } else if (!ignoreMibs) {
                        token = new Token(this.getTokenId(tokenString), position, tokenString.length());
                        token.setTokenClassId(-3);
                        filteredTokens.add(token);
                    }
                } else if (this.exceptions.matcher(tokenString).matches()) {
                    filteredTokens.add(new Token(this.getTokenId(tokenString), position, tokenString.length()));
                } else if (this.urls.matcher(tokenString).matches()) {
                    token = new Token(this.getTokenId(tokenString), position, tokenString.length());
                    token.setTokenClassId(-5);
                    filteredTokens.add(token);
                } else if (this.mibStringIds.matcher(tokenString).matches()) {
                    String filteredToken = tokenString.replaceAll("\\..*", "");
                    filteredTokens.add(new Token(this.getTokenId(filteredToken), position, filteredToken.length()));
                } else if (this.identifier.matcher(tokenString).matches()) {
                    token = new Token(this.getTokenId(tokenString), position, tokenString.length());
                    token.setTokenClassId(-4);
                    filteredTokens.add(token);
                }
            }
            position = position + 1 + tokenString.length();
            ++n2;
        }
        if (filteredTokens.size() == 0) {
            filteredTokens.add(new Token(this.getTokenId(text), 0, text.length()));
        }
        return filteredTokens;
    }

    private Integer getTokenId(String token) {
        Integer result = this.tokenToIdMap.get(token);
        if (result == null) {
            result = ++this.sequenceId;
            this.tokenToIdMap.put(token, result);
        }
        return result;
    }

    public static void main(String[] args) {
        String text = "aasdf /root/blubb c:\\temp\\ahu";
        AdvancedTokenizer tokenizer = new AdvancedTokenizer();
        List<Token> tokens = tokenizer.getTokens(text);
        System.out.println("TokensCount: " + tokens.size());
        System.out.println("TokensToMatch: " + Math.round((float)(tokens.size() - 1) * 0.8f));
        for (Token token : tokens) {
            System.out.print(String.valueOf(token.getTokenId()) + " ");
        }
    }

    private void addWeekDays(Set<String> tokens) {
        tokens.add("mon");
        tokens.add("mo");
        tokens.add("tue");
        tokens.add("tu");
        tokens.add("wed");
        tokens.add("we");
        tokens.add("thu");
        tokens.add("th");
        tokens.add("fri");
        tokens.add("fr");
        tokens.add("sat");
        tokens.add("sa");
        tokens.add("sun");
    }

    private void addMonths(Set<String> tokens) {
        tokens.add("jan");
        tokens.add("feb");
        tokens.add("mar");
        tokens.add("apr");
        tokens.add("may");
        tokens.add("june");
        tokens.add("jun");
        tokens.add("july");
        tokens.add("jul");
        tokens.add("aug");
        tokens.add("sept");
        tokens.add("sep");
        tokens.add("oct");
        tokens.add("nov");
        tokens.add("dec");
    }

    private void addTimeTokens(Set<String> tokens) {
        tokens.add("h");
        tokens.add("m");
        tokens.add("min");
        tokens.add("s");
        tokens.add("sec");
        tokens.add("d");
    }

    private void addTimeZones(Set<String> tokens) {
        tokens.add("acdt");
        tokens.add("acst");
        tokens.add("act");
        tokens.add("adt");
        tokens.add("aedt");
        tokens.add("aest");
        tokens.add("aft");
        tokens.add("akdt");
        tokens.add("akst");
        tokens.add("amst");
        tokens.add("amt");
        tokens.add("art");
        tokens.add("ast");
        tokens.add("awdt");
        tokens.add("awst");
        tokens.add("azost");
        tokens.add("azt");
        tokens.add("bdt");
        tokens.add("biot");
        tokens.add("bit");
        tokens.add("bot");
        tokens.add("brst");
        tokens.add("brt");
        tokens.add("bst");
        tokens.add("btt");
        tokens.add("cat");
        tokens.add("cct");
        tokens.add("cdt");
        tokens.add("cedt");
        tokens.add("cest");
        tokens.add("cet");
        tokens.add("chadt");
        tokens.add("chast");
        tokens.add("chot");
        tokens.add("chst");
        tokens.add("chut");
        tokens.add("cist");
        tokens.add("cit");
        tokens.add("ckt");
        tokens.add("clst");
        tokens.add("clt");
        tokens.add("cost");
        tokens.add("cot");
        tokens.add("cst");
        tokens.add("ct");
        tokens.add("cvt");
        tokens.add("cwst");
        tokens.add("cxt");
        tokens.add("davt");
        tokens.add("ddut");
        tokens.add("dft");
        tokens.add("easst");
        tokens.add("east");
        tokens.add("eat");
        tokens.add("ect");
        tokens.add("edt");
        tokens.add("eedt");
        tokens.add("eest");
        tokens.add("eet");
        tokens.add("egst");
        tokens.add("egt");
        tokens.add("eit");
        tokens.add("est");
        tokens.add("fet");
        tokens.add("fjt");
        tokens.add("fkst");
        tokens.add("fkt");
        tokens.add("fnt");
        tokens.add("galt");
        tokens.add("gamt");
        tokens.add("gft");
        tokens.add("gilt");
        tokens.add("gmt");
        tokens.add("gst");
        tokens.add("gyt");
        tokens.add("hadt");
        tokens.add("haec");
        tokens.add("hast");
        tokens.add("hkt");
        tokens.add("hmt");
        tokens.add("hovt");
        tokens.add("hst");
        tokens.add("ibst");
        tokens.add("ict");
        tokens.add("idt");
        tokens.add("iot");
        tokens.add("irdt");
        tokens.add("irkt");
        tokens.add("irst");
        tokens.add("jst");
        tokens.add("kgt");
        tokens.add("kost");
        tokens.add("krat");
        tokens.add("kst");
        tokens.add("lhst");
        tokens.add("lint");
        tokens.add("magt");
        tokens.add("mart");
        tokens.add("mawt");
        tokens.add("mdt");
        tokens.add("met");
        tokens.add("mest");
        tokens.add("mht");
        tokens.add("mist");
        tokens.add("mit");
        tokens.add("mmt");
        tokens.add("msk");
        tokens.add("mst");
        tokens.add("mut");
        tokens.add("mvt");
        tokens.add("myt");
        tokens.add("nct");
        tokens.add("ndt");
        tokens.add("nft");
        tokens.add("npt");
        tokens.add("nst");
        tokens.add("nt");
        tokens.add("nut");
        tokens.add("nzdt");
        tokens.add("nzst");
        tokens.add("omst");
        tokens.add("orat");
        tokens.add("pdt");
        tokens.add("pet");
        tokens.add("pett");
        tokens.add("pgt");
        tokens.add("phot");
        tokens.add("pkt");
        tokens.add("pmdt");
        tokens.add("pmst");
        tokens.add("pont");
        tokens.add("pst");
        tokens.add("pyst");
        tokens.add("pyt");
        tokens.add("ret");
        tokens.add("rott");
        tokens.add("sakt");
        tokens.add("samt");
        tokens.add("sast");
        tokens.add("sbt");
        tokens.add("sct");
        tokens.add("sgt");
        tokens.add("slst");
        tokens.add("sret");
        tokens.add("srt");
        tokens.add("sst");
        tokens.add("syot");
        tokens.add("taht");
        tokens.add("tha");
        tokens.add("tjt");
        tokens.add("tkt");
        tokens.add("tlt");
        tokens.add("tmt");
        tokens.add("tot");
        tokens.add("tvt");
        tokens.add("uct");
        tokens.add("ulat");
        tokens.add("usz1");
        tokens.add("utc");
        tokens.add("uyst");
        tokens.add("uyt");
        tokens.add("uzt");
        tokens.add("vet");
        tokens.add("vlat");
        tokens.add("volt");
        tokens.add("vost");
        tokens.add("vut");
        tokens.add("wakt");
        tokens.add("wast");
        tokens.add("wat");
        tokens.add("wedt");
        tokens.add("west");
        tokens.add("wet");
        tokens.add("wit");
        tokens.add("wst");
        tokens.add("yakt");
        tokens.add("yekt");
        tokens.add("z");
    }
}

