/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.sim.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Histogram<T> {
    private Map<T, Integer> histogram;

    public Histogram() {
        this.histogram = new HashMap<T, Integer>();
    }

    public Histogram(int size) {
        this.histogram = new HashMap<T, Integer>(size);
    }

    public void add(Collection<T> entries) {
        if (entries != null) {
            for (T entry : entries) {
                if (this.histogram.containsKey(entry)) {
                    this.histogram.put(entry, this.histogram.get(entry) + 1);
                    continue;
                }
                this.histogram.put(entry, 1);
            }
        }
    }

    public void add(T entry) {
        if (entry != null) {
            Integer count = this.histogram.get(entry);
            if (count == null) {
                this.histogram.put(entry, 1);
            } else {
                this.histogram.put(entry, count + 1);
            }
        }
    }

    public Map<T, Integer> getHistogram() {
        return this.histogram;
    }

    public List<Map.Entry<T, Integer>> getTopEntries() {
        ArrayList<Map.Entry<T, Integer>> topEntries = new ArrayList<Map.Entry<T, Integer>>();
        int maxHits = 0;
        for (Map.Entry<T, Integer> entry : this.histogram.entrySet()) {
            if (maxHits >= entry.getValue()) continue;
            maxHits = entry.getValue();
        }
        for (Map.Entry<T, Integer> entry : this.histogram.entrySet()) {
            if (entry.getValue() != maxHits) continue;
            topEntries.add(entry);
        }
        return topEntries;
    }

    public Set<T> keySet() {
        return this.histogram.keySet();
    }

    public Integer getCount(T key) {
        return this.histogram.get(key);
    }

    public int size() {
        return this.histogram.size();
    }

    public boolean contentEquals(Histogram<T> other) {
        boolean result = true;
        if (this.size() == other.size()) {
            for (T currentKey : this.histogram.keySet()) {
                Integer thisResult = this.getCount(currentKey);
                Integer otherResult = other.getCount(currentKey);
                if (otherResult != null && otherResult.equals(thisResult)) continue;
                result = false;
            }
        } else {
            result = false;
        }
        return result;
    }
}

