/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.snmp;

import com.blixx.boom.engine.BMUI;
import com.blixx.boom.engine.Repository;
import com.blixx.boom.engine.ServerClient;
import com.blixx.boom.engine.UIJob;
import com.blixx.boom.engine.UIJobManager;
import com.blixx.boom.gui.Activator;
import com.blixx.boom.gui.dialogs.IRefreshable;
import com.blixx.boom.gui.dialogs.MIBSelectionDialog;
import com.blixx.boom.gui.dialogs.ShowMessageBox;
import com.blixx.boom.gui.dialogs.ShowMessageDialog;
import com.blixx.boom.gui.policies.PolicyManager;
import com.blixx.boom.gui.policies.PolicyTreeProvider;
import com.blixx.boom.gui.policies.ViewContentProvider;
import com.blixx.boom.gui.utils.FilterComposite;
import com.blixx.boom.gui.utils.GUIDisplayElements;
import com.blixx.boom.gui.utils.MIBBrowserTreeFilterAbstract;
import com.blixx.boom.gui.utils.MIBBrowserTreeFilterName;
import com.blixx.boom.gui.utils.MIBBrowserTreeFilterType;
import com.blixx.boom.gui.utils.STreeViewer;
import com.blixx.boom.gui.utils.TreeElementComparer;
import com.blixx.boom.gui.views.MonprogTableProvider;
import com.blixx.boom.gui.views.PolicyView;
import com.blixx.boom.gui.views.actions.ExpandCollapseAction;
import com.blixx.boom.gui.views.dnd.DNDCopyMsgConditionAction;
import com.blixx.boom.gui.views.dnd.DNDShare;
import com.blixx.boom.snmp.MIBLabelProvider;
import com.blixx.boom.snmp.MIBTreeFilter;
import com.blixx.boom.snmp.MibReader;
import com.blixx.boom.snmp.MibTreeObject;
import com.blixx.boom.snmp.SNMPTableProvider;
import com.blixx.boom.snmp.SNMPWalkGuiAction;
import com.blixx.shared.Condition;
import com.blixx.shared.Cryptor;
import com.blixx.shared.Policy;
import com.blixx.shared.utils.FileUtils;
import com.blixx.shared.utils.GroupTreeObject;
import com.blixx.shared.utils.GroupTreeObjectUnsubmitted;
import com.blixx.shared.utils.TreeObject;
import com.blixx.shared.utils.ZIP;
import java.io.File;
import java.io.FileReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import net.percederberg.mibble.Mib;
import net.percederberg.mibble.MibContext;
import net.percederberg.mibble.MibLoader;
import net.percederberg.mibble.MibLoaderException;
import net.percederberg.mibble.MibLoaderLog;
import net.percederberg.mibble.MibSymbol;
import net.percederberg.mibble.MibValueSymbol;
import net.percederberg.mibble.snmp.SnmpTrapType;
import net.percederberg.mibble.value.ObjectIdentifierValue;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IElementComparer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.snmp4j.smi.VariableBinding;

public class MIBBrowser
implements ISelectionChangedListener,
SelectionListener,
ModifyListener,
ShellListener,
IRefreshable,
IDoubleClickListener {
    private static final String BUTTON_SYNC_MIBS = "BUTTON_SYNC_MIBS";
    public static final String BUTTON_LOAD_MIBS = "BUTTON_LOAD_MIBS";
    private static final String SNMP_CREATE_POLICY = "SNMP_CREATE_POLICY";
    private static final String BUTTON_UNLOADALL = "BUTTON_UNLOADALL";
    private static final String SNMP_RETRY = "SNMP_RETRY";
    private static final String SNMP_TIMEOUT = "SNMP_TIMEOUT";
    private static final String BUTTON_LOAD_DIR = "BUTTON_LOAD_DIR";
    private static final String SNMP_PASSTYPE = "SNMP_PASSTYPE";
    private static final String SNMP_AUTHTYPE = "SNMP_AUTHTYPE";
    private static final String SNMP_USER = "SNMP_USER";
    private static final String SNMP_PORT = "SNMP_PORT";
    private static final String SNMP_START = "SNMP_START";
    private static final String SNMP_ENCR = "SNMP_ENCR";
    private static final String SNMP_PASS = "SNMP_PASS";
    private static final String SNMP_COMMUNITY = "SNMP_COMMUNITY";
    private static final String SNMP_VERSION = "SNMP_VER";
    private static final String SNMP_OID = "SNMP_OID";
    private static final String SNMP_HOST = "SNMP_HOST";
    private static final String BUTTON_SEARCH = "SEARCH_BUTTON";
    private static final String TEXT_SEARCH = "SEARCH";
    private static final String BUTTON_LOAD_MIB = "LoadMib";
    private static String m_lastDirSelected = null;
    public static GroupTreeObject m_root = new GroupTreeObject(new TreeObject("root", "", null));
    private TreeViewer m_treeViewer = null;
    private Composite m_topLeftComp = null;
    private Composite m_filterComp = null;
    private Group m_filterByTypeGrp = null;
    private Composite m_treeComp = null;
    private Composite m_topRightComp = null;
    private GUIDisplayElements m_gui = null;
    private Text m_text = null;
    static MibLoader m_mibLoader = new MibLoader();
    private Set<String> m_selectedMIBs = new TreeSet<String>();
    public static Image m_folder = BMUI.IMAGE_DESCR_UPLOAD_FILE.createImage();
    public static Image m_folder_x = BMUI.IMAGE_HS_O;
    public static Image m_el = BMUI.IMAGE_HS_B;
    public static Image m_el_wo = BMUI.IMAGE_HS_B_WO;
    public static Image m_el_x = BMUI.IMAGE_HS_B_X;
    public static Image m_elTrap = BMUI.IMAGE_HS_Y;
    public static Image m_elNotification = BMUI.IMAGE_HS_G;
    private Text m_search;
    private Text m_host_field;
    private Text m_OID_field;
    private Text m_community_field;
    private Text m_privPassword_field;
    private Text m_authPassword_field;
    private TableViewer m_TableViewer;
    private SNMPTableProvider m_tableProvider;
    private Table m_table;
    private ProgressBar m_progressBar;
    private Button m_walk_btn;
    private Text m_log_field;
    private SNMPWalkGuiAction m_lastWalk = null;
    private Text m_user_field;
    private Text m_port_field;
    private Shell m_shell;
    private ProgressBar m_progressBarLoad;
    private CCombo m_version_field;
    private CCombo m_authType_field;
    private CCombo m_privateType_field;
    private Text m_timeout_field;
    private Text m_retry_field;
    private Button m_createPolicy_btn = null;
    private boolean m_showAll = true;
    private boolean m_showNotifOnly = false;
    private boolean m_showTrapsOnly = false;
    public static String DISPLAY_ALL = "TYPE_ALL";
    public static String FILTER_BY_NAME = " FILTER_BY_NAME";
    public static String FILTER_BY_TYPE = "FILTER_BY_TYPE";
    public static String FILTER_BY_MIB = "FILTER_BY_MIB";
    public Map<String, ViewerFilter> m_treeFilters = new HashMap<String, ViewerFilter>();
    public static String[] m_snmp_versions = new String[]{"1", "2c", "3"};
    public static String[] m_auth_types = new String[]{"", "MD5", "SHA", "HMAC192SHA256", "HMAC384SHA512"};
    public static String[] m_priv_types = new String[]{"", "DES", "3DES", "AES", "AES128", "AES192", "AES256", "AES192p", "AES256p"};

    public MIBBrowser() {
        this.m_gui = new GUIDisplayElements();
        this.createDialog();
    }

    public void createDialog() {
        this.m_shell = new Shell(Display.getCurrent(), 1265);
        this.m_shell.setLayout((Layout)new FillLayout());
        this.m_shell.setText(" MIB Browser");
        this.m_shell.setImage(m_folder);
        this.m_shell.setSize(900, 650);
        this.m_shell.addShellListener((ShellListener)this);
        this.m_gui.openShellInActiveMonitor(this.m_shell);
        this.createContents((Composite)this.m_shell);
    }

    protected Control createContents(Composite parent) {
        SashForm sash_main_vertical = new SashForm(parent, 512);
        SashForm sash_main_horizonal = new SashForm((Composite)sash_main_vertical, 2304);
        this.createTree((Composite)sash_main_horizonal);
        this.createLiveAction((Composite)sash_main_horizonal);
        this.createButtons((Composite)sash_main_vertical);
        sash_main_vertical.setWeights(new int[]{84, 16});
        sash_main_horizonal.setWeights(new int[]{40, 60});
        this.loadStart(false);
        return parent;
    }

    public void loadStart(boolean force) {
        if (!force && m_mibLoader.getAllMibs().length > 0) {
            return;
        }
        m_root.clean();
        this.m_shell.setEnabled(false);
        Job uijob = new Job("LoadMIBS"){

            public IStatus run(IProgressMonitor monitor) {
                File dirIANA = new File(String.valueOf(Repository.getUserDirectory()) + "/mibs/iana");
                if (dirIANA.exists() && dirIANA.isDirectory()) {
                    m_mibLoader.addDir(dirIANA);
                }
                MIBBrowser.this.parseDirectory(String.valueOf(Repository.getUserDirectory()) + "/mibs");
                return Status.OK_STATUS;
            }
        };
        uijob.schedule();
    }

    public void createButtons(Composite parent) {
        Composite comp = new Composite(parent, 0);
        comp.setLayout((Layout)new GridLayout(5, false));
        this.m_gui.addButton(comp, BUTTON_LOAD_MIB, " Load MIB File(s)", true, this);
        this.m_gui.addButton(comp, BUTTON_LOAD_DIR, " Load MIB Directory ", true, this);
        this.m_gui.addButton(comp, BUTTON_UNLOADALL, " Unload All ", true, this);
        this.m_search = new Text(comp, 2048);
        GridData gd = new GridData();
        gd.widthHint = 180;
        gd.horizontalIndent = 50;
        this.m_search.setLayoutData((Object)gd);
        this.m_search.setData((Object)TEXT_SEARCH);
        this.m_gui.addButton(comp, BUTTON_SEARCH, " Search OID ", true, this);
        Composite comp2 = new Composite(comp, 0);
        GridData gd2 = new GridData();
        gd2.horizontalSpan = 5;
        gd2.horizontalIndent = -5;
        comp2.setLayoutData((Object)gd2);
        comp2.setLayout((Layout)new GridLayout(2, false));
        this.m_gui.addButton(comp2, BUTTON_LOAD_MIBS, " Load MIBs from server", true, this);
        this.m_gui.addButton(comp2, BUTTON_SYNC_MIBS, " Unload All / Clean / Load MIBs from server", true, this);
        this.m_progressBarLoad = new ProgressBar(comp, 256);
        this.m_progressBarLoad.setVisible(false);
        GridData ldp = new GridData(4, 1024, true, false);
        ldp.heightHint = 15;
        ldp.horizontalSpan = 5;
        this.m_progressBarLoad.setLayoutData((Object)ldp);
    }

    public void createTree(Composite parent) {
        SashForm sashLeft_vertical = new SashForm(parent, 2560);
        this.m_topLeftComp = new Composite((Composite)sashLeft_vertical, 0);
        this.m_topLeftComp.setBackground(BMUI.color_critical);
        GridLayout gl = new GridLayout(1, false);
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        gl.horizontalSpacing = 0;
        gl.verticalSpacing = 0;
        this.m_topLeftComp.setLayout((Layout)gl);
        this.m_filterComp = new Composite(this.m_topLeftComp, 0);
        gl = new GridLayout(1, false);
        gl.marginBottom = 3;
        gl.marginHeight = 3;
        gl.marginWidth = 3;
        this.m_filterComp.setLayout((Layout)gl);
        this.m_filterComp.setLayoutData((Object)new GridData(4, 4, true, false));
        this.m_filterByTypeGrp = new Group(this.m_filterComp, 4);
        this.m_filterByTypeGrp.setText("Filter by Type");
        gl = new GridLayout(3, false);
        gl.marginHeight = 3;
        this.m_filterByTypeGrp.setLayout((Layout)gl);
        this.m_filterByTypeGrp.setLayoutData((Object)new GridData(4, 128, true, false));
        this.m_gui.addRadioButton((Composite)this.m_filterByTypeGrp, DISPLAY_ALL, "Display all", true, 1, 1, 1, 0, this);
        this.m_gui.addRadioButton((Composite)this.m_filterByTypeGrp, "NOTIFICATION-TYPE", "Notification only", false, 1, 1, 1, 0, this);
        this.m_gui.addRadioButton((Composite)this.m_filterByTypeGrp, "TRAP-TYPE", "Traps only", false, 1, 1, 1, 0, this);
        new FilterComposite(this.m_filterComp, this);
        this.m_treeComp = new Composite(this.m_topLeftComp, 0);
        gl = new GridLayout(1, false);
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        gl.verticalSpacing = 0;
        gl.horizontalSpacing = 0;
        this.m_treeComp.setLayout((Layout)gl);
        this.m_treeComp.setLayoutData((Object)new GridData(4, 4, true, true));
        this.m_treeViewer = new STreeViewer(this.m_treeComp, 268438274);
        this.m_treeViewer.getTree().setLayoutData((Object)new GridData(4, 4, true, true));
        this.m_treeViewer.setUseHashlookup(true);
        this.m_treeViewer.setData("MIBBrowser", (Object)"true");
        this.m_treeViewer.setComparer((IElementComparer)new TreeElementComparer());
        this.m_treeViewer.setContentProvider((IContentProvider)new ViewContentProvider());
        this.m_treeViewer.setLabelProvider((IBaseLabelProvider)new MIBLabelProvider(null));
        this.m_treeViewer.setInput((Object)m_root);
        this.m_treeViewer.setAutoExpandLevel(6);
        this.m_treeViewer.expandToLevel(6);
        this.m_treeViewer.addSelectionChangedListener((ISelectionChangedListener)this);
        this.createContentMenuTree();
        this.m_text = new Text((Composite)sashLeft_vertical, 768);
        sashLeft_vertical.setWeights(new int[]{75, 25});
    }

    public void createContentMenuTree() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(false);
        Menu menu = menuMgr.createContextMenu(this.m_treeViewer.getControl());
        this.m_treeViewer.getControl().setMenu(menu);
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                try {
                    IStructuredSelection ssel = (IStructuredSelection)MIBBrowser.this.m_treeViewer.getSelection();
                    if (ssel != null && !ssel.isEmpty()) {
                        Clipboard m_clipboard = new Clipboard(PolicyView.getInstance().getViewSite().getShell().getDisplay());
                        manager.add((IAction)new DNDCopyMsgConditionAction(DNDShare.DND_COPY_MSG_CONDITION, (StructuredViewer)MIBBrowser.this.m_treeViewer, false, m_clipboard));
                        manager.add((IAction)new DNDCopyMsgConditionAction(DNDShare.DND_COPY_MSG_CONDITION, (StructuredViewer)MIBBrowser.this.m_treeViewer, true, m_clipboard));
                        m_clipboard.dispose();
                        manager.add((IAction)new CopyOIDToTheClipboardAction(MIBBrowser.this.m_treeViewer));
                        manager.add((IContributionItem)new Separator());
                        manager.add((IAction)new ShowLoadedMIBsAction(m_mibLoader));
                        manager.add((IAction)new SelectMIBsToDisplayAction(m_mibLoader));
                        manager.add((IContributionItem)new Separator());
                        manager.add((IAction)new ExpandCollapseAction(MIBBrowser.this.m_treeViewer, "ExpandSubTree"));
                        manager.add((IAction)new ExpandCollapseAction(MIBBrowser.this.m_treeViewer, "CollagpseSubTree"));
                    }
                }
                catch (RuntimeException runtimeException) {}
            }
        });
    }

    public void createLiveAction(Composite parent) {
        SashForm m_sashRight_vertical = new SashForm(parent, 2560);
        this.m_topRightComp = new Composite((Composite)m_sashRight_vertical, 0);
        GridLayout gl = new GridLayout(2, false);
        gl.horizontalSpacing = 10;
        this.m_topRightComp.setLayout((Layout)gl);
        this.m_topRightComp.setLayoutData((Object)new GridData(4, 4, true, false));
        Composite compLeft = new Composite(this.m_topRightComp, 0);
        gl = new GridLayout(2, false);
        gl.marginHeight = 0;
        compLeft.setLayout((Layout)gl);
        compLeft.setLayoutData((Object)new GridData(4, 4, true, false));
        this.m_host_field = this.m_gui.addInputFieldSingle(compLeft, SNMP_HOST, "Host: ", "localhost", 1, 1, 0, 0, 60, this);
        this.m_OID_field = this.m_gui.addInputFieldSingle(compLeft, SNMP_OID, "OID: ", "1.3.6", 1, 1, 0, 0, 60, this);
        this.m_community_field = this.m_gui.addInputFieldSingle(compLeft, SNMP_COMMUNITY, "Community: ", "public", 1, 1, 0, 0, 60, this);
        this.m_retry_field = this.m_gui.addInputFieldSingle(compLeft, SNMP_RETRY, "Retry: ", "2", 1, 1, 0, 0, 60, this);
        this.m_authType_field = this.m_gui.addDropDown(compLeft, SNMP_AUTHTYPE, "Auth Type: ", m_auth_types, m_auth_types[0], null, 1, 1, 0, 0, this);
        this.m_privateType_field = this.m_gui.addDropDown(compLeft, SNMP_PASSTYPE, "Priv Type: ", m_priv_types, m_priv_types[0], null, 1, 1, 0, 0, this);
        Composite compRight = new Composite(this.m_topRightComp, 0);
        gl = new GridLayout(2, false);
        gl.marginHeight = 0;
        compRight.setLayout((Layout)gl);
        compRight.setLayoutData((Object)new GridData(4, 4, true, false));
        this.m_port_field = this.m_gui.addInputFieldSingle(compRight, SNMP_PORT, "Port: ", "161", 1, 1, 0, 0, 60, this);
        this.m_version_field = this.m_gui.addDropDown(compRight, SNMP_VERSION, "SNMP Version:", m_snmp_versions, m_snmp_versions[0], null, 1, 1, 0, 0, this);
        this.m_timeout_field = this.m_gui.addInputFieldSingle(compRight, SNMP_TIMEOUT, "Timeout (sec): ", "2", 1, 1, 0, 0, 60, this);
        this.m_user_field = this.m_gui.addInputFieldSingle(compRight, SNMP_USER, "User: ", "", 1, 1, 0, 0, 60, this);
        this.m_user_field.setBackground(BMUI.color_critical);
        this.m_authPassword_field = this.m_gui.addInputFieldSingle(compRight, SNMP_ENCR, "Auth Password: ", "", 1, 1, 0, 0, 60, this);
        this.m_authPassword_field.setEchoChar('*');
        this.m_privPassword_field = this.m_gui.addInputFieldSingle(compRight, SNMP_PASS, "Priv Password: ", "", 1, 1, 0, 0, 60, this);
        this.m_privPassword_field.setEchoChar('*');
        this.m_gui.enableField(this.m_authType_field, false);
        this.m_gui.enableField(this.m_authPassword_field, false);
        this.m_gui.enableField(this.m_privPassword_field, false);
        this.m_gui.enableField(this.m_privateType_field, false);
        this.m_gui.enableField(this.m_user_field, false);
        Composite compBtn = new Composite(this.m_topRightComp, 0);
        compBtn.setLayout((Layout)new GridLayout(2, false));
        compBtn.setLayoutData((Object)new GridData(16384, 4, false, false, 2, 1));
        this.m_walk_btn = this.m_gui.addButton(compBtn, SNMP_START, " Walk ", true, this);
        this.m_createPolicy_btn = this.m_gui.addButton(compBtn, SNMP_CREATE_POLICY, " Create Walk Policy ", true, this);
        if (Repository.getInstance().getRights(1001) < 3) {
            this.m_createPolicy_btn.setEnabled(false);
        }
        this.m_progressBar = new ProgressBar(this.m_topRightComp, 258);
        this.m_progressBar.setVisible(false);
        GridData gd = new GridData(4, 1024, true, false);
        gd.heightHint = 15;
        gd.horizontalSpan = 3;
        this.m_progressBar.setLayoutData((Object)gd);
        Composite compTable = new Composite(this.m_topRightComp, 0);
        gl = new GridLayout(1, false);
        gl.verticalSpacing = 0;
        gl.horizontalSpacing = 0;
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        compTable.setLayout((Layout)gl);
        compTable.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        this.m_table = new Table(compTable, 268503810);
        this.m_table.setHeaderVisible(true);
        this.m_table.setLinesVisible(true);
        gd = new GridData(4, 4, true, true);
        gd.heightHint = 450;
        this.m_table.setLayoutData((Object)gd);
        this.m_TableViewer = new TableViewer(this.m_table);
        TableColumn col1 = new TableColumn(this.m_table, 0);
        col1.setWidth(220);
        col1.setText("Variable");
        TableColumn col2 = new TableColumn(this.m_table, 0);
        col2.setWidth(140);
        col2.setText("OID");
        TableColumn col3 = new TableColumn(this.m_table, 0);
        col3.setWidth(100);
        col3.setText("Value");
        TableColumn col4 = new TableColumn(this.m_table, 0);
        col4.setWidth(100);
        col4.setText("Full Path");
        this.m_gui.maximizeTableColumn(compTable, this.m_table, this.m_table.getColumnCount() - 1);
        this.m_tableProvider = new SNMPTableProvider(this);
        this.m_TableViewer.setContentProvider((IContentProvider)this.m_tableProvider);
        this.m_TableViewer.setLabelProvider((IBaseLabelProvider)this.m_tableProvider);
        this.m_TableViewer.addDoubleClickListener((IDoubleClickListener)this);
        this.createContentMenuTable();
        this.m_log_field = new Text((Composite)m_sashRight_vertical, 768);
        m_sashRight_vertical.setWeights(new int[]{75, 25});
    }

    public void createContentMenuTable() {
        Menu menu = new Menu((Decorations)this.m_TableViewer.getTable().getShell(), 8);
        this.m_TableViewer.getControl().setMenu(menu);
        MenuItem mi = new MenuItem(menu, 8);
        mi.setText("Copy OID");
        mi.setAccelerator(262211);
        mi.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                StructuredSelection sel = (StructuredSelection)MIBBrowser.this.m_TableViewer.getSelection();
                Object obj = sel.getFirstElement();
                if (obj instanceof VariableBinding) {
                    VariableBinding vb = (VariableBinding)obj;
                    String oid = vb.getOid().toString();
                    Clipboard clipboard = new Clipboard(Display.getCurrent());
                    TextTransfer textTransfer = TextTransfer.getInstance();
                    clipboard.setContents(new Object[]{oid}, new Transfer[]{textTransfer});
                    clipboard.dispose();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        MenuItem mi2 = new MenuItem(menu, 8);
        mi2.setText("Search in the tree");
        mi2.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                StructuredSelection sel = (StructuredSelection)MIBBrowser.this.m_TableViewer.getSelection();
                Object obj = sel.getFirstElement();
                if (obj instanceof VariableBinding) {
                    VariableBinding vb = (VariableBinding)obj;
                    String oid = vb.getOid().toString();
                    while (MIBBrowser.this.searchInTree(oid) == null || oid.indexOf(46) == -1) {
                        oid = oid.substring(0, oid.lastIndexOf(46));
                    }
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    private GroupTreeObject processMib(Mib mib) {
        GroupTreeObject first = null;
        for (MibSymbol symbol : mib.getAllSymbols()) {
            if (!(symbol instanceof MibValueSymbol)) continue;
            GroupTreeObject ff = MIBBrowser.addNode((MibValueSymbol)symbol, m_root);
            if (first != null) continue;
            first = ff;
        }
        this.m_selectedMIBs.add(mib.getName());
        return first;
    }

    /*
     * Unable to fully structure code
     */
    public static GroupTreeObject addNode(MibValueSymbol oid, GroupTreeObject root) {
        block20: {
            created = null;
            pathP = oid.toString();
            if (oid.getParent() != null) {
                oidStrP = oid.getParent().toString();
                pathP = "/root/" + (oidStrP = oidStrP.substring(oidStrP.indexOf("::=") + 3)).trim().replace('.', '/');
                created = root.searchPath(pathP, BMUI.type_folder);
                if (created == null) {
                    created = root.searchPath(pathP);
                }
                if (created == null) {
                    created = MIBBrowser.addNode(oid.getParent(), root);
                }
            } else if (oid.getValue() instanceof ObjectIdentifierValue) {
                oi = (ObjectIdentifierValue)oid.getValue();
                if (oi.getParent() != null) {
                    oidStrP = oi.getParent().toString();
                    pathP = "/root/" + oidStrP.trim().replace('.', '/');
                    created = root.searchPath(pathP, BMUI.type_folder);
                    if (created == null) {
                        created = root.searchPath(pathP);
                    }
                    if (created == null) {
                        created = GroupTreeObject.createPath(pathP, root);
                    }
                }
            } else {
                type = oid.getType();
                if (type instanceof SnmpTrapType) {
                    stype = (SnmpTrapType)type;
                    oidStrP = stype.getEnterprise().toString();
                    pathP = "/root/" + oidStrP.trim().replace('.', '/');
                    created = root.searchPath(pathP, BMUI.type_folder);
                    if (created == null) {
                        created = root.searchPath(pathP);
                    }
                    if (created == null) {
                        created = MIBBrowser.addNode(((ObjectIdentifierValue)stype.getEnterprise()).getReferenceSymbol(), root);
                    }
                }
            }
            newGTO = new MibTreeObject(oid);
            if (created == null) {
                if (newGTO.getName().equals("1")) {
                    root.addElement(newGTO);
                }
            } else {
                try {
                    created.addElement(newGTO);
                    break block20;
                }
                catch (Throwable v0) {
                    old = created.getChild(newGTO.getName(), newGTO.getType());
                    children = old.getElements();
                    ** for (child : children)
                }
lbl-1000:
                // 1 sources

                {
                    try {
                        newGTO.addElement(child);
                    }
                    catch (Exception e1) {
                        sw = new StringWriter();
                        e1.printStackTrace(new PrintWriter(sw));
                        System.out.println(sw.toString());
                    }
                    continue;
                }
lbl53:
                // 1 sources

                created.removeElement(old);
                created.addElement(newGTO);
            }
        }
        created = newGTO;
        return created;
    }

    public void filterTreeByType() {
        this.m_treeFilters.remove(FILTER_BY_TYPE);
        if (!this.m_showAll) {
            if (this.m_showNotifOnly) {
                this.m_treeFilters.put(FILTER_BY_TYPE, new MIBBrowserTreeFilterType("NOTIFICATION-TYPE"));
            } else if (this.m_showTrapsOnly) {
                this.m_treeFilters.put(FILTER_BY_TYPE, new MIBBrowserTreeFilterType("TRAP-TYPE"));
            }
        }
        this.updateTree();
    }

    public void filterTreeByName(String filterText) {
        this.m_treeFilters.remove(FILTER_BY_NAME);
        if (filterText != null && filterText.length() != 0) {
            MIBBrowserTreeFilterName filterOnName = new MIBBrowserTreeFilterName(filterText);
            this.m_treeFilters.put(FILTER_BY_NAME, filterOnName);
        }
        this.updateTree();
    }

    public void updateTree() {
        MIBBrowserTreeFilterName filter;
        ViewerFilter[] filters = new ViewerFilter[this.m_treeFilters.size()];
        int count = 0;
        if (this.m_treeFilters.containsKey(FILTER_BY_TYPE)) {
            filters[count] = this.m_treeFilters.get(FILTER_BY_TYPE);
            ++count;
        }
        if (this.m_treeFilters.containsKey(FILTER_BY_NAME)) {
            filter = (MIBBrowserTreeFilterName)this.m_treeFilters.get(FILTER_BY_NAME);
            filters[count++] = filter;
        }
        if (this.m_treeFilters.containsKey(FILTER_BY_MIB)) {
            filter = this.m_treeFilters.get(FILTER_BY_MIB);
            filters[count] = filter;
        }
        this.m_treeViewer.setFilters(filters);
        this.m_treeViewer.expandToLevel(this.m_treeViewer.getAutoExpandLevel());
    }

    public void selectionChanged(SelectionChangedEvent event) {
        TreeViewer view;
        GroupTreeObject gto;
        if (event.getSource() instanceof TreeViewer && (gto = (GroupTreeObject)((IStructuredSelection)(view = (TreeViewer)event.getSource()).getSelection()).getFirstElement()) != null && gto.getTreeObject() instanceof MibTreeObject) {
            String mibModule;
            Mib mib;
            MibTreeObject mto = (MibTreeObject)gto.getTreeObject();
            Map<String, String> m = mto.getTrapVariables();
            StringBuffer res = new StringBuffer();
            String mibfn = mto.getMIBfilename();
            if (mibfn != null) {
                res.append("MIB File: ").append(mibfn).append("\n");
            }
            if ((mib = mto.getMIB()) != null && (mibModule = mib.getName()) != null) {
                res.append("MIB Module: ").append(mibModule).append("\n");
            }
            if (m.size() > 0) {
                res.append("Variables expected\n");
                res.append(this.getExpectedVariables(m));
            }
            res.append(mto.getFullLabel()).append("\n\n");
            res.append(mto.getDescription());
            if (mto.getComments() != null) {
                res.append("\n\n\t--").append(mto.getComments().replace("\n", "\n\t--"));
            }
            this.m_text.setText(res.toString());
        }
    }

    private StringBuffer getExpectedVariables(Map<String, String> m) {
        StringBuffer sb = new StringBuffer();
        for (String oid : m.keySet()) {
            String name = m.get(oid);
            sb.append(name).append(" : <$").append(oid).append(">\n");
        }
        sb.append("\n");
        return sb;
    }

    public TreeViewer getTreeViewer() {
        return this.m_treeViewer;
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent event) {
        CCombo combo;
        String name;
        Object obj = event.getSource();
        if (obj instanceof Button) {
            Button b = (Button)obj;
            String btnName = (String)b.getData();
            if (BUTTON_LOAD_MIB.equals(btnName) || BUTTON_LOAD_DIR.equals(btnName)) {
                String path = null;
                String[] fnames = null;
                String fileFIRST = null;
                if (BUTTON_LOAD_DIR.equals(btnName)) {
                    DirectoryDialog dd = new DirectoryDialog(this.m_treeViewer.getControl().getShell());
                    dd.setText("Select Directory");
                    if (m_lastDirSelected != null) {
                        dd.setFilterPath(m_lastDirSelected);
                    }
                    if ((fileFIRST = dd.open()) == null) {
                        return;
                    }
                    File dir = new File(fileFIRST);
                    fnames = dir.list();
                    path = fileFIRST;
                } else {
                    FileDialog fd = new FileDialog(this.m_treeViewer.getControl().getShell(), 2);
                    fd.setText("Select MIB file(s)");
                    if (m_lastDirSelected != null) {
                        fd.setFilterPath(m_lastDirSelected);
                    }
                    fileFIRST = fd.open();
                    fnames = fd.getFileNames();
                    path = fd.getFilterPath();
                    if (fnames == null || fnames.length == 0) {
                        return;
                    }
                }
                m_lastDirSelected = fileFIRST;
                File filer = new File(m_lastDirSelected);
                if (filer.isFile()) {
                    filer = filer.getParentFile();
                }
                if (filer != null) {
                    m_mibLoader.addDir(filer);
                }
                this.startLoad(path, fnames);
            } else if (SNMP_CREATE_POLICY.equals(btnName)) {
                this.createWalkPolicy();
            } else if (BUTTON_LOAD_MIBS.equals(btnName) || BUTTON_SYNC_MIBS.equals(btnName)) {
                String dirM = String.valueOf(Repository.getUserDirectory()) + File.separator + "mibs";
                String bkpzip = String.valueOf(Repository.getUserTmpDirectory()) + File.separator + "mibs" + System.currentTimeMillis() + ".zip";
                if (BUTTON_SYNC_MIBS.equals(btnName)) {
                    this.unloadAll();
                    try {
                        ZIP zip = new ZIP();
                        zip.zipDir(dirM, bkpzip);
                        FileUtils.deleteDirectoryRecursive(dirM);
                    }
                    catch (Throwable throwable) {
                        new ShowMessageBox("Error", "Can't cleanup directory: " + dirM, 1);
                        return;
                    }
                }
                ServerClient sc = ServerClient.getMIBS();
                sc.run();
                if (sc.isSuccess()) {
                    this.loadStart(true);
                } else if (btnName.equals(BUTTON_SYNC_MIBS)) {
                    block57: {
                        new ShowMessageBox("Error getting mibs from server", sc.getResultObject() + "\n old content will be restored...", 1);
                        ZIP zip = new ZIP();
                        try {
                            try {
                                zip.unzip(bkpzip, dirM);
                            }
                            catch (Throwable throwable) {
                                try {
                                    File bkp = new File(bkpzip);
                                    bkp.delete();
                                }
                                catch (Throwable throwable2) {}
                                break block57;
                            }
                        }
                        catch (Throwable throwable) {
                            try {
                                File bkp = new File(bkpzip);
                                bkp.delete();
                            }
                            catch (Throwable throwable3) {}
                            throw throwable;
                        }
                        try {
                            File bkp = new File(bkpzip);
                            bkp.delete();
                        }
                        catch (Throwable throwable) {}
                    }
                    this.loadStart(true);
                } else {
                    new ShowMessageBox("Error getting mibs from server", "" + sc.getResultObject(), 1);
                }
            } else if (BUTTON_UNLOADALL.equals(btnName)) {
                this.unloadAll();
            } else if (BUTTON_SEARCH.equals(btnName)) {
                String search = this.m_search.getText();
                if (this.searchInTree(search) == null) {
                    this.m_treeViewer.setSelection(null);
                    this.m_text.setText("No element found for: " + search);
                }
            } else if (SNMP_START.equals(btnName)) {
                this.m_walk_btn.setEnabled(false);
                ArrayList<String> params = new ArrayList<String>();
                params.add("-v");
                String ver = this.m_version_field.getText();
                params.add(ver);
                params.add("-c");
                params.add(this.m_community_field.getText());
                params.add("-p");
                params.add(this.m_port_field.getText());
                params.add("-t");
                params.add(this.m_timeout_field.getText());
                params.add("-r");
                params.add(this.m_retry_field.getText());
                if (ver.equalsIgnoreCase("3")) {
                    params.add("-Xu");
                    params.add(this.m_user_field.getText());
                    if (this.m_authType_field.getText().length() > 0) {
                        params.add("-Xa");
                        params.add(this.m_authType_field.getText());
                        params.add("-Xs");
                        params.add(this.m_authPassword_field.getText());
                    }
                    if (this.m_privateType_field.getText().length() > 0) {
                        params.add("-Xt");
                        params.add(this.m_privateType_field.getText());
                        params.add("-Xp");
                        params.add(this.m_privPassword_field.getText());
                    }
                }
                params.add(this.m_host_field.getText());
                params.add(this.m_OID_field.getText());
                this.m_lastWalk = new SNMPWalkGuiAction(this.m_tableProvider, params.toArray(new String[0]), 1000, this);
                Thread tr = new Thread(this.m_lastWalk);
                tr.start();
                this.m_progressBar.setVisible(true);
                this.m_progressBar.setState(0);
            } else if (DISPLAY_ALL.equals(btnName)) {
                this.m_showAll = b.getSelection();
                if (this.m_showAll) {
                    this.filterTreeByType();
                }
            } else if ("NOTIFICATION-TYPE".equals(btnName)) {
                if (this.m_showNotifOnly != b.getSelection()) {
                    this.m_showNotifOnly = b.getSelection();
                    if (this.m_showNotifOnly) {
                        this.filterTreeByType();
                    }
                }
            } else if ("TRAP-TYPE".equals(btnName) && this.m_showTrapsOnly != b.getSelection()) {
                this.m_showTrapsOnly = b.getSelection();
                if (this.m_showTrapsOnly) {
                    this.filterTreeByType();
                }
            }
        } else if (obj instanceof CCombo && (name = (String)(combo = (CCombo)obj).getData()).equals(SNMP_VERSION)) {
            if (combo.getText().equalsIgnoreCase("3")) {
                this.m_gui.enableField(this.m_authType_field, true);
                this.m_gui.enableField(this.m_authPassword_field, true);
                this.m_gui.enableField(this.m_privPassword_field, true);
                this.m_gui.enableField(this.m_privateType_field, true);
                this.m_gui.enableField(this.m_user_field, true);
                if (this.m_user_field.getText().trim().equals("")) {
                    this.m_user_field.setBackground(BMUI.color_critical);
                }
                this.m_gui.enableField(this.m_community_field, false);
            } else {
                this.m_gui.enableField(this.m_authType_field, false);
                this.m_gui.enableField(this.m_authPassword_field, false);
                this.m_gui.enableField(this.m_privPassword_field, false);
                this.m_gui.enableField(this.m_privateType_field, false);
                this.m_gui.enableField(this.m_user_field, false);
                this.m_gui.enableField(this.m_community_field, true);
            }
            this.createMonitorCall();
        }
    }

    private void unloadAll() {
        m_mibLoader.unloadAll();
        m_mibLoader.removeAllDirs();
        m_root.clean();
        this.m_treeViewer.setInput((Object)m_root);
        this.m_treeViewer.refresh();
    }

    public void parseDirectory(String dir) {
        MibContext mc = m_mibLoader.getDefaultContext();
        MibSymbol msISO = mc.findSymbol("iso", false);
        if (msISO != null) {
            try {
                MIBBrowser.addNode((MibValueSymbol)msISO, m_root);
            }
            catch (Throwable throwable) {}
        }
        StringBuffer Errors = new StringBuffer();
        File dirF = new File(dir);
        if (dirF.exists() && dirF.isDirectory()) {
            File[] list = dirF.listFiles();
            final int size = list.length;
            m_mibLoader.addDir(dirF);
            UIJob ui = new UIJob("lm1"){

                @Override
                public IStatus runInUIThread(IProgressMonitor monitor) {
                    MIBBrowser.this.m_progressBarLoad.setVisible(true);
                    MIBBrowser.this.m_progressBarLoad.setMaximum(size);
                    MIBBrowser.this.m_progressBarLoad.setSelection(0);
                    return null;
                }
            };
            UIJobManager.getInstance().schedule(ui);
            int i = 0;
            while (i < list.length) {
                File file = list[i];
                if (file.isFile()) {
                    try {
                        if (m_mibLoader.getMib(file) != null) {
                            try {
                                m_mibLoader.unload(file);
                            }
                            catch (Throwable throwable) {}
                        }
                        MibReader mr = new MibReader(new FileReader(file));
                        Mib mib = m_mibLoader.load(mr);
                        this.processMib(mib);
                        mr.close();
                    }
                    catch (Throwable e) {
                        if (e instanceof MibLoaderException) {
                            MibLoaderException me = (MibLoaderException)e;
                            this.addErrors(Errors, file, me);
                        }
                        Errors.append(e.getMessage()).append("\n");
                    }
                    UIJob ui1 = new UIJob("lm2"){

                        @Override
                        public IStatus runInUIThread(IProgressMonitor monitor) {
                            MIBBrowser.this.m_progressBarLoad.setSelection(MIBBrowser.this.m_progressBarLoad.getSelection() + 1);
                            return null;
                        }
                    };
                    UIJobManager.getInstance().schedule(ui1);
                }
                ++i;
            }
        }
        GroupTreeObject zero = m_root.getFirstChild("0");
        m_root.removeElement(zero);
        m_root.sortElementsRecursive();
        final String str = Errors.toString();
        UIJob ui2 = new UIJob("lm3"){

            @Override
            public IStatus runInUIThread(IProgressMonitor monitor) {
                MIBBrowser.this.m_progressBarLoad.setVisible(false);
                MIBBrowser.this.m_treeViewer.setInput((Object)m_root);
                MIBBrowser.this.m_treeViewer.expandToLevel(6);
                MIBBrowser.this.m_treeViewer.refresh();
                MIBBrowser.this.m_shell.setEnabled(true);
                if (str.length() > 0) {
                    ShowMessageDialog smd = new ShowMessageDialog(new Shell(Display.getCurrent().getActiveShell()), "Errors occured", "Error list:", str, "", false, "OK", 600);
                    smd.setBlockOnOpen(true);
                    smd.open();
                }
                return null;
            }
        };
        UIJobManager.getInstance().schedule(ui2);
    }

    private void startLoad(final String path, final String[] fnames) {
        this.m_progressBarLoad.setVisible(true);
        this.m_progressBarLoad.setMaximum(fnames.length);
        this.m_progressBarLoad.setSelection(0);
        Job job = new Job("lll"){

            protected IStatus run(IProgressMonitor monitor) {
                LinkedList<String> loadedMibs = new LinkedList<String>();
                StringBuffer Errors = new StringBuffer();
                try {
                    int i = 0;
                    while (i < fnames.length) {
                        String pName = String.valueOf(path) + File.separator + fnames[i];
                        File mibFile = new File(pName);
                        if (mibFile.isFile()) {
                            try {
                                MibReader mr = new MibReader(new FileReader(mibFile));
                                Mib mib = m_mibLoader.load(mr);
                                MIBBrowser.this.processMib(mib);
                                loadedMibs.add(mib.getName());
                                mr.close();
                            }
                            catch (Throwable e) {
                                if (e instanceof MibLoaderException) {
                                    MibLoaderException me = (MibLoaderException)e;
                                    MIBBrowser.this.addErrors(Errors, mibFile, me);
                                }
                                Errors.append(e.getMessage()).append("\n");
                            }
                            UIJob ui1 = new UIJob("lm2"){

                                @Override
                                public IStatus runInUIThread(IProgressMonitor monitor) {
                                    MIBBrowser.this.m_progressBarLoad.setSelection(MIBBrowser.this.m_progressBarLoad.getSelection() + 1);
                                    return null;
                                }
                            };
                            UIJobManager.getInstance().schedule(ui1);
                        }
                        ++i;
                    }
                    final LinkedList<String> loadedMibsFinal = loadedMibs;
                    final String str = Errors.toString();
                    UIJob ui2 = new UIJob("lm3"){

                        @Override
                        public IStatus runInUIThread(IProgressMonitor monitor) {
                            int numOfLoadedMibs = loadedMibsFinal.size();
                            MIBBrowser.this.m_progressBarLoad.setVisible(false);
                            ViewerFilter[] vfs = MIBBrowser.this.m_treeViewer.getFilters();
                            if (vfs != null) {
                                int i = 0;
                                while (i < vfs.length) {
                                    ViewerFilter vf = vfs[i];
                                    if (vf instanceof MIBBrowserTreeFilterAbstract) {
                                        ((MIBBrowserTreeFilterAbstract)vf).cleanCache();
                                    }
                                    if (vf instanceof MIBTreeFilter) {
                                        MIBTreeFilter mtf = (MIBTreeFilter)vf;
                                        MIBBrowser.this.m_selectedMIBs.addAll(loadedMibsFinal);
                                        mtf = new MIBTreeFilter(MIBBrowser.this.m_selectedMIBs);
                                        (this).MIBBrowser.this.m_treeFilters.put(FILTER_BY_MIB, mtf);
                                        vfs[i] = mtf;
                                    }
                                    ++i;
                                }
                            }
                            if (vfs != null) {
                                MIBBrowser.this.m_treeViewer.setFilters(vfs);
                            }
                            MIBBrowser.this.m_treeViewer.setInput((Object)m_root);
                            MIBBrowser.this.m_treeViewer.expandToLevel(6);
                            MIBBrowser.this.m_treeViewer.refresh();
                            MIBBrowser.this.m_TableViewer.refresh();
                            if (str.length() > 0) {
                                ShowMessageDialog smd = new ShowMessageDialog(new Shell(Display.getCurrent().getActiveShell()), "Errors occured", "Error list: \n", str, "", false, "OK", 600);
                                smd.setBlockOnOpen(true);
                                smd.open();
                            } else {
                                String mibStr = loadedMibsFinal.toString();
                                mibStr = mibStr.replace("[", "");
                                mibStr = mibStr.replace("]", "");
                                mibStr = mibStr.replace(", ", ",");
                                mibStr = mibStr.replace(",", "\n");
                                String s = numOfLoadedMibs > 1 ? "s" : "";
                                String msg = "Successfully loaded " + numOfLoadedMibs + " MIB File" + s;
                                ShowMessageDialog smd = new ShowMessageDialog(new Shell(Display.getCurrent().getActiveShell()), "Load MIB Files", "", String.valueOf(msg) + ": \n" + mibStr, "", false, "OK", 600);
                                smd.setBlockOnOpen(true);
                                smd.open();
                            }
                            return null;
                        }
                    };
                    UIJobManager.getInstance().schedule(ui2);
                }
                catch (Throwable throwable) {}
                return Status.OK_STATUS;
            }
        };
        job.schedule();
    }

    private GroupTreeObject searchInTree(String search) {
        GroupTreeObject gto = null;
        if (search.trim().length() > 0) {
            String path;
            if (search.startsWith(".")) {
                search = search.substring(1);
            }
            if (search.endsWith(".")) {
                search = search.substring(0, search.lastIndexOf(46));
            }
            if ((gto = m_root.searchPath(path = "/root/" + search.replace('.', '/'))) != null) {
                this.m_treeViewer.setSelection((ISelection)new StructuredSelection((Object)gto));
            }
        }
        return gto;
    }

    @Override
    public void refresh() {
        this.m_TableViewer.setInput((Object)this.m_tableProvider.getElements(null));
        this.m_progressBar.setState(4);
        this.m_progressBar.setVisible(false);
        this.m_walk_btn.setEnabled(true);
        if (this.m_lastWalk.m_status.length() > 0) {
            this.m_lastWalk.m_status.append("\n\n");
        }
        this.m_lastWalk.m_status.append("======== SNMPWalkMonitor parameters ===========\n");
        this.m_lastWalk.m_status.append(this.createMonitorCall());
        this.m_lastWalk.m_status.append("<object1> = <calculation string>").append("\n");
        this.m_lastWalk.m_status.append("<object2> = <calculation string>").append("\n");
        this.m_lastWalk.m_status.append("...");
        this.m_log_field.setText(this.m_lastWalk.m_status.toString());
    }

    public String createMonitorCall() {
        StringBuffer mcall = new StringBuffer();
        mcall.append(MonprogTableProvider.SNMP_MONITOR_NAME).append("\n");
        mcall.append("-h ").append(this.m_host_field.getText()).append("\n");
        mcall.append("-p ").append(this.m_port_field.getText()).append("\n");
        mcall.append("-o ").append(this.m_OID_field.getText()).append("\n");
        mcall.append("-r ").append(this.m_retry_field.getText()).append("\n");
        mcall.append("-t ").append(this.m_timeout_field.getText()).append("\n");
        String version = this.m_version_field.getText();
        mcall.append("-v ").append(version).append("\n");
        if (version.equals("3")) {
            mcall.append("-Xu ").append(this.m_user_field.getText()).append("\n");
            mcall.append("-Xa ").append(this.m_authType_field.getText()).append("\n");
            String xs = this.m_authPassword_field.getText();
            if (xs.length() > 0) {
                mcall.append("-Xs <$BOOMMON_ONINIT($$").append(Cryptor.encrypt(xs)).append(")>\n");
            }
            mcall.append("-Xt ").append(this.m_privateType_field.getText()).append("\n");
            String xp = this.m_privPassword_field.getText();
            if (xp.length() > 0) {
                mcall.append("-Xp <$BOOMMON_ONINIT($$").append(Cryptor.encrypt(xp)).append(")>\n");
            }
        } else {
            mcall.append("-c ").append(this.m_community_field.getText()).append("\n");
        }
        return mcall.toString();
    }

    public void modifyText(ModifyEvent event) {
        if (event.getSource() instanceof Text) {
            Text field = (Text)event.getSource();
            String name = (String)field.getData();
            String value = field.getText().trim();
            if (!name.equals(TEXT_SEARCH) && name.equals(SNMP_USER)) {
                if (value.equals("")) {
                    field.setBackground(BMUI.color_critical);
                } else {
                    field.setBackground(BMUI.color_white);
                }
            }
        }
    }

    public void open() {
        this.m_shell.open();
    }

    public void shellActivated(ShellEvent e) {
    }

    public void shellDeactivated(ShellEvent e) {
    }

    public void shellDeiconified(ShellEvent e) {
    }

    public void shellIconified(ShellEvent e) {
    }

    public void shellClosed(ShellEvent e) {
    }

    private void createWalkPolicy() {
        Policy pNew = Policy.createNewPolicy();
        pNew.setCallType("JAVA");
        pNew.setSetGroup("SNMP");
        pNew.setDescription("Generated from MibBrowser " + BMUI.m_sdf.format(new Date()));
        Condition c = (Condition)pNew.getConditions().getConditionList().get(0);
        c.setSetNode("<$host>");
        pNew.setMonprog(this.createMonitorCall());
        GroupTreeObjectUnsubmitted gtol = new GroupTreeObjectUnsubmitted(new TreeObject(pNew.getName(), BMUI.type_mon, pNew), null, "IMAGE_MON");
        GroupTreeObject POLICIES = PolicyTreeProvider.getInstance().getRoot().getFirstChild("Policies");
        POLICIES.addElement(gtol);
        PolicyView.showNewPolicyTab(pNew, this.m_treeViewer, gtol, true);
        PolicyManager.getInstance().addUnsubmitted(gtol, POLICIES.getPath());
        this.m_shell.moveBelow((Control)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
    }

    public void doubleClick(DoubleClickEvent arg0) {
        Object obj = arg0.getSource();
        if (obj instanceof TableViewer) {
            TableViewer tv = (TableViewer)obj;
            StructuredSelection selection = (StructuredSelection)tv.getSelection();
            VariableBinding vb = (VariableBinding)selection.getFirstElement();
            String oid = vb.getOid().toString();
            while (this.searchInTree(oid) == null || oid.indexOf(46) == -1) {
                oid = oid.substring(0, oid.lastIndexOf(46));
            }
        }
    }

    public static void main(String[] args) {
        Shell shell = new Shell(Display.getDefault());
        shell.setLayout((Layout)new FillLayout());
        MIBBrowser db = new MIBBrowser();
        db.open();
    }

    private void addErrors(StringBuffer Errors, File mibFile, MibLoaderException me) {
        MibLoaderLog log = me.getLog();
        Iterator it = log.entries();
        while (it.hasNext()) {
            MibLoaderLog.LogEntry le = (MibLoaderLog.LogEntry)it.next();
            StringBuilder sb = new StringBuilder();
            switch (le.getType()) {
                case 2: {
                    sb.append("ERROR - ");
                    break;
                }
                case 1: {
                    sb.append("IERROR - ");
                    break;
                }
                case 3: {
                    sb.append("WARN - ");
                    break;
                }
            }
            sb.append("File: ").append(mibFile.getName()).append(" line:").append(le.getLineNumber()).append(" col:").append(le.getColumnNumber()).append(" : ").append(le.getMessage()).append("\n");
            if (Errors.indexOf(sb.toString()) != -1) continue;
            Errors.append((CharSequence)sb);
        }
    }

    public class CopyOIDToTheClipboardAction
    extends Action {
        private TreeViewer m_tv = null;

        public CopyOIDToTheClipboardAction(TreeViewer tv) {
            this.setId("CopyOIDToTheClipboard");
            this.setText("Copy OID to the Clipboard");
            this.m_tv = tv;
            IWorkbenchWindow window = Activator.getDefault().getWorkbench().getActiveWorkbenchWindow();
            ISharedImages sharedImages = window.getWorkbench().getSharedImages();
            this.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_COPY"));
            this.setDisabledImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_COPY_DISABLED"));
        }

        public void run() {
            Object o;
            StructuredSelection ssel = (StructuredSelection)this.m_tv.getSelection();
            if (ssel != null && !ssel.isEmpty() && (o = ssel.getFirstElement()) instanceof MibTreeObject) {
                MibTreeObject mto = (MibTreeObject)o;
                Clipboard clipboard = new Clipboard(Display.getCurrent());
                TextTransfer textTransfer = TextTransfer.getInstance();
                clipboard.setContents(new Object[]{mto.getSNMP_OID()}, new Transfer[]{textTransfer});
                clipboard.dispose();
            }
        }
    }

    public class SelectMIBsToDisplayAction
    extends Action {
        private MibLoader m_ml = null;

        public SelectMIBsToDisplayAction(MibLoader ml) {
            this.setId("SelectMIBs");
            this.setText("Select MIBs to display ...");
            this.m_ml = ml;
        }

        public void run() {
            Mib[] mibs = this.m_ml.getAllMibs();
            ArrayList<String> mibNamesSorted = new ArrayList<String>();
            int i = 0;
            while (i < mibs.length) {
                Mib mib = mibs[i];
                if (mib != null && !mibNamesSorted.contains(mib.getName())) {
                    mibNamesSorted.add(mib.getName());
                }
                ++i;
            }
            Collections.sort(mibNamesSorted);
            MIBSelectionDialog md = new MIBSelectionDialog(new Shell(Display.getCurrent().getActiveShell()), mibNamesSorted, MIBBrowser.this.m_selectedMIBs);
            md.setBlockOnOpen(true);
            int res = md.open();
            if (res == 0) {
                MIBBrowser.this.m_selectedMIBs = new TreeSet<String>(md.getSelection());
                if (MIBBrowser.this.m_selectedMIBs.size() == 0) {
                    MIBBrowser.this.m_treeFilters.remove(FILTER_BY_MIB);
                } else {
                    MIBTreeFilter mtf = new MIBTreeFilter(MIBBrowser.this.m_selectedMIBs);
                    MIBBrowser.this.m_treeFilters.put(FILTER_BY_MIB, mtf);
                }
                MIBBrowser.this.updateTree();
            }
        }
    }

    public class ShowLoadedMIBsAction
    extends Action {
        private MibLoader m_ml = null;

        public ShowLoadedMIBsAction(MibLoader ml) {
            this.setId("showloadedmibs");
            this.setText("Show loaded MIBs");
            this.m_ml = ml;
        }

        public void run() {
            Mib[] mibs = this.m_ml.getAllMibs();
            ArrayList<String> names = new ArrayList<String>();
            int i = 0;
            while (i < mibs.length) {
                Mib mib = mibs[i];
                if (mib != null && !names.contains(mib.getName())) {
                    names.add(mib.getName());
                }
                ++i;
            }
            Collections.sort(names);
            ArrayList<String> names2 = new ArrayList<String>();
            for (String name : names) {
                name = name.replaceAll("\\s*,\\s*", "\n");
                name = name.replaceAll("[\\]\\[]", "");
                names2.add(name);
            }
            MIBSelectionDialog md = new MIBSelectionDialog(new Shell(Display.getCurrent().getActiveShell()), names);
            md.setBlockOnOpen(true);
            md.open();
        }
    }
}

