/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.snmp;

import com.blixx.boom.gui.utils.IColorer;
import com.blixx.boom.snmp.MIBBrowser;
import com.blixx.boom.snmp.MibTreeObject;
import com.blixx.shared.utils.GroupTreeObject;
import com.blixx.shared.utils.ITreeObject;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;

public class MIBLabelProvider
extends LabelProvider
implements IColorProvider {
    private IColorer m_colorer = null;

    public MIBLabelProvider(IColorer colorer) {
        this.m_colorer = colorer;
    }

    public Image getImage(Object obj) {
        Image res = MIBBrowser.m_folder;
        if (obj instanceof GroupTreeObject) {
            GroupTreeObject gto = (GroupTreeObject)obj;
            MibTreeObject mto = null;
            if (gto instanceof MibTreeObject && !(mto = (MibTreeObject)gto).isAccesible()) {
                res = MIBBrowser.m_folder_x;
            }
            if (gto.getTreeObject().getType() == "NOTIFICATION-TYPE") {
                res = MIBBrowser.m_elNotification;
            } else if (gto.getTreeObject().getType() == "TRAP-TYPE") {
                res = MIBBrowser.m_elTrap;
            } else if (gto.getElements().size() == 0) {
                res = MIBBrowser.m_el;
                if (gto instanceof MibTreeObject) {
                    if (!mto.isAccesible()) {
                        res = MIBBrowser.m_el_x;
                    } else if (mto.isWriteOnly()) {
                        res = MIBBrowser.m_el_wo;
                    }
                }
            }
        }
        return res;
    }

    public String getText(Object obj) {
        String res = "***";
        if (obj instanceof GroupTreeObject) {
            GroupTreeObject gto = (GroupTreeObject)obj;
            ITreeObject treeObject = gto.getTreeObject();
            if (treeObject instanceof MibTreeObject) {
                MibTreeObject mib = (MibTreeObject)treeObject;
                res = mib.getLabel();
            } else {
                res = gto.getName();
            }
        } else {
            res = "" + obj;
        }
        return res;
    }

    public void dispose() {
    }

    public Color getBackground(Object element) {
        if (this.m_colorer != null) {
            return this.m_colorer.getBackground(element);
        }
        return null;
    }

    public Color getForeground(Object element) {
        if (this.m_colorer != null) {
            return this.m_colorer.getForeground(element);
        }
        return null;
    }
}

