/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.snmp;

import com.blixx.boom.snmp.MIBBrowser;
import java.util.List;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

public class MIBTableProvider
implements IStructuredContentProvider,
ITableLabelProvider {
    private TableViewer m_tableViewer = null;
    private List<String> m_mibs_sorted = null;
    private boolean m_displayImage = true;

    public MIBTableProvider(TableViewer tableViewer, boolean displayImage, List<String> mibs_sorted) {
        this.m_tableViewer = tableViewer;
        this.m_displayImage = displayImage;
        this.m_mibs_sorted = mibs_sorted;
    }

    public Object[] getElements(Object inputElement) {
        return this.m_mibs_sorted.toArray();
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public Image getColumnImage(Object element, int columnIndex) {
        Image res = null;
        if (this.m_displayImage) {
            res = MIBBrowser.m_folder;
        }
        return res;
    }

    public String getColumnText(Object element, int columnIndex) {
        String res = "";
        if (element instanceof String) {
            res = (String)element;
        }
        return res;
    }

    public void setTableSelection(List<String> selectedMIBs, List<String> selectedMIBs_changed) {
        if (selectedMIBs.size() == 0) {
            return;
        }
        Table table = this.m_tableViewer.getTable();
        TableItem[] items = table.getItems();
        int i = 0;
        while (i < items.length) {
            TableItem ti = items[i];
            String mibName = ti.getText(0);
            if (selectedMIBs.contains(mibName)) {
                ti.setChecked(true);
                selectedMIBs_changed.add(mibName);
            }
            ++i;
        }
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }
}

