/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.snmp;

import com.blixx.boom.snmp.MIBBrowser;
import com.blixx.shared.utils.GroupTreeObject;
import com.blixx.shared.utils.TreeObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import net.percederberg.mibble.Mib;
import net.percederberg.mibble.MibImport;
import net.percederberg.mibble.MibSymbol;
import net.percederberg.mibble.MibValueSymbol;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;

public class MIBTreeFilter
extends ViewerFilter {
    GroupTreeObject m_filteredView = new GroupTreeObject(new TreeObject("root", "", null));

    public MIBTreeFilter(Collection<String> mibnames) {
        if (mibnames != null) {
            ArrayList<MibValueSymbol> selectedPlusDependency = new ArrayList<MibValueSymbol>();
            for (String name : mibnames) {
                Mib mib = MIBBrowser.m_mibLoader.getMib(name);
                Collection col = mib.getAllImports();
                for (MibImport imp : col) {
                    Collection names = imp.getAllSymbolNames();
                    Iterator it2 = names.iterator();
                    while (it2.hasNext()) {
                        MibSymbol ms = imp.findSymbol((String)it2.next(), true);
                        if (ms == null || !(ms instanceof MibValueSymbol)) continue;
                        selectedPlusDependency.add((MibValueSymbol)ms);
                        this.addNode((MibValueSymbol)ms, this.m_filteredView);
                    }
                }
            }
            for (String name : mibnames) {
                Mib mib = MIBBrowser.m_mibLoader.getMib(name);
                for (Object obj : mib.getAllSymbols()) {
                    if (!(obj instanceof MibValueSymbol)) continue;
                    this.addNode((MibValueSymbol)obj, this.m_filteredView);
                }
            }
        }
    }

    public boolean select(Viewer viewer, Object parent, Object element) {
        if (this.m_filteredView.getElements().size() == 0) {
            return true;
        }
        GroupTreeObject gto = (GroupTreeObject)element;
        return this.m_filteredView.searchPath(gto.getPath(), gto.getType()) != null;
    }

    private GroupTreeObject addNode(MibValueSymbol oid, GroupTreeObject root) {
        return MIBBrowser.addNode(oid, root);
    }
}

