/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.snmp;

import com.blixx.shared.utils.GroupTreeObject;
import com.blixx.shared.utils.ITreeObject;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import net.percederberg.mibble.Mib;
import net.percederberg.mibble.MibValue;
import net.percederberg.mibble.MibValueSymbol;
import net.percederberg.mibble.snmp.SnmpNotificationType;
import net.percederberg.mibble.snmp.SnmpTrapType;
import net.percederberg.mibble.value.NumberValue;
import net.percederberg.mibble.value.ObjectIdentifierValue;

public class MibTreeObject
extends GroupTreeObject
implements ITreeObject {
    public static final String TRAP_TYPE = "TRAP-TYPE";
    public static final String NOTIFICATION_TYPE = "NOTIFICATION-TYPE";
    public static final String FOLDER = "";
    public String m_type = null;
    private MibValueSymbol m_symbol;
    private MibValue m_value;
    private String m_fullLabel = null;
    private Map<String, String> m_trapVariables = new LinkedHashMap<String, String>();
    private Boolean isWriteOnly;
    private Boolean isAccessible;
    private String oid = null;

    public MibTreeObject(MibValueSymbol value) {
        super(null);
        this.m_symbol = value;
        this.m_value = this.m_symbol.getValue();
        this.m_obj = this;
    }

    @Override
    public String getComparableName() {
        if (this.m_value instanceof ObjectIdentifierValue) {
            return FOLDER + (10000 + ((ObjectIdentifierValue)this.m_value).getValue());
        }
        return 10000 + this.m_value.toString();
    }

    @Override
    public String getLabel() {
        if (this.m_value instanceof ObjectIdentifierValue) {
            return String.valueOf(((ObjectIdentifierValue)this.m_value).getName()) + " (" + ((ObjectIdentifierValue)this.m_value).toString() + ")";
        }
        if (this.m_symbol != null && this.m_symbol.getName() != null) {
            return String.valueOf(this.m_symbol.getName()) + " (" + this.m_value.toString() + ")";
        }
        return this.m_value.toString();
    }

    public String getLabel2() {
        if (this.m_value instanceof ObjectIdentifierValue) {
            return ((ObjectIdentifierValue)this.m_value).getName();
        }
        if (this.m_symbol != null && this.m_symbol.getName() != null) {
            return this.m_symbol.getName();
        }
        return this.m_value.toString();
    }

    public String getSNMP_OID() {
        if (this.m_value != null) {
            String oid = this.m_value.toString();
            if (this.m_value instanceof NumberValue) {
                oid = this.getPath().replace("/root/", ".").replace('/', '.');
            }
            if (!oid.startsWith(".")) {
                oid = "." + oid;
            }
            return oid;
        }
        return null;
    }

    public String getFullLabel() {
        if (this.m_fullLabel == null) {
            StringBuffer sb = new StringBuffer();
            if (this.m_value instanceof ObjectIdentifierValue) {
                GroupTreeObject gto;
                String name = null;
                name = this.m_value instanceof ObjectIdentifierValue ? ((ObjectIdentifierValue)this.m_value).getName() : this.m_value.toString();
                sb.append(name);
                if (this.getParent() != null && (gto = this.getParent()) instanceof MibTreeObject) {
                    sb.insert(0, '.');
                    MibTreeObject parent = (MibTreeObject)gto;
                    sb.insert(0, parent.getFullLabel());
                }
            } else {
                this.m_fullLabel = this.m_value.toString();
            }
            this.m_fullLabel = sb.toString();
        }
        return this.m_fullLabel;
    }

    public String getMIBfilename() {
        Mib mib;
        if (this.m_symbol != null && (mib = this.m_symbol.getMib()) != null) {
            return mib.getName();
        }
        return null;
    }

    public Mib getMIB() {
        if (this.m_symbol != null) {
            return this.m_symbol.getMib();
        }
        return null;
    }

    @Override
    public String getName() {
        if (this.m_value instanceof ObjectIdentifierValue) {
            return FOLDER + ((ObjectIdentifierValue)this.m_value).getValue();
        }
        return this.m_value.toString();
    }

    @Override
    public Object getObject() {
        return this.m_value;
    }

    public boolean isWriteOnly() {
        if (this.isWriteOnly != null) {
            return this.isWriteOnly;
        }
        this.isWriteOnly = false;
        try {
            this.isWriteOnly = this.getDescription().indexOf("write-only") != -1;
        }
        catch (Throwable throwable) {}
        return this.isWriteOnly;
    }

    public boolean isAccesible() {
        if (this.isAccessible != null) {
            return this.isAccessible;
        }
        this.isAccessible = true;
        try {
            this.isAccessible = this.getDescription().indexOf("not-accessible") == -1;
        }
        catch (Throwable throwable) {}
        return this.isAccessible;
    }

    @Override
    public String getType() {
        if (this.m_type == null) {
            this.m_type = FOLDER;
            if (this.m_symbol != null && this.m_symbol.getChildCount() == 0) {
                String comm = null;
                try {
                    comm = this.m_symbol.getType().getName();
                }
                catch (Throwable throwable) {}
                if (comm != null) {
                    if (comm.indexOf(NOTIFICATION_TYPE) != -1) {
                        this.m_type = NOTIFICATION_TYPE;
                    } else if (comm.indexOf(TRAP_TYPE) != -1) {
                        this.m_type = TRAP_TYPE;
                    }
                }
            }
        } else if (this.m_symbol.getChildCount() > 0) {
            this.m_type = FOLDER;
        }
        return this.m_type;
    }

    @Override
    public void setName(String name) {
    }

    @Override
    public void setObject(Object obj) {
        this.m_symbol = (MibValueSymbol)obj;
    }

    @Override
    public void setType(String type) {
    }

    public String getDescription() {
        if (this.m_symbol != null) {
            return this.m_symbol.toString();
        }
        return this.m_value.toString();
    }

    public Map<String, String> getTrapVariables() {
        this.m_trapVariables.clear();
        if (this.getType() == NOTIFICATION_TYPE) {
            try {
                ObjectIdentifierValue OIV = (ObjectIdentifierValue)this.getObject();
                SnmpNotificationType nt = (SnmpNotificationType)OIV.getSymbol().getType();
                ArrayList objects = nt.getObjects();
                int i = 0;
                while (i < objects.size()) {
                    String var_oid;
                    ObjectIdentifierValue ref = (ObjectIdentifierValue)objects.get(i);
                    MibValueSymbol symbol = ref.getSymbol();
                    String name = symbol.getName();
                    if (symbol.getComment() != null) {
                        name = String.valueOf(name) + "  --" + symbol.getComment().replace("\n", "\n--") + "\n\t";
                    }
                    if (!(var_oid = ref.toString()).startsWith(".")) {
                        var_oid = "." + var_oid;
                    }
                    this.m_trapVariables.put(var_oid, name);
                    ++i;
                }
            }
            catch (Throwable throwable) {}
        } else if (this.getType() == TRAP_TYPE) {
            SnmpTrapType stt = (SnmpTrapType)this.m_symbol.getType();
            for (Object object : stt.getVariables()) {
                String var_oid;
                ObjectIdentifierValue ref = (ObjectIdentifierValue)object;
                MibValueSymbol symbol = ref.getSymbol();
                String name = symbol.getName();
                if (symbol.getComment() != null) {
                    name = String.valueOf(name) + "  --" + symbol.getComment().replace("\n", "\n--") + "\n\t";
                }
                if (!(var_oid = ref.toString()).startsWith(".")) {
                    var_oid = "." + var_oid;
                }
                this.m_trapVariables.put(var_oid, name);
            }
        }
        return this.m_trapVariables;
    }

    public String getComments() {
        return this.m_symbol.getComment();
    }

    @Override
    public String getOID() {
        return this.oid;
    }

    @Override
    public void setOID(String oid) {
        this.oid = oid;
    }

    @Override
    public boolean equals(Object arg0) {
        if (arg0 instanceof MibTreeObject) {
            return this.getFullLabel().equals(((MibTreeObject)arg0).getFullLabel()) && super.equals(arg0);
        }
        return super.equals(arg0);
    }

    @Override
    public int hashCode() {
        return this.getFullLabel().hashCode();
    }
}

