/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.snmp;

import com.blixx.boom.snmp.MIBBrowser;
import com.blixx.boom.snmp.MibTreeObject;
import com.blixx.shared.utils.GroupTreeObject;
import com.blixx.shared.utils.ITreeObject;
import java.util.ArrayList;
import java.util.List;
import net.percederberg.mibble.Mib;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.snmp4j.smi.VariableBinding;

public class SNMPTableProvider
implements IStructuredContentProvider,
ITableLabelProvider {
    MIBBrowser m_mibbrowser = null;
    List<VariableBinding> m_data = new ArrayList<VariableBinding>();
    List<ILabelProviderListener> m_listeners = new ArrayList<ILabelProviderListener>();

    public SNMPTableProvider(MIBBrowser mibbrowser) {
        this.m_mibbrowser = mibbrowser;
    }

    public void dispose() {
    }

    public void inputChanged(Viewer arg0, Object arg1, Object arg2) {
    }

    public void addListener(ILabelProviderListener arg0) {
        this.m_listeners.add(arg0);
    }

    public boolean isLabelProperty(Object arg0, String arg1) {
        return true;
    }

    public void removeListener(ILabelProviderListener arg0) {
        this.m_listeners.remove(arg0);
    }

    public Object[] getElements(Object arg0) {
        return this.m_data.toArray();
    }

    public Image getColumnImage(Object arg0, int arg1) {
        return null;
    }

    public String getColumnText(Object arg0, int arg1) {
        VariableBinding vb = (VariableBinding)arg0;
        switch (arg1) {
            case 0: 
            case 3: {
                String path;
                GroupTreeObject gto;
                String oid = vb.getOid().toString();
                if (oid.startsWith(".")) {
                    oid = oid.substring(1);
                }
                if ((gto = MIBBrowser.m_root.searchPath(path = "/root/" + oid.replace('.', '/'))) != null) {
                    MibTreeObject mto = (MibTreeObject)gto.getTreeObject();
                    String part1 = mto.getFullLabel();
                    if (arg1 == 0) {
                        part1 = this.resolveMibModule(gto, mto, part1);
                    }
                    return part1;
                }
                String path2 = path;
                while (gto == null) {
                    path2 = path2.substring(0, path2.lastIndexOf(47));
                    gto = MIBBrowser.m_root.searchPath(path2);
                }
                if (gto.getParent() == null) {
                    return oid;
                }
                try {
                    MibTreeObject mto = (MibTreeObject)gto.getTreeObject();
                    String part1 = mto.getFullLabel();
                    String part2 = path.replace(path2, "");
                    part2 = part2.replace('/', '.');
                    if (arg1 == 0) {
                        part1 = this.resolveMibModule(gto, mto, part1);
                    }
                    return String.valueOf(part1) + part2;
                }
                catch (Throwable throwable) {
                    return oid;
                }
            }
            case 1: {
                return vb.getOid().toString();
            }
            case 2: {
                return vb.getVariable().toString();
            }
        }
        return null;
    }

    private String resolveMibModule(GroupTreeObject gto, MibTreeObject mto, String part1) {
        Mib module = mto.getMIB();
        MibTreeObject rootInModule = mto;
        while (gto.getParent() != null) {
            ITreeObject obj = gto.getParent().getTreeObject();
            if (!(obj instanceof MibTreeObject) || (mto = (MibTreeObject)obj).getMIB() != module) break;
            rootInModule = mto;
            gto = gto.getParent();
        }
        if (rootInModule != mto) {
            String rootFullLabel = rootInModule.getFullLabel();
            part1 = part1.replace(rootFullLabel, String.valueOf(rootInModule.getMIB().getName()) + ":");
        }
        return part1;
    }

    public void setData(List<VariableBinding> data) {
        this.m_data.clear();
        this.m_data.addAll(data);
        data.clear();
        data = null;
    }
}

