/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.snmp;

import com.blixx.boom.engine.UIJob;
import com.blixx.boom.engine.UIJobManager;
import com.blixx.boom.gui.dialogs.IRefreshable;
import com.blixx.boom.snmp.SNMPTableProvider;
import java.io.IOException;
import java.net.InetAddress;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.snmp4j.CommunityTarget;
import org.snmp4j.PDU;
import org.snmp4j.PDUv1;
import org.snmp4j.ScopedPDU;
import org.snmp4j.Snmp;
import org.snmp4j.Target;
import org.snmp4j.UserTarget;
import org.snmp4j.mp.MPv3;
import org.snmp4j.mp.MessageProcessingModel;
import org.snmp4j.security.AuthMD5;
import org.snmp4j.security.AuthSHA;
import org.snmp4j.security.Priv3DES;
import org.snmp4j.security.PrivAES128;
import org.snmp4j.security.PrivAES192;
import org.snmp4j.security.PrivAES256;
import org.snmp4j.security.PrivDES;
import org.snmp4j.security.SecurityModels;
import org.snmp4j.security.SecurityProtocols;
import org.snmp4j.security.USM;
import org.snmp4j.security.UsmUser;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.UdpAddress;
import org.snmp4j.smi.VariableBinding;
import org.snmp4j.transport.DefaultUdpTransportMapping;
import org.snmp4j.util.PDUFactory;
import org.snmp4j.util.TreeEvent;
import org.snmp4j.util.TreeListener;
import org.snmp4j.util.TreeUtils;

public class SNMPWalkGuiAction
implements Runnable,
PDUFactory {
    StringBuffer m_status = new StringBuffer();
    int m_version = 0;
    String m_community = null;
    int m_retries = 1;
    int m_timeout = 10000;
    int m_port = 161;
    String m_host = "127.0.0.1";
    OID m_startOid = new OID("1.3.6");
    OID m_stopAt = null;
    Target target;
    Snmp session = null;
    OctetString localEngineID = new OctetString(MPv3.createLocalEngineID());
    static int engineBootCount = 0;
    OID authProtocol;
    OID privProtocol;
    OctetString privPassphrase;
    OctetString authPassphrase;
    OctetString community = new OctetString("public");
    OctetString authoritativeEngineID;
    OctetString contextEngineID;
    OctetString contextName = new OctetString();
    OctetString securityName = new OctetString();
    int maxSizeResponsePDU = 65535;
    PDUv1 v1TrapPDU = new PDUv1();
    SNMPTableProvider m_provider = null;
    String[] m_parameters;
    IRefreshable m_refreshable = null;

    public SNMPWalkGuiAction(SNMPTableProvider provider, String[] parameters, int timeout, IRefreshable refreshable) {
        this.m_provider = provider;
        this.m_parameters = parameters;
        this.m_timeout = timeout;
        this.m_refreshable = refreshable;
    }

    @Override
    public PDU createPDU(Target target) {
        PDU request;
        if (target.getVersion() == 3) {
            request = new ScopedPDU();
            ScopedPDU scopedPDU = request;
            if (this.contextEngineID != null) {
                scopedPDU.setContextEngineID(this.contextEngineID);
            }
            if (this.contextName != null) {
                scopedPDU.setContextName(this.contextName);
            }
        } else {
            request = this.m_version == -92 ? this.v1TrapPDU : new PDU();
            request.setType(-95);
        }
        return request;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void parseOptions(String[] args) throws IllegalArgumentException {
        int lastArg = 0;
        int x = 0;
        while (x < args.length) {
            block35: {
                block37: {
                    block38: {
                        block40: {
                            block39: {
                                block36: {
                                    if (!args[x].startsWith("-")) break block35;
                                    if (!args[x].equals("-c")) break block36;
                                    this.m_community = args[++x];
                                    this.community = new OctetString(this.m_community);
                                    break block37;
                                }
                                if (!args[x].equals("-v")) break block38;
                                if (!args[++x].equals("1")) break block39;
                                this.m_version = 0;
                                break block37;
                            }
                            if (!args[x].equals("2") && !args[x].equals("2c")) break block40;
                            this.m_version = 1;
                            break block37;
                        }
                        if (!args[x].equals("3")) break block37;
                        this.m_version = 3;
                        break block37;
                    }
                    if (args[x].equals("-r")) {
                        try {
                            this.m_retries = Integer.parseInt(args[++x]);
                        }
                        catch (NumberFormatException numberFormatException) {
                            throw new IllegalArgumentException("Malformed retry number");
                        }
                    } else if (args[x].equals("-t")) {
                        try {
                            float f = Float.parseFloat(args[++x]);
                            this.m_timeout = (int)(f * 1000.0f);
                        }
                        catch (NumberFormatException numberFormatException) {
                            throw new IllegalArgumentException("Malformed timeout period");
                        }
                    } else if (args[x].equals("-p")) {
                        try {
                            this.m_port = Integer.parseInt(args[++x]);
                        }
                        catch (NumberFormatException numberFormatException) {
                            throw new IllegalArgumentException("Malformed port number");
                        }
                    } else if (args[x].equals("-Xu")) {
                        this.securityName = SNMPWalkGuiAction.createOctetString(args[++x]);
                    } else if (args[x].equals("-Xa")) {
                        String s;
                        if ((s = args[++x]).equals("MD5")) {
                            this.authProtocol = AuthMD5.ID;
                        } else {
                            if (!s.equals("SHA")) throw new IllegalArgumentException("Authentication protocol unsupported: " + s);
                            this.authProtocol = AuthSHA.ID;
                        }
                    } else if (args[x].equals("-Xs")) {
                        this.authPassphrase = SNMPWalkGuiAction.createOctetString(args[++x]);
                    } else if (args[x].equals("-Xp")) {
                        this.privPassphrase = SNMPWalkGuiAction.createOctetString(args[++x]);
                    } else if (args[x].equals("-Xt")) {
                        String s;
                        if ((s = args[++x]).equals("DES")) {
                            this.privProtocol = PrivDES.ID;
                        } else if (s.equals("AES128") || s.equals("AES")) {
                            this.privProtocol = PrivAES128.ID;
                        } else if (s.equals("AES192")) {
                            this.privProtocol = PrivAES192.ID;
                        } else if (s.equals("AES256")) {
                            this.privProtocol = PrivAES256.ID;
                        } else {
                            if (!s.equals("3DES") && !s.equalsIgnoreCase("DESEDE")) throw new IllegalArgumentException("Privacy protocol " + s + " not supported");
                            this.privProtocol = Priv3DES.ID;
                        }
                    } else {
                        if (!args[x].equals("--")) throw new IllegalArgumentException("Unknown Option " + args[x]);
                        lastArg = x + 1;
                        break;
                    }
                }
                lastArg = x + 1;
            }
            ++x;
        }
        if (args.length - lastArg == 1) {
            this.m_host = args[lastArg++];
            return;
        } else {
            if (args.length - lastArg != 2) throw new IllegalArgumentException("Invalid number of arguments");
            this.m_host = args[lastArg++];
            this.m_startOid = new OID(args[lastArg++]);
        }
    }

    private static OctetString createOctetString(String s) {
        OctetString octetString = s.startsWith("0x") ? OctetString.fromHexString(s.substring(2), ':') : new OctetString(s);
        return octetString;
    }

    @Override
    public void run() {
        block12: {
            this.m_provider.m_data.clear();
            this.m_status = new StringBuffer();
            Snmp snmp = null;
            try {
                try {
                    this.parseOptions(this.m_parameters);
                    InetAddress.getByName(this.m_host);
                    DefaultUdpTransportMapping transport = new DefaultUdpTransportMapping();
                    snmp = new Snmp(transport);
                    ((MPv3)snmp.getMessageProcessingModel(3)).setLocalEngineID(this.localEngineID.getValue());
                    if (this.m_version == 3) {
                        SecurityProtocols.getInstance().addDefaultProtocols();
                        SecurityProtocols.getInstance().addPrivacyProtocol(new Priv3DES());
                        USM usm = new USM(SecurityProtocols.getInstance(), this.localEngineID, engineBootCount);
                        SecurityModels.getInstance().addSecurityModel(usm);
                        this.addUsmUser(snmp);
                    }
                    this.target = this.createTarget();
                    this.target.setVersion(this.m_version);
                    UdpAddress ua = new UdpAddress(String.valueOf(this.m_host) + "/" + this.m_port);
                    this.target.setAddress(ua);
                    this.target.setRetries(this.m_retries);
                    this.target.setTimeout(this.m_timeout);
                    this.target.setMaxSizeRequestPDU(this.maxSizeResponsePDU);
                    snmp.listen();
                    PDU request = this.createPDU(this.target);
                    request.setMaxRepetitions(0);
                    request.setNonRepeaters(0);
                    request.add(new VariableBinding(this.m_startOid));
                    this.walk(snmp, request, this.target);
                    UIJob job = new UIJob("updateSnmpTable"){

                        @Override
                        public IStatus runInUIThread(IProgressMonitor monitor) {
                            SNMPWalkGuiAction.this.m_refreshable.refresh();
                            return Status.OK_STATUS;
                        }
                    };
                    UIJobManager.getInstance().schedule(job);
                }
                catch (Throwable e) {
                    this.m_status.append("FAILED: " + e.getMessage());
                    UIJob job = new UIJob("updateSnmpTable"){

                        @Override
                        public IStatus runInUIThread(IProgressMonitor monitor) {
                            SNMPWalkGuiAction.this.m_refreshable.refresh();
                            return Status.OK_STATUS;
                        }
                    };
                    UIJobManager.getInstance().schedule(job);
                    try {
                        snmp.close();
                    }
                    catch (Throwable throwable) {}
                    break block12;
                }
            }
            catch (Throwable throwable) {
                try {
                    snmp.close();
                }
                catch (Throwable throwable2) {}
                throw throwable;
            }
            try {
                snmp.close();
            }
            catch (Throwable throwable) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PDU walk(Snmp snmp, PDU request, Target target) throws IOException {
        TreeListener treeListener;
        OID rootOID = request.get(0).getOid();
        PDU response = null;
        final WalkCounts counts = new WalkCounts();
        final long startTime = System.currentTimeMillis();
        TreeUtils treeUtils = new TreeUtils(snmp, this);
        treeUtils.setIgnoreLexicographicOrder(true);
        TreeListener treeListener2 = treeListener = new TreeListener(){
            private boolean finished;

            @Override
            public boolean next(TreeEvent e) {
                ++counts.requests;
                if (e.getVariableBindings() != null) {
                    VariableBinding[] vbs = e.getVariableBindings();
                    counts.objects += vbs.length;
                    int i = 0;
                    while (i < vbs.length) {
                        SNMPWalkGuiAction.this.m_provider.m_data.add(vbs[i]);
                        ++i;
                    }
                }
                return true;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void finished(TreeEvent e) {
                if (e.getVariableBindings() != null && e.getVariableBindings().length > 0) {
                    this.next(e);
                }
                SNMPWalkGuiAction.this.m_status.append("\n");
                SNMPWalkGuiAction.this.m_status.append("Total requests sent:    " + counts.requests).append("\n");
                SNMPWalkGuiAction.this.m_status.append("Total objects received: " + counts.objects).append("\n");
                SNMPWalkGuiAction.this.m_status.append("Total walk time:        " + (System.currentTimeMillis() - startTime) + " milliseconds").append("\n");
                if (e.isError()) {
                    SNMPWalkGuiAction.this.m_status.append("\n");
                    SNMPWalkGuiAction.this.m_status.append("The following error occurred during walk:").append("\n");
                    SNMPWalkGuiAction.this.m_status.append(e.getErrorMessage()).append("\n");
                }
                this.finished = true;
                3 var2_2 = this;
                synchronized (var2_2) {
                    this.notify();
                }
            }

            @Override
            public boolean isFinished() {
                return this.finished;
            }
        };
        synchronized (treeListener2) {
            treeUtils.getSubtree(target, rootOID, null, treeListener);
            try {
                treeListener.wait();
            }
            catch (InterruptedException ex) {
                System.err.println("Tree retrieval interrupted: " + ex.getMessage());
                Thread.currentThread().interrupt();
            }
        }
        return response;
    }

    private void addUsmUser(Snmp snmp) {
        snmp.getUSM().addUser(this.securityName, new UsmUser(this.securityName, this.authProtocol, this.authPassphrase, this.privProtocol, this.privPassphrase));
    }

    private Target createTarget() {
        if (this.m_version == 3) {
            UserTarget target = new UserTarget();
            if (this.authPassphrase != null) {
                if (this.privPassphrase != null) {
                    target.setSecurityLevel(3);
                } else {
                    target.setSecurityLevel(2);
                }
            } else {
                target.setSecurityLevel(1);
            }
            target.setSecurityName(this.securityName);
            return target;
        }
        CommunityTarget target = new CommunityTarget();
        target.setCommunity(this.community);
        return target;
    }

    @Override
    public PDU createPDU(MessageProcessingModel messageProcessingModel) {
        PDU request = messageProcessingModel.getID() == 3 ? new ScopedPDU() : new PDU();
        return request;
    }

    class WalkCounts {
        public int requests;
        public int objects;

        WalkCounts() {
        }
    }
}

