/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.ctrl.sc;

import com.blixx.shared.IODataStream;
import com.blixx.shared.SEventFwd;
import com.blixx.shared.io.SDataOutputStream;
import java.io.IOException;
import java.util.Arrays;

public class CMD
implements Comparable<CMD> {
    public String m_command = null;
    public String m_action = null;
    public String[] m_params = null;
    public IODataStream[] m_objects = null;
    public SEventFwd[] m_events = null;
    private long m_timeWhenAdded = System.currentTimeMillis();
    private String m_toString = null;

    public CMD(String command) {
        this.m_command = command;
    }

    public CMD(String command, String action, Object[] params) {
        this.m_command = command;
        this.m_action = action;
        if (this.m_action == null) {
            this.m_action = "";
        }
        if (params != null) {
            if (params instanceof String[]) {
                this.m_params = (String[])params;
            } else if (params instanceof SEventFwd[]) {
                this.m_events = (SEventFwd[])params;
            } else if (params instanceof IODataStream[]) {
                this.m_objects = (IODataStream[])params;
            }
        }
    }

    public void send(SDataOutputStream out) throws IOException {
        out.writeUTF(this.m_command);
        out.writeUTF(this.m_action);
        if (this.m_params == null || this.m_params.length == 0) {
            out.writeInt(0);
        } else {
            out.writeInt(this.m_params.length);
            int i = 0;
            while (i < this.m_params.length) {
                out.writeUTF(this.m_params[i]);
                ++i;
            }
        }
    }

    public String toString() {
        if (this.m_toString == null) {
            StringBuffer res = new StringBuffer();
            res.append(this.m_command);
            if (this.m_action != null) {
                res.append(' ').append(this.m_action);
            }
            if (this.m_params != null) {
                int i = 0;
                while (i < this.m_params.length) {
                    res.append(' ').append(this.m_params[i]);
                    ++i;
                }
            }
            if (this.m_objects != null) {
                res.append(Arrays.asList(this.m_objects));
            }
            if (this.m_events != null) {
                res.append(Arrays.asList(this.m_events));
            }
            this.m_toString = res.toString();
        }
        return this.m_toString;
    }

    @Override
    public int compareTo(CMD o) {
        return this.toString().compareTo("" + o);
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof CMD)) {
            return false;
        }
        CMD cmd2 = (CMD)obj;
        return (this.m_command == null ? cmd2.m_command == null : this.m_command.equals(cmd2.m_command)) && (this.m_action == null ? cmd2.m_action == null : this.m_action.equals(cmd2.m_action)) && Arrays.equals(this.m_params, cmd2.m_params) && Arrays.equals(this.m_objects, cmd2.m_objects) && Arrays.equals(this.m_events, cmd2.m_events);
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public long getPendingTime() {
        return System.currentTimeMillis() - this.m_timeWhenAdded;
    }
}

